/*
 * Decompiled with CFR 0.152.
 */
package com.sendcloud.sdk.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.TreeMap;

public class Md5Util {
    public static String makeMd5Sum(byte[] srcContent) {
        if (srcContent == null) {
            return null;
        }
        String strDes = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(srcContent);
            strDes = Md5Util.bytes2Hex(md5.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        return strDes;
    }

    private static String bytes2Hex(byte[] byteArray) {
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            if (byteArray[i] >= 0 && byteArray[i] < 16) {
                strBuf.append("0");
            }
            strBuf.append(Integer.toHexString(byteArray[i] & 0xFF));
        }
        return strBuf.toString();
    }

    public static String md5Signature(TreeMap<String, String> params, String secret) {
        String result = null;
        String orgin = Md5Util.getOrginSign(params, secret);
        if (orgin == null) {
            return result;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            result = Md5Util.bytes2Hex(md.digest(orgin.toString().getBytes("utf-8")));
        }
        catch (Exception e) {
            throw new RuntimeException("sign error !");
        }
        return result;
    }

    public static String getOrginSign(TreeMap<String, String> params, String secret) {
        if (params == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(secret).append("&");
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.putAll(params);
        for (String key : treeMap.keySet()) {
            String value = params.get(key);
            sb.append(key).append("=").append(value).append("&");
        }
        sb.append(secret);
        return sb.toString();
    }
}

