/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.maven.plugins;

import com.google.common.base.Optional;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.serenitybdd.core.history.FileSystemTestOutcomeSummaryRecorder;
import net.serenitybdd.core.history.TestOutcomeSummaryRecorder;
import net.serenitybdd.maven.plugins.MavenProjectHelper;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="history")
public class SerenityHistoryMojo
extends AbstractMojo {
    private static final String DEFAULT_HISTORY_DIRECTORY = "history";
    @Parameter(property="serenity.outputDirectory")
    public String outcomesDirectoryPath;
    @Parameter(property="serenity.historyDirectory")
    public String historyDirectoryPath;
    @Parameter(property="serenity.deletePreviousHistory")
    public Boolean deletePreviousHistory = false;
    @Parameter(defaultValue="${session}")
    private MavenSession session;

    protected TestOutcomeSummaryRecorder getTestOutcomeSummaryRecorder() {
        MavenProjectHelper.propagateBuildDir(this.session);
        EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        System.out.println("historyDirectoryPath = " + this.historyDirectoryPath);
        System.out.println("SERENITY_HISTORY_DIRECTORY = " + ThucydidesSystemProperty.SERENITY_HISTORY_DIRECTORY.from(environmentVariables));
        String configuredHistoryDirectoryPath = ThucydidesSystemProperty.SERENITY_HISTORY_DIRECTORY.from(environmentVariables, (String)Optional.fromNullable((Object)this.historyDirectoryPath).or((Object)DEFAULT_HISTORY_DIRECTORY));
        System.out.println("configuredHistoryDirectoryPath = " + configuredHistoryDirectoryPath);
        Path historyDirectory = Paths.get(configuredHistoryDirectoryPath, new String[0]);
        return new FileSystemTestOutcomeSummaryRecorder(historyDirectory, this.deletePreviousHistory);
    }

    private Path outputDirectory() {
        return !StringUtils.isEmpty((CharSequence)this.outcomesDirectoryPath) ? this.session.getCurrentProject().getBasedir().toPath().resolve(this.outcomesDirectoryPath).toAbsolutePath() : this.getConfiguration().getOutputDirectory().toPath();
    }

    private Configuration getConfiguration() {
        return (Configuration)Injectors.getInjector().getProvider(Configuration.class).get();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Storing Serenity test result summaries");
        this.getTestOutcomeSummaryRecorder().recordOutcomeSummariesFrom(this.outputDirectory());
    }
}

