/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.functions.standard;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.sf.jasperreports.functions.annotations.Function;
import net.sf.jasperreports.functions.annotations.FunctionCategories;
import net.sf.jasperreports.functions.annotations.FunctionParameter;
import net.sf.jasperreports.functions.annotations.FunctionParameters;
import net.sf.jasperreports.functions.standard.MathCategory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@FunctionCategories(value={MathCategory.class})
public final class MathFunctions {
    private static final Log log = LogFactory.getLog(MathFunctions.class);

    @Function(value="ABS")
    @FunctionParameters(value={@FunctionParameter(value="number")})
    public static Number ABS(Number number) {
        if (number == null) {
            MathFunctions.logNullArgument();
            return null;
        }
        if (number instanceof Integer) {
            return Math.abs((Integer)number);
        }
        if (number instanceof Double) {
            return Math.abs((Double)number);
        }
        if (number instanceof Float) {
            return Float.valueOf(Math.abs(((Float)number).floatValue()));
        }
        if (number instanceof Long) {
            return Math.abs((Long)number);
        }
        return Math.abs(number.doubleValue());
    }

    @Function(value="FACT")
    @FunctionParameters(value={@FunctionParameter(value="number")})
    public static Long FACT(Integer number) {
        if (number == null) {
            MathFunctions.logNullArgument();
            return null;
        }
        if (number < 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to calculate the factorial number of a negative number.");
            }
            return null;
        }
        Long result = 1L;
        for (int i = 1; i <= number; ++i) {
            result = result * (long)i;
        }
        return result;
    }

    @Function(value="ISEVEN")
    @FunctionParameters(value={@FunctionParameter(value="number")})
    public static Boolean ISEVEN(Number number) {
        if (number == null) {
            MathFunctions.logNullArgument();
            return null;
        }
        return number.intValue() % 2 == 0;
    }

    @Function(value="ISODD")
    @FunctionParameters(value={@FunctionParameter(value="number")})
    public static Boolean ISODD(Number number) {
        if (number == null) {
            MathFunctions.logNullArgument();
            return null;
        }
        return number.intValue() % 2 == 1;
    }

    @Function(value="PRODUCT")
    @FunctionParameters(value={@FunctionParameter(value="numbers")})
    public static Number PRODUCT(Number ... numbers) {
        if (numbers.length == 0) {
            MathFunctions.logEmptyArgumentsList();
            return null;
        }
        if (!MathFunctions.isNumberListValid(numbers)) {
            MathFunctions.logArgumentsWithNullElements();
            return null;
        }
        double result = 1.0;
        for (int i = 0; i < numbers.length; ++i) {
            result *= numbers[i].doubleValue();
        }
        return result;
    }

    @Function(value="RAND")
    public static Double RAND() {
        return Math.random();
    }

    @Function(value="RANDBETWEEN")
    @FunctionParameters(value={@FunctionParameter(value="bottomRange"), @FunctionParameter(value="topRange")})
    public static Integer RANDBETWEEN(Integer bottomRange, Integer topRange) {
        int min = bottomRange;
        int max = topRange;
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    @Function(value="SIGN")
    @FunctionParameters(value={@FunctionParameter(value="number")})
    public static Integer SIGN(Number number) {
        if (number == null) {
            MathFunctions.logNullArgument();
            return null;
        }
        return (int)Math.signum(number.doubleValue());
    }

    @Function(value="SQRT")
    @FunctionParameters(value={@FunctionParameter(value="number")})
    public static Number SQRT(Number number) {
        if (number == null) {
            MathFunctions.logNullArgument();
            return null;
        }
        return Math.sqrt(number.doubleValue());
    }

    @Function(value="SUM")
    @FunctionParameters(value={@FunctionParameter(value="numbers")})
    public static Number SUM(Number ... numbers) {
        if (numbers.length == 0) {
            MathFunctions.logEmptyArgumentsList();
            return null;
        }
        if (!MathFunctions.isNumberListValid(numbers)) {
            MathFunctions.logArgumentsWithNullElements();
            return null;
        }
        double result = 0.0;
        for (int i = 0; i < numbers.length; ++i) {
            result += numbers[i].doubleValue();
        }
        return result;
    }

    @Function(value="MIN")
    @FunctionParameters(value={@FunctionParameter(value="numbers")})
    public static Number MIN(Number ... numbers) {
        if (numbers.length == 0) {
            MathFunctions.logEmptyArgumentsList();
            return null;
        }
        if (!MathFunctions.isNumberListValid(numbers)) {
            MathFunctions.logArgumentsWithNullElements();
            return null;
        }
        double min = numbers[0].doubleValue();
        for (int i = 1; i < numbers.length; ++i) {
            if (!(numbers[i].doubleValue() < min)) continue;
            min = numbers[i].doubleValue();
        }
        return MathFunctions.fixNumberReturnType(min, numbers);
    }

    @Function(value="MAX")
    @FunctionParameters(value={@FunctionParameter(value="numbers")})
    public static Number MAX(Number ... numbers) {
        if (numbers.length == 0) {
            MathFunctions.logEmptyArgumentsList();
            return null;
        }
        if (!MathFunctions.isNumberListValid(numbers)) {
            MathFunctions.logArgumentsWithNullElements();
            return null;
        }
        double max = numbers[0].doubleValue();
        for (int i = 1; i < numbers.length; ++i) {
            if (!(numbers[i].doubleValue() > max)) continue;
            max = numbers[i].doubleValue();
        }
        return MathFunctions.fixNumberReturnType(max, numbers);
    }

    @Function(value="FLOOR")
    @FunctionParameters(value={@FunctionParameter(value="number")})
    public static Double FLOOR(Number number) {
        if (number == null) {
            MathFunctions.logNullArgument();
            return null;
        }
        return Math.floor(number.doubleValue());
    }

    @Function(value="CEIL")
    @FunctionParameters(value={@FunctionParameter(value="number")})
    public static Double CEIL(Number number) {
        if (number == null) {
            MathFunctions.logNullArgument();
            return null;
        }
        return Math.ceil(number.doubleValue());
    }

    @Function(value="ROUND_UP")
    @FunctionParameters(value={@FunctionParameter(value="number"), @FunctionParameter(value="scale")})
    public static BigDecimal ROUND_UP(Number number, int scale) {
        if (number == null) {
            MathFunctions.logNullArgument();
            return null;
        }
        return new BigDecimal(number.toString()).setScale(scale, RoundingMode.UP);
    }

    @Function(value="ROUND_DOWN")
    @FunctionParameters(value={@FunctionParameter(value="number"), @FunctionParameter(value="scale")})
    public static BigDecimal ROUND_DOWN(Number number, int scale) {
        if (number == null) {
            MathFunctions.logNullArgument();
            return null;
        }
        return new BigDecimal(number.toString()).setScale(scale, RoundingMode.DOWN);
    }

    @Function(value="ROUND_CEILING")
    @FunctionParameters(value={@FunctionParameter(value="number"), @FunctionParameter(value="scale")})
    public static BigDecimal ROUND_CEILING(Number number, int scale) {
        if (number == null) {
            MathFunctions.logNullArgument();
            return null;
        }
        return new BigDecimal(number.toString()).setScale(scale, RoundingMode.CEILING);
    }

    @Function(value="ROUND_FLOOR")
    @FunctionParameters(value={@FunctionParameter(value="number"), @FunctionParameter(value="scale")})
    public static BigDecimal ROUND_FLOOR(Number number, int scale) {
        if (number == null) {
            MathFunctions.logNullArgument();
            return null;
        }
        return new BigDecimal(number.toString()).setScale(scale, RoundingMode.FLOOR);
    }

    @Function(value="ROUND_HALF_UP")
    @FunctionParameters(value={@FunctionParameter(value="number"), @FunctionParameter(value="scale")})
    public static BigDecimal ROUND_HALF_UP(Number number, int scale) {
        if (number == null) {
            MathFunctions.logNullArgument();
            return null;
        }
        return new BigDecimal(number.toString()).setScale(scale, RoundingMode.HALF_UP);
    }

    @Function(value="ROUND_HALF_EVEN")
    @FunctionParameters(value={@FunctionParameter(value="number"), @FunctionParameter(value="scale")})
    public static BigDecimal ROUND_HALF_EVEN(Number number, int scale) {
        if (number == null) {
            MathFunctions.logNullArgument();
            return null;
        }
        return new BigDecimal(number.toString()).setScale(scale, RoundingMode.HALF_EVEN);
    }

    @Function(value="ROUND_HALF_DOWN")
    @FunctionParameters(value={@FunctionParameter(value="number"), @FunctionParameter(value="scale")})
    public static BigDecimal ROUND_HALF_DOWN(Number number, int scale) {
        if (number == null) {
            MathFunctions.logNullArgument();
            return null;
        }
        return new BigDecimal(number.toString()).setScale(scale, RoundingMode.HALF_DOWN);
    }

    private static boolean isNumberListValid(Number ... numbers) {
        for (int i = 0; i < numbers.length; ++i) {
            if (numbers[i] != null) continue;
            return false;
        }
        return true;
    }

    private static Number fixNumberReturnType(Number returnValue, Number ... numbers) {
        if (MathFunctions.haveSameType(Integer.class, numbers)) {
            return returnValue.intValue();
        }
        if (MathFunctions.haveSameType(Long.class, numbers)) {
            return returnValue.longValue();
        }
        if (MathFunctions.haveSameType(Float.class, numbers)) {
            return Float.valueOf(returnValue.floatValue());
        }
        return returnValue.doubleValue();
    }

    private static boolean haveSameType(Class<? extends Number> clazz, Number ... numbers) {
        for (int i = 0; i < numbers.length; ++i) {
            if (numbers[i].getClass() == clazz) continue;
            return false;
        }
        return true;
    }

    private static void logNullArgument() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"The argument can not be null.");
        }
    }

    private static void logEmptyArgumentsList() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"No arguments were specified.");
        }
    }

    private static void logArgumentsWithNullElements() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"No null element is allowed among arguments");
        }
    }
}

