/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.ThemeDescription;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.TinyUtils;
import de.muntjak.tinylookandfeel.util.BooleanReference;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import de.muntjak.tinylookandfeel.util.ColoredFont;
import de.muntjak.tinylookandfeel.util.HSBReference;
import de.muntjak.tinylookandfeel.util.IntReference;
import de.muntjak.tinylookandfeel.util.SBReference;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.plaf.InsetsUIResource;

public class Theme {
    private static final boolean DEBUG = false;
    public static final FilenameFilter THEMES_FILTER = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(Theme.FILE_EXTENSION);
        }
    };
    public static final int ERROR_NONE = 1;
    public static final int ERROR_NULL_ARGUMENT = 2;
    public static final int ERROR_FILE_NOT_FOUND = 3;
    public static final int ERROR_IO_EXCEPTION = 4;
    public static final int ERROR_NO_TINYLAF_THEME = 5;
    public static final int ERROR_WIN99_STYLE = 6;
    public static final int ERROR_INVALID_THEME_DESCRIPTION = 7;
    private static final int DEFAULT_SCROLL_SIZE = 17;
    public static int errorCode = 1;
    protected static final Properties MAC_FONT_MAPPINGS = new Properties();
    protected static final Properties LINUX_FONT_MAPPINGS = new Properties();
    protected static final int YQ_STYLE = 2;
    public static final String DEFAULT_THEME = "Default.theme";
    public static final String FILE_EXTENSION = ".theme";
    static final URL YQ_URL = Theme.getYQ_URL();
    static final URI YQ_URI = Theme.getYQ_URI();
    protected static final int FILE_ID_1 = 4660;
    protected static final int FILE_ID_2 = 8756;
    public static final int FILE_ID_3A = 12852;
    protected static final int FILE_ID_3B = 12853;
    protected static final int FILE_ID_3C = 12854;
    protected static final int FILE_ID_3D = 12855;
    protected static final int FILE_ID_3E = 12856;
    protected static final int FILE_ID_3F = 12857;
    protected static final int FILE_ID_4 = 16384;
    protected static final int FILE_ID_4B = 16385;
    protected static final int FILE_ID_4C = 16386;
    protected static final int FILE_ID_4D = 16387;
    protected static final int FILE_ID_4E = 16388;
    public static int fileID;
    public static SBReference mainColor;
    public static SBReference disColor;
    public static SBReference backColor;
    public static SBReference frameColor;
    public static SBReference sub1Color;
    public static SBReference sub2Color;
    public static SBReference sub3Color;
    public static SBReference sub4Color;
    public static SBReference sub5Color;
    public static SBReference sub6Color;
    public static SBReference sub7Color;
    public static SBReference sub8Color;
    public static ColoredFont plainFont;
    public static ColoredFont boldFont;
    public static ColoredFont buttonFont;
    public static SBReference buttonFontColor;
    public static ColoredFont labelFont;
    public static SBReference labelFontColor;
    public static ColoredFont comboFont;
    public static ColoredFont listFont;
    public static ColoredFont menuFont;
    public static SBReference menuFontColor;
    public static ColoredFont menuItemFont;
    public static SBReference menuItemFontColor;
    public static ColoredFont passwordFont;
    public static ColoredFont radioFont;
    public static SBReference radioFontColor;
    public static ColoredFont checkFont;
    public static SBReference checkFontColor;
    public static ColoredFont tableFont;
    public static SBReference tableFontColor;
    public static ColoredFont tableHeaderFont;
    public static SBReference tableHeaderFontColor;
    public static ColoredFont textAreaFont;
    public static ColoredFont textFieldFont;
    public static ColoredFont textPaneFont;
    public static ColoredFont titledBorderFont;
    public static SBReference titledBorderFontColor;
    public static ColoredFont toolTipFont;
    public static ColoredFont treeFont;
    public static ColoredFont tabFont;
    public static SBReference tabFontColor;
    public static ColoredFont editorFont;
    public static ColoredFont frameTitleFont;
    public static ColoredFont internalFrameTitleFont;
    public static ColoredFont internalPaletteTitleFont;
    public static ColoredFont progressBarFont;
    public static SBReference progressColor;
    public static SBReference progressTrackColor;
    public static SBReference progressBorderColor;
    public static SBReference progressDarkColor;
    public static SBReference progressLightColor;
    public static SBReference progressSelectForeColor;
    public static SBReference progressSelectBackColor;
    public static SBReference textBgColor;
    public static SBReference textSelectedBgColor;
    public static SBReference textDisabledBgColor;
    public static SBReference textNonEditableBgColor;
    public static SBReference textTextColor;
    public static SBReference textSelectedTextColor;
    public static SBReference textBorderColor;
    public static SBReference textBorderDisabledColor;
    public static SBReference textCaretColor;
    public static SBReference textPaneBgColor;
    public static SBReference editorPaneBgColor;
    public static SBReference desktopPaneBgColor;
    public static InsetsUIResource textInsets;
    public static SBReference comboBorderColor;
    public static SBReference comboBorderDisabledColor;
    public static SBReference comboSelectedBgColor;
    public static SBReference comboSelectedTextColor;
    public static SBReference comboFocusBgColor;
    public static SBReference comboArrowColor;
    public static SBReference comboArrowDisabledColor;
    public static SBReference comboButtColor;
    public static SBReference comboButtRolloverColor;
    public static SBReference comboButtPressedColor;
    public static SBReference comboButtDisabledColor;
    public static SBReference comboButtBorderColor;
    public static SBReference comboButtBorderDisabledColor;
    public static SBReference comboBgColor;
    public static SBReference comboTextColor;
    public static IntReference comboSpreadLight;
    public static IntReference comboSpreadLightDisabled;
    public static IntReference comboSpreadDark;
    public static IntReference comboSpreadDarkDisabled;
    public static InsetsUIResource comboInsets;
    public static BooleanReference comboRollover;
    public static BooleanReference comboFocus;
    public static SBReference listBgColor;
    public static SBReference listTextColor;
    public static SBReference listSelectedBgColor;
    public static SBReference listSelectedTextColor;
    public static SBReference listFocusBorderColor;
    public static SBReference menuBarColor;
    public static SBReference menuRolloverBgColor;
    public static SBReference menuRolloverFgColor;
    public static SBReference menuDisabledFgColor;
    public static SBReference menuItemDisabledFgColor;
    public static SBReference menuItemRolloverColor;
    public static SBReference menuItemSelectedTextColor;
    public static SBReference menuBorderColor;
    public static SBReference menuPopupColor;
    public static SBReference menuInnerHilightColor;
    public static SBReference menuInnerShadowColor;
    public static SBReference menuOuterHilightColor;
    public static SBReference menuOuterShadowColor;
    public static SBReference menuIconColor;
    public static SBReference menuIconRolloverColor;
    public static SBReference menuIconDisabledColor;
    public static SBReference menuSeparatorColor;
    public static BooleanReference menuRollover;
    public static BooleanReference menuPopupShadow;
    public static BooleanReference menuAllowTwoIcons;
    public static SBReference toolBarColor;
    public static SBReference toolBarDarkColor;
    public static SBReference toolBarLightColor;
    public static SBReference toolButtColor;
    public static SBReference toolButtSelectedColor;
    public static SBReference toolButtRolloverColor;
    public static SBReference toolButtPressedColor;
    public static SBReference toolBorderColor;
    public static SBReference toolBorderSelectedColor;
    public static SBReference toolBorderRolloverColor;
    public static SBReference toolBorderPressedColor;
    public static SBReference toolGripDarkColor;
    public static SBReference toolGripLightColor;
    public static SBReference toolSeparatorColor;
    public static InsetsUIResource toolMargin;
    public static BooleanReference toolFocus;
    public static BooleanReference toolRollover;
    public static SBReference buttonNormalColor;
    public static SBReference buttonRolloverBgColor;
    public static SBReference buttonPressedColor;
    public static SBReference buttonDisabledColor;
    public static SBReference buttonRolloverColor;
    public static SBReference buttonDefaultColor;
    public static SBReference buttonCheckColor;
    public static SBReference buttonCheckDisabledColor;
    public static SBReference buttonBorderColor;
    public static SBReference buttonBorderDisabledColor;
    public static SBReference buttonDisabledFgColor;
    public static SBReference checkDisabledFgColor;
    public static SBReference radioDisabledFgColor;
    public static SBReference toggleSelectedBg;
    public static BooleanReference buttonRolloverBorder;
    public static BooleanReference buttonFocus;
    public static BooleanReference buttonFocusBorder;
    public static BooleanReference buttonEnter;
    public static BooleanReference shiftButtonText;
    public static InsetsUIResource buttonMargin;
    public static IntReference buttonSpreadLight;
    public static IntReference buttonSpreadLightDisabled;
    public static IntReference buttonSpreadDark;
    public static IntReference buttonSpreadDarkDisabled;
    public static InsetsUIResource checkMargin;
    public static SBReference tabPaneBorderColor;
    public static SBReference tabNormalColor;
    public static SBReference tabSelectedColor;
    public static SBReference tabDisabledColor;
    public static SBReference tabDisabledSelectedColor;
    public static SBReference tabDisabledTextColor;
    public static SBReference tabBorderColor;
    public static SBReference tabRolloverColor;
    public static SBReference tabPaneDisabledBorderColor;
    public static SBReference tabDisabledBorderColor;
    public static BooleanReference tabRollover;
    public static BooleanReference tabFocus;
    public static BooleanReference ignoreSelectedBg;
    public static BooleanReference fixedTabs;
    public static InsetsUIResource tabInsets;
    public static InsetsUIResource tabAreaInsets;
    public static BooleanReference sliderRolloverEnabled;
    public static BooleanReference sliderFocusEnabled;
    public static SBReference sliderThumbColor;
    public static SBReference sliderThumbRolloverColor;
    public static SBReference sliderThumbPressedColor;
    public static SBReference sliderThumbDisabledColor;
    public static SBReference sliderBorderColor;
    public static SBReference sliderDarkColor;
    public static SBReference sliderLightColor;
    public static SBReference sliderBorderDisabledColor;
    public static SBReference sliderTrackColor;
    public static SBReference sliderTrackBorderColor;
    public static SBReference sliderTrackDarkColor;
    public static SBReference sliderTrackLightColor;
    public static SBReference sliderTickColor;
    public static SBReference sliderTickDisabledColor;
    public static SBReference sliderFocusColor;
    public static BooleanReference spinnerRollover;
    public static SBReference spinnerButtColor;
    public static SBReference spinnerButtRolloverColor;
    public static SBReference spinnerButtPressedColor;
    public static SBReference spinnerButtDisabledColor;
    public static SBReference spinnerBorderColor;
    public static SBReference spinnerBorderDisabledColor;
    public static SBReference spinnerArrowColor;
    public static SBReference spinnerArrowDisabledColor;
    public static IntReference spinnerSpreadLight;
    public static IntReference spinnerSpreadLightDisabled;
    public static IntReference spinnerSpreadDark;
    public static IntReference spinnerSpreadDarkDisabled;
    public static SBReference scrollTrackColor;
    public static SBReference scrollTrackDisabledColor;
    public static SBReference scrollTrackBorderColor;
    public static SBReference scrollTrackBorderDisabledColor;
    public static SBReference scrollThumbColor;
    public static SBReference scrollThumbRolloverColor;
    public static SBReference scrollThumbPressedColor;
    public static SBReference scrollThumbDisabledColor;
    public static SBReference scrollButtColor;
    public static SBReference scrollButtRolloverColor;
    public static SBReference scrollButtPressedColor;
    public static SBReference scrollButtDisabledColor;
    public static SBReference scrollArrowColor;
    public static SBReference scrollArrowDisabledColor;
    public static SBReference scrollGripLightColor;
    public static SBReference scrollGripDarkColor;
    public static SBReference scrollBorderColor;
    public static SBReference scrollBorderLightColor;
    public static SBReference scrollBorderDisabledColor;
    public static SBReference scrollLightDisabledColor;
    public static SBReference scrollPaneBorderColor;
    public static IntReference scrollSpreadLight;
    public static IntReference scrollSpreadLightDisabled;
    public static IntReference scrollSpreadDark;
    public static IntReference scrollSpreadDarkDisabled;
    public static BooleanReference scrollRollover;
    public static IntReference scrollSize;
    public static SBReference treeBgColor;
    public static SBReference treeTextColor;
    public static SBReference treeTextBgColor;
    public static SBReference treeSelectedTextColor;
    public static SBReference treeSelectedBgColor;
    public static SBReference treeLineColor;
    public static SBReference frameCaptionColor;
    public static SBReference frameCaptionDisabledColor;
    public static SBReference frameBorderColor;
    public static SBReference frameLightColor;
    public static SBReference frameBorderDisabledColor;
    public static SBReference frameLightDisabledColor;
    public static SBReference frameTitleColor;
    public static SBReference frameTitleShadowColor;
    public static SBReference frameTitleDisabledColor;
    public static SBReference frameButtColor;
    public static SBReference frameButtRolloverColor;
    public static SBReference frameButtPressedColor;
    public static SBReference frameButtDisabledColor;
    public static SBReference frameButtCloseColor;
    public static SBReference frameButtCloseRolloverColor;
    public static SBReference frameButtClosePressedColor;
    public static SBReference frameButtCloseDisabledColor;
    public static SBReference frameButtBorderColor;
    public static SBReference frameButtBorderDisabledColor;
    public static IntReference frameButtSpreadLight;
    public static IntReference frameButtSpreadDark;
    public static IntReference frameButtSpreadLightDisabled;
    public static IntReference frameButtSpreadDarkDisabled;
    public static SBReference frameButtCloseBorderColor;
    public static SBReference frameButtCloseDarkColor;
    public static SBReference frameButtCloseLightColor;
    public static SBReference frameButtCloseBorderDisabledColor;
    public static IntReference frameButtCloseSpreadLight;
    public static IntReference frameButtCloseSpreadLightDisabled;
    public static IntReference frameButtCloseSpreadDark;
    public static IntReference frameButtCloseSpreadDarkDisabled;
    public static SBReference frameSymbolColor;
    public static SBReference frameSymbolPressedColor;
    public static SBReference frameSymbolDisabledColor;
    public static SBReference frameSymbolDarkColor;
    public static SBReference frameSymbolLightColor;
    public static SBReference frameSymbolDarkDisabledColor;
    public static SBReference frameSymbolLightDisabledColor;
    public static SBReference frameSymbolCloseColor;
    public static SBReference frameSymbolClosePressedColor;
    public static SBReference frameSymbolCloseDisabledColor;
    public static SBReference frameSymbolCloseDarkColor;
    public static SBReference frameSymbolCloseDarkDisabledColor;
    public static IntReference frameSpreadDark;
    public static IntReference frameSpreadLight;
    public static IntReference frameSpreadDarkDisabled;
    public static IntReference frameSpreadLightDisabled;
    public static SBReference tableBackColor;
    public static SBReference tableHeaderBackColor;
    public static SBReference tableHeaderRolloverBackColor;
    public static SBReference tableHeaderRolloverColor;
    public static SBReference tableHeaderArrowColor;
    public static SBReference tableGridColor;
    public static SBReference tableSelectedBackColor;
    public static SBReference tableSelectedForeColor;
    public static SBReference tableBorderDarkColor;
    public static SBReference tableBorderLightColor;
    public static SBReference tableHeaderDarkColor;
    public static SBReference tableHeaderLightColor;
    public static SBReference tableFocusBorderColor;
    public static SBReference tableAlternateRowColor;
    private static final int hue = 51;
    public static HSBReference[] colorizer;
    public static BooleanReference[] colorize;
    public static SBReference separatorColor;
    public static SBReference tipBorderColor;
    public static SBReference tipBorderDis;
    public static SBReference tipBgColor;
    public static SBReference tipBgDis;
    public static SBReference tipTextColor;
    public static SBReference tipTextDis;
    public static SBReference titledBorderColor;
    public static SBReference splitPaneButtonColor;

    private Theme() {
    }

    private static URI getYQ_URI() {
        try {
            return new URI("file:/YQ%20Theme");
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.println("Exception creating YQ URI:\n" + uRISyntaxException);
            return null;
        }
    }

    private static URL getYQ_URL() {
        try {
            return new URL("file:/YQ%20Theme");
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Exception creating YQ URL:\n" + malformedURLException);
            return null;
        }
    }

    public static ThemeDescription[] getAvailableThemes() {
        ThemeDescription themeDescription;
        int n;
        File file;
        File[] fileArray;
        String string;
        Vector<ThemeDescription> vector = new Vector<ThemeDescription>();
        if (YQ_URI != null) {
            vector.add(new ThemeDescription(YQ_URI));
        }
        try {
            string = TinyUtils.getSystemProperty("user.home");
            if (string != null && (fileArray = (file = new File(string)).listFiles(THEMES_FILTER)) != null && fileArray.length > 0) {
                for (n = 0; n < fileArray.length; ++n) {
                    themeDescription = new ThemeDescription(fileArray[n].toURI());
                    if (!themeDescription.isValid()) continue;
                    vector.add(themeDescription);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            string = TinyUtils.getSystemProperty("user.dir");
            if (string != null && (fileArray = (file = new File(string)).listFiles(THEMES_FILTER)) != null && fileArray.length > 0) {
                for (n = 0; n < fileArray.length; ++n) {
                    themeDescription = new ThemeDescription(fileArray[n].toURI());
                    if (!themeDescription.isValid()) continue;
                    vector.add(themeDescription);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Theme.addResourceTheme("/themes/Forest.theme", vector);
        Theme.addResourceTheme("/themes/Golden.theme", vector);
        Theme.addResourceTheme("/themes/Nightly.theme", vector);
        Theme.addResourceTheme("/themes/Plastic.theme", vector);
        Theme.addResourceTheme("/themes/Silver.theme", vector);
        Theme.addResourceTheme("/themes/Unicode.theme", vector);
        if (vector.isEmpty()) {
            return new ThemeDescription[0];
        }
        return vector.toArray(new ThemeDescription[vector.size()]);
    }

    private static void addResourceTheme(String string, Vector vector) {
        ThemeDescription themeDescription;
        URL uRL = TinyLookAndFeel.class.getResource(string);
        if (uRL != null && (themeDescription = new ThemeDescription(uRL)).isValid() && !vector.contains(themeDescription)) {
            vector.add(themeDescription);
        }
    }

    private static void printThemes(Vector vector) {
        System.out.println(vector.size() + " themes:");
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ThemeDescription themeDescription = (ThemeDescription)iterator.next();
            System.out.println("  " + themeDescription.getURL().toExternalForm());
            System.out.println("  '" + themeDescription.getName() + "' valid: " + themeDescription.isValid());
        }
    }

    public static String getPlatformFont(String string) {
        if (TinyUtils.isOSMac()) {
            String string2 = MAC_FONT_MAPPINGS.getProperty(string);
            return string2 != null ? string2 : string;
        }
        if (TinyUtils.isOSLinux()) {
            String string3 = LINUX_FONT_MAPPINGS.getProperty(string);
            return string3 != null ? string3 : string;
        }
        return string;
    }

    private static void loadFontMappings() {
        URL uRL = Theme.class.getResource("/de/muntjak/tinylookandfeel/MacFontMappings.properties");
        if (uRL != null) {
            try {
                MAC_FONT_MAPPINGS.load(uRL.openStream());
            }
            catch (IOException iOException) {
                System.err.println(Theme.class.getName() + ": Unable to locate MacFontMappings.properties.");
            }
        } else {
            System.err.println(Theme.class.getName() + ": Unable to locate MacFontMappings.properties.");
        }
        uRL = Theme.class.getResource("/de/muntjak/tinylookandfeel/LinuxFontMappings.properties");
        if (uRL != null) {
            try {
                LINUX_FONT_MAPPINGS.load(uRL.openStream());
            }
            catch (IOException iOException) {
                System.err.println(Theme.class.getName() + ": Unable to locate LinuxFontMappings.properties.");
            }
        } else {
            System.err.println(Theme.class.getName() + ": Unable to locate LinuxFontMappings.properties.");
        }
    }

    private static void initData() {
        Theme.loadFontMappings();
        mainColor = new SBReference(new Color(0, 106, 255), 0, 0, 1, true);
        disColor = new SBReference(new Color(143, 142, 139), 0, 0, 1, true);
        backColor = new SBReference(new Color(236, 233, 216), 0, 0, 1, true);
        frameColor = new SBReference(new Color(0, 85, 255), 0, 0, 1, true);
        sub1Color = new SBReference(new Color(197, 213, 252), 0, 0, 1);
        sub2Color = new SBReference(new Color(34, 161, 34), 0, 0, 1);
        sub3Color = new SBReference(new Color(231, 232, 245), 0, 0, 1);
        sub4Color = new SBReference(new Color(227, 92, 60), 0, 0, 1);
        sub5Color = new SBReference(new Color(120, 123, 189), 0, 0, 1);
        sub6Color = new SBReference(new Color(248, 179, 48), 0, 0, 1);
        sub7Color = new SBReference(new Color(175, 105, 125), 0, 0, 1);
        sub8Color = new SBReference(new Color(255, 255, 255), 0, 0, 1);
        buttonFontColor = new SBReference();
        labelFontColor = new SBReference();
        menuFontColor = new SBReference();
        menuItemFontColor = new SBReference();
        radioFontColor = new SBReference();
        checkFontColor = new SBReference();
        tableFontColor = new SBReference();
        tableHeaderFontColor = new SBReference();
        titledBorderFontColor = new SBReference();
        tabFontColor = new SBReference();
        plainFont = new ColoredFont("Tahoma", 0, 11);
        boldFont = new ColoredFont("Tahoma", 1, 11);
        buttonFont = new ColoredFont(buttonFontColor);
        labelFont = new ColoredFont(labelFontColor);
        passwordFont = new ColoredFont();
        comboFont = new ColoredFont();
        listFont = new ColoredFont();
        menuFont = new ColoredFont(menuFontColor);
        menuItemFont = new ColoredFont(menuItemFontColor);
        radioFont = new ColoredFont(radioFontColor);
        checkFont = new ColoredFont(checkFontColor);
        tableFont = new ColoredFont(tableFontColor);
        tableHeaderFont = new ColoredFont(tableHeaderFontColor);
        textAreaFont = new ColoredFont();
        textFieldFont = new ColoredFont();
        textPaneFont = new ColoredFont();
        titledBorderFont = new ColoredFont(titledBorderFontColor);
        toolTipFont = new ColoredFont();
        treeFont = new ColoredFont();
        tabFontColor = new SBReference();
        tabFont = new ColoredFont(tabFontColor);
        tabFont.setBoldFont(false);
        editorFont = new ColoredFont();
        frameTitleFont = new ColoredFont("Trebuchet MS", 1, 13);
        internalFrameTitleFont = new ColoredFont("Trebuchet MS", 1, 13);
        internalPaletteTitleFont = new ColoredFont("Trebuchet MS", 1, 12);
        progressBarFont = new ColoredFont();
        progressColor = new SBReference(new Color(44, 212, 43), 43, 19, 7);
        progressTrackColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        progressBorderColor = new SBReference(new Color(104, 104, 104), -100, -54, 3);
        progressDarkColor = new SBReference(new Color(190, 190, 190), -100, -16, 3);
        progressLightColor = new SBReference(new Color(238, 238, 238), -100, 40, 3);
        progressSelectForeColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        progressSelectBackColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        textBgColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        textPaneBgColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        editorPaneBgColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        desktopPaneBgColor = new SBReference(new Color(212, 210, 194), 0, -10, 3);
        textTextColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        textCaretColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        textSelectedBgColor = new SBReference(new Color(43, 107, 197), -36, -6, 2);
        textSelectedTextColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        textDisabledBgColor = new SBReference(new Color(240, 237, 224), 0, 20, 3);
        textNonEditableBgColor = new SBReference(new Color(240, 237, 224), 0, 20, 3);
        textBorderColor = new SBReference(new Color(128, 152, 186), -70, 23, 2);
        textBorderDisabledColor = new SBReference(new Color(201, 198, 184), 0, -15, 3);
        textInsets = new InsetsUIResource(2, 3, 2, 3);
        buttonRolloverBorder = new BooleanReference(true);
        buttonFocus = new BooleanReference(false);
        buttonFocusBorder = new BooleanReference(true);
        buttonEnter = new BooleanReference(true);
        shiftButtonText = new BooleanReference(true);
        buttonNormalColor = new SBReference(new Color(231, 232, 245), 0, 0, 8);
        buttonRolloverBgColor = new SBReference(new Color(239, 240, 248), 0, 33, 8);
        buttonPressedColor = new SBReference(new Color(217, 218, 230), 0, -6, 8);
        buttonDisabledColor = new SBReference(new Color(245, 244, 235), 0, 48, 3);
        buttonBorderColor = new SBReference(new Color(21, 61, 117), -30, -46, 2);
        buttonBorderDisabledColor = new SBReference(new Color(201, 198, 184), 0, -15, 3);
        buttonDisabledFgColor = new SBReference(new Color(143, 142, 139), 0, 0, 4);
        checkDisabledFgColor = new SBReference(new Color(143, 142, 139), 0, 0, 4);
        radioDisabledFgColor = new SBReference(new Color(143, 142, 139), 0, 0, 4);
        toggleSelectedBg = new SBReference(new Color(160, 182, 235), 38, -12, 6);
        buttonMargin = new InsetsUIResource(2, 12, 2, 12);
        buttonRolloverColor = new SBReference(new Color(248, 179, 48), 0, 0, 11);
        buttonDefaultColor = new SBReference(new Color(160, 182, 235), 38, -12, 6);
        buttonCheckColor = new SBReference(new Color(34, 161, 34), 0, 0, 7);
        buttonCheckDisabledColor = new SBReference(new Color(208, 205, 190), 0, -12, 3);
        checkMargin = new InsetsUIResource(2, 2, 2, 2);
        buttonSpreadLight = new IntReference(20);
        buttonSpreadDark = new IntReference(3);
        buttonSpreadLightDisabled = new IntReference(20);
        buttonSpreadDarkDisabled = new IntReference(1);
        scrollRollover = new BooleanReference(true);
        scrollSize = new IntReference(17);
        scrollTrackColor = new SBReference(new Color(249, 249, 247), -50, 76, 3);
        scrollTrackDisabledColor = new SBReference(new Color(249, 249, 247), -50, 76, 3);
        scrollTrackBorderColor = new SBReference(new Color(234, 231, 218), -23, 0, 3);
        scrollTrackBorderDisabledColor = new SBReference(new Color(234, 231, 218), -23, 0, 3);
        scrollThumbColor = new SBReference(new Color(197, 213, 252), 0, 0, 6);
        scrollThumbRolloverColor = new SBReference(new Color(226, 234, 254), 0, 50, 6);
        scrollThumbPressedColor = new SBReference(new Color(187, 202, 239), 0, -5, 6);
        scrollThumbDisabledColor = new SBReference(new Color(238, 238, 231), 0, -3, 6);
        scrollGripLightColor = new SBReference(new Color(238, 243, 254), 0, 71, 6);
        scrollGripDarkColor = new SBReference(new Color(171, 185, 219), 0, -13, 6);
        scrollButtColor = new SBReference(new Color(197, 213, 252), 0, 0, 6);
        scrollButtRolloverColor = new SBReference(new Color(226, 234, 254), 0, 50, 6);
        scrollButtPressedColor = new SBReference(new Color(187, 202, 239), 0, -5, 6);
        scrollButtDisabledColor = new SBReference(new Color(238, 237, 231), -48, 29, 3);
        scrollSpreadLight = new IntReference(20);
        scrollSpreadDark = new IntReference(2);
        scrollSpreadLightDisabled = new IntReference(20);
        scrollSpreadDarkDisabled = new IntReference(1);
        scrollArrowColor = new SBReference(new Color(77, 100, 132), -74, -18, 2);
        scrollArrowDisabledColor = new SBReference(new Color(193, 193, 193), -100, -15, 3);
        scrollBorderColor = new SBReference(new Color(212, 210, 194), 0, -10, 6);
        scrollBorderLightColor = new SBReference(new Color(255, 255, 255), 0, 100, 6);
        scrollBorderDisabledColor = new SBReference(new Color(232, 230, 220), -41, 0, 3);
        scrollLightDisabledColor = new SBReference(new Color(232, 230, 220), -41, 0, 3);
        scrollPaneBorderColor = new SBReference(new Color(201, 198, 184), 0, -15, 3);
        tabPaneBorderColor = new SBReference(new Color(143, 160, 183), -78, 28, 2);
        tabNormalColor = new SBReference(new Color(242, 240, 238), 0, 69, 3);
        tabSelectedColor = new SBReference(new Color(251, 251, 250), 0, 91, 3);
        tabDisabledColor = new SBReference(new Color(244, 242, 232), 0, 40, 3);
        tabDisabledSelectedColor = new SBReference(new Color(251, 251, 247), 0, 80, 3);
        tabDisabledTextColor = new SBReference(new Color(188, 187, 185), 0, 40, 4);
        tabBorderColor = new SBReference(new Color(143, 160, 183), -78, 28, 2);
        tabRolloverColor = new SBReference(new Color(255, 199, 59), 0, 0, 11);
        tabPaneDisabledBorderColor = new SBReference(new Color(208, 205, 190), 0, -12, 3);
        tabDisabledBorderColor = new SBReference(new Color(208, 205, 190), 0, -12, 3);
        tabRollover = new BooleanReference(true);
        tabFocus = new BooleanReference(true);
        ignoreSelectedBg = new BooleanReference(false);
        fixedTabs = new BooleanReference(true);
        tabInsets = new InsetsUIResource(1, 6, 4, 6);
        tabAreaInsets = new InsetsUIResource(4, 2, 0, 0);
        sliderRolloverEnabled = new BooleanReference(true);
        sliderFocusEnabled = new BooleanReference(true);
        sliderThumbColor = new SBReference(new Color(245, 244, 235), 0, 49, 3);
        sliderThumbRolloverColor = new SBReference(new Color(233, 166, 0), 100, -26, 11);
        sliderThumbPressedColor = new SBReference(new Color(244, 243, 239), -50, 50, 3);
        sliderThumbDisabledColor = new SBReference(new Color(245, 243, 234), 0, 45, 3);
        sliderBorderColor = new SBReference(new Color(176, 189, 207), -76, 50, 2);
        sliderDarkColor = new SBReference(new Color(119, 130, 146), -89, 4, 2);
        sliderLightColor = new SBReference(new Color(27, 155, 27), 16, -7, 7);
        sliderBorderDisabledColor = new SBReference(new Color(214, 212, 198), -6, -9, 3);
        sliderTrackColor = new SBReference(new Color(240, 237, 224), 0, 20, 3);
        sliderTrackBorderColor = new SBReference(new Color(157, 156, 150), -53, -32, 3);
        sliderTrackDarkColor = new SBReference(new Color(242, 241, 232), -22, 39, 3);
        sliderTrackLightColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        sliderTickColor = new SBReference(new Color(118, 117, 108), 0, -50, 3);
        sliderTickDisabledColor = new SBReference(new Color(174, 174, 171), 0, 28, 4);
        sliderFocusColor = new SBReference(new Color(113, 112, 104), 0, -52, 3);
        spinnerRollover = new BooleanReference(false);
        spinnerButtColor = new SBReference(new Color(198, 213, 250), 0, 0, 6);
        spinnerButtRolloverColor = new SBReference(new Color(232, 238, 254), 0, 60, 6);
        spinnerButtPressedColor = new SBReference(new Color(175, 190, 224), 0, -11, 6);
        spinnerButtDisabledColor = new SBReference(new Color(242, 240, 228), 0, 30, 3);
        spinnerSpreadLight = new IntReference(20);
        spinnerSpreadDark = new IntReference(3);
        spinnerSpreadLightDisabled = new IntReference(20);
        spinnerSpreadDarkDisabled = new IntReference(1);
        spinnerBorderColor = new SBReference(new Color(128, 152, 186), -70, 23, 2);
        spinnerBorderDisabledColor = new SBReference(new Color(215, 212, 197), 0, -9, 3);
        spinnerArrowColor = new SBReference(new Color(77, 100, 132), -74, -18, 2);
        spinnerArrowDisabledColor = new SBReference(new Color(212, 210, 194), 0, -10, 3);
        comboBorderColor = new SBReference(new Color(128, 152, 186), -70, 23, 2);
        comboBorderDisabledColor = new SBReference(new Color(201, 198, 184), 0, -15, 3);
        comboSelectedBgColor = new SBReference(new Color(43, 107, 197), -36, -6, 2);
        comboSelectedTextColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        comboFocusBgColor = new SBReference(new Color(43, 107, 197), 0, 0, 1);
        comboBgColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        comboTextColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        comboButtColor = new SBReference(new Color(197, 213, 252), 0, 0, 6);
        comboButtRolloverColor = new SBReference(new Color(226, 234, 254), 0, 50, 6);
        comboButtPressedColor = new SBReference(new Color(175, 190, 224), 0, -11, 6);
        comboButtDisabledColor = new SBReference(new Color(238, 237, 231), -48, 29, 3);
        comboSpreadLight = new IntReference(20);
        comboSpreadDark = new IntReference(3);
        comboSpreadLightDisabled = new IntReference(20);
        comboSpreadDarkDisabled = new IntReference(1);
        comboButtBorderColor = new SBReference(new Color(212, 210, 194), 0, -10, 6);
        comboButtBorderDisabledColor = new SBReference(new Color(232, 230, 220), -41, 0, 3);
        comboArrowColor = new SBReference(new Color(77, 100, 132), -74, -18, 2);
        comboArrowDisabledColor = new SBReference(new Color(203, 200, 186), 0, -14, 3);
        comboInsets = new InsetsUIResource(2, 2, 2, 2);
        comboRollover = new BooleanReference(false);
        comboFocus = new BooleanReference(false);
        menuBarColor = new SBReference(new Color(238, 237, 230), -43, 28, 3);
        menuItemSelectedTextColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        menuPopupColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        menuRolloverBgColor = new SBReference(new Color(189, 208, 234), -50, 66, 2);
        menuRolloverFgColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        menuDisabledFgColor = new SBReference(new Color(143, 142, 139), 0, 0, 4);
        menuItemDisabledFgColor = new SBReference(new Color(143, 142, 139), 0, 0, 4);
        menuItemRolloverColor = new SBReference(new Color(189, 208, 234), -50, 66, 2);
        menuBorderColor = new SBReference(new Color(173, 170, 153), 4, -28, 3);
        menuInnerHilightColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        menuInnerShadowColor = new SBReference(new Color(213, 212, 207), -70, -7, 3);
        menuOuterHilightColor = new SBReference(new Color(173, 170, 153), 4, -28, 3);
        menuOuterShadowColor = new SBReference(new Color(173, 170, 153), 4, -28, 3);
        menuIconColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        menuIconRolloverColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        menuIconDisabledColor = new SBReference(new Color(165, 163, 151), 0, -30, 3);
        menuSeparatorColor = new SBReference(new Color(173, 170, 153), 4, -28, 3);
        menuRollover = new BooleanReference(true);
        menuPopupShadow = new BooleanReference(false);
        menuAllowTwoIcons = new BooleanReference(false);
        toolBarColor = new SBReference(new Color(239, 237, 229), -35, 28, 3);
        toolBarLightColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        toolBarDarkColor = new SBReference(new Color(214, 210, 187), 10, -11, 3);
        toolButtColor = new SBReference(new Color(239, 237, 229), -35, 28, 3);
        toolButtSelectedColor = new SBReference(new Color(243, 242, 239), -51, 52, 3);
        toolButtRolloverColor = new SBReference(new Color(251, 251, 248), -30, 81, 3);
        toolButtPressedColor = new SBReference(new Color(225, 224, 218), -58, -2, 3);
        toolGripDarkColor = new SBReference(new Color(167, 167, 163), -70, -27, 3);
        toolGripLightColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        toolSeparatorColor = new SBReference(new Color(167, 167, 163), -70, -27, 3);
        toolBorderColor = new SBReference(new Color(239, 237, 229), -35, 28, 3);
        toolBorderPressedColor = new SBReference(new Color(122, 144, 174), -76, 16, 2);
        toolBorderRolloverColor = new SBReference(new Color(122, 144, 174), -76, 16, 2);
        toolBorderSelectedColor = new SBReference(new Color(122, 144, 174), -76, 16, 2);
        toolMargin = new InsetsUIResource(5, 5, 5, 5);
        toolFocus = new BooleanReference(false);
        toolRollover = new BooleanReference(true);
        listBgColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        listTextColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        listSelectedBgColor = new SBReference(new Color(43, 107, 197), -36, -6, 2);
        listSelectedTextColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        listFocusBorderColor = new SBReference(new Color(179, 211, 255), 100, 70, 2);
        treeBgColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        treeTextColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        treeTextBgColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        treeSelectedTextColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        treeSelectedBgColor = new SBReference(new Color(43, 107, 197), -36, -6, 2);
        treeLineColor = new SBReference(new Color(208, 205, 190), 0, -12, 3);
        frameCaptionColor = new SBReference(new Color(13, 94, 255), 0, 5, 5);
        frameCaptionDisabledColor = new SBReference(new Color(122, 159, 223), -25, 41, 5);
        frameBorderColor = new SBReference(new Color(0, 60, 161), 0, -30, 5);
        frameLightColor = new SBReference(new Color(0, 68, 184), 0, -20, 5);
        frameBorderDisabledColor = new SBReference(new Color(74, 125, 212), -25, 20, 5);
        frameLightDisabledColor = new SBReference(new Color(99, 144, 233), -25, 30, 5);
        frameTitleColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameTitleShadowColor = new SBReference(new Color(0, 43, 128), 0, -50, 5);
        frameTitleDisabledColor = new SBReference(new Color(216, 226, 248), -29, 82, 5);
        frameButtColor = new SBReference(new Color(13, 94, 255), 0, 5, 5);
        frameButtRolloverColor = new SBReference(new Color(51, 119, 255), 0, 20, 5);
        frameButtPressedColor = new SBReference(new Color(0, 68, 204), 0, -20, 5);
        frameButtDisabledColor = new SBReference(new Color(63, 120, 233), -21, 16, 5);
        frameButtSpreadLight = new IntReference(8);
        frameButtSpreadDark = new IntReference(2);
        frameButtSpreadLightDisabled = new IntReference(5);
        frameButtSpreadDarkDisabled = new IntReference(2);
        frameButtCloseColor = new SBReference(new Color(227, 92, 60), 0, 0, 9);
        frameButtCloseRolloverColor = new SBReference(new Color(233, 125, 99), 0, 20, 9);
        frameButtClosePressedColor = new SBReference(new Color(193, 78, 51), 0, -15, 9);
        frameButtCloseDisabledColor = new SBReference(new Color(175, 105, 125), 0, 0, 12);
        frameButtCloseSpreadLight = new IntReference(8);
        frameButtCloseSpreadDark = new IntReference(2);
        frameButtCloseSpreadLightDisabled = new IntReference(5);
        frameButtCloseSpreadDarkDisabled = new IntReference(2);
        frameButtBorderColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameButtBorderDisabledColor = new SBReference(new Color(190, 206, 238), -42, 68, 5);
        frameSymbolColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolPressedColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolDisabledColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolDarkColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolLightColor = new SBReference(new Color(13, 94, 255), 0, 5, 5);
        frameSymbolDarkDisabledColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolLightDisabledColor = new SBReference(new Color(63, 120, 233), -21, 16, 5);
        frameButtCloseBorderColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameButtCloseDarkColor = new SBReference(new Color(174, 51, 20), 50, -32, 9);
        frameButtCloseLightColor = new SBReference(new Color(226, 88, 55), 11, -2, 9);
        frameButtCloseBorderDisabledColor = new SBReference(new Color(190, 206, 238), -42, 68, 5);
        frameSymbolCloseColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolClosePressedColor = new SBReference(new Color(231, 180, 168), -24, 50, 9);
        frameSymbolCloseDisabledColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolCloseDarkColor = new SBReference(new Color(227, 92, 60), 0, 0, 9);
        frameSymbolCloseDarkDisabledColor = new SBReference(new Color(175, 105, 125), 0, 0, 12);
        frameSpreadDark = new IntReference(3);
        frameSpreadLight = new IntReference(2);
        frameSpreadDarkDisabled = new IntReference(2);
        frameSpreadLightDisabled = new IntReference(2);
        tableBackColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        tableHeaderBackColor = new SBReference(new Color(236, 233, 216), 0, 0, 3);
        tableHeaderRolloverBackColor = new SBReference(new Color(249, 248, 243), 0, 70, 3);
        tableHeaderRolloverColor = new SBReference(new Color(248, 179, 48), 0, 0, 11);
        tableGridColor = new SBReference(new Color(167, 166, 160), -50, -28, 3);
        tableHeaderArrowColor = new SBReference(new Color(167, 166, 160), -50, -28, 3);
        tableSelectedBackColor = new SBReference(new Color(213, 211, 204), -50, -8, 3);
        tableSelectedForeColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        tableBorderDarkColor = new SBReference(new Color(167, 166, 160), -50, -28, 3);
        tableBorderLightColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        tableHeaderDarkColor = new SBReference(new Color(189, 186, 173), 0, -20, 3);
        tableHeaderLightColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        tableFocusBorderColor = new SBReference(new Color(185, 184, 177), -50, -20, 3);
        tableAlternateRowColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        for (int i = 0; i < 20; ++i) {
            Theme.colorizer[i] = new HSBReference(51, 25, 0, 3);
            Theme.colorize[i] = new BooleanReference(false);
        }
        separatorColor = new SBReference(new Color(167, 167, 163), -70, -27, 3);
        tipBorderColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        tipBorderDis = new SBReference(new Color(143, 141, 139), 0, 0, 4);
        tipBgColor = new SBReference(new Color(255, 255, 225), 0, 0, 1);
        tipBgDis = new SBReference(new Color(236, 233, 216), 0, 0, 3);
        tipTextColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        tipTextDis = new SBReference(new Color(143, 141, 139), 0, 0, 4);
        titledBorderColor = new SBReference(new Color(165, 163, 151), 0, -30, 3);
        splitPaneButtonColor = new SBReference(new Color(170, 168, 156), 0, -28, 3);
    }

    public static void loadYQTheme() {
        mainColor.update(new Color(0, 106, 255), 0, 0, 1);
        disColor.update(new Color(143, 142, 139), 0, 0, 1);
        backColor.update(new Color(236, 233, 216), 0, 0, 1);
        frameColor.update(new Color(0, 85, 255), 0, 0, 1);
        sub1Color.update(new Color(197, 213, 252), 0, 0, 1);
        sub2Color.update(new Color(34, 161, 34), 0, 0, 1);
        sub3Color.update(new Color(231, 232, 245), 0, 0, 1);
        sub4Color.update(new Color(227, 92, 60), 0, 0, 1);
        sub5Color.update(new Color(120, 123, 189), 0, 0, 1);
        sub6Color.update(new Color(248, 179, 48), 0, 0, 1);
        sub7Color.update(new Color(175, 105, 125), 0, 0, 1);
        sub8Color.update(new Color(255, 255, 255), 0, 0, 1);
        buttonFontColor.update(Color.BLACK);
        labelFontColor.update(Color.BLACK);
        menuFontColor.update(Color.BLACK);
        menuItemFontColor.update(Color.BLACK);
        radioFontColor.update(Color.BLACK);
        checkFontColor.update(Color.BLACK);
        tableFontColor.update(Color.BLACK);
        tableHeaderFontColor.update(Color.BLACK);
        titledBorderFontColor.update(Color.BLACK);
        tabFontColor.update(Color.BLACK);
        plainFont.update("Tahoma", 0, 11);
        boldFont.update("Tahoma", 1, 11);
        buttonFont.update(buttonFontColor);
        labelFont.update(labelFontColor);
        passwordFont.update((SBReference)null);
        comboFont.update((SBReference)null);
        listFont.update((SBReference)null);
        menuFont.update(menuFontColor);
        menuItemFont.update(menuItemFontColor);
        radioFont.update(radioFontColor);
        checkFont.update(checkFontColor);
        tableFont.update(tableFontColor);
        tableHeaderFont.update(tableHeaderFontColor);
        textAreaFont.update((SBReference)null);
        textFieldFont.update((SBReference)null);
        textPaneFont.update((SBReference)null);
        titledBorderFont.update(titledBorderFontColor);
        toolTipFont.update((SBReference)null);
        treeFont.update((SBReference)null);
        tabFontColor.update(Color.BLACK);
        tabFont.update(tabFontColor);
        tabFont.setBoldFont(false);
        editorFont.update((SBReference)null);
        frameTitleFont.update("Trebuchet MS", 1, 13);
        internalFrameTitleFont.update("Trebuchet MS", 1, 13);
        internalPaletteTitleFont.update("Trebuchet MS", 1, 12);
        progressBarFont.update((SBReference)null);
        progressColor.update(new Color(44, 212, 43), 43, 19, 7);
        progressTrackColor.update(new Color(255, 255, 255), 0, 100, 3);
        progressBorderColor.update(new Color(104, 104, 104), -100, -54, 3);
        progressDarkColor.update(new Color(190, 190, 190), -100, -16, 3);
        progressLightColor.update(new Color(238, 238, 238), -100, 40, 3);
        progressSelectForeColor.update(new Color(0, 0, 0), 0, -100, 3);
        progressSelectBackColor.update(new Color(0, 0, 0), 0, -100, 3);
        textBgColor.update(new Color(255, 255, 255), 0, 100, 3);
        textPaneBgColor.update(new Color(255, 255, 255), 0, 100, 3);
        editorPaneBgColor.update(new Color(255, 255, 255), 0, 100, 3);
        desktopPaneBgColor.update(new Color(212, 210, 194), 0, -10, 3);
        textTextColor.update(new Color(0, 0, 0), 0, -100, 3);
        textCaretColor.update(new Color(0, 0, 0), 0, -100, 3);
        textSelectedBgColor.update(new Color(43, 107, 197), -36, -6, 2);
        textSelectedTextColor.update(new Color(255, 255, 255), 0, 100, 3);
        textDisabledBgColor.update(new Color(240, 237, 224), 0, 20, 3);
        textNonEditableBgColor.update(new Color(240, 237, 224), 0, 20, 3);
        textBorderColor.update(new Color(128, 152, 186), -70, 23, 2);
        textBorderDisabledColor.update(new Color(201, 198, 184), 0, -15, 3);
        Theme.textInsets.top = 2;
        Theme.textInsets.left = 3;
        Theme.textInsets.bottom = 2;
        Theme.textInsets.right = 3;
        buttonRolloverBorder.setValue(true);
        buttonFocus.setValue(false);
        buttonFocusBorder.setValue(true);
        buttonEnter.setValue(true);
        shiftButtonText.setValue(true);
        buttonNormalColor.update(new Color(231, 232, 245), 0, 0, 8);
        buttonRolloverBgColor.update(new Color(239, 240, 248), 0, 33, 8);
        buttonPressedColor.update(new Color(217, 218, 230), 0, -6, 8);
        buttonDisabledColor.update(new Color(245, 244, 235), 0, 48, 3);
        buttonBorderColor.update(new Color(21, 61, 117), -30, -46, 2);
        buttonBorderDisabledColor.update(new Color(201, 198, 184), 0, -15, 3);
        buttonDisabledFgColor.update(new Color(143, 142, 139), 0, 0, 4);
        checkDisabledFgColor.update(new Color(143, 142, 139), 0, 0, 4);
        radioDisabledFgColor.update(new Color(143, 142, 139), 0, 0, 4);
        toggleSelectedBg.update(new Color(160, 182, 235), 38, -12, 6);
        Theme.buttonMargin.top = 2;
        Theme.buttonMargin.left = 12;
        Theme.buttonMargin.bottom = 2;
        Theme.buttonMargin.right = 12;
        buttonRolloverColor.update(new Color(248, 179, 48), 0, 0, 11);
        buttonDefaultColor.update(new Color(160, 182, 235), 38, -12, 6);
        buttonCheckColor.update(new Color(34, 161, 34), 0, 0, 7);
        buttonCheckDisabledColor.update(new Color(208, 205, 190), 0, -12, 3);
        Theme.checkMargin.top = 2;
        Theme.checkMargin.left = 2;
        Theme.checkMargin.bottom = 2;
        Theme.checkMargin.right = 2;
        buttonSpreadLight.setValue(20);
        buttonSpreadDark.setValue(3);
        buttonSpreadLightDisabled.setValue(20);
        buttonSpreadDarkDisabled.setValue(1);
        scrollRollover.setValue(true);
        scrollSize.setValue(17);
        scrollTrackColor.update(new Color(249, 249, 247), -50, 76, 3);
        scrollTrackDisabledColor.update(new Color(249, 249, 247), -50, 76, 3);
        scrollTrackBorderColor.update(new Color(234, 231, 218), -23, 0, 3);
        scrollTrackBorderDisabledColor.update(new Color(234, 231, 218), -23, 0, 3);
        scrollThumbColor.update(new Color(197, 213, 252), 0, 0, 6);
        scrollThumbRolloverColor.update(new Color(226, 234, 254), 0, 50, 6);
        scrollThumbPressedColor.update(new Color(187, 202, 239), 0, -5, 6);
        scrollThumbDisabledColor.update(new Color(238, 238, 231), 0, -3, 6);
        scrollGripLightColor.update(new Color(238, 243, 254), 0, 71, 6);
        scrollGripDarkColor.update(new Color(171, 185, 219), 0, -13, 6);
        scrollButtColor.update(new Color(197, 213, 252), 0, 0, 6);
        scrollButtRolloverColor.update(new Color(226, 234, 254), 0, 50, 6);
        scrollButtPressedColor.update(new Color(187, 202, 239), 0, -5, 6);
        scrollButtDisabledColor.update(new Color(238, 237, 231), -48, 29, 3);
        scrollSpreadLight.setValue(20);
        scrollSpreadDark.setValue(2);
        scrollSpreadLightDisabled.setValue(20);
        scrollSpreadDarkDisabled.setValue(1);
        scrollArrowColor.update(new Color(77, 100, 132), -74, -18, 2);
        scrollArrowDisabledColor.update(new Color(193, 193, 193), -100, -15, 3);
        scrollBorderColor.update(new Color(212, 210, 194), 0, -10, 6);
        scrollBorderLightColor.update(new Color(255, 255, 255), 0, 100, 6);
        scrollBorderDisabledColor.update(new Color(232, 230, 220), -41, 0, 3);
        scrollLightDisabledColor.update(new Color(232, 230, 220), -41, 0, 3);
        scrollPaneBorderColor.update(new Color(201, 198, 184), 0, -15, 3);
        tabPaneBorderColor.update(new Color(143, 160, 183), -78, 28, 2);
        tabNormalColor.update(new Color(242, 240, 238), 0, 69, 3);
        tabSelectedColor.update(new Color(251, 251, 250), 0, 91, 3);
        tabDisabledColor.update(new Color(244, 242, 232), 0, 40, 3);
        tabDisabledSelectedColor.update(new Color(251, 251, 247), 0, 80, 3);
        tabDisabledTextColor.update(new Color(188, 187, 185), 0, 40, 4);
        tabBorderColor.update(new Color(143, 160, 183), -78, 28, 2);
        tabRolloverColor.update(new Color(255, 199, 59), 0, 0, 11);
        tabRollover.setValue(true);
        tabFocus.setValue(true);
        ignoreSelectedBg.setValue(false);
        fixedTabs.setValue(true);
        Theme.tabInsets.top = 1;
        Theme.tabInsets.left = 6;
        Theme.tabInsets.bottom = 4;
        Theme.tabInsets.right = 6;
        Theme.tabAreaInsets.top = 4;
        Theme.tabAreaInsets.left = 2;
        Theme.tabAreaInsets.bottom = 0;
        Theme.tabAreaInsets.right = 0;
        sliderRolloverEnabled.setValue(true);
        sliderFocusEnabled.setValue(true);
        sliderThumbColor.update(new Color(245, 244, 235), 0, 49, 3);
        sliderThumbRolloverColor.update(new Color(233, 166, 0), 100, -26, 11);
        sliderThumbPressedColor.update(new Color(244, 243, 239), -50, 50, 3);
        sliderThumbDisabledColor.update(new Color(245, 243, 234), 0, 45, 3);
        sliderBorderColor.update(new Color(176, 189, 207), -76, 50, 2);
        sliderDarkColor.update(new Color(119, 130, 146), -89, 4, 2);
        sliderLightColor.update(new Color(27, 155, 27), 16, -7, 7);
        sliderBorderDisabledColor.update(new Color(214, 212, 198), -6, -9, 3);
        sliderTrackColor.update(new Color(240, 237, 224), 0, 20, 3);
        sliderTrackBorderColor.update(new Color(157, 156, 150), -53, -32, 3);
        sliderTrackDarkColor.update(new Color(242, 241, 232), -22, 39, 3);
        sliderTrackLightColor.update(new Color(255, 255, 255), 0, 100, 3);
        sliderTickColor.update(new Color(118, 117, 108), 0, -50, 3);
        sliderTickDisabledColor.update(new Color(174, 174, 171), 0, 28, 4);
        sliderFocusColor.update(new Color(113, 112, 104), 0, -52, 3);
        spinnerRollover.setValue(false);
        spinnerButtColor.update(new Color(198, 213, 250), 0, 0, 6);
        spinnerButtRolloverColor.update(new Color(232, 238, 254), 0, 60, 6);
        spinnerButtPressedColor.update(new Color(175, 190, 224), 0, -11, 6);
        spinnerButtDisabledColor.update(new Color(242, 240, 228), 0, 30, 3);
        spinnerSpreadLight.setValue(20);
        spinnerSpreadDark.setValue(3);
        spinnerSpreadLightDisabled.setValue(20);
        spinnerSpreadDarkDisabled.setValue(1);
        spinnerBorderColor.update(new Color(128, 152, 186), -70, 23, 2);
        spinnerBorderDisabledColor.update(new Color(215, 212, 197), 0, -9, 3);
        spinnerArrowColor.update(new Color(77, 100, 132), -74, -18, 2);
        spinnerArrowDisabledColor.update(new Color(212, 210, 194), 0, -10, 3);
        comboBorderColor.update(new Color(128, 152, 186), -70, 23, 2);
        comboBorderDisabledColor.update(new Color(201, 198, 184), 0, -15, 3);
        comboSelectedBgColor.update(new Color(43, 107, 197), -36, -6, 2);
        comboSelectedTextColor.update(new Color(255, 255, 255), 0, 100, 3);
        comboFocusBgColor.update(new Color(43, 107, 197), 0, 0, 1);
        comboBgColor.update(new Color(255, 255, 255), 0, 100, 3);
        comboTextColor.update(new Color(0, 0, 0), 0, -100, 3);
        comboButtColor.update(new Color(197, 213, 252), 0, 0, 6);
        comboButtRolloverColor.update(new Color(226, 234, 254), 0, 50, 6);
        comboButtPressedColor.update(new Color(175, 190, 224), 0, -11, 6);
        comboButtDisabledColor.update(new Color(238, 237, 231), -48, 29, 3);
        comboSpreadLight.setValue(20);
        comboSpreadDark.setValue(3);
        comboSpreadLightDisabled.setValue(20);
        comboSpreadDarkDisabled.setValue(1);
        comboButtBorderColor.update(new Color(212, 210, 194), 0, -10, 6);
        comboButtBorderDisabledColor.update(new Color(232, 230, 220), -41, 0, 3);
        comboArrowColor.update(new Color(77, 100, 132), -74, -18, 2);
        comboArrowDisabledColor.update(new Color(203, 200, 186), 0, -14, 3);
        Theme.comboInsets.top = 2;
        Theme.comboInsets.left = 2;
        Theme.comboInsets.bottom = 2;
        Theme.comboInsets.right = 2;
        comboRollover.setValue(false);
        comboFocus.setValue(false);
        menuBarColor.update(new Color(238, 237, 230), -43, 28, 3);
        menuItemSelectedTextColor.update(new Color(0, 0, 0), 0, -100, 3);
        menuPopupColor.update(new Color(255, 255, 255), 0, 100, 3);
        menuRolloverBgColor.update(new Color(189, 208, 234), -50, 66, 2);
        menuRolloverFgColor.update(new Color(0, 0, 0), 0, -100, 3);
        menuDisabledFgColor.update(new Color(143, 142, 139), 0, 0, 4);
        menuItemDisabledFgColor.update(new Color(143, 142, 139), 0, 0, 4);
        menuItemRolloverColor.update(new Color(189, 208, 234), -50, 66, 2);
        menuBorderColor.update(new Color(173, 170, 153), 4, -28, 3);
        menuInnerHilightColor.update(new Color(255, 255, 255), 0, 100, 3);
        menuInnerShadowColor.update(new Color(213, 212, 207), -70, -7, 3);
        menuOuterHilightColor.update(new Color(173, 170, 153), 4, -28, 3);
        menuOuterShadowColor.update(new Color(173, 170, 153), 4, -28, 3);
        menuIconColor.update(new Color(0, 0, 0), 0, -100, 3);
        menuIconRolloverColor.update(new Color(0, 0, 0), 0, -100, 3);
        menuIconDisabledColor.update(new Color(165, 163, 151), 0, -30, 3);
        menuSeparatorColor.update(new Color(173, 170, 153), 4, -28, 3);
        menuRollover.setValue(true);
        menuPopupShadow.setValue(false);
        menuAllowTwoIcons.setValue(false);
        toolBarColor.update(new Color(239, 237, 229), -35, 28, 3);
        toolBarLightColor.update(new Color(255, 255, 255), 0, 100, 3);
        toolBarDarkColor.update(new Color(214, 210, 187), 10, -11, 3);
        toolButtColor.update(new Color(239, 237, 229), -35, 28, 3);
        toolButtSelectedColor.update(new Color(243, 242, 239), -51, 52, 3);
        toolButtRolloverColor.update(new Color(251, 251, 248), -30, 81, 3);
        toolButtPressedColor.update(new Color(225, 224, 218), -58, -2, 3);
        toolGripDarkColor.update(new Color(167, 167, 163), -70, -27, 3);
        toolGripLightColor.update(new Color(255, 255, 255), 0, 100, 3);
        toolSeparatorColor.update(new Color(167, 167, 163), -70, -27, 3);
        toolBorderColor.update(new Color(239, 237, 229), -35, 28, 3);
        toolBorderPressedColor.update(new Color(122, 144, 174), -76, 16, 2);
        toolBorderRolloverColor.update(new Color(122, 144, 174), -76, 16, 2);
        toolBorderSelectedColor.update(new Color(122, 144, 174), -76, 16, 2);
        Theme.toolMargin.top = 5;
        Theme.toolMargin.left = 5;
        Theme.toolMargin.bottom = 5;
        Theme.toolMargin.right = 5;
        toolFocus.setValue(false);
        toolRollover.setValue(true);
        listBgColor.update(new Color(255, 255, 255), 0, 100, 3);
        listTextColor.update(new Color(0, 0, 0), 0, -100, 3);
        listSelectedBgColor.update(new Color(43, 107, 197), -36, -6, 2);
        listSelectedTextColor.update(new Color(255, 255, 255), 0, 100, 3);
        listFocusBorderColor.update(new Color(179, 211, 255), 100, 70, 2);
        treeBgColor.update(new Color(255, 255, 255), 0, 100, 3);
        treeTextColor.update(new Color(0, 0, 0), 0, -100, 3);
        treeTextBgColor.update(new Color(255, 255, 255), 0, 100, 3);
        treeSelectedTextColor.update(new Color(255, 255, 255), 0, 100, 3);
        treeSelectedBgColor.update(new Color(43, 107, 197), -36, -6, 2);
        treeLineColor.update(new Color(208, 205, 190), 0, -12, 3);
        frameCaptionColor.update(new Color(13, 94, 255), 0, 5, 5);
        frameCaptionDisabledColor.update(new Color(122, 159, 223), -25, 41, 5);
        frameBorderColor.update(new Color(0, 60, 161), 0, -30, 5);
        frameLightColor.update(new Color(0, 68, 184), 0, -20, 5);
        frameBorderDisabledColor.update(new Color(74, 125, 212), -25, 20, 5);
        frameLightDisabledColor.update(new Color(99, 144, 233), -25, 30, 5);
        frameTitleColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameTitleShadowColor.update(new Color(0, 43, 128), 0, -50, 5);
        frameTitleDisabledColor.update(new Color(216, 226, 248), -29, 82, 5);
        frameButtColor.update(new Color(13, 94, 255), 0, 5, 5);
        frameButtRolloverColor.update(new Color(51, 119, 255), 0, 20, 5);
        frameButtPressedColor.update(new Color(0, 68, 204), 0, -20, 5);
        frameButtDisabledColor.update(new Color(63, 120, 233), -21, 16, 5);
        frameButtSpreadLight.setValue(8);
        frameButtSpreadDark.setValue(2);
        frameButtSpreadLightDisabled.setValue(5);
        frameButtSpreadDarkDisabled.setValue(2);
        frameButtCloseColor.update(new Color(227, 92, 60), 0, 0, 9);
        frameButtCloseRolloverColor.update(new Color(233, 125, 99), 0, 20, 9);
        frameButtClosePressedColor.update(new Color(193, 78, 51), 0, -15, 9);
        frameButtCloseDisabledColor.update(new Color(175, 105, 125), 0, 0, 12);
        frameButtCloseSpreadLight.setValue(8);
        frameButtCloseSpreadDark.setValue(2);
        frameButtCloseSpreadLightDisabled.setValue(5);
        frameButtCloseSpreadDarkDisabled.setValue(2);
        frameButtBorderColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameButtBorderDisabledColor.update(new Color(190, 206, 238), -42, 68, 5);
        frameSymbolColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolPressedColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolDisabledColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolDarkColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolLightColor.update(new Color(13, 94, 255), 0, 5, 5);
        frameSymbolDarkDisabledColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolLightDisabledColor.update(new Color(63, 120, 233), -21, 16, 5);
        frameButtCloseBorderColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameButtCloseDarkColor.update(new Color(174, 51, 20), 50, -32, 9);
        frameButtCloseLightColor.update(new Color(226, 88, 55), 11, -2, 9);
        frameButtCloseBorderDisabledColor.update(new Color(190, 206, 238), -42, 68, 5);
        frameSymbolCloseColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolClosePressedColor.update(new Color(231, 180, 168), -24, 50, 9);
        frameSymbolCloseDisabledColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolCloseDarkColor.update(new Color(227, 92, 60), 0, 0, 9);
        frameSymbolCloseDarkDisabledColor.update(new Color(175, 105, 125), 0, 0, 12);
        frameSpreadDark.setValue(3);
        frameSpreadLight.setValue(2);
        frameSpreadDarkDisabled.setValue(2);
        frameSpreadLightDisabled.setValue(2);
        tableBackColor.update(new Color(255, 255, 255), 0, 100, 3);
        tableHeaderBackColor.update(new Color(236, 233, 216), 0, 0, 3);
        tableHeaderRolloverBackColor.update(new Color(249, 248, 243), 0, 70, 3);
        tableHeaderRolloverColor.update(new Color(248, 179, 48), 0, 0, 11);
        tableGridColor.update(new Color(167, 166, 160), -50, -28, 3);
        tableHeaderArrowColor.update(new Color(167, 166, 160), -50, -28, 3);
        tableSelectedBackColor.update(new Color(213, 211, 204), -50, -8, 3);
        tableSelectedForeColor.update(new Color(0, 0, 0), 0, -100, 3);
        tableBorderDarkColor.update(new Color(167, 166, 160), -50, -28, 3);
        tableBorderLightColor.update(new Color(255, 255, 255), 0, 100, 3);
        tableHeaderDarkColor.update(new Color(189, 186, 173), 0, -20, 3);
        tableHeaderLightColor.update(new Color(255, 255, 255), 0, 100, 3);
        tableFocusBorderColor.update(new Color(185, 184, 177), -50, -20, 3);
        tableAlternateRowColor.update(new Color(255, 255, 255), 0, 100, 3);
        for (int i = 0; i < 20; ++i) {
            colorizer[i].setHue(51);
            colorizer[i].setSaturation(25);
            colorizer[i].setBrightness(0);
            colorizer[i].setReference(3);
            colorize[i].setValue(false);
        }
        separatorColor.update(new Color(167, 167, 163), -70, -27, 3);
        tipBorderColor.update(new Color(0, 0, 0), 0, -100, 3);
        tipBorderDis.update(new Color(143, 141, 139), 0, 0, 4);
        tipBgColor.update(new Color(255, 255, 225), 0, 0, 1);
        tipBgDis.update(new Color(236, 233, 216), 0, 0, 3);
        tipTextColor.update(new Color(0, 0, 0), 0, -100, 3);
        tipTextDis.update(new Color(143, 141, 139), 0, 0, 4);
        titledBorderColor.update(new Color(165, 163, 151), 0, -30, 3);
        splitPaneButtonColor.update(new Color(170, 168, 156), 0, -28, 3);
    }

    public static boolean loadTheme(File file) {
        errorCode = 1;
        if (file == null) {
            errorCode = 2;
            return false;
        }
        try {
            return Theme.loadTheme(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Theme.loadTheme(File) : " + fileNotFoundException);
            errorCode = 3;
        }
        catch (IOException iOException) {
            System.out.println("Theme.loadTheme(File) : " + iOException);
            errorCode = 4;
        }
        return false;
    }

    public static boolean loadTheme(ThemeDescription themeDescription) {
        if (themeDescription == null) {
            errorCode = 2;
            return false;
        }
        if (themeDescription.isValid()) {
            return Theme.loadTheme(themeDescription.getURL());
        }
        errorCode = 7;
        return false;
    }

    public static boolean loadTheme(URL uRL) {
        errorCode = 1;
        if (uRL == null) {
            errorCode = 2;
            return false;
        }
        if (YQ_URL != null && uRL.equals(YQ_URL)) {
            Theme.loadYQTheme();
            return true;
        }
        try {
            return Theme.loadTheme(uRL.openStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            errorCode = 3;
        }
        catch (IOException iOException) {
            System.out.println("Theme.loadTheme(URL) : " + iOException);
            errorCode = 4;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadTheme(InputStream inputStream) throws IOException {
        FilterInputStream filterInputStream = null;
        try {
            Color color;
            filterInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            fileID = ((DataInputStream)filterInputStream).readInt();
            if (fileID != 12852 && fileID != 12853 && fileID != 12854 && fileID != 12855 && fileID != 12856 && fileID != 12857 && fileID != 16384 && fileID != 16385 && fileID != 16386 && fileID != 16387 && fileID != 16388 && fileID != 8756 && fileID != 4660) {
                errorCode = 5;
                boolean bl = false;
                return bl;
            }
            int n = ((DataInputStream)filterInputStream).readInt();
            if (n != 2) {
                errorCode = 6;
                boolean bl = false;
                return bl;
            }
            mainColor.load((DataInputStream)filterInputStream);
            disColor.load((DataInputStream)filterInputStream);
            backColor.load((DataInputStream)filterInputStream);
            frameColor.load((DataInputStream)filterInputStream);
            sub1Color.load((DataInputStream)filterInputStream);
            sub2Color.load((DataInputStream)filterInputStream);
            sub3Color.load((DataInputStream)filterInputStream);
            sub4Color.load((DataInputStream)filterInputStream);
            sub5Color.load((DataInputStream)filterInputStream);
            sub6Color.load((DataInputStream)filterInputStream);
            sub7Color.load((DataInputStream)filterInputStream);
            sub8Color.load((DataInputStream)filterInputStream);
            plainFont.load((DataInputStream)filterInputStream);
            boldFont.load((DataInputStream)filterInputStream);
            buttonFont.load((DataInputStream)filterInputStream);
            passwordFont.load((DataInputStream)filterInputStream);
            labelFont.load((DataInputStream)filterInputStream);
            comboFont.load((DataInputStream)filterInputStream);
            if (fileID == 4660) {
                ColoredFont.loadDummyData((DataInputStream)filterInputStream);
            }
            listFont.load((DataInputStream)filterInputStream);
            menuFont.load((DataInputStream)filterInputStream);
            menuItemFont.load((DataInputStream)filterInputStream);
            radioFont.load((DataInputStream)filterInputStream);
            checkFont.load((DataInputStream)filterInputStream);
            tableFont.load((DataInputStream)filterInputStream);
            tableHeaderFont.load((DataInputStream)filterInputStream);
            textAreaFont.load((DataInputStream)filterInputStream);
            textFieldFont.load((DataInputStream)filterInputStream);
            textPaneFont.load((DataInputStream)filterInputStream);
            titledBorderFont.load((DataInputStream)filterInputStream);
            toolTipFont.load((DataInputStream)filterInputStream);
            treeFont.load((DataInputStream)filterInputStream);
            tabFont.load((DataInputStream)filterInputStream);
            editorFont.load((DataInputStream)filterInputStream);
            frameTitleFont.load((DataInputStream)filterInputStream);
            if (fileID >= 12852) {
                internalFrameTitleFont.load((DataInputStream)filterInputStream);
                internalPaletteTitleFont.load((DataInputStream)filterInputStream);
            }
            if (fileID != 4660) {
                progressBarFont.load((DataInputStream)filterInputStream);
            }
            buttonFontColor.load((DataInputStream)filterInputStream);
            buttonFont.setSBReference(buttonFontColor);
            labelFontColor.load((DataInputStream)filterInputStream);
            labelFont.setSBReference(labelFontColor);
            menuFontColor.load((DataInputStream)filterInputStream);
            menuFont.setSBReference(menuFontColor);
            menuItemFontColor.load((DataInputStream)filterInputStream);
            menuItemFont.setSBReference(menuItemFontColor);
            radioFontColor.load((DataInputStream)filterInputStream);
            radioFont.setSBReference(radioFontColor);
            checkFontColor.load((DataInputStream)filterInputStream);
            checkFont.setSBReference(checkFontColor);
            tableFontColor.load((DataInputStream)filterInputStream);
            tableFont.setSBReference(tableFontColor);
            tableHeaderFontColor.load((DataInputStream)filterInputStream);
            tableHeaderFont.setSBReference(tableHeaderFontColor);
            tabFontColor.load((DataInputStream)filterInputStream);
            tabFont.setSBReference(tabFontColor);
            titledBorderFontColor.load((DataInputStream)filterInputStream);
            titledBorderFont.setSBReference(titledBorderFontColor);
            if (fileID < 12854) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            progressColor.load((DataInputStream)filterInputStream);
            progressTrackColor.load((DataInputStream)filterInputStream);
            progressBorderColor.load((DataInputStream)filterInputStream);
            progressDarkColor.load((DataInputStream)filterInputStream);
            progressLightColor.load((DataInputStream)filterInputStream);
            if (fileID != 4660) {
                progressSelectForeColor.load((DataInputStream)filterInputStream);
                progressSelectBackColor.load((DataInputStream)filterInputStream);
            }
            textBgColor.load((DataInputStream)filterInputStream);
            textTextColor.load((DataInputStream)filterInputStream);
            if (fileID >= 12852) {
                textCaretColor.load((DataInputStream)filterInputStream);
                editorPaneBgColor.load((DataInputStream)filterInputStream);
                textPaneBgColor.load((DataInputStream)filterInputStream);
                desktopPaneBgColor.load((DataInputStream)filterInputStream);
            }
            textSelectedBgColor.load((DataInputStream)filterInputStream);
            textSelectedTextColor.load((DataInputStream)filterInputStream);
            textDisabledBgColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                textNonEditableBgColor.update(textDisabledBgColor);
            } else {
                textNonEditableBgColor.load((DataInputStream)filterInputStream);
            }
            textBorderColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            textBorderDisabledColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            Theme.textInsets.top = ((DataInputStream)filterInputStream).readInt();
            Theme.textInsets.left = ((DataInputStream)filterInputStream).readInt();
            Theme.textInsets.bottom = ((DataInputStream)filterInputStream).readInt();
            Theme.textInsets.right = ((DataInputStream)filterInputStream).readInt();
            buttonRolloverBorder.setValue(((DataInputStream)filterInputStream).readBoolean());
            buttonFocus.setValue(((DataInputStream)filterInputStream).readBoolean());
            if (fileID >= 12852) {
                buttonFocusBorder.setValue(((DataInputStream)filterInputStream).readBoolean());
                buttonEnter.setValue(((DataInputStream)filterInputStream).readBoolean());
            }
            if (fileID >= 12855) {
                shiftButtonText.setValue(((DataInputStream)filterInputStream).readBoolean());
            }
            buttonNormalColor.load((DataInputStream)filterInputStream);
            buttonRolloverBgColor.load((DataInputStream)filterInputStream);
            buttonPressedColor.load((DataInputStream)filterInputStream);
            buttonDisabledColor.load((DataInputStream)filterInputStream);
            buttonBorderColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            buttonBorderDisabledColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            Theme.buttonMargin.top = ((DataInputStream)filterInputStream).readInt();
            Theme.buttonMargin.left = ((DataInputStream)filterInputStream).readInt();
            Theme.buttonMargin.bottom = ((DataInputStream)filterInputStream).readInt();
            Theme.buttonMargin.right = ((DataInputStream)filterInputStream).readInt();
            if (fileID >= 12853) {
                Theme.checkMargin.top = ((DataInputStream)filterInputStream).readInt();
                Theme.checkMargin.left = ((DataInputStream)filterInputStream).readInt();
                Theme.checkMargin.bottom = ((DataInputStream)filterInputStream).readInt();
                Theme.checkMargin.right = ((DataInputStream)filterInputStream).readInt();
            } else {
                Theme.checkMargin.top = 2;
                Theme.checkMargin.left = 2;
                Theme.checkMargin.bottom = 2;
                Theme.checkMargin.right = 2;
            }
            buttonRolloverColor.load((DataInputStream)filterInputStream);
            buttonDefaultColor.load((DataInputStream)filterInputStream);
            buttonCheckColor.load((DataInputStream)filterInputStream);
            buttonCheckDisabledColor.load((DataInputStream)filterInputStream);
            buttonDisabledFgColor.load((DataInputStream)filterInputStream);
            checkDisabledFgColor.load((DataInputStream)filterInputStream);
            radioDisabledFgColor.load((DataInputStream)filterInputStream);
            if (fileID >= 16385) {
                toggleSelectedBg.load((DataInputStream)filterInputStream);
            } else {
                toggleSelectedBg.update(buttonPressedColor);
            }
            buttonSpreadLight.setValue(((DataInputStream)filterInputStream).readInt());
            buttonSpreadDark.setValue(((DataInputStream)filterInputStream).readInt());
            buttonSpreadLightDisabled.setValue(((DataInputStream)filterInputStream).readInt());
            buttonSpreadDarkDisabled.setValue(((DataInputStream)filterInputStream).readInt());
            if (fileID < 12852) {
                Theme.buttonMargin.top = Math.max(0, Theme.buttonMargin.top - 2);
                Theme.buttonMargin.left = Math.max(0, Theme.buttonMargin.left - 2);
                Theme.buttonMargin.bottom = Math.max(0, Theme.buttonMargin.bottom - 2);
                Theme.buttonMargin.right = Math.max(0, Theme.buttonMargin.right - 2);
            }
            scrollRollover.setValue(((DataInputStream)filterInputStream).readBoolean());
            if (fileID >= 16387) {
                scrollSize.setValue(((DataInputStream)filterInputStream).readInt());
            } else {
                scrollSize.setValue(17);
            }
            scrollTrackColor.load((DataInputStream)filterInputStream);
            scrollTrackDisabledColor.load((DataInputStream)filterInputStream);
            scrollTrackBorderColor.load((DataInputStream)filterInputStream);
            scrollTrackBorderDisabledColor.load((DataInputStream)filterInputStream);
            scrollThumbColor.load((DataInputStream)filterInputStream);
            scrollThumbRolloverColor.load((DataInputStream)filterInputStream);
            scrollThumbPressedColor.load((DataInputStream)filterInputStream);
            scrollThumbDisabledColor.load((DataInputStream)filterInputStream);
            scrollGripLightColor.load((DataInputStream)filterInputStream);
            scrollGripDarkColor.load((DataInputStream)filterInputStream);
            scrollButtColor.load((DataInputStream)filterInputStream);
            scrollButtRolloverColor.load((DataInputStream)filterInputStream);
            scrollButtPressedColor.load((DataInputStream)filterInputStream);
            scrollButtDisabledColor.load((DataInputStream)filterInputStream);
            scrollSpreadLight.setValue(((DataInputStream)filterInputStream).readInt());
            scrollSpreadDark.setValue(((DataInputStream)filterInputStream).readInt());
            scrollSpreadLightDisabled.setValue(((DataInputStream)filterInputStream).readInt());
            scrollSpreadDarkDisabled.setValue(((DataInputStream)filterInputStream).readInt());
            scrollArrowColor.load((DataInputStream)filterInputStream);
            scrollArrowDisabledColor.load((DataInputStream)filterInputStream);
            scrollBorderColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            scrollBorderLightColor.load((DataInputStream)filterInputStream);
            scrollBorderDisabledColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            scrollLightDisabledColor.load((DataInputStream)filterInputStream);
            scrollPaneBorderColor.load((DataInputStream)filterInputStream);
            tabPaneBorderColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            tabNormalColor.load((DataInputStream)filterInputStream);
            tabSelectedColor.load((DataInputStream)filterInputStream);
            if (fileID >= 12852) {
                tabDisabledColor.load((DataInputStream)filterInputStream);
                tabDisabledSelectedColor.load((DataInputStream)filterInputStream);
                tabDisabledTextColor.load((DataInputStream)filterInputStream);
            }
            tabBorderColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            tabRolloverColor.load((DataInputStream)filterInputStream);
            if (fileID >= 16384) {
                tabDisabledBorderColor.load((DataInputStream)filterInputStream);
                tabPaneDisabledBorderColor.load((DataInputStream)filterInputStream);
            } else {
                tabDisabledBorderColor.update(tabBorderColor);
                tabPaneDisabledBorderColor.update(tabPaneBorderColor);
            }
            int n2 = -1;
            if (fileID < 12852) {
                n2 = ((DataInputStream)filterInputStream).readInt();
            }
            tabRollover.setValue(((DataInputStream)filterInputStream).readBoolean());
            if (fileID >= 12856) {
                tabFocus.setValue(((DataInputStream)filterInputStream).readBoolean());
            } else {
                tabFocus.setValue(true);
            }
            ignoreSelectedBg.setValue(((DataInputStream)filterInputStream).readBoolean());
            if (fileID >= 12854) {
                fixedTabs.setValue(((DataInputStream)filterInputStream).readBoolean());
            }
            if (fileID < 12852) {
                ((DataInputStream)filterInputStream).readInt();
                ((DataInputStream)filterInputStream).readInt();
                ((DataInputStream)filterInputStream).readInt();
                ((DataInputStream)filterInputStream).readInt();
            }
            if (fileID >= 12852) {
                Theme.tabInsets.top = ((DataInputStream)filterInputStream).readInt();
                Theme.tabInsets.left = ((DataInputStream)filterInputStream).readInt();
                Theme.tabInsets.bottom = ((DataInputStream)filterInputStream).readInt();
                Theme.tabInsets.right = ((DataInputStream)filterInputStream).readInt();
                Theme.tabAreaInsets.top = ((DataInputStream)filterInputStream).readInt();
                Theme.tabAreaInsets.left = ((DataInputStream)filterInputStream).readInt();
                Theme.tabAreaInsets.bottom = ((DataInputStream)filterInputStream).readInt();
                Theme.tabAreaInsets.right = ((DataInputStream)filterInputStream).readInt();
                if (n2 > -1) {
                    Theme.tabAreaInsets.left = n2;
                }
            }
            sliderRolloverEnabled.setValue(((DataInputStream)filterInputStream).readBoolean());
            if (fileID >= 12856) {
                sliderFocusEnabled.setValue(((DataInputStream)filterInputStream).readBoolean());
            } else {
                sliderFocusEnabled.setValue(true);
            }
            sliderThumbColor.load((DataInputStream)filterInputStream);
            sliderThumbRolloverColor.load((DataInputStream)filterInputStream);
            sliderThumbPressedColor.load((DataInputStream)filterInputStream);
            sliderThumbDisabledColor.load((DataInputStream)filterInputStream);
            sliderBorderColor.load((DataInputStream)filterInputStream);
            sliderDarkColor.load((DataInputStream)filterInputStream);
            sliderLightColor.load((DataInputStream)filterInputStream);
            if (fileID < 12852) {
                sliderLightColor.update(buttonCheckColor);
            }
            sliderBorderDisabledColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            sliderTrackColor.load((DataInputStream)filterInputStream);
            sliderTrackBorderColor.load((DataInputStream)filterInputStream);
            sliderTrackDarkColor.load((DataInputStream)filterInputStream);
            sliderTrackLightColor.load((DataInputStream)filterInputStream);
            sliderTickColor.load((DataInputStream)filterInputStream);
            sliderTickDisabledColor.load((DataInputStream)filterInputStream);
            if (fileID >= 12856) {
                sliderFocusColor.load((DataInputStream)filterInputStream);
            }
            spinnerRollover.setValue(((DataInputStream)filterInputStream).readBoolean());
            spinnerButtColor.load((DataInputStream)filterInputStream);
            spinnerButtRolloverColor.load((DataInputStream)filterInputStream);
            spinnerButtPressedColor.load((DataInputStream)filterInputStream);
            spinnerButtDisabledColor.load((DataInputStream)filterInputStream);
            spinnerSpreadLight.setValue(((DataInputStream)filterInputStream).readInt());
            spinnerSpreadDark.setValue(((DataInputStream)filterInputStream).readInt());
            spinnerSpreadLightDisabled.setValue(((DataInputStream)filterInputStream).readInt());
            spinnerSpreadDarkDisabled.setValue(((DataInputStream)filterInputStream).readInt());
            spinnerBorderColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            spinnerBorderDisabledColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            spinnerArrowColor.load((DataInputStream)filterInputStream);
            spinnerArrowDisabledColor.load((DataInputStream)filterInputStream);
            comboBorderColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            comboBorderDisabledColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            comboSelectedBgColor.load((DataInputStream)filterInputStream);
            comboSelectedTextColor.load((DataInputStream)filterInputStream);
            comboFocusBgColor.load((DataInputStream)filterInputStream);
            if (fileID >= 12852) {
                comboBgColor.load((DataInputStream)filterInputStream);
                comboTextColor.load((DataInputStream)filterInputStream);
            } else {
                comboBgColor.update(textBgColor);
                comboTextColor.update(textTextColor);
            }
            comboButtColor.load((DataInputStream)filterInputStream);
            comboButtRolloverColor.load((DataInputStream)filterInputStream);
            comboButtPressedColor.load((DataInputStream)filterInputStream);
            comboButtDisabledColor.load((DataInputStream)filterInputStream);
            comboSpreadLight.setValue(((DataInputStream)filterInputStream).readInt());
            comboSpreadDark.setValue(((DataInputStream)filterInputStream).readInt());
            comboSpreadLightDisabled.setValue(((DataInputStream)filterInputStream).readInt());
            comboSpreadDarkDisabled.setValue(((DataInputStream)filterInputStream).readInt());
            comboButtBorderColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            comboButtBorderDisabledColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            comboArrowColor.load((DataInputStream)filterInputStream);
            comboArrowDisabledColor.load((DataInputStream)filterInputStream);
            Theme.comboInsets.top = ((DataInputStream)filterInputStream).readInt();
            Theme.comboInsets.left = ((DataInputStream)filterInputStream).readInt();
            Theme.comboInsets.bottom = ((DataInputStream)filterInputStream).readInt();
            Theme.comboInsets.right = ((DataInputStream)filterInputStream).readInt();
            comboRollover.setValue(((DataInputStream)filterInputStream).readBoolean());
            comboFocus.setValue(((DataInputStream)filterInputStream).readBoolean());
            menuBarColor.load((DataInputStream)filterInputStream);
            menuItemSelectedTextColor.load((DataInputStream)filterInputStream);
            menuPopupColor.load((DataInputStream)filterInputStream);
            menuRolloverBgColor.load((DataInputStream)filterInputStream);
            menuItemRolloverColor.load((DataInputStream)filterInputStream);
            menuBorderColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            menuIconColor.load((DataInputStream)filterInputStream);
            menuIconRolloverColor.load((DataInputStream)filterInputStream);
            menuIconDisabledColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            menuSeparatorColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                ((DataInputStream)filterInputStream).readInt();
                ((DataInputStream)filterInputStream).readInt();
                ((DataInputStream)filterInputStream).readInt();
                ((DataInputStream)filterInputStream).readInt();
            }
            menuRollover.setValue(((DataInputStream)filterInputStream).readBoolean());
            if (fileID >= 12852) {
                menuInnerHilightColor.load((DataInputStream)filterInputStream);
                menuInnerShadowColor.load((DataInputStream)filterInputStream);
                menuOuterHilightColor.load((DataInputStream)filterInputStream);
                menuOuterShadowColor.load((DataInputStream)filterInputStream);
                menuRolloverFgColor.load((DataInputStream)filterInputStream);
                menuDisabledFgColor.load((DataInputStream)filterInputStream);
            } else {
                menuRolloverFgColor.update(menuFont.getSBReference());
                menuDisabledFgColor.update(buttonDisabledFgColor);
            }
            if (fileID >= 16384) {
                menuItemDisabledFgColor.load((DataInputStream)filterInputStream);
            } else {
                menuItemDisabledFgColor.update(menuDisabledFgColor);
            }
            if (fileID > 16385) {
                menuPopupShadow.setValue(((DataInputStream)filterInputStream).readBoolean());
                menuAllowTwoIcons.setValue(((DataInputStream)filterInputStream).readBoolean());
            } else {
                menuPopupShadow.setValue(false);
                menuAllowTwoIcons.setValue(false);
            }
            toolBarColor.load((DataInputStream)filterInputStream);
            toolBarLightColor.load((DataInputStream)filterInputStream);
            toolBarDarkColor.load((DataInputStream)filterInputStream);
            if (fileID >= 12852) {
                toolButtColor.load((DataInputStream)filterInputStream);
                toolButtRolloverColor.load((DataInputStream)filterInputStream);
                toolButtPressedColor.load((DataInputStream)filterInputStream);
                toolButtSelectedColor.load((DataInputStream)filterInputStream);
            } else {
                toolButtSelectedColor.load((DataInputStream)filterInputStream);
                toolButtRolloverColor.load((DataInputStream)filterInputStream);
                toolButtPressedColor.load((DataInputStream)filterInputStream);
                toolButtColor.update(toolButtSelectedColor);
            }
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            toolBorderColor.load((DataInputStream)filterInputStream);
            if (fileID >= 12852) {
                toolBorderRolloverColor.load((DataInputStream)filterInputStream);
            } else {
                toolBorderRolloverColor.update(toolBorderColor);
            }
            toolBorderPressedColor.load((DataInputStream)filterInputStream);
            toolBorderSelectedColor.load((DataInputStream)filterInputStream);
            toolRollover.setValue(((DataInputStream)filterInputStream).readBoolean());
            toolFocus.setValue(((DataInputStream)filterInputStream).readBoolean());
            if (fileID >= 12852) {
                toolGripDarkColor.load((DataInputStream)filterInputStream);
                toolGripLightColor.load((DataInputStream)filterInputStream);
                toolSeparatorColor.load((DataInputStream)filterInputStream);
                if (fileID < 16384) {
                    SBReference.loadDummyData((DataInputStream)filterInputStream);
                }
                Theme.toolMargin.top = ((DataInputStream)filterInputStream).readInt();
                Theme.toolMargin.left = ((DataInputStream)filterInputStream).readInt();
                Theme.toolMargin.bottom = ((DataInputStream)filterInputStream).readInt();
                Theme.toolMargin.right = ((DataInputStream)filterInputStream).readInt();
            } else {
                Theme.toolMargin.top = 5;
                Theme.toolMargin.left = 5;
                Theme.toolMargin.bottom = 5;
                Theme.toolMargin.right = 5;
            }
            listSelectedBgColor.load((DataInputStream)filterInputStream);
            listSelectedTextColor.load((DataInputStream)filterInputStream);
            if (fileID >= 12852) {
                listBgColor.load((DataInputStream)filterInputStream);
                listTextColor.load((DataInputStream)filterInputStream);
            }
            if (fileID >= 16384) {
                listFocusBorderColor.load((DataInputStream)filterInputStream);
            } else {
                listFocusBorderColor.update(new Color(213, 211, 209), 0, 0, 1);
            }
            treeBgColor.load((DataInputStream)filterInputStream);
            treeTextColor.load((DataInputStream)filterInputStream);
            treeTextBgColor.load((DataInputStream)filterInputStream);
            treeSelectedTextColor.load((DataInputStream)filterInputStream);
            treeSelectedBgColor.load((DataInputStream)filterInputStream);
            if (fileID >= 12852) {
                treeLineColor.load((DataInputStream)filterInputStream);
            }
            frameCaptionColor.load((DataInputStream)filterInputStream);
            frameCaptionDisabledColor.load((DataInputStream)filterInputStream);
            frameBorderColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            frameLightColor.load((DataInputStream)filterInputStream);
            frameBorderDisabledColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            frameLightDisabledColor.load((DataInputStream)filterInputStream);
            frameTitleColor.load((DataInputStream)filterInputStream);
            if (fileID > 16385) {
                frameTitleShadowColor.load((DataInputStream)filterInputStream);
            } else {
                frameTitleShadowColor.update(frameCaptionColor);
                if (ColorRoutines.isColorDarker(frameTitleColor.getColor(), frameCaptionColor.getColor())) {
                    frameTitleShadowColor.setBrightness(-8);
                } else {
                    frameTitleShadowColor.setBrightness(-50);
                }
            }
            frameTitleDisabledColor.load((DataInputStream)filterInputStream);
            frameButtColor.load((DataInputStream)filterInputStream);
            frameButtRolloverColor.load((DataInputStream)filterInputStream);
            frameButtPressedColor.load((DataInputStream)filterInputStream);
            frameButtDisabledColor.load((DataInputStream)filterInputStream);
            frameButtSpreadDark.setValue(((DataInputStream)filterInputStream).readInt());
            frameButtSpreadLight.setValue(((DataInputStream)filterInputStream).readInt());
            frameButtSpreadDarkDisabled.setValue(((DataInputStream)filterInputStream).readInt());
            frameButtSpreadLightDisabled.setValue(((DataInputStream)filterInputStream).readInt());
            frameButtCloseColor.load((DataInputStream)filterInputStream);
            frameButtCloseRolloverColor.load((DataInputStream)filterInputStream);
            frameButtClosePressedColor.load((DataInputStream)filterInputStream);
            frameButtCloseDisabledColor.load((DataInputStream)filterInputStream);
            frameButtCloseSpreadDark.setValue(((DataInputStream)filterInputStream).readInt());
            frameButtCloseSpreadLight.setValue(((DataInputStream)filterInputStream).readInt());
            frameButtCloseSpreadDarkDisabled.setValue(((DataInputStream)filterInputStream).readInt());
            frameButtCloseSpreadLightDisabled.setValue(((DataInputStream)filterInputStream).readInt());
            frameButtBorderColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            frameButtBorderDisabledColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            frameSymbolColor.load((DataInputStream)filterInputStream);
            frameSymbolPressedColor.load((DataInputStream)filterInputStream);
            frameSymbolDisabledColor.load((DataInputStream)filterInputStream);
            frameSymbolDarkColor.load((DataInputStream)filterInputStream);
            frameSymbolLightColor.load((DataInputStream)filterInputStream);
            if (fileID >= 16384) {
                frameSymbolDarkDisabledColor.load((DataInputStream)filterInputStream);
                frameSymbolLightDisabledColor.load((DataInputStream)filterInputStream);
            } else {
                color = ColorRoutines.getAverage(frameSymbolDarkColor.getColor(), frameSymbolColor.getColor());
                frameSymbolDarkDisabledColor.update(color, 0, 0, 1);
                color = ColorRoutines.getAverage(frameSymbolLightColor.getColor(), frameSymbolColor.getColor());
                frameSymbolLightDisabledColor.update(color, 0, 0, 1);
            }
            frameButtCloseBorderColor.load((DataInputStream)filterInputStream);
            frameButtCloseDarkColor.load((DataInputStream)filterInputStream);
            frameButtCloseLightColor.load((DataInputStream)filterInputStream);
            frameButtCloseBorderDisabledColor.load((DataInputStream)filterInputStream);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            frameSymbolCloseColor.load((DataInputStream)filterInputStream);
            frameSymbolClosePressedColor.load((DataInputStream)filterInputStream);
            frameSymbolCloseDisabledColor.load((DataInputStream)filterInputStream);
            frameSymbolCloseDarkColor.load((DataInputStream)filterInputStream);
            if (fileID >= 16384) {
                frameSymbolCloseDarkDisabledColor.load((DataInputStream)filterInputStream);
            } else {
                color = ColorRoutines.getAverage(frameSymbolCloseDarkColor.getColor(), frameSymbolCloseColor.getColor());
                frameSymbolCloseDarkDisabledColor.update(color, 0, 0, 1);
            }
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)filterInputStream);
            }
            frameSpreadDark.setValue(((DataInputStream)filterInputStream).readInt());
            frameSpreadLight.setValue(((DataInputStream)filterInputStream).readInt());
            frameSpreadDarkDisabled.setValue(((DataInputStream)filterInputStream).readInt());
            frameSpreadLightDisabled.setValue(((DataInputStream)filterInputStream).readInt());
            tableBackColor.load((DataInputStream)filterInputStream);
            tableHeaderBackColor.load((DataInputStream)filterInputStream);
            if (fileID >= 12857) {
                tableHeaderArrowColor.load((DataInputStream)filterInputStream);
                tableHeaderRolloverBackColor.load((DataInputStream)filterInputStream);
                tableHeaderRolloverColor.load((DataInputStream)filterInputStream);
            }
            tableGridColor.load((DataInputStream)filterInputStream);
            tableSelectedBackColor.load((DataInputStream)filterInputStream);
            tableSelectedForeColor.load((DataInputStream)filterInputStream);
            if (fileID >= 12852) {
                tableBorderDarkColor.load((DataInputStream)filterInputStream);
                tableBorderLightColor.load((DataInputStream)filterInputStream);
                tableHeaderDarkColor.load((DataInputStream)filterInputStream);
                tableHeaderLightColor.load((DataInputStream)filterInputStream);
            }
            if (fileID >= 16384) {
                tableFocusBorderColor.load((DataInputStream)filterInputStream);
            } else {
                tableFocusBorderColor.update(tableSelectedBackColor);
            }
            if (fileID >= 16388) {
                tableAlternateRowColor.load((DataInputStream)filterInputStream);
            } else {
                tableAlternateRowColor.update(tableBackColor);
            }
            if (fileID >= 12852) {
                for (int i = 0; i < colorizer.length; ++i) {
                    colorizer[i].load((DataInputStream)filterInputStream);
                    colorize[i].setValue(((DataInputStream)filterInputStream).readBoolean());
                }
            } else {
                int n3;
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                SBReference.loadDummyData((DataInputStream)filterInputStream);
                ((DataInputStream)filterInputStream).readBoolean();
                ((DataInputStream)filterInputStream).readBoolean();
                ((DataInputStream)filterInputStream).readBoolean();
                ((DataInputStream)filterInputStream).readBoolean();
                ((DataInputStream)filterInputStream).readBoolean();
                for (n3 = 0; n3 < 15; ++n3) {
                    ((DataInputStream)filterInputStream).readBoolean();
                }
                for (n3 = 0; n3 < colorizer.length; ++n3) {
                    colorize[n3].setValue(false);
                }
            }
            if (fileID >= 12852) {
                separatorColor.load((DataInputStream)filterInputStream);
                if (fileID < 16384) {
                    SBReference.loadDummyData((DataInputStream)filterInputStream);
                }
            }
            tipBorderColor.load((DataInputStream)filterInputStream);
            tipBgColor.load((DataInputStream)filterInputStream);
            if (fileID >= 12854) {
                tipBorderDis.load((DataInputStream)filterInputStream);
                tipBgDis.load((DataInputStream)filterInputStream);
                tipTextColor.load((DataInputStream)filterInputStream);
                tipTextDis.load((DataInputStream)filterInputStream);
            }
            titledBorderColor.load((DataInputStream)filterInputStream);
            if (fileID >= 16384) {
                splitPaneButtonColor.load((DataInputStream)filterInputStream);
            } else {
                splitPaneButtonColor.update(scrollArrowColor);
            }
            filterInputStream.close();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean saveTheme(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Argument to Theme.saveTheme(String) is null");
        }
        return Theme.saveTheme(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean saveTheme(File file) {
        FilterOutputStream filterOutputStream = null;
        try {
            boolean bl;
            filterOutputStream = new DataOutputStream(new FileOutputStream(file));
            ((DataOutputStream)filterOutputStream).writeInt(16388);
            ((DataOutputStream)filterOutputStream).writeInt(2);
            mainColor.save((DataOutputStream)filterOutputStream);
            disColor.save((DataOutputStream)filterOutputStream);
            backColor.save((DataOutputStream)filterOutputStream);
            frameColor.save((DataOutputStream)filterOutputStream);
            sub1Color.save((DataOutputStream)filterOutputStream);
            sub2Color.save((DataOutputStream)filterOutputStream);
            sub3Color.save((DataOutputStream)filterOutputStream);
            sub4Color.save((DataOutputStream)filterOutputStream);
            sub5Color.save((DataOutputStream)filterOutputStream);
            sub6Color.save((DataOutputStream)filterOutputStream);
            sub7Color.save((DataOutputStream)filterOutputStream);
            sub8Color.save((DataOutputStream)filterOutputStream);
            plainFont.save((DataOutputStream)filterOutputStream);
            boldFont.save((DataOutputStream)filterOutputStream);
            buttonFont.save((DataOutputStream)filterOutputStream);
            passwordFont.save((DataOutputStream)filterOutputStream);
            labelFont.save((DataOutputStream)filterOutputStream);
            comboFont.save((DataOutputStream)filterOutputStream);
            listFont.save((DataOutputStream)filterOutputStream);
            menuFont.save((DataOutputStream)filterOutputStream);
            menuItemFont.save((DataOutputStream)filterOutputStream);
            radioFont.save((DataOutputStream)filterOutputStream);
            checkFont.save((DataOutputStream)filterOutputStream);
            tableFont.save((DataOutputStream)filterOutputStream);
            tableHeaderFont.save((DataOutputStream)filterOutputStream);
            textAreaFont.save((DataOutputStream)filterOutputStream);
            textFieldFont.save((DataOutputStream)filterOutputStream);
            textPaneFont.save((DataOutputStream)filterOutputStream);
            titledBorderFont.save((DataOutputStream)filterOutputStream);
            toolTipFont.save((DataOutputStream)filterOutputStream);
            treeFont.save((DataOutputStream)filterOutputStream);
            tabFont.save((DataOutputStream)filterOutputStream);
            editorFont.save((DataOutputStream)filterOutputStream);
            frameTitleFont.save((DataOutputStream)filterOutputStream);
            internalFrameTitleFont.save((DataOutputStream)filterOutputStream);
            internalPaletteTitleFont.save((DataOutputStream)filterOutputStream);
            progressBarFont.save((DataOutputStream)filterOutputStream);
            buttonFontColor.save((DataOutputStream)filterOutputStream);
            labelFontColor.save((DataOutputStream)filterOutputStream);
            menuFontColor.save((DataOutputStream)filterOutputStream);
            menuItemFontColor.save((DataOutputStream)filterOutputStream);
            radioFontColor.save((DataOutputStream)filterOutputStream);
            checkFontColor.save((DataOutputStream)filterOutputStream);
            tableFontColor.save((DataOutputStream)filterOutputStream);
            tableHeaderFontColor.save((DataOutputStream)filterOutputStream);
            tabFontColor.save((DataOutputStream)filterOutputStream);
            titledBorderFontColor.save((DataOutputStream)filterOutputStream);
            progressColor.save((DataOutputStream)filterOutputStream);
            progressTrackColor.save((DataOutputStream)filterOutputStream);
            progressBorderColor.save((DataOutputStream)filterOutputStream);
            progressDarkColor.save((DataOutputStream)filterOutputStream);
            progressLightColor.save((DataOutputStream)filterOutputStream);
            progressSelectForeColor.save((DataOutputStream)filterOutputStream);
            progressSelectBackColor.save((DataOutputStream)filterOutputStream);
            textBgColor.save((DataOutputStream)filterOutputStream);
            textTextColor.save((DataOutputStream)filterOutputStream);
            textCaretColor.save((DataOutputStream)filterOutputStream);
            editorPaneBgColor.save((DataOutputStream)filterOutputStream);
            textPaneBgColor.save((DataOutputStream)filterOutputStream);
            desktopPaneBgColor.save((DataOutputStream)filterOutputStream);
            textSelectedBgColor.save((DataOutputStream)filterOutputStream);
            textSelectedTextColor.save((DataOutputStream)filterOutputStream);
            textDisabledBgColor.save((DataOutputStream)filterOutputStream);
            textNonEditableBgColor.save((DataOutputStream)filterOutputStream);
            textBorderColor.save((DataOutputStream)filterOutputStream);
            textBorderDisabledColor.save((DataOutputStream)filterOutputStream);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.textInsets.top);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.textInsets.left);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.textInsets.bottom);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.textInsets.right);
            ((DataOutputStream)filterOutputStream).writeBoolean(buttonRolloverBorder.getValue());
            ((DataOutputStream)filterOutputStream).writeBoolean(buttonFocus.getValue());
            ((DataOutputStream)filterOutputStream).writeBoolean(buttonFocusBorder.getValue());
            ((DataOutputStream)filterOutputStream).writeBoolean(buttonEnter.getValue());
            ((DataOutputStream)filterOutputStream).writeBoolean(shiftButtonText.getValue());
            buttonNormalColor.save((DataOutputStream)filterOutputStream);
            buttonRolloverBgColor.save((DataOutputStream)filterOutputStream);
            buttonPressedColor.save((DataOutputStream)filterOutputStream);
            buttonDisabledColor.save((DataOutputStream)filterOutputStream);
            buttonBorderColor.save((DataOutputStream)filterOutputStream);
            buttonBorderDisabledColor.save((DataOutputStream)filterOutputStream);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.buttonMargin.top);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.buttonMargin.left);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.buttonMargin.bottom);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.buttonMargin.right);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.checkMargin.top);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.checkMargin.left);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.checkMargin.bottom);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.checkMargin.right);
            buttonRolloverColor.save((DataOutputStream)filterOutputStream);
            buttonDefaultColor.save((DataOutputStream)filterOutputStream);
            buttonCheckColor.save((DataOutputStream)filterOutputStream);
            buttonCheckDisabledColor.save((DataOutputStream)filterOutputStream);
            buttonDisabledFgColor.save((DataOutputStream)filterOutputStream);
            checkDisabledFgColor.save((DataOutputStream)filterOutputStream);
            radioDisabledFgColor.save((DataOutputStream)filterOutputStream);
            toggleSelectedBg.save((DataOutputStream)filterOutputStream);
            ((DataOutputStream)filterOutputStream).writeInt(buttonSpreadLight.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(buttonSpreadDark.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(buttonSpreadLightDisabled.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(buttonSpreadDarkDisabled.getValue());
            ((DataOutputStream)filterOutputStream).writeBoolean(scrollRollover.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(scrollSize.getValue());
            scrollTrackColor.save((DataOutputStream)filterOutputStream);
            scrollTrackDisabledColor.save((DataOutputStream)filterOutputStream);
            scrollTrackBorderColor.save((DataOutputStream)filterOutputStream);
            scrollTrackBorderDisabledColor.save((DataOutputStream)filterOutputStream);
            scrollThumbColor.save((DataOutputStream)filterOutputStream);
            scrollThumbRolloverColor.save((DataOutputStream)filterOutputStream);
            scrollThumbPressedColor.save((DataOutputStream)filterOutputStream);
            scrollThumbDisabledColor.save((DataOutputStream)filterOutputStream);
            scrollGripLightColor.save((DataOutputStream)filterOutputStream);
            scrollGripDarkColor.save((DataOutputStream)filterOutputStream);
            scrollButtColor.save((DataOutputStream)filterOutputStream);
            scrollButtRolloverColor.save((DataOutputStream)filterOutputStream);
            scrollButtPressedColor.save((DataOutputStream)filterOutputStream);
            scrollButtDisabledColor.save((DataOutputStream)filterOutputStream);
            ((DataOutputStream)filterOutputStream).writeInt(scrollSpreadLight.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(scrollSpreadDark.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(scrollSpreadLightDisabled.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(scrollSpreadDarkDisabled.getValue());
            scrollArrowColor.save((DataOutputStream)filterOutputStream);
            scrollArrowDisabledColor.save((DataOutputStream)filterOutputStream);
            scrollBorderColor.save((DataOutputStream)filterOutputStream);
            scrollBorderLightColor.save((DataOutputStream)filterOutputStream);
            scrollBorderDisabledColor.save((DataOutputStream)filterOutputStream);
            scrollLightDisabledColor.save((DataOutputStream)filterOutputStream);
            scrollPaneBorderColor.save((DataOutputStream)filterOutputStream);
            tabPaneBorderColor.save((DataOutputStream)filterOutputStream);
            tabNormalColor.save((DataOutputStream)filterOutputStream);
            tabSelectedColor.save((DataOutputStream)filterOutputStream);
            tabDisabledColor.save((DataOutputStream)filterOutputStream);
            tabDisabledSelectedColor.save((DataOutputStream)filterOutputStream);
            tabDisabledTextColor.save((DataOutputStream)filterOutputStream);
            tabBorderColor.save((DataOutputStream)filterOutputStream);
            tabRolloverColor.save((DataOutputStream)filterOutputStream);
            tabDisabledBorderColor.save((DataOutputStream)filterOutputStream);
            tabPaneDisabledBorderColor.save((DataOutputStream)filterOutputStream);
            ((DataOutputStream)filterOutputStream).writeBoolean(tabRollover.getValue());
            ((DataOutputStream)filterOutputStream).writeBoolean(tabFocus.getValue());
            ((DataOutputStream)filterOutputStream).writeBoolean(ignoreSelectedBg.getValue());
            ((DataOutputStream)filterOutputStream).writeBoolean(fixedTabs.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(Theme.tabInsets.top);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.tabInsets.left);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.tabInsets.bottom);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.tabInsets.right);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.tabAreaInsets.top);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.tabAreaInsets.left);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.tabAreaInsets.bottom);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.tabAreaInsets.right);
            ((DataOutputStream)filterOutputStream).writeBoolean(sliderRolloverEnabled.getValue());
            ((DataOutputStream)filterOutputStream).writeBoolean(sliderFocusEnabled.getValue());
            sliderThumbColor.save((DataOutputStream)filterOutputStream);
            sliderThumbRolloverColor.save((DataOutputStream)filterOutputStream);
            sliderThumbPressedColor.save((DataOutputStream)filterOutputStream);
            sliderThumbDisabledColor.save((DataOutputStream)filterOutputStream);
            sliderBorderColor.save((DataOutputStream)filterOutputStream);
            sliderDarkColor.save((DataOutputStream)filterOutputStream);
            sliderLightColor.save((DataOutputStream)filterOutputStream);
            sliderBorderDisabledColor.save((DataOutputStream)filterOutputStream);
            sliderTrackColor.save((DataOutputStream)filterOutputStream);
            sliderTrackBorderColor.save((DataOutputStream)filterOutputStream);
            sliderTrackDarkColor.save((DataOutputStream)filterOutputStream);
            sliderTrackLightColor.save((DataOutputStream)filterOutputStream);
            sliderTickColor.save((DataOutputStream)filterOutputStream);
            sliderTickDisabledColor.save((DataOutputStream)filterOutputStream);
            sliderFocusColor.save((DataOutputStream)filterOutputStream);
            ((DataOutputStream)filterOutputStream).writeBoolean(spinnerRollover.getValue());
            spinnerButtColor.save((DataOutputStream)filterOutputStream);
            spinnerButtRolloverColor.save((DataOutputStream)filterOutputStream);
            spinnerButtPressedColor.save((DataOutputStream)filterOutputStream);
            spinnerButtDisabledColor.save((DataOutputStream)filterOutputStream);
            ((DataOutputStream)filterOutputStream).writeInt(spinnerSpreadLight.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(spinnerSpreadDark.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(spinnerSpreadLightDisabled.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(spinnerSpreadDarkDisabled.getValue());
            spinnerBorderColor.save((DataOutputStream)filterOutputStream);
            spinnerBorderDisabledColor.save((DataOutputStream)filterOutputStream);
            spinnerArrowColor.save((DataOutputStream)filterOutputStream);
            spinnerArrowDisabledColor.save((DataOutputStream)filterOutputStream);
            comboBorderColor.save((DataOutputStream)filterOutputStream);
            comboBorderDisabledColor.save((DataOutputStream)filterOutputStream);
            comboSelectedBgColor.save((DataOutputStream)filterOutputStream);
            comboSelectedTextColor.save((DataOutputStream)filterOutputStream);
            comboFocusBgColor.save((DataOutputStream)filterOutputStream);
            comboBgColor.save((DataOutputStream)filterOutputStream);
            comboTextColor.save((DataOutputStream)filterOutputStream);
            comboButtColor.save((DataOutputStream)filterOutputStream);
            comboButtRolloverColor.save((DataOutputStream)filterOutputStream);
            comboButtPressedColor.save((DataOutputStream)filterOutputStream);
            comboButtDisabledColor.save((DataOutputStream)filterOutputStream);
            ((DataOutputStream)filterOutputStream).writeInt(comboSpreadLight.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(comboSpreadDark.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(comboSpreadLightDisabled.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(comboSpreadDarkDisabled.getValue());
            comboButtBorderColor.save((DataOutputStream)filterOutputStream);
            comboButtBorderDisabledColor.save((DataOutputStream)filterOutputStream);
            comboArrowColor.save((DataOutputStream)filterOutputStream);
            comboArrowDisabledColor.save((DataOutputStream)filterOutputStream);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.comboInsets.top);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.comboInsets.left);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.comboInsets.bottom);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.comboInsets.right);
            ((DataOutputStream)filterOutputStream).writeBoolean(comboRollover.getValue());
            ((DataOutputStream)filterOutputStream).writeBoolean(comboFocus.getValue());
            menuBarColor.save((DataOutputStream)filterOutputStream);
            menuItemSelectedTextColor.save((DataOutputStream)filterOutputStream);
            menuPopupColor.save((DataOutputStream)filterOutputStream);
            menuRolloverBgColor.save((DataOutputStream)filterOutputStream);
            menuItemRolloverColor.save((DataOutputStream)filterOutputStream);
            menuBorderColor.save((DataOutputStream)filterOutputStream);
            menuIconColor.save((DataOutputStream)filterOutputStream);
            menuIconRolloverColor.save((DataOutputStream)filterOutputStream);
            menuIconDisabledColor.save((DataOutputStream)filterOutputStream);
            menuSeparatorColor.save((DataOutputStream)filterOutputStream);
            ((DataOutputStream)filterOutputStream).writeBoolean(menuRollover.getValue());
            menuInnerHilightColor.save((DataOutputStream)filterOutputStream);
            menuInnerShadowColor.save((DataOutputStream)filterOutputStream);
            menuOuterHilightColor.save((DataOutputStream)filterOutputStream);
            menuOuterShadowColor.save((DataOutputStream)filterOutputStream);
            menuRolloverFgColor.save((DataOutputStream)filterOutputStream);
            menuDisabledFgColor.save((DataOutputStream)filterOutputStream);
            menuItemDisabledFgColor.save((DataOutputStream)filterOutputStream);
            ((DataOutputStream)filterOutputStream).writeBoolean(menuPopupShadow.getValue());
            ((DataOutputStream)filterOutputStream).writeBoolean(menuAllowTwoIcons.getValue());
            toolBarColor.save((DataOutputStream)filterOutputStream);
            toolBarLightColor.save((DataOutputStream)filterOutputStream);
            toolBarDarkColor.save((DataOutputStream)filterOutputStream);
            toolButtColor.save((DataOutputStream)filterOutputStream);
            toolButtRolloverColor.save((DataOutputStream)filterOutputStream);
            toolButtPressedColor.save((DataOutputStream)filterOutputStream);
            toolButtSelectedColor.save((DataOutputStream)filterOutputStream);
            toolBorderColor.save((DataOutputStream)filterOutputStream);
            toolBorderRolloverColor.save((DataOutputStream)filterOutputStream);
            toolBorderPressedColor.save((DataOutputStream)filterOutputStream);
            toolBorderSelectedColor.save((DataOutputStream)filterOutputStream);
            ((DataOutputStream)filterOutputStream).writeBoolean(toolRollover.getValue());
            ((DataOutputStream)filterOutputStream).writeBoolean(toolFocus.getValue());
            toolGripDarkColor.save((DataOutputStream)filterOutputStream);
            toolGripLightColor.save((DataOutputStream)filterOutputStream);
            toolSeparatorColor.save((DataOutputStream)filterOutputStream);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.toolMargin.top);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.toolMargin.left);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.toolMargin.bottom);
            ((DataOutputStream)filterOutputStream).writeInt(Theme.toolMargin.right);
            listSelectedBgColor.save((DataOutputStream)filterOutputStream);
            listSelectedTextColor.save((DataOutputStream)filterOutputStream);
            listBgColor.save((DataOutputStream)filterOutputStream);
            listTextColor.save((DataOutputStream)filterOutputStream);
            listFocusBorderColor.save((DataOutputStream)filterOutputStream);
            treeBgColor.save((DataOutputStream)filterOutputStream);
            treeTextColor.save((DataOutputStream)filterOutputStream);
            treeTextBgColor.save((DataOutputStream)filterOutputStream);
            treeSelectedTextColor.save((DataOutputStream)filterOutputStream);
            treeSelectedBgColor.save((DataOutputStream)filterOutputStream);
            treeLineColor.save((DataOutputStream)filterOutputStream);
            frameCaptionColor.save((DataOutputStream)filterOutputStream);
            frameCaptionDisabledColor.save((DataOutputStream)filterOutputStream);
            frameBorderColor.save((DataOutputStream)filterOutputStream);
            frameLightColor.save((DataOutputStream)filterOutputStream);
            frameBorderDisabledColor.save((DataOutputStream)filterOutputStream);
            frameLightDisabledColor.save((DataOutputStream)filterOutputStream);
            frameTitleColor.save((DataOutputStream)filterOutputStream);
            frameTitleShadowColor.save((DataOutputStream)filterOutputStream);
            frameTitleDisabledColor.save((DataOutputStream)filterOutputStream);
            frameButtColor.save((DataOutputStream)filterOutputStream);
            frameButtRolloverColor.save((DataOutputStream)filterOutputStream);
            frameButtPressedColor.save((DataOutputStream)filterOutputStream);
            frameButtDisabledColor.save((DataOutputStream)filterOutputStream);
            ((DataOutputStream)filterOutputStream).writeInt(frameButtSpreadDark.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(frameButtSpreadLight.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(frameButtSpreadDarkDisabled.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(frameButtSpreadLightDisabled.getValue());
            frameButtCloseColor.save((DataOutputStream)filterOutputStream);
            frameButtCloseRolloverColor.save((DataOutputStream)filterOutputStream);
            frameButtClosePressedColor.save((DataOutputStream)filterOutputStream);
            frameButtCloseDisabledColor.save((DataOutputStream)filterOutputStream);
            ((DataOutputStream)filterOutputStream).writeInt(frameButtCloseSpreadDark.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(frameButtCloseSpreadLight.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(frameButtCloseSpreadDarkDisabled.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(frameButtCloseSpreadLightDisabled.getValue());
            frameButtBorderColor.save((DataOutputStream)filterOutputStream);
            frameButtBorderDisabledColor.save((DataOutputStream)filterOutputStream);
            frameSymbolColor.save((DataOutputStream)filterOutputStream);
            frameSymbolPressedColor.save((DataOutputStream)filterOutputStream);
            frameSymbolDisabledColor.save((DataOutputStream)filterOutputStream);
            frameSymbolDarkColor.save((DataOutputStream)filterOutputStream);
            frameSymbolLightColor.save((DataOutputStream)filterOutputStream);
            frameSymbolDarkDisabledColor.save((DataOutputStream)filterOutputStream);
            frameSymbolLightDisabledColor.save((DataOutputStream)filterOutputStream);
            frameButtCloseBorderColor.save((DataOutputStream)filterOutputStream);
            frameButtCloseDarkColor.save((DataOutputStream)filterOutputStream);
            frameButtCloseLightColor.save((DataOutputStream)filterOutputStream);
            frameButtCloseBorderDisabledColor.save((DataOutputStream)filterOutputStream);
            frameSymbolCloseColor.save((DataOutputStream)filterOutputStream);
            frameSymbolClosePressedColor.save((DataOutputStream)filterOutputStream);
            frameSymbolCloseDisabledColor.save((DataOutputStream)filterOutputStream);
            frameSymbolCloseDarkColor.save((DataOutputStream)filterOutputStream);
            frameSymbolCloseDarkDisabledColor.save((DataOutputStream)filterOutputStream);
            ((DataOutputStream)filterOutputStream).writeInt(frameSpreadDark.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(frameSpreadLight.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(frameSpreadDarkDisabled.getValue());
            ((DataOutputStream)filterOutputStream).writeInt(frameSpreadLightDisabled.getValue());
            tableBackColor.save((DataOutputStream)filterOutputStream);
            tableHeaderBackColor.save((DataOutputStream)filterOutputStream);
            tableHeaderArrowColor.save((DataOutputStream)filterOutputStream);
            tableHeaderRolloverBackColor.save((DataOutputStream)filterOutputStream);
            tableHeaderRolloverColor.save((DataOutputStream)filterOutputStream);
            tableGridColor.save((DataOutputStream)filterOutputStream);
            tableSelectedBackColor.save((DataOutputStream)filterOutputStream);
            tableSelectedForeColor.save((DataOutputStream)filterOutputStream);
            tableBorderDarkColor.save((DataOutputStream)filterOutputStream);
            tableBorderLightColor.save((DataOutputStream)filterOutputStream);
            tableHeaderDarkColor.save((DataOutputStream)filterOutputStream);
            tableHeaderLightColor.save((DataOutputStream)filterOutputStream);
            tableFocusBorderColor.save((DataOutputStream)filterOutputStream);
            tableAlternateRowColor.save((DataOutputStream)filterOutputStream);
            for (bl = false; bl < colorizer.length; bl += 1) {
                colorizer[bl].save((DataOutputStream)filterOutputStream);
                ((DataOutputStream)filterOutputStream).writeBoolean(colorize[bl].getValue());
            }
            separatorColor.save((DataOutputStream)filterOutputStream);
            tipBorderColor.save((DataOutputStream)filterOutputStream);
            tipBgColor.save((DataOutputStream)filterOutputStream);
            tipBorderDis.save((DataOutputStream)filterOutputStream);
            tipBgDis.save((DataOutputStream)filterOutputStream);
            tipTextColor.save((DataOutputStream)filterOutputStream);
            tipTextDis.save((DataOutputStream)filterOutputStream);
            titledBorderColor.save((DataOutputStream)filterOutputStream);
            splitPaneButtonColor.save((DataOutputStream)filterOutputStream);
            bl = true;
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    static {
        colorizer = new HSBReference[20];
        colorize = new BooleanReference[20];
        Theme.initData();
    }
}

