/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class TinyProgressBarUI
extends BasicProgressBarUI {
    private static final HashMap cache = new HashMap();
    private static final Dimension PREFERRED_YQ_HORIZONTAL = new Dimension(146, 7);
    private static final Dimension PREFERRED_YQ_VERTICAL = new Dimension(7, 146);

    public static void clearCache() {
        cache.clear();
    }

    protected Dimension getPreferredInnerHorizontal() {
        return PREFERRED_YQ_HORIZONTAL;
    }

    protected Dimension getPreferredInnerVertical() {
        return PREFERRED_YQ_VERTICAL;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new TinyProgressBarUI();
    }

    protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth() - (insets.right + insets.left);
        int n2 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        if (this.progressBar.getOrientation() == 0) {
            int n3 = this.getAmountFull(insets, n, n2);
            this.drawXpHorzProgress(graphics, insets.left, insets.top, n, n2, n3);
            if (this.progressBar.isStringPainted()) {
                graphics.setFont(jComponent.getFont());
                this.paintString(graphics, insets.left, insets.top, n, n2, n3, insets);
            }
        } else {
            int n4 = this.getAmountFull(insets, n, n2);
            this.drawXpVertProgress(graphics, insets.left, insets.top, n, n2, n4);
            if (this.progressBar.isStringPainted()) {
                graphics.setFont(jComponent.getFont());
                this.paintString(graphics, insets.left, insets.top, n, n2, n4, insets);
            }
        }
    }

    private void drawXpHorzProgress(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        ProgressKey progressKey;
        Object object;
        graphics.translate(n, n2);
        if (!this.progressBar.isOpaque()) {
            graphics.setColor(this.progressBar.getBackground());
            graphics.fillRect(0, 0, n3, n4);
        }
        if ((object = cache.get(progressKey = new ProgressKey(this.progressBar.getForeground(), true, n4))) == null) {
            BufferedImage bufferedImage = new BufferedImage(6, n4, 2);
            Graphics graphics2 = ((Image)bufferedImage).getGraphics();
            Color color = this.progressBar.getForeground();
            Color color2 = ColorRoutines.lighten(color, 15);
            Color color3 = ColorRoutines.lighten(color, 35);
            Color color4 = ColorRoutines.lighten(color, 60);
            graphics2.setColor(color4);
            graphics2.drawLine(0, 0, 5, 0);
            graphics2.drawLine(0, n4 - 1, 5, n4 - 1);
            graphics2.setColor(color3);
            graphics2.drawLine(0, 1, 5, 1);
            graphics2.drawLine(0, n4 - 2, 5, n4 - 2);
            graphics2.setColor(color2);
            graphics2.drawLine(0, 2, 5, 2);
            graphics2.drawLine(0, n4 - 3, 5, n4 - 3);
            graphics2.setColor(color);
            graphics2.fillRect(0, 3, 6, n4 - 6);
            graphics2.dispose();
            cache.put(progressKey, bufferedImage);
            object = bufferedImage;
        }
        for (int i = 0; i < n5; i += 8) {
            if (i + 6 > n3) {
                graphics.drawImage((Image)object, i, 0, n3 - i, n4, this.progressBar);
                continue;
            }
            graphics.drawImage((Image)object, i, 0, this.progressBar);
        }
        graphics.translate(-n, -n2);
    }

    private void drawXpVertProgress(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        ProgressKey progressKey;
        Object object;
        graphics.translate(n, n2);
        if (!this.progressBar.isOpaque()) {
            graphics.setColor(this.progressBar.getBackground());
            graphics.fillRect(0, 0, n3, n4);
        }
        if ((object = cache.get(progressKey = new ProgressKey(this.progressBar.getForeground(), false, n3))) == null) {
            BufferedImage bufferedImage = new BufferedImage(n3, 6, 2);
            Graphics graphics2 = ((Image)bufferedImage).getGraphics();
            Color color = this.progressBar.getForeground();
            Color color2 = ColorRoutines.lighten(color, 15);
            Color color3 = ColorRoutines.lighten(color, 35);
            Color color4 = ColorRoutines.lighten(color, 60);
            graphics2.setColor(color4);
            graphics2.drawLine(0, 0, 0, 5);
            graphics2.drawLine(n3 - 1, 0, n3 - 1, 5);
            graphics2.setColor(color3);
            graphics2.drawLine(1, 0, 1, 5);
            graphics2.drawLine(n3 - 2, 0, n3 - 2, 5);
            graphics2.setColor(color2);
            graphics2.drawLine(2, 0, 2, 5);
            graphics2.drawLine(n3 - 3, 0, n3 - 3, 5);
            graphics2.setColor(color);
            graphics2.fillRect(3, 0, n3 - 6, 6);
            graphics2.dispose();
            cache.put(progressKey, bufferedImage);
            object = bufferedImage;
        }
        for (int i = 0; i < n5; i += 8) {
            if (i + 6 > n4) {
                graphics.drawImage((Image)object, 0, 0, n3, n4 - i, this.progressBar);
                continue;
            }
            graphics.drawImage((Image)object, 0, n4 - i - 6, this.progressBar);
        }
        graphics.translate(-n, -n2);
    }

    protected void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth() - (insets.right + insets.left);
        int n2 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        Rectangle rectangle = new Rectangle();
        try {
            rectangle = this.getBox(rectangle);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.progressBar.getOrientation() == 0) {
            this.drawXpHorzProgress(graphics, insets.left, insets.top, n, n2, rectangle);
        } else {
            this.drawXpVertProgress(graphics, insets.left, insets.top, n, n2, rectangle);
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(graphics, insets.left, insets.top, n, n2, rectangle.width, insets);
            } else {
                this.paintString(graphics, insets.left, insets.top, n, n2, rectangle.height, insets);
            }
        }
    }

    private void drawXpHorzProgress(Graphics graphics, int n, int n2, int n3, int n4, Rectangle rectangle) {
        if (!this.progressBar.isOpaque()) {
            graphics.setColor(this.progressBar.getBackground());
            graphics.fillRect(n, n2, n3, n4);
        }
        graphics.translate(rectangle.x, rectangle.y);
        ProgressKey progressKey = new ProgressKey(this.progressBar.getForeground(), true, n4);
        Object object = cache.get(progressKey);
        if (object == null) {
            BufferedImage bufferedImage = new BufferedImage(6, n4, 2);
            Graphics graphics2 = ((Image)bufferedImage).getGraphics();
            Color color = this.progressBar.getForeground();
            Color color2 = ColorRoutines.lighten(color, 15);
            Color color3 = ColorRoutines.lighten(color, 35);
            Color color4 = ColorRoutines.lighten(color, 60);
            graphics2.setColor(color4);
            graphics2.drawLine(0, 0, 5, 0);
            graphics2.drawLine(0, n4 - 1, 5, n4 - 1);
            graphics2.setColor(color3);
            graphics2.drawLine(0, 1, 5, 1);
            graphics2.drawLine(0, n4 - 2, 5, n4 - 2);
            graphics2.setColor(color2);
            graphics2.drawLine(0, 2, 5, 2);
            graphics2.drawLine(0, n4 - 3, 5, n4 - 3);
            graphics2.setColor(color);
            graphics2.fillRect(0, 3, 6, n4 - 6);
            graphics2.dispose();
            cache.put(progressKey, bufferedImage);
            object = bufferedImage;
        }
        int n5 = 0;
        while (n5 + 6 < rectangle.width) {
            graphics.drawImage((Image)object, n5, 0, this.progressBar);
            n5 += 8;
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    private void drawXpVertProgress(Graphics graphics, int n, int n2, int n3, int n4, Rectangle rectangle) {
        if (!this.progressBar.isOpaque()) {
            graphics.setColor(this.progressBar.getBackground());
            graphics.fillRect(n, n2, n3, n4);
        }
        graphics.translate(rectangle.x, rectangle.y);
        ProgressKey progressKey = new ProgressKey(this.progressBar.getForeground(), false, n3);
        Object object = cache.get(progressKey);
        if (object == null) {
            BufferedImage bufferedImage = new BufferedImage(n3, 6, 2);
            Graphics graphics2 = ((Image)bufferedImage).getGraphics();
            Color color = this.progressBar.getForeground();
            Color color2 = ColorRoutines.lighten(color, 15);
            Color color3 = ColorRoutines.lighten(color, 35);
            Color color4 = ColorRoutines.lighten(color, 60);
            graphics2.setColor(color4);
            graphics2.drawLine(0, 0, 0, 5);
            graphics2.drawLine(n3 - 1, 0, n3 - 1, 5);
            graphics2.setColor(color3);
            graphics2.drawLine(1, 0, 1, 5);
            graphics2.drawLine(n3 - 2, 0, n3 - 2, 5);
            graphics2.setColor(color2);
            graphics2.drawLine(2, 0, 2, 5);
            graphics2.drawLine(n3 - 3, 0, n3 - 3, 5);
            graphics2.setColor(color);
            graphics2.fillRect(3, 0, n3 - 6, 6);
            graphics2.dispose();
            cache.put(progressKey, bufferedImage);
            object = bufferedImage;
        }
        int n5 = 0;
        while (n5 + 6 < rectangle.height) {
            graphics.drawImage((Image)object, 0, n5, this.progressBar);
            n5 += 8;
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected Color getSelectionForeground() {
        return Theme.progressSelectForeColor.getColor();
    }

    protected Color getSelectionBackground() {
        return Theme.progressSelectBackColor.getColor();
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.progressBar, "ProgressBar.border");
        LookAndFeel.installColorsAndFont(this.progressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
    }

    private static class ProgressKey {
        private Color c;
        private boolean horizontal;
        private int size;

        ProgressKey(Color color, boolean bl, int n) {
            this.c = color;
            this.horizontal = bl;
            this.size = n;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof ProgressKey)) {
                return false;
            }
            ProgressKey progressKey = (ProgressKey)object;
            return this.size == progressKey.size && this.horizontal == progressKey.horizontal && this.c.equals(progressKey.c);
        }

        public int hashCode() {
            return this.c.hashCode() * (this.horizontal ? 1 : 2) * this.size;
        }
    }
}

