/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyUtils;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class TinyTabbedPaneUI
extends BasicTabbedPaneUI {
    int rollover = -1;

    public static ComponentUI createUI(JComponent jComponent) {
        return new TinyTabbedPaneUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.tabPane.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
    }

    protected MouseListener createMouseListener() {
        return new TinyMouseHandler();
    }

    protected void installDefaults() {
        super.installDefaults();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getTabLayoutPolicy() == 1;
    }

    private void checkRollOver(int n) {
        if (this.rollover >= this.tabPane.getTabCount()) {
            this.rollover = -1;
        }
        if (n == this.rollover) {
            return;
        }
        if (this.rollover != -1) {
            this.tabPane.repaint(this.getTabBounds(this.tabPane, this.rollover));
            if (n == -1) {
                this.rollover = -1;
            }
        }
        if (n >= 0 && this.tabPane.isEnabledAt(n)) {
            this.rollover = n;
            this.tabPane.repaint(this.getTabBounds(this.tabPane, n));
        }
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return super.createLayoutManager();
        }
        return new TinyTabbedPaneLayout();
    }

    private int getTabAtLocation(int n, int n2) {
        if (TinyUtils.is1dot4()) {
            this.ensureCurrentLayout();
            int n3 = this.tabPane.getTabCount();
            for (int i = 0; i < n3; ++i) {
                if (!this.rects[i].contains(n, n2)) continue;
                return i;
            }
            return -1;
        }
        return this.tabForCoordinate(this.tabPane, n, n2);
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout tabbedPaneLayout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        boolean bl2 = this.tabPane.isEnabled() & this.tabPane.isEnabledAt(n2);
        if (bl && !Theme.ignoreSelectedBg.getValue()) {
            if (bl2) {
                graphics.setColor(Theme.tabSelectedColor.getColor());
            } else {
                graphics.setColor(Theme.tabDisabledSelectedColor.getColor());
            }
        } else if (bl2) {
            graphics.setColor(this.tabPane.getBackgroundAt(n2));
        } else {
            graphics.setColor(Theme.tabDisabledColor.getColor());
        }
        switch (n) {
            case 2: {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 1, n6 - 3);
                break;
            }
            case 4: {
                graphics.fillRect(n3 -= 2, n4 + 1, n5 - 1, n6 - 3);
                break;
            }
            case 3: {
                graphics.fillRect(n3 + 1, n4 -= 2, n5 - 3, n6 - 1);
                break;
            }
            default: {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 3, n6 - 1);
            }
        }
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2) {
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        if (!Theme.tabFocus.getValue()) {
            return;
        }
        Rectangle rectangle3 = rectangleArray[n2];
        if (this.tabPane.hasFocus() && bl) {
            int n3;
            int n4;
            int n5;
            int n6;
            graphics.setColor(Theme.tabFontColor.getColor());
            switch (n) {
                case 2: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 5;
                    n3 = rectangle3.height - 7;
                    break;
                }
                case 4: {
                    n6 = rectangle3.x;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 5;
                    n3 = rectangle3.height - 7;
                    break;
                }
                case 3: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y;
                    n4 = rectangle3.width - 7;
                    n3 = rectangle3.height - 5;
                    break;
                }
                default: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 7;
                    n3 = rectangle3.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(graphics, n6, n5, n4, n3);
        }
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        boolean bl2 = this.tabPane.isEnabledAt(n2);
        if (!this.tabPane.isEnabled()) {
            bl2 = false;
        }
        boolean bl3 = this.rollover == n2;
        this.drawXpTabBorder(graphics, n, n3, n4, n5, n6, bl, bl2, bl3);
    }

    private void drawXpTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3) {
        if (!bl2) {
            DrawRoutines.drawXpTabBorder(graphics, Theme.tabDisabledBorderColor.getColor(), n2, n3, n4, n5, n);
        } else if (bl) {
            DrawRoutines.drawSelectedXpTabBorder(graphics, Theme.tabBorderColor.getColor(), n2, n3, n4, n5, n);
        } else if (bl3 && Theme.tabRollover.getValue()) {
            DrawRoutines.drawSelectedXpTabBorder(graphics, Theme.tabBorderColor.getColor(), n2, n3, n4, n5, n);
        } else {
            DrawRoutines.drawXpTabBorder(graphics, Theme.tabBorderColor.getColor(), n2, n3, n4, n5, n);
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Insets insets = this.tabPane.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.tabPane.getWidth() - insets.right - insets.left;
        int n4 = this.tabPane.getHeight() - insets.top - insets.bottom;
        if (jComponent.isOpaque()) {
            graphics.setColor(Theme.backColor.getColor());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        int n5 = this.tabPane.getTabPlacement();
        switch (n5) {
            case 2: {
                n3 -= (n += this.calculateTabAreaWidth(n5, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n3 -= this.calculateTabAreaWidth(n5, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n4 -= this.calculateTabAreaHeight(n5, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n4 -= (n2 += this.calculateTabAreaHeight(n5, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        this.drawXpContentBorder(graphics, n, n2, n3, n4);
        super.paint(graphics, jComponent);
    }

    private void drawXpContentBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.tabPane.isEnabled()) {
            graphics.setColor(Theme.tabPaneBorderColor.getColor());
        } else {
            graphics.setColor(Theme.tabPaneDisabledBorderColor.getColor());
        }
        graphics.drawRect(n, n2, n3 - 3, n4 - 3);
        graphics.setColor(ColorRoutines.darken(Theme.backColor.getColor(), 15));
        graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + n4 - 2);
        graphics.drawLine(n + 1, n2 + n4 - 2, n + n3 - 3, n2 + n4 - 2);
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        Rectangle rectangle = this.rects[n2];
        int n3 = 0;
        switch (n) {
            case 2: {
                n3 = bl ? -1 : 1;
                break;
            }
            case 4: {
                n3 = bl ? 1 : -1;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        return n3;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        Rectangle rectangle = this.rects[n2];
        int n3 = 0;
        switch (n) {
            case 3: {
                n3 = bl ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                n3 = rectangle.height % 2;
                break;
            }
            default: {
                n3 = bl ? -1 : 1;
            }
        }
        return n3;
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            int n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n2)) {
                graphics.setColor(this.tabPane.getForegroundAt(n2));
            } else {
                graphics.setColor(Theme.tabDisabledTextColor.getColor());
            }
            TinyUtils.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    protected class TinyTabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        protected TinyTabbedPaneLayout() {
            super(TinyTabbedPaneUI.this);
        }

        protected void rotateTabRuns(int n, int n2) {
            if (!Theme.fixedTabs.getValue()) {
                super.rotateTabRuns(n, n2);
            }
        }
    }

    public class TinyMouseHandler
    implements MouseListener,
    MouseMotionListener {
        public void mousePressed(MouseEvent mouseEvent) {
            if (!TinyTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int n = TinyTabbedPaneUI.this.getTabAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0 && TinyTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                if (n != TinyTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    TinyTabbedPaneUI.this.tabPane.setSelectedIndex(n);
                } else if (TinyTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                    TinyTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (TinyTabbedPaneUI.this.rollover >= TinyTabbedPaneUI.this.tabPane.getTabCount()) {
                TinyTabbedPaneUI.this.rollover = -1;
            }
            if (TinyTabbedPaneUI.this.rollover != -1) {
                TinyTabbedPaneUI.this.tabPane.repaint(TinyTabbedPaneUI.this.getTabBounds(TinyTabbedPaneUI.this.tabPane, TinyTabbedPaneUI.this.rollover));
                TinyTabbedPaneUI.this.rollover = -1;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (TinyTabbedPaneUI.this.tabPane == null) {
                return;
            }
            if (!TinyTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            if (TinyUtils.is1dot4() && TinyTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                return;
            }
            TinyTabbedPaneUI.this.checkRollOver(TinyTabbedPaneUI.this.getTabAtLocation(mouseEvent.getX(), mouseEvent.getY()));
        }
    }
}

