/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JToolBar;
import javax.swing.plaf.metal.MetalBorders;

public class TinyToolBarBorder
extends MetalBorders.ToolBarBorder {
    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        Insets insets2;
        insets.right = 2;
        insets.bottom = 2;
        insets.left = 2;
        insets.top = 2;
        if (!(component instanceof JToolBar)) {
            return insets;
        }
        if (((JToolBar)component).isFloatable()) {
            if (((JToolBar)component).getOrientation() == 0) {
                if (component.getComponentOrientation().isLeftToRight()) {
                    insets.left = 10;
                } else {
                    insets.right = 10;
                }
            } else {
                insets.top = 10;
            }
        }
        if ((insets2 = ((JToolBar)component).getMargin()) != null) {
            insets.left += insets2.left;
            insets.top += insets2.top;
            insets.right += insets2.right;
            insets.bottom += insets2.bottom;
        }
        return insets;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (!(component instanceof JToolBar)) {
            return;
        }
        this.drawXPBorder(component, graphics, n, n2, n3, n4);
        if (((JToolBar)component).getOrientation() == 0) {
            graphics.setColor(Theme.toolBarLightColor.getColor());
            graphics.drawLine(n, n2, n3 - 1, n2);
            graphics.setColor(Theme.toolBarDarkColor.getColor());
            graphics.drawLine(n, n4 - 1, n3 - 1, n4 - 1);
        } else {
            graphics.setColor(Theme.toolBarLightColor.getColor());
            graphics.drawLine(n, n2, n, n4 - 1);
            graphics.setColor(Theme.toolBarDarkColor.getColor());
            graphics.drawLine(n3 - 1, n2, n3 - 1, n4 - 1);
        }
    }

    protected void drawXPBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        if (((JToolBar)component).isFloatable()) {
            if (((JToolBar)component).getOrientation() == 0) {
                int n5 = 3;
                if (!component.getComponentOrientation().isLeftToRight()) {
                    n5 = component.getBounds().width - 8 + 3;
                }
                graphics.setColor(Theme.toolGripLightColor.getColor());
                graphics.drawLine(n5, 3, n5 + 1, 3);
                graphics.drawLine(n5, 3, n5, n4 - 5);
                graphics.setColor(Theme.toolGripDarkColor.getColor());
                graphics.drawLine(n5, n4 - 4, n5 + 1, n4 - 4);
                graphics.drawLine(n5 + 2, 3, n5 + 2, n4 - 4);
            } else {
                graphics.setColor(Theme.toolGripLightColor.getColor());
                graphics.drawLine(3, 3, 3, 4);
                graphics.drawLine(3, 3, n3 - 4, 3);
                graphics.setColor(Theme.toolGripDarkColor.getColor());
                graphics.drawLine(n3 - 4, 4, n3 - 4, 5);
                graphics.drawLine(3, 5, n3 - 4, 5);
            }
        }
        graphics.translate(-n, -n2);
    }
}

