/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.util;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import de.muntjak.tinylookandfeel.util.HSBReference;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;

public class DrawRoutines {
    static final int[][] checkA = new int[][]{{53, 66, 78, 99, 115, 136, 144, 156, 165, 177, 189}, {66, 78, 99, 115, 136, 144, 156, 165, 177, 189, 202}, {78, 99, 0, 0, 0, 0, 0, 0, 0, 202, 210}, {99, 115, 0, 0, 0, 0, 0, 0, 0, 210, 214}, {115, 136, 0, 0, 0, 0, 0, 0, 0, 214, 226}, {136, 144, 0, 0, 0, 0, 0, 0, 0, 226, 230}, {144, 156, 0, 0, 0, 0, 0, 0, 0, 230, 239}, {156, 165, 0, 0, 0, 0, 0, 0, 0, 239, 243}, {165, 177, 0, 0, 0, 0, 0, 0, 0, 243, 247}, {177, 189, 202, 210, 214, 226, 230, 239, 243, 247, 251}, {189, 202, 210, 214, 226, 230, 239, 243, 247, 251, 255}};
    static final int[][] radioA = new int[][]{{0, 0, 78, 99, 115, 136, 144, 156, 165, 0, 0}, {0, 78, 99, 115, 136, 144, 156, 165, 177, 189, 0}, {78, 99, 115, 136, 92, 48, 92, 177, 189, 202, 210}, {99, 115, 136, 0, 0, 0, 0, 0, 202, 210, 214}, {115, 136, 92, 0, 0, 0, 0, 0, 128, 214, 226}, {136, 144, 48, 0, 0, 0, 0, 0, 64, 226, 230}, {144, 156, 92, 0, 0, 0, 0, 0, 128, 230, 239}, {156, 165, 177, 0, 0, 0, 0, 0, 230, 239, 243}, {165, 177, 189, 202, 128, 64, 128, 230, 239, 243, 247}, {0, 189, 202, 210, 214, 226, 230, 239, 243, 247, 0}, {0, 0, 210, 214, 226, 230, 239, 243, 247, 0, 0}};
    static GraphicsConfiguration graphicsConfiguration;

    public static void drawBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
    }

    public static void drawEditableComboBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.drawLine(n, n2 + 3, n, n4 - 4);
        graphics.drawLine(n + 3, n2, n3 - 1, n2);
        graphics.drawLine(n + 3, n4 - 1, n3 - 1, n4 - 1);
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 216);
        graphics.setColor(color2);
        graphics.drawLine(n + 2, n2, n + 2, n2);
        graphics.drawLine(n + n3 - 3, n2, n + n3 - 3, n2);
        graphics.drawLine(n, n2 + 2, n, n2 + 2);
        graphics.drawLine(n, n2 + n4 - 3, n, n2 + n4 - 3);
        graphics.drawLine(n + 2, n2 + n4 - 1, n + 2, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 3, n2 + n4 - 1, n + n3 - 3, n2 + n4 - 1);
        color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 130);
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n2, n + 1, n2);
        graphics.drawLine(n, n2 + 1, n, n2 + 1);
        graphics.drawLine(n, n2 + n4 - 2, n, n2 + n4 - 2);
        graphics.drawLine(n + 1, n2 + n4 - 1, n + 1, n2 + n4 - 1);
        color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 24);
        graphics.setColor(color2);
        graphics.drawLine(n, n2, n, n2);
        graphics.drawLine(n, n2 + n4 - 1, n, n2 + n4 - 1);
        color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 112);
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 104);
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2);
    }

    public static void drawRoundedBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.drawLine(n + 3, n2, n + n3 - 4, n2);
        graphics.drawLine(n + 3, n2 + n4 - 1, n + n3 - 4, n2 + n4 - 1);
        graphics.drawLine(n, n2 + 3, n, n2 + n4 - 4);
        graphics.drawLine(n + n3 - 1, n2 + 3, n + n3 - 1, n2 + n4 - 4);
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 216);
        graphics.setColor(color2);
        graphics.drawLine(n + 2, n2, n + 2, n2);
        graphics.drawLine(n + n3 - 3, n2, n + n3 - 3, n2);
        graphics.drawLine(n, n2 + 2, n, n2 + 2);
        graphics.drawLine(n, n2 + n4 - 3, n, n2 + n4 - 3);
        graphics.drawLine(n + 2, n2 + n4 - 1, n + 2, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 3, n2 + n4 - 1, n + n3 - 3, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2 + 2, n + n3 - 1, n2 + 2);
        graphics.drawLine(n + n3 - 1, n2 + n4 - 3, n + n3 - 1, n2 + n4 - 3);
        color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 130);
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n2, n + 1, n2);
        graphics.drawLine(n + n3 - 2, n2, n + n3 - 2, n2);
        graphics.drawLine(n, n2 + 1, n, n2 + 1);
        graphics.drawLine(n, n2 + n4 - 2, n, n2 + n4 - 2);
        graphics.drawLine(n + 1, n2 + n4 - 1, n + 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 2, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + 1);
        graphics.drawLine(n + n3 - 1, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
        color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 24);
        graphics.setColor(color2);
        graphics.drawLine(n, n2, n, n2);
        graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2);
        graphics.drawLine(n, n2 + n4 - 1, n, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 112);
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1);
        color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 104);
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2);
        graphics.drawLine(n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
    }

    public static void drawWindowButtonBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.drawLine(n + 2, n2, n + n3 - 3, n2);
        graphics.drawLine(n + 2, n2 + n4 - 1, n + n3 - 3, n2 + n4 - 1);
        graphics.drawLine(n, n2 + 2, n, n2 + n4 - 3);
        graphics.drawLine(n + n3 - 1, n2 + 2, n + n3 - 1, n2 + n4 - 3);
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 100);
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n2, n + 1, n2);
        graphics.drawLine(n + n3 - 2, n2, n + n3 - 2, n2);
        graphics.drawLine(n, n2 + 1, n, n2 + 1);
        graphics.drawLine(n, n2 + n4 - 2, n, n2 + n4 - 2);
        graphics.drawLine(n + 1, n2 + n4 - 1, n + 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 2, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + 1);
        graphics.drawLine(n + n3 - 1, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
        color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 216);
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1);
        graphics.drawLine(n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2);
        graphics.drawLine(n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
    }

    public static synchronized void drawProgressBarBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.drawLine(n + 1, n2, n + n3 - 2, n2);
        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
        graphics.drawLine(n, n2 + 1, n, n2 + n4 - 2);
        graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 2);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1);
        graphics.drawLine(n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2);
        graphics.drawLine(n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
    }

    public static void drawRolloverBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        int n5;
        graphics.setColor(ColorRoutines.darken(color, 10));
        graphics.drawLine(n + 2, n2 + n4 - 2, n + n3 - 3, n2 + n4 - 2);
        graphics.setColor(color);
        graphics.drawLine(n + 1, n2 + n4 - 3, n + n3 - 2, n2 + n4 - 3);
        graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 144));
        graphics.drawLine(n + 2, n2 + 2, n + n3 - 3, n2 + 2);
        graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 64));
        graphics.drawLine(n + 2, n2 + 1, n + n3 - 3, n2 + 1);
        if (n4 <= 6) {
            return;
        }
        int n6 = 191 / (n4 - 5);
        int n7 = 64 + n6;
        for (n5 = n2 + 2; n5 < n2 + n4 - 3; ++n5) {
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n7));
            graphics.drawLine(n + 1, n5, n + 1, n5);
            graphics.drawLine(n + n3 - 2, n5, n + n3 - 2, n5);
            n7 += n6;
        }
        n6 = 111 / (n4 - 6);
        n7 = 144 + n6;
        for (n5 = n2 + 3; n5 < n2 + n4 - 3; ++n5) {
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n7));
            graphics.drawLine(n + 2, n5, n + 2, n5);
            graphics.drawLine(n + n3 - 3, n5, n + n3 - 3, n5);
            n7 += n6;
        }
    }

    public static void drawRolloverCheckBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        for (int i = 0; i < 11; ++i) {
            for (int j = 0; j < 11; ++j) {
                if (checkA[i][j] <= 0) continue;
                Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), checkA[i][j]);
                graphics.setColor(color2);
                graphics.drawLine(j + 1, i + 1, j + 1, i + 1);
            }
        }
        graphics.translate(-n, -n2);
    }

    public static void drawSelectedXpTabBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4, int n5) {
        Color color2 = ColorRoutines.getAdjustedColor(Theme.tabRolloverColor.getColor(), 20, -30);
        graphics.setColor(color2);
        Color color3 = ColorRoutines.getAverage(Theme.backColor.getColor(), color2);
        switch (n5) {
            case 2: {
                graphics.drawLine(n, n2 + 2, n, n2 + --n4 - 3);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
                graphics.drawLine(n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2);
                graphics.drawLine(n + 2, n2, n + 2, n2);
                graphics.drawLine(n + 2, n2 + n4 - 1, n + 2, n2 + n4 - 1);
                graphics.setColor(Theme.tabRolloverColor.getColor());
                graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + n4 - 3);
                graphics.drawLine(n + 2, n2 + 1, n + 2, n2 + n4 - 2);
                graphics.setColor(color3);
                graphics.drawLine(n, n2 + 1, n, n2 + 1);
                graphics.drawLine(n + 1, n2, n + 1, n2);
                graphics.drawLine(n, n2 + n4 - 2, n, n2 + n4 - 2);
                graphics.drawLine(n + 1, n2 + n4 - 1, n + 1, n2 + n4 - 1);
                graphics.setColor(color);
                graphics.drawLine(n + 3, n2, n + n3 - 1, n2);
                graphics.drawLine(n + 3, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                break;
            }
            case 4: {
                graphics.drawLine((n -= 2) + n3 - 1, n2 + 2, n + n3 - 1, n2 + --n4 - 3);
                graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1);
                graphics.drawLine(n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
                graphics.drawLine(n + n3 - 3, n2, n + n3 - 3, n2);
                graphics.drawLine(n + n3 - 3, n2 + n4 - 1, n + n3 - 3, n2 + n4 - 1);
                graphics.setColor(Theme.tabRolloverColor.getColor());
                graphics.drawLine(n + n3 - 2, n2 + 2, n + n3 - 2, n2 + n4 - 3);
                graphics.drawLine(n + n3 - 3, n2 + 1, n + n3 - 3, n2 + n4 - 2);
                graphics.setColor(color3);
                graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + 1);
                graphics.drawLine(n + n3 - 2, n2, n + n3 - 2, n2);
                graphics.drawLine(n + n3 - 1, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
                graphics.drawLine(n + n3 - 2, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
                graphics.setColor(color);
                graphics.drawLine(n, n2, n + n3 - 4, n2);
                graphics.drawLine(n, n2 + n4 - 1, n + n3 - 4, n2 + n4 - 1);
                break;
            }
            case 3: {
                graphics.drawLine(n + 2, (n2 -= 2) + n4 - 1, n + --n3 - 3, n2 + n4 - 1);
                graphics.drawLine(n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2);
                graphics.drawLine(n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
                graphics.drawLine(n, n2 + n4 - 3, n, n2 + n4 - 3);
                graphics.drawLine(n + n3 - 1, n2 + n4 - 3, n + n3 - 1, n2 + n4 - 3);
                graphics.setColor(Theme.tabRolloverColor.getColor());
                graphics.drawLine(n + 2, n2 + n4 - 2, n + n3 - 3, n2 + n4 - 2);
                graphics.drawLine(n + 1, n2 + n4 - 3, n + n3 - 2, n2 + n4 - 3);
                graphics.setColor(color);
                graphics.drawLine(n, n2, n, n2 + n4 - 4);
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 4);
                graphics.setColor(color3);
                graphics.drawLine(n + 1, n2 + n4 - 1, n + 1, n2 + n4 - 1);
                graphics.drawLine(n, n2 + n4 - 2, n, n2 + n4 - 2);
                graphics.drawLine(n + n3 - 2, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
                break;
            }
            default: {
                graphics.drawLine(n + 2, n2, n + --n3 - 3, n2);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
                graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1);
                graphics.drawLine(n, n2 + 2, n, n2 + 2);
                graphics.drawLine(n + n3 - 1, n2 + 2, n + n3 - 1, n2 + 2);
                graphics.setColor(Theme.tabRolloverColor.getColor());
                graphics.drawLine(n + 2, n2 + 1, n + n3 - 3, n2 + 1);
                graphics.drawLine(n + 1, n2 + 2, n + n3 - 2, n2 + 2);
                graphics.setColor(color3);
                graphics.drawLine(n + 1, n2, n + 1, n2);
                graphics.drawLine(n, n2 + 1, n, n2 + 1);
                graphics.drawLine(n + n3 - 2, n2, n + n3 - 2, n2);
                graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + 1);
                graphics.setColor(color);
                graphics.drawLine(n, n2 + 3, n, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2 + 3, n + n3 - 1, n2 + n4 - 1);
            }
        }
    }

    public static void drawXpTabBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4, int n5) {
        Color color2 = null;
        graphics.setColor(color);
        switch (n5) {
            case 2: {
                graphics.drawLine(n + 2, n2, n + n3 - 1, n2);
                graphics.drawLine(n + 2, n2 + --n4 - 1, n + n3 - 1, n2 + n4 - 1);
                graphics.drawLine(n, n2 + 2, n, n2 + n4 - 3);
                color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 56);
                graphics.setColor(color2);
                graphics.drawLine(n, n2, n, n2);
                graphics.drawLine(n, n2 + n4 - 1, n, n2 + n4 - 1);
                color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 183);
                graphics.setColor(color2);
                graphics.drawLine(n + 1, n2, n + 1, n2);
                graphics.drawLine(n, n2 + 1, n, n2 + 1);
                graphics.drawLine(n, n2 + n4 - 2, n, n2 + n4 - 2);
                graphics.drawLine(n + 1, n2 + n4 - 1, n + 1, n2 + n4 - 1);
                color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 76);
                graphics.setColor(color2);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
                graphics.drawLine(n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2);
                break;
            }
            case 4: {
                graphics.drawLine(n -= 2, n2, n + n3 - 3, n2);
                graphics.drawLine(n, n2 + --n4 - 1, n + n3 - 3, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2 + 2, n + n3 - 1, n2 + n4 - 3);
                color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 56);
                graphics.setColor(color2);
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2);
                graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 183);
                graphics.setColor(color2);
                graphics.drawLine(n + n3 - 2, n2, n + n3 - 2, n2);
                graphics.drawLine(n + n3 - 2, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + 1);
                graphics.drawLine(n + n3 - 1, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
                color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 76);
                graphics.setColor(color2);
                graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1);
                graphics.drawLine(n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
                break;
            }
            case 3: {
                graphics.drawLine(n + 2, (n2 -= 2) + n4 - 1, n + --n3 - 3, n2 + n4 - 1);
                graphics.drawLine(n, n2, n, n2 + n4 - 3);
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 3);
                color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 56);
                graphics.setColor(color2);
                graphics.drawLine(n, n2 + n4 - 1, n, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 183);
                graphics.setColor(color2);
                graphics.drawLine(n, n2 + n4 - 2, n, n2 + n4 - 2);
                graphics.drawLine(n + 1, n2 + n4 - 1, n + 1, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 2, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
                color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 76);
                graphics.setColor(color2);
                graphics.drawLine(n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2);
                graphics.drawLine(n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
                break;
            }
            default: {
                graphics.drawLine(n + 2, n2, n + --n3 - 3, n2);
                graphics.drawLine(n, n2 + 2, n, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2 + 2, n + n3 - 1, n2 + n4 - 1);
                color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 56);
                graphics.setColor(color2);
                graphics.drawLine(n, n2, n, n2);
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2);
                color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 183);
                graphics.setColor(color2);
                graphics.drawLine(n + 1, n2, n + 1, n2);
                graphics.drawLine(n + n3 - 2, n2, n + n3 - 2, n2);
                graphics.drawLine(n, n2 + 1, n, n2 + 1);
                graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + 1);
                color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 76);
                graphics.setColor(color2);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
                graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1);
            }
        }
    }

    public static void drawXpRadioRolloverBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        for (int i = 0; i < 11; ++i) {
            for (int j = 0; j < 11; ++j) {
                if (radioA[i][j] <= 0) continue;
                Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), radioA[i][j]);
                graphics.setColor(color2);
                graphics.drawLine(j + 1, i + 1, j + 1, i + 1);
            }
        }
        graphics.translate(-n, -n2);
    }

    public static void drawXpRadioBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.drawLine(n + 6, n2, n + 6, n2);
        graphics.drawLine(n + 3, n2 + 1, n + 3, n2 + 1);
        graphics.drawLine(n + 9, n2 + 1, n + 9, n2 + 1);
        graphics.drawLine(n + 1, n2 + 3, n + 1, n2 + 3);
        graphics.drawLine(n + 11, n2 + 3, n + 11, n2 + 3);
        graphics.drawLine(n, n2 + 6, n, n2 + 6);
        graphics.drawLine(n + 12, n2 + 6, n + 12, n2 + 6);
        graphics.drawLine(n + 1, n2 + 9, n + 1, n2 + 9);
        graphics.drawLine(n + 11, n2 + 9, n + 11, n2 + 9);
        graphics.drawLine(n + 3, n2 + 11, n + 3, n2 + 11);
        graphics.drawLine(n + 9, n2 + 11, n + 9, n2 + 11);
        graphics.drawLine(n + 6, n2 + 12, n + 6, n2 + 12);
        graphics.setColor(ColorRoutines.getAlphaColor(color, 168));
        graphics.drawLine(n + 5, n2, n + 5, n2);
        graphics.drawLine(n + 7, n2, n + 7, n2);
        graphics.drawLine(n + 4, n2 + 1, n + 4, n2 + 1);
        graphics.drawLine(n + 8, n2 + 1, n + 8, n2 + 1);
        graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
        graphics.drawLine(n + 10, n2 + 2, n + 10, n2 + 2);
        graphics.drawLine(n + 1, n2 + 4, n + 1, n2 + 4);
        graphics.drawLine(n + 11, n2 + 4, n + 11, n2 + 4);
        graphics.drawLine(n, n2 + 5, n, n2 + 5);
        graphics.drawLine(n + 12, n2 + 5, n + 12, n2 + 5);
        graphics.drawLine(n, n2 + 7, n, n2 + 7);
        graphics.drawLine(n + 12, n2 + 7, n + 12, n2 + 7);
        graphics.drawLine(n + 1, n2 + 8, n + 1, n2 + 8);
        graphics.drawLine(n + 11, n2 + 8, n + 11, n2 + 8);
        graphics.drawLine(n + 2, n2 + 10, n + 2, n2 + 10);
        graphics.drawLine(n + 10, n2 + 10, n + 10, n2 + 10);
        graphics.drawLine(n + 4, n2 + 11, n + 4, n2 + 11);
        graphics.drawLine(n + 8, n2 + 11, n + 8, n2 + 11);
        graphics.drawLine(n + 5, n2 + 12, n + 5, n2 + 12);
        graphics.drawLine(n + 7, n2 + 12, n + 7, n2 + 12);
        graphics.setColor(ColorRoutines.getAlphaColor(color, 64));
        graphics.drawLine(n + 4, n2, n + 4, n2);
        graphics.drawLine(n + 8, n2, n + 8, n2);
        graphics.drawLine(n + 2, n2 + 1, n + 2, n2 + 1);
        graphics.drawLine(n + 2, n2 + 3, n + 2, n2 + 3);
        graphics.drawLine(n + 10, n2 + 1, n + 10, n2 + 1);
        graphics.drawLine(n + 10, n2 + 3, n + 10, n2 + 3);
        graphics.drawLine(n + 5, n2 + 1, n + 5, n2 + 1);
        graphics.drawLine(n + 7, n2 + 1, n + 7, n2 + 1);
        graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 2);
        graphics.drawLine(n + 1, n2 + 5, n + 1, n2 + 5);
        graphics.drawLine(n + 1, n2 + 7, n + 1, n2 + 7);
        graphics.drawLine(n + 11, n2 + 2, n + 11, n2 + 2);
        graphics.drawLine(n + 3, n2 + 2, n + 3, n2 + 2);
        graphics.drawLine(n + 9, n2 + 2, n + 9, n2 + 2);
        graphics.drawLine(n, n2 + 4, n, n2 + 4);
        graphics.drawLine(n + 12, n2 + 4, n + 12, n2 + 4);
        graphics.drawLine(n, n2 + 8, n, n2 + 8);
        graphics.drawLine(n + 12, n2 + 8, n + 12, n2 + 8);
        graphics.drawLine(n + 2, n2 + 9, n + 2, n2 + 9);
        graphics.drawLine(n + 10, n2 + 9, n + 10, n2 + 9);
        graphics.drawLine(n + 1, n2 + 10, n + 1, n2 + 10);
        graphics.drawLine(n + 11, n2 + 5, n + 11, n2 + 5);
        graphics.drawLine(n + 11, n2 + 7, n + 11, n2 + 7);
        graphics.drawLine(n + 11, n2 + 10, n + 11, n2 + 10);
        graphics.drawLine(n + 3, n2 + 10, n + 3, n2 + 10);
        graphics.drawLine(n + 9, n2 + 10, n + 9, n2 + 10);
        graphics.drawLine(n + 2, n2 + 11, n + 2, n2 + 11);
        graphics.drawLine(n + 10, n2 + 11, n + 10, n2 + 11);
        graphics.drawLine(n + 5, n2 + 11, n + 5, n2 + 11);
        graphics.drawLine(n + 7, n2 + 11, n + 7, n2 + 11);
        graphics.drawLine(n + 4, n2 + 12, n + 4, n2 + 12);
        graphics.drawLine(n + 8, n2 + 12, n + 8, n2 + 12);
        graphics.setColor(ColorRoutines.getAlphaColor(color, 16));
        graphics.drawLine(n + 3, n2, n + 3, n2);
        graphics.drawLine(n + 9, n2, n + 9, n2);
        graphics.drawLine(n, n2 + 3, n, n2 + 3);
        graphics.drawLine(n + 12, n2 + 3, n + 12, n2 + 3);
        graphics.drawLine(n, n2 + 9, n, n2 + 9);
        graphics.drawLine(n + 12, n2 + 9, n + 12, n2 + 9);
        graphics.drawLine(n + 3, n2 + 12, n + 3, n2 + 12);
        graphics.drawLine(n + 9, n2 + 12, n + 9, n2 + 12);
    }

    public static ImageIcon colorizeIcon(Image image, HSBReference hSBReference) {
        ColorRoutines colorRoutines = new ColorRoutines(hSBReference);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("PixelGrabber interrupted waiting for pixels");
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("Image fetch aborted or errored.");
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    bufferedImage.setRGB(j, i, DrawRoutines.colorizePixel(nArray[i * n + j], colorRoutines));
                }
            }
        }
        return new ImageIcon(bufferedImage);
    }

    private static int colorizePixel(int n, ColorRoutines colorRoutines) {
        int n2 = n >> 24 & 0xFF;
        if (n2 == 0) {
            return n;
        }
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        return colorRoutines.colorize(n3, n4, n5, n2);
    }

    static {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
    }
}

