/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.utilities.java.support.logic;

/**
 * An exception that represents the violation of a constraint. For example, a method argument not being within the
 * proper integer range or a return value being null. The astute observer might ask "Why not just use
 * {@link IllegalArgumentException}?" The short answer is that that exception is really only meant to be thrown when
 * checking method inputs and we wanted something that could really be used anywhere.
 */
public class ConstraintViolationException extends RuntimeException {

    /** Serial version UID. */
    private static final long serialVersionUID = -3994361273802830823L;

    /**
     * Constructor.
     * 
     * @param message message describing the violated constraint
     */
    public ConstraintViolationException(final String message) {
        super(message);
    }
}