/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import java.net.InetAddress;
import net.shibboleth.utilities.java.support.net.IPRange;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IPRangeTest {
    @Test
    public void testValidV4Addresses() {
        IPRange.parseCIDRBlock((String)"1.2.3.4/32");
        IPRange.parseCIDRBlock((String)"0.0.0.0/8");
        IPRange.parseCIDRBlock((String)"0.0.0.0/0");
    }

    @Test
    public void testValidV6Addresses() {
        IPRange.parseCIDRBlock((String)"0:0:0:0:0:0:0:0/128");
        IPRange.parseCIDRBlock((String)"0:0:0:0:0:0:0:0/0");
        IPRange.parseCIDRBlock((String)"1234:5678:90ab:cdef:FfFf:AaAa:BBBB:CCCC/128");
        IPRange.parseCIDRBlock((String)"1234:5678::BBBB:CCCC/128");
        IPRange.parseCIDRBlock((String)"2001:630:200::/48");
        IPRange.parseCIDRBlock((String)"::0BAD:7/128");
    }

    @Test
    public void testInvalidJunkAddresses() {
        this.testInvalid(null);
        this.testInvalid("1.2.3.500/32");
        this.testInvalid("1.2.3.G/32");
        this.testInvalid("1234:5678:90ab:cdef:FfFf:AaAa:BBBB:FFFFF/128");
        this.testInvalid("1234:5678:90ab:cdef:FfFf:AaAa:BBBB:GHIJ/128");
        this.testInvalid("/32");
        this.testInvalid("f/32");
        this.testInvalid("1.2.3.4");
        this.testInvalid("1.2.3.4/32/1");
        try {
            new IPRange(new byte[]{1, 2, 3}, 32);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidV4Addresses() {
        this.testInvalid("1/32");
        this.testInvalid("1.2/32");
        this.testInvalid("1.2.3/32");
        this.testInvalid("1.2.3.4/33");
        this.testInvalid("1.2.3.4/-3");
        this.testInvalid("1.2.3.4/wrong");
    }

    @Test
    public void testInvalidV6Addresses() {
        this.testInvalid("0:0/128");
        this.testInvalid("1:2:3:4:5:6:7/128");
        this.testInvalid("::0BAD::7/128");
        this.testInvalid("1:2:3:4:5:6:7:8/-5");
        this.testInvalid("1:2:3:4:5:6:7:8/129");
        this.testInvalid("1:2:3:4:5:6:7:8/wrong");
    }

    @Test
    public void testContains() throws Exception {
        IPRange networkRange = IPRange.parseCIDRBlock((String)"192.168.117.192/28");
        IPRange hostRange = IPRange.parseCIDRBlock((String)"192.168.117.199/28");
        byte[] bytes = new byte[]{-64, -88, 117, -65};
        Assert.assertFalse((boolean)networkRange.contains(bytes));
        Assert.assertFalse((boolean)hostRange.contains(bytes));
        for (int host = 0; host < 16; ++host) {
            bytes[3] = (byte)(192 + host);
            Assert.assertTrue((boolean)networkRange.contains(bytes));
            Assert.assertTrue((boolean)hostRange.contains(bytes));
        }
        bytes[3] = -48;
        Assert.assertFalse((boolean)networkRange.contains(bytes));
        Assert.assertFalse((boolean)hostRange.contains(bytes));
        Assert.assertFalse((boolean)networkRange.contains(new byte[]{1, 2, 3}));
        Assert.assertFalse((boolean)hostRange.contains(new byte[]{1, 2, 3}));
        Assert.assertFalse((boolean)networkRange.contains(InetAddress.getLocalHost()));
        Assert.assertFalse((boolean)hostRange.contains(InetAddress.getLocalHost()));
        IPRange v6Range = IPRange.parseCIDRBlock((String)"2620:102:c000::1/48");
        InetAddress v6Addr = InetAddress.getByName("2620:102:c000:f10:d::29c1");
        Assert.assertTrue((boolean)v6Range.contains(v6Addr));
    }

    @Test
    public void testGetNetworkAddress() {
        IPRange v6a = IPRange.parseCIDRBlock((String)"1234:5678:90ab:cdef:FfFf:AaAa:BBBB:CCCC/128");
        byte[] expected6a = new byte[]{18, 52, 86, 120, -112, -85, -51, -17, -1, -1, -86, -86, -69, -69, -52, -52};
        Assert.assertEquals((byte[])v6a.getNetworkAddress().getAddress(), (byte[])expected6a);
        IPRange v6b = IPRange.parseCIDRBlock((String)"1234:5678:90ab:cdef:FfFf:AaAa:BBBB:CCCC/104");
        byte[] expected6b = new byte[]{18, 52, 86, 120, -112, -85, -51, -17, -1, -1, -86, -86, -69, 0, 0, 0};
        Assert.assertEquals((byte[])v6b.getNetworkAddress().getAddress(), (byte[])expected6b);
        IPRange v4a = IPRange.parseCIDRBlock((String)"192.168.117.17/32");
        byte[] expected4a = new byte[]{-64, -88, 117, 17};
        Assert.assertEquals((byte[])v4a.getNetworkAddress().getAddress(), (byte[])expected4a);
        IPRange v4b = IPRange.parseCIDRBlock((String)"192.168.117.17/16");
        byte[] expected4b = new byte[]{-64, -88, 0, 0};
        Assert.assertEquals((byte[])v4b.getNetworkAddress().getAddress(), (byte[])expected4b);
    }

    @Test
    public void testGetHostAddress() {
        IPRange v6a = IPRange.parseCIDRBlock((String)"1234:5678:90ab:cdef:FfFf:AaAa:BBBB:CCCC/128");
        Assert.assertNull((Object)v6a.getHostAddress());
        IPRange v6b = IPRange.parseCIDRBlock((String)"1234:5678:90ab:cdef::/64");
        Assert.assertNull((Object)v6b.getHostAddress());
        IPRange v6c = IPRange.parseCIDRBlock((String)"1234:5678:90ab:cdef:FfFf:AaAa:BBBB:CCCC/64");
        Assert.assertNotNull((Object)v6c.getHostAddress());
        Assert.assertEquals((byte[])v6c.getHostAddress().getAddress(), (byte[])v6a.getNetworkAddress().getAddress());
        IPRange v4a = IPRange.parseCIDRBlock((String)"192.168.117.17/32");
        Assert.assertNull((Object)v4a.getHostAddress());
        IPRange v4b = IPRange.parseCIDRBlock((String)"192.168.0.0/16");
        Assert.assertNull((Object)v4b.getHostAddress());
        IPRange v4c = IPRange.parseCIDRBlock((String)"192.168.117.17/16");
        Assert.assertNotNull((Object)v4c.getHostAddress());
        Assert.assertEquals((byte[])v4c.getHostAddress().getAddress(), (byte[])v4a.getNetworkAddress().getAddress());
    }

    private void testInvalid(String address) {
        try {
            IPRange.parseCIDRBlock((String)address);
            Assert.fail((String)("address should have been invalid: " + address));
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }
}

