/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import net.shibboleth.utilities.java.support.net.RequestResponseContextFilter;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletConfig;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RequestResponseContextFilterTest {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private FilterChain filterChain;
    private Servlet servlet;
    private RequestResponseContextFilter filter;

    @BeforeMethod
    public void setUp() throws ServletException {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest();
        mockRequest.setMethod("GET");
        mockRequest.setRequestURI("/foo");
        mockRequest.addHeader("MyRequestHeader", (Object)"MyRequestHeaderValue");
        mockRequest.addParameter("MyParam", "MyParamValue");
        this.request = mockRequest;
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        mockResponse.setHeader("MyResponseHeader", "MyResponseHeaderValue");
        this.response = mockResponse;
        this.filter = new RequestResponseContextFilter();
        this.filter.init((FilterConfig)new MockFilterConfig());
        this.servlet = new TestServlet();
        this.servlet.init((ServletConfig)new MockServletConfig());
        this.filterChain = new MockFilterChain(this.servlet, new Filter[]{this.filter});
    }

    @AfterMethod
    public void tearDown() {
        HttpServletRequestResponseContext.clearCurrent();
    }

    @Test
    public void testFilter() throws IOException, ServletException {
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
        this.filterChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
    }

    public class TestServlet
    implements Servlet {
        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            Assert.assertNotNull((Object)HttpServletRequestResponseContext.getRequest(), (String)"HttpServletRequest was null");
            Assert.assertNotNull((Object)HttpServletRequestResponseContext.getResponse(), (String)"HttpServletResponse was null");
        }

        public void init(ServletConfig config) throws ServletException {
        }

        public ServletConfig getServletConfig() {
            return null;
        }

        public String getServletInfo() {
            return null;
        }

        public void destroy() {
        }
    }
}

