/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import java.net.MalformedURLException;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class URLBuilderTest {
    @Test
    public void testURLBuilder1() throws MalformedURLException {
        String url = "http://www.example.com";
        URLBuilder builder1 = new URLBuilder(url);
        Assert.assertEquals((String)builder1.getScheme(), (String)"http");
        Assert.assertEquals((String)builder1.getUsername(), null);
        Assert.assertEquals((String)builder1.getPassword(), null);
        Assert.assertEquals((String)builder1.getHost(), (String)"www.example.com");
        Assert.assertEquals((Object)builder1.getPort(), null);
        Assert.assertEquals((String)builder1.getPath(), null);
        Assert.assertEquals((int)builder1.getQueryParams().size(), (int)0);
        Assert.assertEquals((String)builder1.getFragment(), null);
        Assert.assertEquals((String)builder1.buildURL(), (String)url);
    }

    @Test
    public void testURLBuilder2() throws MalformedURLException {
        String url = "https://www.example.com/foo/index.html";
        URLBuilder builder1 = new URLBuilder(url);
        Assert.assertEquals((String)builder1.getScheme(), (String)"https");
        Assert.assertEquals((String)builder1.getUsername(), null);
        Assert.assertEquals((String)builder1.getPassword(), null);
        Assert.assertEquals((String)builder1.getHost(), (String)"www.example.com");
        Assert.assertEquals((Object)builder1.getPort(), null);
        Assert.assertEquals((String)builder1.getPath(), (String)"/foo/index.html");
        Assert.assertEquals((int)builder1.getQueryParams().size(), (int)0);
        Assert.assertEquals((String)builder1.getFragment(), null);
        Assert.assertEquals((String)builder1.buildURL(), (String)url);
    }

    @Test
    public void testURLBuilder3() throws MalformedURLException {
        String url = "http://www.example.com:8080/index.html?attrib1=value1&attrib2=value&attrib3";
        URLBuilder builder1 = new URLBuilder(url);
        Assert.assertEquals((String)builder1.getScheme(), (String)"http");
        Assert.assertEquals((String)builder1.getUsername(), null);
        Assert.assertEquals((String)builder1.getPassword(), null);
        Assert.assertEquals((String)builder1.getHost(), (String)"www.example.com");
        Assert.assertEquals((Object)builder1.getPort(), (Object)8080);
        Assert.assertEquals((String)builder1.getPath(), (String)"/index.html");
        Assert.assertEquals((int)builder1.getQueryParams().size(), (int)3);
        Assert.assertEquals((String)builder1.getFragment(), null);
        Assert.assertEquals((String)builder1.buildURL(), (String)url);
    }

    @Test
    public void testURLBuilder4() throws MalformedURLException {
        String url = "https://www.example.com#anchor";
        URLBuilder builder1 = new URLBuilder(url);
        Assert.assertEquals((String)builder1.getScheme(), (String)"https");
        Assert.assertEquals((String)builder1.getUsername(), null);
        Assert.assertEquals((String)builder1.getPassword(), null);
        Assert.assertEquals((String)builder1.getHost(), (String)"www.example.com");
        Assert.assertEquals((Object)builder1.getPort(), null);
        Assert.assertEquals((String)builder1.getPath(), null);
        Assert.assertEquals((int)builder1.getQueryParams().size(), (int)0);
        Assert.assertEquals((String)builder1.getFragment(), (String)"anchor");
        Assert.assertEquals((String)builder1.buildURL(), (String)url);
    }

    @Test
    public void testURLBuilder5() throws MalformedURLException {
        String url = "http://www.example.com/index.html?attrib1=value1&attrib2=value&attrib3#anchor";
        URLBuilder builder1 = new URLBuilder(url);
        Assert.assertEquals((String)builder1.getScheme(), (String)"http");
        Assert.assertEquals((String)builder1.getUsername(), null);
        Assert.assertEquals((String)builder1.getPassword(), null);
        Assert.assertEquals((String)builder1.getHost(), (String)"www.example.com");
        Assert.assertEquals((Object)builder1.getPort(), null);
        Assert.assertEquals((String)builder1.getPath(), (String)"/index.html");
        Assert.assertEquals((int)builder1.getQueryParams().size(), (int)3);
        Assert.assertEquals((String)builder1.getFragment(), (String)"anchor");
        Assert.assertEquals((String)builder1.buildURL(), (String)url);
    }

    @Test
    public void testURLBuilder6() throws MalformedURLException {
        String url = "http://user:pass@www.example.com";
        URLBuilder builder1 = new URLBuilder(url);
        Assert.assertEquals((String)builder1.getScheme(), (String)"http");
        Assert.assertEquals((String)builder1.getUsername(), (String)"user");
        Assert.assertEquals((String)builder1.getPassword(), (String)"pass");
        Assert.assertEquals((String)builder1.getHost(), (String)"www.example.com");
        Assert.assertEquals((Object)builder1.getPort(), null);
        Assert.assertEquals((String)builder1.getPath(), null);
        Assert.assertEquals((int)builder1.getQueryParams().size(), (int)0);
        Assert.assertEquals((String)builder1.getFragment(), null);
        Assert.assertEquals((String)builder1.buildURL(), (String)url);
    }

    @Test
    public void testURLBuilder7() throws MalformedURLException {
        String url = "http://user@www.example.com";
        URLBuilder builder1 = new URLBuilder(url);
        Assert.assertEquals((String)builder1.getScheme(), (String)"http");
        Assert.assertEquals((String)builder1.getUsername(), (String)"user");
        Assert.assertEquals((String)builder1.getPassword(), null);
        Assert.assertEquals((String)builder1.getHost(), (String)"www.example.com");
        Assert.assertEquals((Object)builder1.getPort(), null);
        Assert.assertEquals((String)builder1.getPath(), null);
        Assert.assertEquals((int)builder1.getQueryParams().size(), (int)0);
        Assert.assertEquals((String)builder1.getFragment(), null);
        Assert.assertEquals((String)builder1.buildURL(), (String)url);
    }
}

