/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resource.Resource;

public final class TestResourceConverter
implements Resource {
    private org.springframework.core.io.Resource springResource;

    private TestResourceConverter(@Nonnull org.springframework.core.io.Resource theResource) {
        this.springResource = (org.springframework.core.io.Resource)Constraint.isNotNull((Object)theResource, (String)"provided Spring Resource should not be null");
    }

    public static Resource of(org.springframework.core.io.Resource springResource) {
        if (springResource instanceof Resource) {
            return (Resource)springResource;
        }
        return new TestResourceConverter(springResource);
    }

    public InputStream getInputStream() throws IOException {
        return this.springResource.getInputStream();
    }

    public boolean exists() {
        return this.springResource.exists();
    }

    public boolean isReadable() {
        return this.springResource.isReadable();
    }

    public boolean isOpen() {
        return this.springResource.isOpen();
    }

    public URL getURL() throws IOException {
        return this.springResource.getURL();
    }

    public URI getURI() throws IOException {
        return this.springResource.getURI();
    }

    public File getFile() throws IOException {
        return this.springResource.getFile();
    }

    public long contentLength() throws IOException {
        return this.springResource.contentLength();
    }

    public long lastModified() throws IOException {
        return this.springResource.lastModified();
    }

    public Resource createRelativeResource(String relativePath) throws IOException {
        return TestResourceConverter.of(this.springResource.createRelative(relativePath));
    }

    public String getFilename() {
        return this.springResource.getFilename();
    }

    public String getDescription() {
        return this.springResource.getDescription();
    }
}

