/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class SerializeSupportTest {
    private Element parent;
    private BasicParserPool parserPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeTest
    public void setup() throws XMLParserException, ComponentInitializationException, SAXException, IOException {
        this.parserPool = new BasicParserPool();
        this.parserPool.initialize();
        DocumentBuilder builder = this.parserPool.getBuilder();
        try {
            ClassPathResource resource = new ClassPathResource("/net/shibboleth/utilities/java/support/xml/serializeSupportTest.xml");
            Document testFile = builder.parse(resource.getInputStream());
            this.parent = (Element)testFile.getFirstChild();
        }
        finally {
            this.parserPool.returnBuilder(builder);
        }
    }

    @Test
    public void testNodeToString() throws XMLParserException {
        String s = SerializeSupport.nodeToString((Node)this.parent);
        Document dom = this.parserPool.parse((Reader)new StringReader(s));
        Assert.assertEquals((String)SerializeSupport.nodeToString((Node)dom.getFirstChild()), (String)s, (String)"Should serialize to same output");
    }

    @Test(dependsOnMethods={"testNodeToString"})
    public void testWriteNode() throws XMLParserException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        SerializeSupport.writeNode((Node)this.parent, (OutputStream)output);
        byte[] data = output.toByteArray();
        Document dom = this.parserPool.parse((InputStream)new ByteArrayInputStream(data));
        Assert.assertEquals((String)SerializeSupport.nodeToString((Node)dom.getFirstChild()), (String)SerializeSupport.nodeToString((Node)this.parent), (String)"Should serialize to same output");
    }

    @Test(dependsOnMethods={"testNodeToString"})
    public void testPrettyPrintXML() throws XMLParserException {
        String s = SerializeSupport.prettyPrintXML((Node)this.parent);
        Document dom = this.parserPool.parse((Reader)new StringReader(s));
        Assert.assertEquals((String)SerializeSupport.nodeToString((Node)dom.getFirstChild()), (String)SerializeSupport.nodeToString((Node)this.parent), (String)"Should serialize to same output");
    }

    @Test(dependsOnMethods={"testNodeToString"})
    public void testLSOps() throws XMLParserException {
        DOMImplementationLS domLS = SerializeSupport.getDOMImplementationLS((Node)this.parent);
        LSSerializer serializer = SerializeSupport.getLSSerializer((DOMImplementationLS)domLS, null);
        LSOutput serializerOut = domLS.createLSOutput();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        serializerOut.setByteStream(output);
        serializer.write(this.parent, serializerOut);
        Document dom = this.parserPool.parse((InputStream)new ByteArrayInputStream(output.toByteArray()));
        Assert.assertEquals((String)SerializeSupport.nodeToString((Node)dom.getFirstChild()), (String)SerializeSupport.nodeToString((Node)this.parent), (String)"Should serialize to same output");
    }
}

