/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.oboformat.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.obolibrary.oboformat.model.QualifierValue;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;

public class Clause {
    protected String tag;
    protected final Collection<Object> values = new ArrayList<Object>();
    protected final Collection<Xref> xrefs = new ArrayList<Xref>();
    protected final Collection<QualifierValue> qualifierValues = new ArrayList<QualifierValue>();

    public Clause(OBOFormatConstants.OboFormatTag tag) {
        this(tag.getTag());
    }

    public Clause(String tag) {
        this.tag = tag;
    }

    public Clause(String tag, String value) {
        this(tag);
        this.setValue(value);
    }

    public Clause(OBOFormatConstants.OboFormatTag tag, String value) {
        this(tag.getTag(), value);
    }

    @Deprecated
    public Clause() {
    }

    public String getTag() {
        return this.tag;
    }

    @Deprecated
    public void setTag(String tag) {
        this.tag = tag;
    }

    public Collection<Object> getValues() {
        return this.values;
    }

    public void setValues(Collection<Object> values) {
        this.values.clear();
        this.values.addAll(values);
    }

    public void setValue(Object v) {
        this.values.clear();
        this.values.add(v);
    }

    public void addValue(Object v) {
        this.values.add(v);
    }

    public Object getValue() {
        Object value = null;
        if (!this.values.isEmpty()) {
            value = this.values.iterator().next();
        }
        return value;
    }

    public <T> T getValue(Class<T> cls) {
        Object value = this.getValue();
        if (value != null && value.getClass().isAssignableFrom(cls)) {
            return cls.cast(value);
        }
        return null;
    }

    public Object getValue2() {
        Object value = null;
        if (this.values.size() > 1) {
            Iterator<Object> iterator = this.values.iterator();
            iterator.next();
            value = iterator.next();
        }
        return value;
    }

    public <T> T getValue2(Class<T> cls) {
        Object value = this.getValue2();
        if (value != null && value.getClass().isAssignableFrom(cls)) {
            return cls.cast(value);
        }
        return null;
    }

    public Collection<Xref> getXrefs() {
        return this.xrefs;
    }

    public void setXrefs(Collection<Xref> xrefs) {
        this.xrefs.clear();
        this.xrefs.addAll(xrefs);
    }

    public void addXref(Xref xref) {
        this.xrefs.add(xref);
    }

    public Collection<QualifierValue> getQualifierValues() {
        return this.qualifierValues;
    }

    public void setQualifierValues(Collection<QualifierValue> qualifierValues) {
        this.qualifierValues.clear();
        this.qualifierValues.addAll(qualifierValues);
    }

    public void addQualifierValue(QualifierValue qv) {
        this.qualifierValues.add(qv);
    }

    public String toString() {
        if (this.values == null) {
            return this.tag + "=null";
        }
        StringBuilder sb = new StringBuilder(this.tag);
        sb.append('(');
        for (Object ob : this.values) {
            sb.append(' ');
            sb.append(ob);
        }
        if (this.qualifierValues != null) {
            sb.append('{');
            for (QualifierValue qv : this.qualifierValues) {
                sb.append(qv);
                sb.append(' ');
            }
            sb.append('}');
        }
        if (this.xrefs != null) {
            sb.append('[');
            for (Xref x : this.xrefs) {
                sb.append(x);
                sb.append(' ');
            }
            sb.append(']');
        }
        sb.append(')');
        return sb.toString();
    }

    private boolean collectionsEquals(Collection<?> c1, Collection<?> c2) {
        if (c1 == null || c1.size() == 0) {
            return c2 == null || c2.size() == 0;
        }
        if (c2 == null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        for (Object x : c1) {
            if (c2.contains(x)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 29791 * this.qualifierValues.hashCode() + 31 * this.xrefs.hashCode() + 961 * this.values.hashCode() + (this.tag == null ? 0 : this.tag.hashCode());
    }

    public boolean equals(Object e) {
        if (e == null || !(e instanceof Clause)) {
            return false;
        }
        if (e == this) {
            return true;
        }
        Clause other = (Clause)e;
        if (!this.getTag().equals(other.getTag())) {
            return false;
        }
        if (this.getValues().size() == 1 && other.getValues().size() == 1) {
            if (!(this.getValue().equals(other.getValue()) || this.getValue().equals(Boolean.TRUE) && other.getValue().equals("true") || other.getValue().equals(Boolean.TRUE) && this.getValue().equals("true") || this.getValue().equals(Boolean.FALSE) && other.getValue().equals("false") || other.getValue().equals(Boolean.FALSE) && this.getValue().equals("false"))) {
                return false;
            }
        } else if (!this.getValues().equals(other.getValues())) {
            return false;
        }
        if (!this.collectionsEquals(this.xrefs, other.getXrefs())) {
            return false;
        }
        if (this.qualifierValues != null) {
            if (other.getQualifierValues() == null) {
                return false;
            }
            if (!this.collectionsEquals(this.qualifierValues, other.getQualifierValues())) {
                return false;
            }
        } else if (other.getQualifierValues() != null && other.getQualifierValues().size() > 0) {
            return false;
        }
        return true;
    }
}

