/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class ConvertPropertyAssertionsToAnnotations
extends AbstractCompositeOntologyChange {
    private final Set<OWLOntology> ontologies;
    private List<OWLOntologyChange> changes;

    public ConvertPropertyAssertionsToAnnotations(OWLDataFactory dataFactory, Set<OWLOntology> ontologies) {
        super(dataFactory);
        this.ontologies = ontologies;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes = new ArrayList<OWLOntologyChange>();
        HashSet<OWLNamedIndividual> individuals = new HashSet<OWLNamedIndividual>();
        for (OWLOntology ont : this.ontologies) {
            individuals.addAll(ont.getIndividualsInSignature());
        }
        HashSet<OWLDataProperty> convertedDataProperties = new HashSet<OWLDataProperty>();
        for (OWLNamedIndividual ind : individuals) {
            boolean punned = false;
            for (OWLOntology ont : this.ontologies) {
                if (!ont.containsClassInSignature(ind.getIRI())) continue;
                punned = true;
                break;
            }
            if (!punned) continue;
            for (OWLOntology ont : this.ontologies) {
                for (OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom : ont.getDataPropertyAssertionAxioms(ind)) {
                    if (((OWLDataPropertyExpression)oWLDataPropertyAssertionAxiom.getProperty()).isAnonymous()) continue;
                    this.changes.add(new RemoveAxiom(ont, oWLDataPropertyAssertionAxiom));
                    OWLDataFactory df = this.getDataFactory();
                    OWLAnnotation anno = df.getOWLAnnotation(df.getOWLAnnotationProperty(((OWLDataPropertyExpression)oWLDataPropertyAssertionAxiom.getProperty()).asOWLDataProperty().getIRI()), (OWLAnnotationValue)oWLDataPropertyAssertionAxiom.getObject());
                    OWLAnnotationAssertionAxiom annoAx = df.getOWLAnnotationAssertionAxiom(ind.getIRI(), anno);
                    this.changes.add(new AddAxiom(ont, annoAx));
                    convertedDataProperties.add((OWLDataProperty)oWLDataPropertyAssertionAxiom.getProperty());
                }
            }
            for (OWLOntology ont : this.ontologies) {
                for (OWLAxiom oWLAxiom : ont.getDeclarationAxioms(ind)) {
                    this.changes.add(new RemoveAxiom(ont, oWLAxiom));
                }
                for (OWLClassAssertionAxiom oWLClassAssertionAxiom : ont.getClassAssertionAxioms(ind)) {
                    this.changes.add(new RemoveAxiom(ont, oWLClassAssertionAxiom));
                }
            }
        }
        for (OWLDataProperty prop : convertedDataProperties) {
            for (OWLOntology ont : this.ontologies) {
                for (OWLAxiom oWLAxiom : ont.getDeclarationAxioms(prop)) {
                    this.changes.add(new RemoveAxiom(ont, oWLAxiom));
                }
                for (OWLAxiom oWLAxiom : ont.getAxioms(prop)) {
                    this.changes.add(new RemoveAxiom(ont, oWLAxiom));
                }
            }
        }
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

