/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import uk.ac.manchester.cs.owl.owlapi.OWLNaryIndividualAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectOneOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubClassOfAxiomImpl;

public class OWLDifferentIndividualsAxiomImpl
extends OWLNaryIndividualAxiomImpl
implements OWLDifferentIndividualsAxiom {
    private static final long serialVersionUID = 30406L;

    public OWLDifferentIndividualsAxiomImpl(Set<? extends OWLIndividual> individuals, Set<? extends OWLAnnotation> annotations) {
        super(individuals, annotations);
    }

    @Override
    public OWLDifferentIndividualsAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLDifferentIndividualsAxiomImpl(this.getIndividuals(), NO_ANNOTATIONS);
    }

    @Override
    public OWLDifferentIndividualsAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return new OWLDifferentIndividualsAxiomImpl(this.getIndividuals(), this.mergeAnnos(annotations));
    }

    @Override
    public Set<OWLDifferentIndividualsAxiom> asPairwiseAxioms() {
        List<OWLIndividual> individuals = this.getIndividualsAsList();
        HashSet<OWLDifferentIndividualsAxiom> result = new HashSet<OWLDifferentIndividualsAxiom>();
        for (int i = 0; i < individuals.size() - 1; ++i) {
            for (int j = i + 1; j < individuals.size(); ++j) {
                OWLIndividual indI = individuals.get(i);
                OWLIndividual indJ = individuals.get(j);
                result.add(new OWLDifferentIndividualsAxiomImpl((Set<? extends OWLIndividual>)new HashSet<OWLIndividual>(Arrays.asList(indI, indJ)), NO_ANNOTATIONS));
            }
        }
        return result;
    }

    @Override
    public boolean containsAnonymousIndividuals() {
        for (OWLIndividual ind : this.getIndividuals()) {
            if (!ind.isAnonymous()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof OWLDifferentIndividualsAxiom;
    }

    @Override
    public Set<OWLSubClassOfAxiom> asOWLSubClassOfAxioms() {
        ArrayList<OWLObjectOneOfImpl> nominalsList = new ArrayList<OWLObjectOneOfImpl>();
        for (OWLIndividual individual : this.getIndividuals()) {
            nominalsList.add(new OWLObjectOneOfImpl(Collections.singleton(individual)));
        }
        HashSet<OWLSubClassOfAxiom> result = new HashSet<OWLSubClassOfAxiom>();
        for (int i = 0; i < nominalsList.size() - 1; ++i) {
            for (int j = i + 1; j < nominalsList.size(); ++j) {
                OWLClassExpression ceI = (OWLClassExpression)nominalsList.get(i);
                OWLClassExpression ceJ = ((OWLClassExpression)nominalsList.get(j)).getObjectComplementOf();
                result.add(new OWLSubClassOfAxiomImpl(ceI, ceJ, NO_ANNOTATIONS));
            }
        }
        return result;
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public AxiomType<?> getAxiomType() {
        return AxiomType.DIFFERENT_INDIVIDUALS;
    }
}

