/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntax;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.OWLAxiomFilter;
import org.semanticweb.owlapi.util.OntologyIRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.ManchesterOWLSyntaxObjectRenderer;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.ManchesterOWLSyntaxPrefixNameShortFormProvider;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.RendererEvent;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.RendererListener;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.RenderingDirector;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.SectionMap;

public class ManchesterOWLSyntaxFrameRenderer
extends ManchesterOWLSyntaxObjectRenderer
implements OWLEntityVisitor {
    private Set<OWLOntology> ontologies;
    private OntologyIRIShortFormProvider shortFormProvider = new OntologyIRIShortFormProvider();
    private Set<AxiomType<?>> filteredAxiomTypes = new HashSet();
    private boolean renderExtensions = false;
    private List<RendererListener> listeners = new ArrayList<RendererListener>();
    private OWLAxiomFilter axiomFilter = new OWLAxiomFilter(){

        @Override
        public boolean passes(OWLAxiom axiom) {
            return true;
        }
    };
    private RenderingDirector renderingDirector = new DefaultRenderingDirector();
    private RendererEvent event;

    @Deprecated
    public ManchesterOWLSyntaxFrameRenderer(OWLOntologyManager owlOntologyManager, OWLOntology ontology, Writer writer, ShortFormProvider entityShortFormProvider) {
        this(Collections.singleton(ontology), writer, entityShortFormProvider);
    }

    public ManchesterOWLSyntaxFrameRenderer(OWLOntology ontology, Writer writer, ShortFormProvider entityShortFormProvider) {
        this(Collections.singleton(ontology), writer, entityShortFormProvider);
    }

    @Deprecated
    public ManchesterOWLSyntaxFrameRenderer(OWLOntologyManager owlOntologyManager, Set<OWLOntology> ontologies, OWLOntology defaultOntology, Writer writer, ShortFormProvider entityShortFormProvider) {
        this(ontologies, writer, entityShortFormProvider);
    }

    @Deprecated
    public ManchesterOWLSyntaxFrameRenderer(Set<OWLOntology> ontologies, OWLOntology defaultOntology, Writer writer, ShortFormProvider entityShortFormProvider) {
        super(writer, entityShortFormProvider);
        this.ontologies = new LinkedHashSet<OWLOntology>(ontologies);
    }

    public ManchesterOWLSyntaxFrameRenderer(Set<OWLOntology> ontologies, Writer writer, ShortFormProvider entityShortFormProvider) {
        super(writer, entityShortFormProvider);
        this.ontologies = new LinkedHashSet<OWLOntology>(ontologies);
    }

    public void setRenderingDirector(RenderingDirector renderingDirector) {
        this.renderingDirector = renderingDirector;
    }

    public void addRendererListener(RendererListener listener) {
        this.listeners.add(listener);
    }

    public void removeRendererListener(RendererListener listener) {
        this.listeners.remove(listener);
    }

    public void setAxiomFilter(OWLAxiomFilter axiomFilter) {
        this.axiomFilter = axiomFilter;
    }

    public void clearFilteredAxiomTypes() {
        this.filteredAxiomTypes.clear();
    }

    public void addFilteredAxiomType(AxiomType<?> axiomType) {
        this.filteredAxiomTypes.add(axiomType);
    }

    public void setRenderExtensions(boolean renderExtensions) {
        this.renderExtensions = renderExtensions;
    }

    public Set<OWLOntology> getOntologies() {
        return this.ontologies;
    }

    public void writeOntology() throws OWLRendererException {
        SectionMap map;
        if (this.ontologies.size() != 1) {
            throw new OWLRuntimeException("Can only render one ontology");
        }
        OWLOntology ontology = this.getOntologies().iterator().next();
        this.writePrefixMap();
        this.writeNewLine();
        this.writeOntologyHeader(ontology);
        for (OWLAnnotationProperty oWLAnnotationProperty : ontology.getAnnotationPropertiesInSignature()) {
            this.write(oWLAnnotationProperty);
        }
        for (OWLDatatype oWLDatatype : ontology.getDatatypesInSignature()) {
            this.write(oWLDatatype);
        }
        for (OWLObjectProperty oWLObjectProperty : ontology.getObjectPropertiesInSignature()) {
            this.write(oWLObjectProperty);
            OWLObjectPropertyExpression invProp = oWLObjectProperty.getInverseProperty();
            if (ontology.getAxioms(invProp).isEmpty()) continue;
            this.write(invProp);
        }
        for (OWLDataProperty oWLDataProperty : ontology.getDataPropertiesInSignature()) {
            this.write(oWLDataProperty);
        }
        for (OWLClass oWLClass : ontology.getClassesInSignature()) {
            this.write(oWLClass);
        }
        for (OWLNamedIndividual oWLNamedIndividual : ontology.getIndividualsInSignature()) {
            this.write(oWLNamedIndividual);
        }
        for (OWLAnonymousIndividual oWLAnonymousIndividual : ontology.getReferencedAnonymousIndividuals()) {
            this.write(oWLAnonymousIndividual);
        }
        this.event = new RendererEvent(this, ontology);
        for (OWLDisjointClassesAxiom oWLDisjointClassesAxiom : ontology.getAxioms(AxiomType.DISJOINT_CLASSES)) {
            if (oWLDisjointClassesAxiom.getClassExpressions().size() <= 2) continue;
            map = new SectionMap();
            map.add(oWLDisjointClassesAxiom.getClassExpressions(), oWLDisjointClassesAxiom);
            this.writeSection(ManchesterOWLSyntax.DISJOINT_CLASSES, map, ",", false, ontology);
        }
        for (OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom : ontology.getAxioms(AxiomType.EQUIVALENT_CLASSES)) {
            if (oWLEquivalentClassesAxiom.getClassExpressions().size() <= 2) continue;
            map = new SectionMap();
            map.add(oWLEquivalentClassesAxiom.getClassExpressions(), oWLEquivalentClassesAxiom);
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_CLASSES, map, ",", false, ontology);
        }
        for (OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom : ontology.getAxioms(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            if (oWLDisjointObjectPropertiesAxiom.getProperties().size() <= 2) continue;
            map = new SectionMap();
            map.add(oWLDisjointObjectPropertiesAxiom.getProperties(), oWLDisjointObjectPropertiesAxiom);
            this.writeSection(ManchesterOWLSyntax.DISJOINT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom : ontology.getAxioms(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
            if (oWLEquivalentObjectPropertiesAxiom.getProperties().size() <= 2) continue;
            map = new SectionMap();
            map.add(oWLEquivalentObjectPropertiesAxiom.getProperties(), oWLEquivalentObjectPropertiesAxiom);
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom : ontology.getAxioms(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            if (oWLDisjointDataPropertiesAxiom.getProperties().size() <= 2) continue;
            map = new SectionMap();
            map.add(oWLDisjointDataPropertiesAxiom.getProperties(), oWLDisjointDataPropertiesAxiom);
            this.writeSection(ManchesterOWLSyntax.DISJOINT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom : ontology.getAxioms(AxiomType.EQUIVALENT_DATA_PROPERTIES)) {
            if (oWLEquivalentDataPropertiesAxiom.getProperties().size() <= 2) continue;
            map = new SectionMap();
            map.add(oWLEquivalentDataPropertiesAxiom.getProperties(), oWLEquivalentDataPropertiesAxiom);
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom : ontology.getAxioms(AxiomType.DIFFERENT_INDIVIDUALS)) {
            if (oWLDifferentIndividualsAxiom.getIndividuals().size() <= 2) continue;
            map = new SectionMap();
            map.add(oWLDifferentIndividualsAxiom.getIndividuals(), oWLDifferentIndividualsAxiom);
            this.writeSection(ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, map, ",", false, ontology);
        }
        for (SWRLRule sWRLRule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
            this.writeSection(ManchesterOWLSyntax.RULE, Collections.singleton(sWRLRule), ", ", false, new OWLOntology[0]);
        }
        this.flush();
    }

    public void writeOntologyHeader(OWLOntology ontology) {
        this.event = new RendererEvent(this, ontology);
        this.fireFrameRenderingPrepared(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.write(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.write(":");
        this.writeSpace();
        if (!ontology.isAnonymous()) {
            int indent = this.getIndent();
            this.writeFullURI(ontology.getOntologyID().getOntologyIRI().toString());
            this.writeNewLine();
            this.pushTab(indent);
            if (ontology.getOntologyID().getVersionIRI() != null) {
                this.writeFullURI(ontology.getOntologyID().getVersionIRI().toString());
            }
            this.popTab();
        }
        this.fireFrameRenderingStarted(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.writeNewLine();
        for (OWLImportsDeclaration decl : ontology.getImportsDeclarations()) {
            this.fireSectionItemPrepared(ManchesterOWLSyntax.IMPORT.toString());
            this.write(ManchesterOWLSyntax.IMPORT.toString());
            this.write(":");
            this.writeSpace();
            this.fireSectionRenderingStarted(ManchesterOWLSyntax.IMPORT.toString());
            this.writeFullURI(decl.getURI().toString());
            this.writeNewLine();
            this.fireSectionRenderingFinished(ManchesterOWLSyntax.IMPORT.toString());
        }
        this.writeNewLine();
        this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, ontology.getAnnotations(), ",", true, new OWLOntology[0]);
        this.fireFrameRenderingFinished(ManchesterOWLSyntax.ONTOLOGY.toString());
    }

    public void writePrefixMap() {
        ShortFormProvider sfp = this.getShortFormProvider();
        if (!(sfp instanceof ManchesterOWLSyntaxPrefixNameShortFormProvider)) {
            return;
        }
        ManchesterOWLSyntaxPrefixNameShortFormProvider prov = (ManchesterOWLSyntaxPrefixNameShortFormProvider)sfp;
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        PrefixManager prefixManager = prov.getPrefixManager();
        for (String prefixName : prefixManager.getPrefixName2PrefixMap().keySet()) {
            String prefix = prefixManager.getPrefix(prefixName);
            prefixMap.put(prefixName, prefix);
            this.write(ManchesterOWLSyntax.PREFIX.toString());
            this.write(": ");
            this.write(prefixName);
            this.write(" ");
            this.writeFullURI(prefix);
            this.writeNewLine();
        }
        if (!prefixMap.isEmpty()) {
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeFullURI(String uri) {
        this.write("<");
        this.write(uri);
        this.write(">");
    }

    public boolean isFiltered(AxiomType<?> axiomType) {
        return this.filteredAxiomTypes.contains(axiomType);
    }

    public boolean isDisplayed(OWLAxiom axiom) {
        if (axiom == null) {
            return false;
        }
        return this.axiomFilter.passes(axiom);
    }

    public Set<OWLAxiom> writeFrame(OWLEntity entity) {
        if (entity.isOWLClass()) {
            return this.write(entity.asOWLClass());
        }
        if (entity.isOWLObjectProperty()) {
            return this.write(entity.asOWLObjectProperty());
        }
        if (entity.isOWLDataProperty()) {
            return this.write(entity.asOWLDataProperty());
        }
        if (entity.isOWLNamedIndividual()) {
            return this.write(entity.asOWLNamedIndividual());
        }
        if (entity.isOWLAnnotationProperty()) {
            return this.write(entity.asOWLAnnotationProperty());
        }
        if (entity.isOWLDatatype()) {
            return this.write(entity.asOWLDatatype());
        }
        return Collections.emptySet();
    }

    public Set<OWLAxiom> write(OWLClass cls) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.CLASS, cls));
        if (!this.isFiltered(AxiomType.EQUIVALENT_CLASSES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap equivalentClasses = new SectionMap();
                for (OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom : ontology.getEquivalentClassesAxioms(cls)) {
                    if (oWLEquivalentClassesAxiom.getClassExpressions().size() != 2 || !this.isDisplayed(oWLEquivalentClassesAxiom)) continue;
                    for (OWLClassExpression equivCls : oWLEquivalentClassesAxiom.getClassExpressionsMinus(cls)) {
                        equivalentClasses.add(equivCls, oWLEquivalentClassesAxiom);
                    }
                    axioms.add(oWLEquivalentClassesAxiom);
                }
                equivalentClasses.remove(cls);
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, equivalentClasses, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SUBCLASS_OF)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap superclasses = new SectionMap();
                for (OWLSubClassOfAxiom oWLSubClassOfAxiom : ontology.getSubClassAxiomsForSubClass(cls)) {
                    if (!this.isDisplayed(oWLSubClassOfAxiom)) continue;
                    superclasses.add(oWLSubClassOfAxiom.getSuperClass(), oWLSubClassOfAxiom);
                    axioms.add(oWLSubClassOfAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.SUBCLASS_OF, superclasses, ",", true, ontology);
            }
            if (this.renderExtensions) {
                for (OWLOntology ont : this.getOntologies()) {
                    SectionMap subClasses = new SectionMap();
                    for (OWLSubClassOfAxiom oWLSubClassOfAxiom : ont.getSubClassAxiomsForSuperClass(cls)) {
                        if (!this.isDisplayed(oWLSubClassOfAxiom)) continue;
                        subClasses.add(oWLSubClassOfAxiom.getSubClass(), oWLSubClassOfAxiom);
                        axioms.add(oWLSubClassOfAxiom);
                    }
                    this.writeSection(ManchesterOWLSyntax.SUPERCLASS_OF, subClasses, ",", true, ont);
                }
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_UNION)) {
            for (OWLOntology ontology : this.getOntologies()) {
                for (OWLDisjointUnionAxiom oWLDisjointUnionAxiom : ontology.getDisjointUnionAxioms(cls)) {
                    if (!this.isDisplayed(oWLDisjointUnionAxiom)) continue;
                    TreeSet<OWLClassExpression> treeSet = new TreeSet<OWLClassExpression>(oWLDisjointUnionAxiom.getClassExpressions());
                    axioms.add(oWLDisjointUnionAxiom);
                    this.writeSection(ManchesterOWLSyntax.DISJOINT_UNION_OF, treeSet, ", ", false, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_CLASSES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                HashSet<OWLDisjointClassesAxiom> pairwiseDisjointClassesAxioms = new HashSet<OWLDisjointClassesAxiom>();
                SectionMap sectionMap = new SectionMap();
                for (OWLDisjointClassesAxiom ax : ontology.getDisjointClassesAxioms(cls)) {
                    if (!this.isDisplayed(ax)) continue;
                    if (ax.getClassExpressions().size() == 2) {
                        pairwiseDisjointClassesAxioms.add(ax);
                        OWLClassExpression disjointWith = ax.getClassExpressionsMinus(cls).iterator().next();
                        sectionMap.add(disjointWith, ax);
                    }
                    axioms.add(ax);
                }
                this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, sectionMap, ", ", false, ontology);
                if (!this.renderExtensions) continue;
                for (OWLDisjointClassesAxiom ax : ontology.getDisjointClassesAxioms(cls)) {
                    if (!this.isDisplayed(ax) || ax.getClassExpressions().size() <= 2) continue;
                    TreeSet<OWLClassExpression> allDisjointClasses = new TreeSet<OWLClassExpression>(ax.getClassExpressions());
                    allDisjointClasses.remove(cls);
                    axioms.add(ax);
                    this.writeSection(ManchesterOWLSyntax.DISJOINT_CLASSES, allDisjointClasses, ", ", false, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.HAS_KEY)) {
            for (OWLOntology ontology : this.getOntologies()) {
                for (OWLHasKeyAxiom oWLHasKeyAxiom : ontology.getHasKeyAxioms(cls)) {
                    if (!this.isDisplayed(oWLHasKeyAxiom)) continue;
                    SectionMap sectionMap = new SectionMap();
                    sectionMap.add(oWLHasKeyAxiom.getPropertyExpressions(), oWLHasKeyAxiom);
                    this.writeSection(ManchesterOWLSyntax.HAS_KEY, sectionMap, ", ", true, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.CLASS_ASSERTION)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap individuals = new SectionMap();
                for (OWLClassAssertionAxiom oWLClassAssertionAxiom : ontology.getClassAssertionAxioms(cls)) {
                    if (!this.isDisplayed(oWLClassAssertionAxiom) || !this.renderExtensions && !oWLClassAssertionAxiom.getIndividual().isAnonymous()) continue;
                    individuals.add(oWLClassAssertionAxiom.getIndividual(), oWLClassAssertionAxiom);
                    axioms.add(oWLClassAssertionAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.INDIVIDUALS, individuals, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            for (OWLOntology ontology : this.getOntologies()) {
                HashSet rules = new HashSet();
                block17: for (SWRLRule sWRLRule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
                    if (!this.isDisplayed(sWRLRule)) continue;
                    for (SWRLAtom atom : sWRLRule.getHead()) {
                        if (!atom.getPredicate().equals(cls)) continue;
                        this.writeSection(ManchesterOWLSyntax.RULE, rules, ", ", true, ontology);
                        continue block17;
                    }
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.CLASS.toString());
        return axioms;
    }

    protected void writeEntitySectionEnd(String type) {
        this.fireFrameRenderingFinished(type);
        this.popTab();
        this.writeNewLine();
    }

    public Set<OWLAxiom> write(OWLObjectPropertyExpression property) {
        SectionMap expressions;
        Set<OWLObjectPropertyExpression> props;
        Object properties;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.OBJECT_PROPERTY, property));
        if (!this.isFiltered(AxiomType.SUB_OBJECT_PROPERTY)) {
            for (OWLOntology ontology : this.getOntologies()) {
                properties = new SectionMap();
                for (OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom : ontology.getObjectSubPropertyAxiomsForSubProperty(property)) {
                    if (!this.isDisplayed(oWLSubObjectPropertyOfAxiom)) continue;
                    ((SectionMap)properties).add(oWLSubObjectPropertyOfAxiom.getSuperProperty(), oWLSubObjectPropertyOfAxiom);
                    axioms.add(oWLSubObjectPropertyOfAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, (SectionMap)properties, ",", true, ontology);
            }
            if (this.renderExtensions) {
                for (OWLOntology ontology : this.getOntologies()) {
                    properties = new SectionMap();
                    for (OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom : ontology.getObjectSubPropertyAxiomsForSuperProperty(property)) {
                        if (!this.isDisplayed(oWLSubObjectPropertyOfAxiom)) continue;
                        ((SectionMap)properties).add(oWLSubObjectPropertyOfAxiom.getSubProperty(), oWLSubObjectPropertyOfAxiom);
                        axioms.add(oWLSubObjectPropertyOfAxiom);
                    }
                    this.writeSection(ManchesterOWLSyntax.SUPER_PROPERTY_OF, (SectionMap)properties, ",", true, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                properties = new SectionMap();
                for (OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom : ontology.getEquivalentObjectPropertiesAxioms(property)) {
                    if (!this.isDisplayed(oWLEquivalentObjectPropertiesAxiom) || oWLEquivalentObjectPropertiesAxiom.getProperties().size() != 2) continue;
                    props = oWLEquivalentObjectPropertiesAxiom.getPropertiesMinus(property);
                    ((SectionMap)properties).add(props.iterator().next(), oWLEquivalentObjectPropertiesAxiom);
                    axioms.add(oWLEquivalentObjectPropertiesAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, (SectionMap)properties, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                properties = new SectionMap();
                for (OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom : ontology.getDisjointObjectPropertiesAxioms(property)) {
                    if (oWLDisjointObjectPropertiesAxiom.getProperties().size() != 2 || !this.isDisplayed(oWLDisjointObjectPropertiesAxiom)) continue;
                    props = oWLDisjointObjectPropertiesAxiom.getPropertiesMinus(property);
                    ((SectionMap)properties).add(props.iterator().next(), oWLDisjointObjectPropertiesAxiom);
                    axioms.add(oWLDisjointObjectPropertiesAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, (SectionMap)properties, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
            for (OWLOntology ontology : this.getOntologies()) {
                for (OWLSubPropertyChainOfAxiom ax : ontology.getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
                    if (!ax.getSuperProperty().equals(property) || !this.isDisplayed(ax)) continue;
                    SectionMap sectionMap = new SectionMap();
                    sectionMap.add(ax.getPropertyChain(), ax);
                    this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_CHAIN, sectionMap, " o ", false, ontology);
                    axioms.add(ax);
                }
            }
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap characteristics = new SectionMap();
            if (!this.isFiltered(AxiomType.FUNCTIONAL_OBJECT_PROPERTY)) {
                for (OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom : ontology.getFunctionalObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLFunctionalObjectPropertyAxiom)) continue;
                    characteristics.add(ManchesterOWLSyntax.FUNCTIONAL.toString(), oWLFunctionalObjectPropertyAxiom);
                    axioms.add(oWLFunctionalObjectPropertyAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY)) {
                for (OWLAxiom oWLAxiom : ontology.getInverseFunctionalObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLAxiom)) continue;
                    characteristics.add(ManchesterOWLSyntax.INVERSE_FUNCTIONAL.toString(), oWLAxiom);
                    axioms.add(oWLAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.SYMMETRIC_OBJECT_PROPERTY)) {
                for (OWLAxiom oWLAxiom : ontology.getSymmetricObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLAxiom)) continue;
                    characteristics.add(ManchesterOWLSyntax.SYMMETRIC.toString(), oWLAxiom);
                    axioms.add(oWLAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.TRANSITIVE_OBJECT_PROPERTY)) {
                for (OWLAxiom oWLAxiom : ontology.getTransitiveObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLAxiom)) continue;
                    characteristics.add(ManchesterOWLSyntax.TRANSITIVE.toString(), oWLAxiom);
                    axioms.add(oWLAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.REFLEXIVE_OBJECT_PROPERTY)) {
                for (OWLAxiom oWLAxiom : ontology.getReflexiveObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLAxiom)) continue;
                    characteristics.add(ManchesterOWLSyntax.REFLEXIVE.toString(), oWLAxiom);
                    axioms.add(oWLAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY)) {
                for (OWLAxiom oWLAxiom : ontology.getIrreflexiveObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLAxiom)) continue;
                    characteristics.add(ManchesterOWLSyntax.IRREFLEXIVE.toString(), oWLAxiom);
                    axioms.add(oWLAxiom);
                }
            }
            if (!this.isFiltered(AxiomType.ASYMMETRIC_OBJECT_PROPERTY)) {
                for (OWLAxiom oWLAxiom : ontology.getAsymmetricObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLAxiom)) continue;
                    characteristics.add(ManchesterOWLSyntax.ASYMMETRIC.toString(), oWLAxiom);
                    axioms.add(oWLAxiom);
                }
            }
            this.writeSection(ManchesterOWLSyntax.CHARACTERISTICS, characteristics, ",", true, ontology);
        }
        if (!this.isFiltered(AxiomType.OBJECT_PROPERTY_DOMAIN)) {
            for (OWLOntology ontology : this.getOntologies()) {
                expressions = new SectionMap();
                for (OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom : ontology.getObjectPropertyDomainAxioms(property)) {
                    if (!this.isDisplayed(oWLObjectPropertyDomainAxiom)) continue;
                    expressions.add(oWLObjectPropertyDomainAxiom.getDomain(), oWLObjectPropertyDomainAxiom);
                    axioms.add(oWLObjectPropertyDomainAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.DOMAIN, expressions, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.OBJECT_PROPERTY_RANGE)) {
            for (OWLOntology ontology : this.getOntologies()) {
                expressions = new SectionMap();
                for (OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom : ontology.getObjectPropertyRangeAxioms(property)) {
                    if (!this.isDisplayed(oWLObjectPropertyRangeAxiom)) continue;
                    expressions.add(oWLObjectPropertyRangeAxiom.getRange(), oWLObjectPropertyRangeAxiom);
                    axioms.add(oWLObjectPropertyRangeAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.RANGE, expressions, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.INVERSE_OBJECT_PROPERTIES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                properties = new TreeSet();
                for (OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom : ontology.getInverseObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLInverseObjectPropertiesAxiom)) continue;
                    if (oWLInverseObjectPropertiesAxiom.getFirstProperty().equals(property)) {
                        properties.add(oWLInverseObjectPropertiesAxiom.getSecondProperty());
                    } else {
                        properties.add(oWLInverseObjectPropertiesAxiom.getFirstProperty());
                    }
                    axioms.add(oWLInverseObjectPropertiesAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.INVERSE_OF, (Collection<?>)properties, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            for (OWLOntology ontology : this.getOntologies()) {
                HashSet<SWRLRule> rules = new HashSet<SWRLRule>();
                block25: for (SWRLRule sWRLRule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
                    if (!this.isDisplayed(sWRLRule)) continue;
                    for (SWRLAtom atom : sWRLRule.getHead()) {
                        if (!atom.getPredicate().equals(property)) continue;
                        rules.add(sWRLRule);
                        this.writeSection(ManchesterOWLSyntax.RULE, rules, ",", true, ontology);
                        continue block25;
                    }
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.OBJECT_PROPERTY.toString());
        return axioms;
    }

    public Set<OWLAxiom> write(OWLDataProperty property) {
        SectionMap props;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.DATA_PROPERTY, property));
        if (!this.isFiltered(AxiomType.FUNCTIONAL_DATA_PROPERTY)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap characteristics = new SectionMap();
                for (OWLAxiom oWLAxiom : ontology.getFunctionalDataPropertyAxioms(property)) {
                    if (!this.isDisplayed(oWLAxiom)) continue;
                    characteristics.add(ManchesterOWLSyntax.FUNCTIONAL.toString(), oWLAxiom);
                    axioms.add(oWLAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.CHARACTERISTICS, characteristics, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DATA_PROPERTY_DOMAIN)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap domains = new SectionMap();
                for (OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom : ontology.getDataPropertyDomainAxioms(property)) {
                    if (!this.isDisplayed(oWLDataPropertyDomainAxiom)) continue;
                    domains.add(oWLDataPropertyDomainAxiom.getDomain(), oWLDataPropertyDomainAxiom);
                    axioms.add(oWLDataPropertyDomainAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.DOMAIN, domains, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DATA_PROPERTY_RANGE)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap ranges = new SectionMap();
                for (OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom : ontology.getDataPropertyRangeAxioms(property)) {
                    if (!this.isDisplayed(oWLDataPropertyRangeAxiom)) continue;
                    ranges.add(oWLDataPropertyRangeAxiom.getRange(), oWLDataPropertyRangeAxiom);
                    axioms.add(oWLDataPropertyRangeAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.RANGE, ranges, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SUB_DATA_PROPERTY)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap supers = new SectionMap();
                for (OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom : ontology.getDataSubPropertyAxiomsForSubProperty(property)) {
                    if (!this.isDisplayed(oWLSubDataPropertyOfAxiom)) continue;
                    supers.add(oWLSubDataPropertyOfAxiom.getSuperProperty(), oWLSubDataPropertyOfAxiom);
                    axioms.add(oWLSubDataPropertyOfAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, supers, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.EQUIVALENT_DATA_PROPERTIES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                props = new SectionMap();
                for (OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom : ontology.getEquivalentDataPropertiesAxioms(property)) {
                    if (!this.isDisplayed(oWLEquivalentDataPropertiesAxiom) || oWLEquivalentDataPropertiesAxiom.getProperties().size() != 2) continue;
                    props.add(oWLEquivalentDataPropertiesAxiom.getPropertiesMinus(property).iterator().next(), oWLEquivalentDataPropertiesAxiom);
                    axioms.add(oWLEquivalentDataPropertiesAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, props, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                props = new SectionMap();
                for (OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom : ontology.getDisjointDataPropertiesAxioms(property)) {
                    if (oWLDisjointDataPropertiesAxiom.getProperties().size() != 2 || !this.isDisplayed(oWLDisjointDataPropertiesAxiom)) continue;
                    props.add(oWLDisjointDataPropertiesAxiom.getPropertiesMinus(property).iterator().next(), oWLDisjointDataPropertiesAxiom);
                    axioms.add(oWLDisjointDataPropertiesAxiom);
                }
                props.remove(property);
                this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, props, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            for (OWLOntology ontology : this.getOntologies()) {
                HashSet rules = new HashSet();
                block13: for (SWRLRule sWRLRule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
                    if (!this.isDisplayed(sWRLRule)) continue;
                    for (SWRLAtom atom : sWRLRule.getHead()) {
                        if (!atom.getPredicate().equals(property)) continue;
                        this.writeSection(ManchesterOWLSyntax.RULE, rules, "", true, ontology);
                        continue block13;
                    }
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.DATA_PROPERTY.toString());
        return axioms;
    }

    public Set<OWLAxiom> write(OWLIndividual individual) {
        TreeSet<OWLIndividual> inds;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.INDIVIDUAL, individual));
        if (!this.isFiltered(AxiomType.CLASS_ASSERTION)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap expressions = new SectionMap();
                for (OWLClassAssertionAxiom oWLClassAssertionAxiom : ontology.getClassAssertionAxioms(individual)) {
                    if (!this.isDisplayed(oWLClassAssertionAxiom)) continue;
                    expressions.add(oWLClassAssertionAxiom.getClassExpression(), oWLClassAssertionAxiom);
                    axioms.add(oWLClassAssertionAxiom);
                }
                this.writeSection(ManchesterOWLSyntax.TYPES, expressions, ",", true, ontology);
            }
        }
        for (OWLOntology ontology : this.getOntologies()) {
            ArrayList<OWLPropertyAssertionAxiom<OWLObjectPropertyExpression, OWLIndividual>> assertions = new ArrayList<OWLPropertyAssertionAxiom<OWLObjectPropertyExpression, OWLIndividual>>();
            assertions.addAll(ontology.getObjectPropertyAssertionAxioms(individual));
            assertions.addAll(ontology.getNegativeObjectPropertyAssertionAxioms(individual));
            assertions.addAll(ontology.getDataPropertyAssertionAxioms(individual));
            assertions.addAll(ontology.getNegativeDataPropertyAssertionAxioms(individual));
            if (assertions.isEmpty()) continue;
            this.fireSectionRenderingPrepared(ManchesterOWLSyntax.FACTS.toString());
            this.writeSection(ManchesterOWLSyntax.FACTS);
            this.writeSpace();
            this.writeOntologiesList(ontology);
            this.incrementTab(1);
            this.writeNewLine();
            this.fireSectionRenderingStarted(ManchesterOWLSyntax.FACTS.toString());
            Iterator it = assertions.iterator();
            while (it.hasNext()) {
                OWLPropertyAssertionAxiom oWLPropertyAssertionAxiom = (OWLPropertyAssertionAxiom)it.next();
                this.fireSectionItemPrepared(ManchesterOWLSyntax.FACTS.toString());
                Set<OWLAnnotation> annos = oWLPropertyAssertionAxiom.getAnnotations();
                if (!annos.isEmpty()) {
                    this.writeAnnotations(annos);
                    this.pushTab(this.getIndent() + 1);
                }
                if (oWLPropertyAssertionAxiom instanceof OWLNegativeDataPropertyAssertionAxiom || oWLPropertyAssertionAxiom instanceof OWLNegativeObjectPropertyAssertionAxiom) {
                    this.write(ManchesterOWLSyntax.NOT);
                    this.writeSpace();
                }
                oWLPropertyAssertionAxiom.getProperty().accept(this);
                this.writeSpace();
                this.writeSpace();
                oWLPropertyAssertionAxiom.getObject().accept(this);
                if (!annos.isEmpty()) {
                    this.popTab();
                }
                this.fireSectionItemFinished(ManchesterOWLSyntax.FACTS.toString());
                if (!it.hasNext()) continue;
                this.write(",");
                this.writeNewLine();
            }
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
        if (!this.isFiltered(AxiomType.SAME_INDIVIDUAL)) {
            for (OWLOntology ontology : this.getOntologies()) {
                inds = new TreeSet<OWLIndividual>();
                for (OWLSameIndividualAxiom oWLSameIndividualAxiom : ontology.getSameIndividualAxioms(individual)) {
                    if (!this.isDisplayed(oWLSameIndividualAxiom)) continue;
                    inds.addAll(oWLSameIndividualAxiom.getIndividuals());
                    axioms.add(oWLSameIndividualAxiom);
                }
                inds.remove(individual);
                this.writeSection(ManchesterOWLSyntax.SAME_AS, inds, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DIFFERENT_INDIVIDUALS)) {
            for (OWLOntology ontology : this.getOntologies()) {
                inds = new TreeSet();
                TreeSet<OWLDifferentIndividualsAxiom> nary = new TreeSet<OWLDifferentIndividualsAxiom>();
                for (OWLDifferentIndividualsAxiom ax : ontology.getDifferentIndividualAxioms(individual)) {
                    if (ax.getIndividuals().size() == 2 && this.isDisplayed(ax)) {
                        inds.addAll(ax.getIndividuals());
                        axioms.add(ax);
                        continue;
                    }
                    nary.add(ax);
                }
                inds.remove(individual);
                this.writeSection(ManchesterOWLSyntax.DIFFERENT_FROM, inds, ",", true, ontology);
                if (!this.renderExtensions) continue;
                for (OWLDifferentIndividualsAxiom ax : nary) {
                    this.writeSection(ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, ax.getIndividuals(), ", ", false, ontology);
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.INDIVIDUAL.toString());
        return axioms;
    }

    public Set<OWLAxiom> write(OWLDatatype datatype) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.DATATYPE, datatype));
        if (!this.isFiltered(AxiomType.DATATYPE_DEFINITION)) {
            for (OWLOntology ontology : this.getOntologies()) {
                TreeSet<OWLDataRange> dataRanges = new TreeSet<OWLDataRange>();
                for (OWLDatatypeDefinitionAxiom ax : ontology.getDatatypeDefinitions(datatype)) {
                    if (!this.isDisplayed(ax)) continue;
                    axioms.add(ax);
                    dataRanges.add(ax.getDataRange());
                }
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, dataRanges, ",", true, ontology);
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.DATATYPE.toString());
        return axioms;
    }

    public Set<OWLAxiom> write(SWRLRule rule) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>(1);
        for (OWLOntology ontology : this.getOntologies()) {
            if (!ontology.containsAxiom(rule)) continue;
            this.writeSection(ManchesterOWLSyntax.RULE, Collections.singleton(rule), "", true, ontology);
            axioms.add(rule);
        }
        return axioms;
    }

    public Set<OWLAxiom> write(OWLAnnotationProperty property) {
        TreeSet<IRI> iris;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.ANNOTATION_PROPERTY, property));
        if (!this.isFiltered(AxiomType.ANNOTATION_ASSERTION)) {
            for (OWLOntology ont : this.getOntologies()) {
                TreeSet<OWLAnnotation> annos = new TreeSet<OWLAnnotation>();
                for (OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom : ont.getAnnotationAssertionAxioms(property.getIRI())) {
                    if (!this.isDisplayed(oWLAnnotationAssertionAxiom)) continue;
                    annos.add(oWLAnnotationAssertionAxiom.getAnnotation());
                }
                this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, annos, ",", true, ont);
            }
        }
        if (!this.isFiltered(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
            for (OWLOntology ont : this.getOntologies()) {
                TreeSet<OWLAnnotationProperty> props = new TreeSet<OWLAnnotationProperty>();
                for (OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom : ont.getSubAnnotationPropertyOfAxioms(property)) {
                    if (!this.isDisplayed(oWLSubAnnotationPropertyOfAxiom)) continue;
                    props.add(oWLSubAnnotationPropertyOfAxiom.getSuperProperty());
                }
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, props, ",", true, ont);
            }
        }
        if (!this.isFiltered(AxiomType.ANNOTATION_PROPERTY_DOMAIN)) {
            for (OWLOntology ont : this.getOntologies()) {
                iris = new TreeSet<IRI>();
                for (OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom : ont.getAnnotationPropertyDomainAxioms(property)) {
                    if (!this.isDisplayed(oWLAnnotationPropertyDomainAxiom)) continue;
                    iris.add(oWLAnnotationPropertyDomainAxiom.getDomain());
                }
                this.writeSection(ManchesterOWLSyntax.DOMAIN, iris, ",", true, ont);
            }
        }
        if (!this.isFiltered(AxiomType.ANNOTATION_PROPERTY_RANGE)) {
            for (OWLOntology ont : this.getOntologies()) {
                iris = new TreeSet();
                for (OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom : ont.getAnnotationPropertyRangeAxioms(property)) {
                    if (!this.isDisplayed(oWLAnnotationPropertyRangeAxiom)) continue;
                    iris.add(oWLAnnotationPropertyRangeAxiom.getRange());
                }
                this.writeSection(ManchesterOWLSyntax.RANGE, iris, ",", true, ont);
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.ANNOTATION_PROPERTY.toString());
        return axioms;
    }

    private Set<OWLAnnotationAssertionAxiom> writeEntityStart(ManchesterOWLSyntax keyword, OWLObject entity) {
        this.event = new RendererEvent(this, entity);
        String kw = keyword.toString();
        this.fireFrameRenderingPrepared(kw);
        this.writeSection(keyword);
        entity.accept(this);
        this.fireFrameRenderingStarted(kw);
        this.writeNewLine();
        this.incrementTab(4);
        this.writeNewLine();
        if (entity instanceof OWLEntity) {
            return this.writeAnnotations(((OWLEntity)entity).getIRI());
        }
        if (entity instanceof OWLAnonymousIndividual) {
            return this.writeAnnotations((OWLAnonymousIndividual)entity);
        }
        return Collections.emptySet();
    }

    public Set<OWLAnnotationAssertionAxiom> writeAnnotations(OWLAnnotationSubject subject) {
        HashSet<OWLAnnotationAssertionAxiom> axioms = new HashSet<OWLAnnotationAssertionAxiom>();
        if (!this.isFiltered(AxiomType.ANNOTATION_ASSERTION)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap sectionMap = new SectionMap();
                for (OWLAnnotationAssertionAxiom ax : ontology.getAnnotationAssertionAxioms(subject)) {
                    if (!this.isDisplayed(ax)) continue;
                    axioms.add(ax);
                    sectionMap.add(ax.getAnnotation(), ax);
                }
                this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, sectionMap, ",", true, ontology);
            }
        }
        return axioms;
    }

    public void writeSection(ManchesterOWLSyntax keyword) {
        this.write("", keyword, "");
        this.write(":");
        this.writeSpace();
    }

    public void writeSection(ManchesterOWLSyntax keyword, SectionMap content, String delimeter, boolean newline, OWLOntology ... ontologiesList) {
        String sec = keyword.toString();
        if (!content.isEmpty() || this.renderingDirector.renderEmptyFrameSection(keyword, ontologiesList)) {
            this.fireSectionRenderingPrepared(sec);
            this.writeSection(keyword);
            this.writeOntologiesList(ontologiesList);
            this.incrementTab(4);
            this.writeNewLine();
            this.fireSectionRenderingStarted(sec);
            Iterator<Object> it = content.getSectionObjects().iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                Set<Set<OWLAnnotation>> annotationSets = content.getAnnotationsForSectionObject(obj);
                Iterator<Set<OWLAnnotation>> annosSetIt = annotationSets.iterator();
                while (annosSetIt.hasNext()) {
                    Set<OWLAnnotation> annos = annosSetIt.next();
                    this.fireSectionItemPrepared(sec);
                    if (!annos.isEmpty()) {
                        this.incrementTab(4);
                        this.writeNewLine();
                        this.write(ManchesterOWLSyntax.ANNOTATIONS.toString());
                        this.write(": ");
                        this.pushTab(this.getIndent() + 1);
                        Iterator<OWLAnnotation> annoIt = annos.iterator();
                        while (annoIt.hasNext()) {
                            annoIt.next().accept(this);
                            if (!annoIt.hasNext()) continue;
                            this.write(", ");
                            this.writeNewLine();
                        }
                        this.popTab();
                        this.popTab();
                        this.writeNewLine();
                    }
                    if (obj instanceof OWLObject) {
                        ((OWLObject)obj).accept(this);
                    } else if (obj instanceof Collection) {
                        Iterator listIt = ((Collection)obj).iterator();
                        while (listIt.hasNext()) {
                            Object o = listIt.next();
                            if (o instanceof OWLObject) {
                                ((OWLObject)o).accept(this);
                            } else {
                                this.write(o.toString());
                            }
                            if (!listIt.hasNext()) continue;
                            this.write(delimeter);
                            if (!newline) continue;
                            this.writeNewLine();
                        }
                    } else {
                        this.write(obj.toString());
                    }
                    if (!annosSetIt.hasNext()) continue;
                    this.write(",");
                    this.writeNewLine();
                }
                if (it.hasNext()) {
                    this.write(delimeter);
                    this.fireSectionItemFinished(sec);
                    if (!newline) continue;
                    this.writeNewLine();
                    continue;
                }
                this.fireSectionItemFinished(sec);
            }
            this.fireSectionRenderingFinished(sec);
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeSection(ManchesterOWLSyntax keyword, Collection<?> content, String delimeter, boolean newline, OWLOntology ... ontologiesList) {
        String sec = keyword.toString();
        if (!content.isEmpty() || this.renderingDirector.renderEmptyFrameSection(keyword, ontologiesList)) {
            this.fireSectionRenderingPrepared(sec);
            this.writeSection(keyword);
            this.writeOntologiesList(ontologiesList);
            this.incrementTab(4);
            this.writeNewLine();
            this.fireSectionRenderingStarted(sec);
            Iterator<?> it = content.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                this.fireSectionItemPrepared(sec);
                if (obj instanceof OWLObject) {
                    ((OWLObject)obj).accept(this);
                } else {
                    this.write(obj.toString());
                }
                if (it.hasNext()) {
                    this.write(delimeter);
                    this.fireSectionItemFinished(sec);
                    if (!newline) continue;
                    this.writeNewLine();
                    continue;
                }
                this.fireSectionItemFinished(sec);
            }
            this.fireSectionRenderingFinished(sec);
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeComment(String comment, boolean placeOnNewline) {
        this.writeComment("#", comment, placeOnNewline);
    }

    public void writeComment(String commentDelim, String comment, boolean placeOnNewline) {
        if (placeOnNewline) {
            this.writeNewLine();
        }
        this.write(commentDelim);
        this.write(comment);
        this.writeNewLine();
    }

    private void writeOntologiesList(OWLOntology ... ontologiesList) {
        if (!this.renderExtensions) {
            return;
        }
        if (ontologiesList.length == 0) {
            return;
        }
        this.write("[in ");
        int count = 0;
        for (OWLOntology ont : ontologiesList) {
            this.write(this.shortFormProvider.getShortForm(ont));
            if (++count >= ontologiesList.length) continue;
            this.write(", ");
        }
        this.write("]");
    }

    private void fireFrameRenderingPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingPrepared(section, this.event);
        }
    }

    private void fireFrameRenderingStarted(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingStarted(section, this.event);
        }
    }

    private void fireFrameRenderingFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingFinished(section, this.event);
        }
    }

    private void fireSectionRenderingPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingPrepared(section, this.event);
        }
    }

    private void fireSectionRenderingStarted(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingStarted(section, this.event);
        }
    }

    private void fireSectionRenderingFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingFinished(section, this.event);
        }
    }

    private void fireSectionItemPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionItemPrepared(section, this.event);
        }
    }

    private void fireSectionItemFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionItemFinished(section, this.event);
        }
    }

    private static class DefaultRenderingDirector
    implements RenderingDirector {
        @Override
        public boolean renderEmptyFrameSection(ManchesterOWLSyntax frameSectionKeyword, OWLOntology ... ontologies) {
            return false;
        }
    }
}

