/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad.sync;

import com.sun.jndi.ldap.ctl.DirSyncResponseControl;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import net.tirasa.adsddl.ntsd.controls.DirSyncControl;
import net.tirasa.adsddl.ntsd.controls.SDFlagsControl;
import net.tirasa.adsddl.ntsd.utils.GUID;
import net.tirasa.connid.bundles.ad.ADConfiguration;
import net.tirasa.connid.bundles.ad.ADConnection;
import net.tirasa.connid.bundles.ad.util.ADUtilities;
import net.tirasa.connid.bundles.ad.util.DeletedControl;
import net.tirasa.connid.bundles.ad.util.DirSyncUtils;
import net.tirasa.connid.bundles.ldap.search.LdapInternalSearch;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;

public class ADSyncStrategy {
    private static final Log LOG = Log.getLog(ADSyncStrategy.class);
    private final transient ADConnection conn;
    private transient SyncToken latestSyncToken;
    private final ADUtilities utils;

    public ADSyncStrategy(ADConnection conn) {
        this.conn = conn;
        this.utils = new ADUtilities(conn);
    }

    private Set<SearchResult> search(LdapContext ctx, String filter, SearchControls searchCtls, boolean updateLastSyncToken) {
        HashSet<SearchResult> result = new HashSet<SearchResult>();
        for (String baseContextDn : this.conn.getConfiguration().getBaseContextsToSynchronize()) {
            if (LOG.isOk()) {
                LOG.ok("Searching from " + baseContextDn, new Object[0]);
            }
            try {
                Control[] rspCtls;
                NamingEnumeration<SearchResult> answer = ctx.search(baseContextDn, filter, searchCtls);
                while (answer.hasMoreElements()) {
                    result.add((SearchResult)answer.nextElement());
                }
                if (!updateLastSyncToken || (rspCtls = ctx.getResponseControls()) == null) continue;
                if (LOG.isOk()) {
                    LOG.ok("Response Controls: {0}", new Object[]{rspCtls.length});
                }
                for (Control rspCtl : rspCtls) {
                    if (!(rspCtl instanceof DirSyncResponseControl)) continue;
                    DirSyncResponseControl dirSyncRspCtl = (DirSyncResponseControl)rspCtl;
                    this.latestSyncToken = new SyncToken((Object)dirSyncRspCtl.getCookie());
                }
                if (!LOG.isOk()) continue;
                LOG.ok("Latest sync token set to {0}", new Object[]{this.latestSyncToken});
            }
            catch (NamingException e) {
                LOG.error((Throwable)e, "While searching base context {0} with filter {1} and search controls {2}", new Object[]{baseContextDn, filter, searchCtls});
            }
        }
        return result;
    }

    public void sync(SyncToken token, SyncResultsHandler handler, OperationOptions options, ObjectClass oclass) {
        String filter;
        LdapContext ctx;
        SearchControls searchCtls = LdapInternalSearch.createDefaultSearchControls();
        searchCtls.setSearchScope(2);
        searchCtls.setReturningAttributes(null);
        try {
            if (token == null || token.getValue() == null || !(token.getValue() instanceof byte[]) || ((byte[])token.getValue()).length == 0) {
                if (LOG.isOk()) {
                    LOG.ok("Synchronization with empty token.", new Object[0]);
                }
                ctx = this.conn.getSyncContext(new Control[]{new DirSyncControl()});
                if (((ADConfiguration)this.conn.getConfiguration()).isStartSyncFromToday()) {
                    this.search(ctx, "(cn=__CONNID-NORES__)", searchCtls, true);
                    return;
                }
            } else {
                if (LOG.isOk()) {
                    LOG.ok("Synchronization with token.", new Object[0]);
                }
                ctx = this.conn.getSyncContext(new Control[]{new DirSyncControl((byte[])token.getValue())});
            }
        }
        catch (Exception e) {
            throw new ConnectorException("Could not set DirSync request controls", (Throwable)e);
        }
        String string = filter = oclass.is(ObjectClass.ACCOUNT_NAME) ? DirSyncUtils.createDirSyncUFilter((ADConfiguration)this.conn.getConfiguration(), this.utils) : DirSyncUtils.createDirSyncGFilter((ADConfiguration)this.conn.getConfiguration());
        if (LOG.isOk()) {
            LOG.ok("Search filter: " + filter, new Object[0]);
        }
        String[] attrsToGetOption = options.getAttributesToGet();
        Set<String> attrsToGet = this.utils.getAttributesToGet(attrsToGetOption, oclass);
        Set<SearchResult> changes = this.search(ctx, filter, searchCtls, true);
        int count = changes.size();
        if (oclass.is(ObjectClass.ACCOUNT_NAME)) {
            for (SearchResult sr : changes) {
                try {
                    this.handleSyncUDelta(ctx, sr, attrsToGet, count == 1 ? this.latestSyncToken : token, handler);
                    --count;
                }
                catch (NamingException e) {
                    LOG.error((Throwable)e, "SyncDelta handling for '{0}' failed", new Object[]{sr.getName()});
                }
            }
        } else {
            for (SearchResult sr : changes) {
                try {
                    this.handleSyncGDelta(ctx, sr, attrsToGet, count == 1 ? this.latestSyncToken : token, handler);
                    --count;
                }
                catch (NamingException e) {
                    LOG.error((Throwable)e, "SyncDelta handling for '{0}' failed", new Object[]{sr.getName()});
                }
            }
        }
    }

    public SyncToken getLatestSyncToken() {
        SearchControls searchCtls = LdapInternalSearch.createDefaultSearchControls();
        searchCtls.setSearchScope(2);
        searchCtls.setReturningAttributes(null);
        String baseContextDn = this.conn.getConfiguration().getBaseContextsToSynchronize()[0];
        String filter = "(CN=__CONNID-NORES__)";
        try {
            LdapContext ctx = this.conn.getSyncContext(new Control[]{new DirSyncControl()});
            ctx.search(baseContextDn, "(CN=__CONNID-NORES__)", searchCtls);
            Control[] rspCtls = ctx.getResponseControls();
            if (rspCtls != null) {
                for (Control rspCtl : rspCtls) {
                    if (!(rspCtl instanceof DirSyncResponseControl)) continue;
                    DirSyncResponseControl dirSyncRspCtl = (DirSyncResponseControl)rspCtl;
                    this.latestSyncToken = new SyncToken((Object)dirSyncRspCtl.getCookie());
                }
                if (LOG.isOk()) {
                    LOG.ok("Latest sync token set to {0}", new Object[]{this.latestSyncToken});
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "While searching for {0} with filter {1} and controls {2}", new Object[]{baseContextDn, "(CN=__CONNID-NORES__)", searchCtls});
        }
        return this.latestSyncToken;
    }

    private void handleSyncUDelta(LdapContext ctx, SearchResult result, Collection<String> attrsToGet, SyncToken token, SyncResultsHandler handler) throws NamingException {
        if (ctx == null || result == null) {
            throw new ConnectorException("Invalid context or search result.");
        }
        ctx.setRequestControls(new Control[]{new DeletedControl(), new SDFlagsControl(4)});
        Attributes profile = result.getAttributes();
        if (LOG.isOk()) {
            LOG.ok("Object profile: {0}", new Object[]{profile});
        }
        String guid = GUID.getGuidAsString((byte[])((byte[])profile.get("objectGUID").get()));
        boolean isDeleted = false;
        try {
            Attribute attributeIsDeleted = profile.get("isDeleted");
            isDeleted = attributeIsDeleted != null && attributeIsDeleted.get() != null && Boolean.parseBoolean(attributeIsDeleted.get().toString());
        }
        catch (NoSuchElementException e) {
            if (LOG.isOk()) {
                LOG.ok("Cannot find the isDeleted element for user.", new Object[0]);
            }
        }
        catch (Throwable t) {
            LOG.error(t, "Error retrieving isDeleted attribute", new Object[0]);
        }
        profile = ctx.getAttributes("<GUID=" + guid + ">");
        Attribute objectClasses = profile.get("objectClass");
        ADConfiguration conf = (ADConfiguration)this.conn.getConfiguration();
        if (objectClasses.contains("group")) {
            if (LOG.isOk()) {
                LOG.ok("Modified group {0}", new Object[]{result.getNameInNamespace()});
            }
            Attribute member11 = result.getAttributes().get("member;range=1-1");
            Attribute member00 = result.getAttributes().get("member;range=0-0");
            ctx.setRequestControls(null);
            if (member11 != null) {
                if (LOG.isOk()) {
                    LOG.ok("Found users 'IN' ...", new Object[0]);
                }
                this.handleInOutEntries(ctx, ObjectClass.ACCOUNT, member11.getAll(), DirSyncUtils.getUserFilter(conf), handler, token, conf, attrsToGet);
            }
            if (member00 != null && conf.isRetrieveDeletedUser()) {
                if (LOG.isOk()) {
                    LOG.ok("Found users 'OUT' ...", new Object[0]);
                }
                this.handleInOutEntries(ctx, ObjectClass.ACCOUNT, member00.getAll(), DirSyncUtils.getUserFilter(conf), handler, token, conf, attrsToGet);
            }
        } else if (objectClasses.contains("user")) {
            if (LOG.isOk()) {
                LOG.ok("Created/Updated/Deleted user {0}", new Object[]{result.getNameInNamespace()});
            }
            if (isDeleted) {
                if (LOG.isOk()) {
                    LOG.ok("Deleted user {0}", new Object[]{result.getNameInNamespace()});
                }
                if (conf.isRetrieveDeletedUser()) {
                    handler.handle(this.getSyncDelta(ObjectClass.ACCOUNT, result.getNameInNamespace(), SyncDeltaType.DELETE, token, profile, attrsToGet));
                }
            } else {
                if (LOG.isOk()) {
                    LOG.ok("Created/Updated user {0}", new Object[]{result.getNameInNamespace()});
                }
                this.handleEntry(ctx, ObjectClass.ACCOUNT, result.getNameInNamespace(), DirSyncUtils.getUserFilter(conf), handler, token, conf, attrsToGet);
            }
        } else {
            LOG.warn("Invalid object type {0}", new Object[]{objectClasses});
        }
    }

    private void handleSyncGDelta(LdapContext ctx, SearchResult sr, Collection<String> attrsToGet, SyncToken token, SyncResultsHandler handler) throws NamingException {
        if (ctx == null || sr == null) {
            throw new ConnectorException("Invalid context or search result.");
        }
        ctx.setRequestControls(new Control[]{new DeletedControl()});
        Attributes profile = sr.getAttributes();
        if (LOG.isOk()) {
            LOG.ok("Object profile: {0}", new Object[]{profile});
        }
        String guid = GUID.getGuidAsString((byte[])((byte[])profile.get("objectGUID").get()));
        boolean isDeleted = false;
        try {
            Attribute attributeIsDeleted = profile.get("isDeleted");
            isDeleted = attributeIsDeleted != null && attributeIsDeleted.get() != null && Boolean.parseBoolean(attributeIsDeleted.get().toString());
        }
        catch (NoSuchElementException e) {
            if (LOG.isOk()) {
                LOG.ok("Cannot find the isDeleted element for group.", new Object[0]);
            }
        }
        catch (Throwable t) {
            LOG.error(t, "Error retrieving isDeleted attribute", new Object[0]);
        }
        profile = ctx.getAttributes("<GUID=" + guid + ">");
        Attribute objectClasses = profile.get("objectClass");
        if (objectClasses.contains("group")) {
            ADConfiguration conf = (ADConfiguration)this.conn.getConfiguration();
            if (LOG.isOk()) {
                LOG.ok("Created/Updated/Deleted group {0}", new Object[]{sr.getNameInNamespace()});
            }
            if (isDeleted) {
                if (LOG.isOk()) {
                    LOG.ok("Deleted group {0}", new Object[]{sr.getNameInNamespace()});
                }
                if (conf.isRetrieveDeletedGroup()) {
                    handler.handle(this.getSyncDelta(ObjectClass.GROUP, sr.getNameInNamespace(), SyncDeltaType.DELETE, token, profile, attrsToGet));
                }
            } else {
                if (LOG.isOk()) {
                    LOG.ok("Created/Updated group {0}", new Object[]{sr.getNameInNamespace()});
                }
                String userDN = sr.getNameInNamespace();
                this.handleEntry(ctx, ObjectClass.GROUP, userDN, conf.getGroupSearchFilter(), handler, token, conf, attrsToGet);
                Attribute member11 = sr.getAttributes().get("member;range=1-1");
                Attribute member00 = sr.getAttributes().get("member;range=0-0");
                ctx.setRequestControls(null);
                if (member11 != null) {
                    if (LOG.isOk()) {
                        LOG.ok("Found entry 'IN' ...", new Object[0]);
                    }
                    this.handleInOutEntries(ctx, ObjectClass.GROUP, member11.getAll(), "(&(objectclass=group)" + conf.getGroupSearchFilter() + ")", handler, token, conf, attrsToGet);
                }
                if (member00 != null) {
                    if (LOG.isOk()) {
                        LOG.ok("Found entry 'OUT' ...", new Object[0]);
                    }
                    this.handleInOutEntries(ctx, ObjectClass.GROUP, member00.getAll(), "(&(objectclass=group)" + conf.getGroupSearchFilter() + ")", handler, token, conf, attrsToGet);
                }
            }
        } else {
            LOG.warn("Invalid object type {0}", new Object[]{objectClasses});
        }
    }

    private SyncDelta getSyncDelta(ObjectClass oclass, String entryDN, SyncDeltaType syncDeltaType, SyncToken token, Attributes profile, Collection<String> attrsToGet) throws NamingException {
        Attribute uidAttribute;
        SyncDeltaBuilder sdb = new SyncDeltaBuilder();
        sdb.setToken(token);
        sdb.setDeltaType(syncDeltaType);
        Uid uid = null;
        if (StringUtil.isNotBlank((String)this.conn.getSchemaMapping().getLdapUidAttribute(oclass)) && (uidAttribute = profile.get(this.conn.getSchemaMapping().getLdapUidAttribute(oclass))) != null) {
            uid = new Uid(uidAttribute.get().toString());
        }
        if (uid == null) {
            throw new ConnectorException("UID attribute not found");
        }
        sdb.setUid(uid);
        sdb.setObject(this.utils.createConnectorObject(entryDN, profile, attrsToGet, oclass));
        return sdb.build();
    }

    private void handleInOutEntries(LdapContext ctx, ObjectClass oclass, NamingEnumeration<String> dns, String filter, SyncResultsHandler handler, SyncToken token, ADConfiguration conf, Collection<String> attrsToGet) throws NamingException {
        while (dns.hasMoreElements()) {
            this.handleEntry(ctx, oclass, dns.next(), filter, handler, token, conf, attrsToGet);
        }
    }

    private void handleEntry(LdapContext ctx, ObjectClass oclass, String dn, String filter, SyncResultsHandler handler, SyncToken token, ADConfiguration conf, Collection<String> attrsToGet) throws NamingException {
        SyncDeltaType deltaType;
        Attributes profile = ctx.getAttributes(dn);
        Attribute objectClasses = profile.get("objectClass");
        if (oclass.is(ObjectClass.ACCOUNT_NAME) && !objectClasses.contains("user") || oclass.is(ObjectClass.GROUP_NAME) && !objectClasses.contains("group")) {
            LOG.warn("Invalid type: skip object {0}", new Object[]{dn});
            return;
        }
        if (DirSyncUtils.verifyFilter(ctx, dn, filter)) {
            if (LOG.isOk()) {
                LOG.ok("Entry {0} - update", new Object[]{dn});
            }
            deltaType = SyncDeltaType.CREATE_OR_UPDATE;
        } else {
            if (LOG.isOk()) {
                LOG.ok("Entry {0} - delete", new Object[]{dn});
            }
            deltaType = SyncDeltaType.DELETE;
        }
        if (deltaType != SyncDeltaType.DELETE || oclass.is(ObjectClass.GROUP_NAME) && conf.isRetrieveDeletedGroup() || oclass.is(ObjectClass.ACCOUNT_NAME) && conf.isRetrieveDeletedUser()) {
            handler.handle(this.getSyncDelta(oclass, dn, deltaType, token, profile, attrsToGet));
        }
    }
}

