/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import net.tirasa.adsddl.ntsd.SDDL;
import net.tirasa.adsddl.ntsd.SID;
import net.tirasa.adsddl.ntsd.utils.GUID;
import net.tirasa.adsddl.ntsd.utils.Hex;
import net.tirasa.adsddl.ntsd.utils.NumberFacility;
import net.tirasa.adsddl.ntsd.utils.SDDLHelper;
import net.tirasa.connid.bundles.ad.ADConfiguration;
import net.tirasa.connid.bundles.ad.ADConnection;
import net.tirasa.connid.bundles.ad.ADConnector;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.commons.GroupHelper;
import net.tirasa.connid.bundles.ldap.commons.LdapConstants;
import net.tirasa.connid.bundles.ldap.commons.LdapEntry;
import net.tirasa.connid.bundles.ldap.commons.LdapUtil;
import net.tirasa.connid.bundles.ldap.schema.LdapSchemaMapping;
import net.tirasa.connid.bundles.ldap.search.LdapFilter;
import net.tirasa.connid.bundles.ldap.search.LdapInternalSearch;
import net.tirasa.connid.bundles.ldap.search.LdapSearches;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;

public class ADUtilities {
    private static final Log LOG = Log.getLog(ADUtilities.class);
    private final ADConnection connection;
    private final GroupHelper groupHelper;

    public ADUtilities(ADConnection connection) {
        this.connection = connection;
        this.groupHelper = new GroupHelper((LdapConnection)connection);
    }

    public static SID getPrimaryGroupSID(SID sid, byte[] pgID) {
        SID pgSID = SID.newInstance((byte[])sid.getIdentifierAuthority());
        pgSID.setRevision(sid.getRevision());
        List subAuthorities = sid.getSubAuthorities();
        if (subAuthorities != null && !subAuthorities.isEmpty()) {
            for (int i = 0; i < subAuthorities.size() - 1; ++i) {
                pgSID.addSubAuthority((byte[])subAuthorities.get(i));
            }
        }
        pgSID.addSubAuthority(pgID);
        return pgSID;
    }

    public Attribute getGroupID(String dn) throws InvalidNameException {
        try {
            LdapName name = new LdapName(dn);
            Attributes group = this.connection.getInitialContext().getAttributes(name, new String[]{"objectSID"});
            SID gsid = SID.parse((byte[])((byte[])group.get("objectSID").get()));
            byte[] groupID = (byte[])gsid.getSubAuthorities().get(gsid.getSubAuthorityCount() - 1);
            return new BasicAttribute("primaryGroupID", String.valueOf(NumberFacility.getUInt((byte[])groupID)));
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Invalid group DN '{0}'", new Object[]{dn});
            throw new ConnectorException((Throwable)e);
        }
    }

    public String getPrimaryGroupDN(LdapEntry entry, Attributes profile) throws NamingException {
        String pgDN;
        Attribute primaryGroupID = profile.get("primaryGroupID");
        Attribute objectSID = profile.get("objectSID");
        if (primaryGroupID == null || primaryGroupID.get() == null || objectSID == null || objectSID.get() == null) {
            pgDN = null;
        } else {
            SID groupSID = ADUtilities.getPrimaryGroupSID(SID.parse((byte[])((byte[])objectSID.get())), NumberFacility.getUIntBytes((long)Long.parseLong(primaryGroupID.get().toString())));
            Set<SearchResult> res = this.basicLdapSearch(String.format("(&(objectclass=group)(%s=%s))", "objectSID", Hex.getEscaped((byte[])groupSID.toByteArray())), ((ADConfiguration)this.connection.getConfiguration()).getGroupBaseContexts());
            if (res == null || res.isEmpty()) {
                LOG.warn("Error retrieving primary group for {0}", new Object[]{entry.getDN()});
                pgDN = null;
            } else {
                pgDN = res.iterator().next().getNameInNamespace();
                LOG.info("Found primary group {0}", new Object[]{pgDN});
            }
        }
        return pgDN;
    }

    public Set<String> getAttributesToGet(String[] attributesToGet, ObjectClass oclass) {
        Set<Object> result;
        if (attributesToGet != null) {
            result = CollectionUtil.newCaseInsensitiveSet();
            result.addAll(Arrays.asList(attributesToGet));
            this.removeNonReadableAttributes(result, oclass);
            result.add(Name.NAME);
        } else {
            result = ADUtilities.getAttributesReturnedByDefault(this.connection, oclass);
        }
        result.add(Uid.NAME);
        if (oclass.is(ObjectClass.ACCOUNT_NAME)) {
            result.add("userAccountControl");
        }
        String memberships = ((ADConfiguration)((Object)ADConfiguration.class.cast(this.connection.getConfiguration()))).getGroupMemberReferenceAttribute();
        if (oclass.is(ObjectClass.GROUP_NAME) && result.contains(memberships)) {
            result.remove(memberships);
            result.add(String.format("%s;range=%d-%d", memberships, 0, 999));
        }
        if (result.contains(OperationalAttributes.PASSWORD_NAME)) {
            LOG.warn("Reading passwords not supported", new Object[0]);
        }
        if (result.contains("userCannotChangePassword")) {
            result.remove("userCannotChangePassword");
            result.add("ntSecurityDescriptor");
        }
        if (result.contains("ldapGroups")) {
            result.add("objectSID");
            result.add("primaryGroupID");
        }
        return result;
    }

    private void removeNonReadableAttributes(Set<String> attributes, ObjectClass oclass) {
        boolean ldapGroups = attributes.remove("ldapGroups");
        boolean posixGroups = attributes.remove("posixGroups");
        this.connection.getSchemaMapping().removeNonReadableAttributes(oclass, attributes);
        if (ldapGroups) {
            attributes.add("ldapGroups");
        }
        if (posixGroups) {
            attributes.add("posixGroups");
        }
    }

    public static Set<String> getAttributesReturnedByDefault(LdapConnection conn, ObjectClass oclass) {
        if (oclass.equals((Object)LdapSchemaMapping.ANY_OBJECT_CLASS)) {
            return CollectionUtil.newSet((Object[])new String[]{Name.NAME});
        }
        SortedSet result = CollectionUtil.newCaseInsensitiveSet();
        ObjectClassInfo oci = conn.getSchemaMapping().schema().findObjectClassInfo(oclass.getObjectClassValue());
        if (oci != null) {
            for (AttributeInfo info : oci.getAttributeInfo()) {
                if (!info.isReturnedByDefault() || ADConnector.ADDS2012_ATTRIBUTES_TO_BE_REMOVED.contains(info.getName())) continue;
                result.add(info.getName());
            }
        }
        return result;
    }

    public Set<String> getLdapAttributesToGet(Set<String> attrsToGet, ObjectClass oclass) {
        SortedSet cleanAttrsToGet = CollectionUtil.newCaseInsensitiveSet();
        cleanAttrsToGet.addAll(attrsToGet);
        cleanAttrsToGet.remove("ldapGroups");
        boolean posixGroups = cleanAttrsToGet.remove("posixGroups");
        Set result = this.connection.getSchemaMapping().getLdapAttributes(oclass, (Set)cleanAttrsToGet, true);
        if (posixGroups) {
            result.add(GroupHelper.getPosixRefAttribute());
        }
        return result;
    }

    public ConnectorObject createConnectorObject(String baseDN, SearchResult result, Collection<String> attrsToGet, ObjectClass oclass) throws NamingException {
        return this.createConnectorObject(baseDN, result.getAttributes(), attrsToGet, oclass);
    }

    public ConnectorObject createConnectorObject(String baseDN, Attributes profile, Collection<String> attrsToGet, ObjectClass oclass) throws NamingException {
        LdapEntry entry = LdapEntry.create((String)baseDN, (Attributes)profile);
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(oclass);
        if ("objectGUID".equals(this.connection.getSchemaMapping().getLdapUidAttribute(oclass))) {
            builder.setUid(GUID.getGuidAsString((byte[])((byte[])entry.getAttributes().get("objectGUID").get())));
        } else {
            builder.setUid(this.connection.getSchemaMapping().createUid(oclass, entry));
        }
        builder.setName(this.connection.getSchemaMapping().createName(oclass, entry));
        String pgDN = null;
        for (String attributeName : attrsToGet) {
            org.identityconnectors.framework.common.objects.Attribute attribute = null;
            if (LdapConstants.isLdapGroups((String)attributeName) || attributeName.equals("memberOf")) {
                Set<String> ldapGroups = this.getGroups(entry.getDN().toString());
                if (StringUtil.isBlank(pgDN)) {
                    pgDN = this.getPrimaryGroupDN(entry, profile);
                }
                if (StringUtil.isNotBlank(pgDN)) {
                    ldapGroups.add(pgDN);
                }
                attribute = AttributeBuilder.build((String)attributeName, ldapGroups);
            } else if (LdapConstants.isPosixGroups((String)attributeName)) {
                Set posixRefAttrs = LdapUtil.getStringAttrValues((Attributes)entry.getAttributes(), (String)GroupHelper.getPosixRefAttribute());
                List posixGroups = this.groupHelper.getPosixGroups((Collection)posixRefAttrs);
                attribute = AttributeBuilder.build((String)"posixGroups", (Collection)posixGroups);
            } else if (LdapConstants.PASSWORD.is(attributeName) && oclass.is(ObjectClass.ACCOUNT_NAME)) {
                attribute = AttributeBuilder.build((String)attributeName, (Object[])new Object[]{new GuardedString()});
            } else if ("userAccountControl".equalsIgnoreCase(attributeName) && oclass.is(ObjectClass.ACCOUNT_NAME)) {
                try {
                    String status;
                    String string = status = profile.get("userAccountControl") == null || profile.get("userAccountControl").get() == null ? null : profile.get("userAccountControl").get().toString();
                    if (LOG.isOk()) {
                        LOG.ok("User Account Control: {0}", new Object[]{status});
                    }
                    builder.addAttribute(new org.identityconnectors.framework.common.objects.Attribute[]{status == null || Integer.parseInt(profile.get("userAccountControl").get().toString()) % 16 != 2 ? AttributeBuilder.buildEnabled((boolean)true) : AttributeBuilder.buildEnabled((boolean)false)});
                    attribute = this.connection.getSchemaMapping().createAttribute(oclass, attributeName, entry, false);
                }
                catch (NamingException e) {
                    LOG.error((Throwable)e, "While fetching userAccountControl", new Object[0]);
                }
            } else if ("objectGUID".equalsIgnoreCase(attributeName)) {
                attribute = AttributeBuilder.build((String)attributeName, (Object[])new Object[]{GUID.getGuidAsString((byte[])((byte[])profile.get("objectGUID").get()))});
            } else if ("ntSecurityDescriptor".equalsIgnoreCase(attributeName)) {
                Attribute sddl = profile.get("ntSecurityDescriptor");
                if (sddl != null) {
                    attribute = AttributeBuilder.build((String)"userCannotChangePassword", (Object[])new Object[]{SDDLHelper.isUserCannotChangePassword((SDDL)new SDDL((byte[])sddl.get()))});
                }
            } else if ("primaryGroupDN".equalsIgnoreCase(attributeName)) {
                if (StringUtil.isBlank((String)pgDN)) {
                    pgDN = this.getPrimaryGroupDN(entry, profile);
                }
                attribute = AttributeBuilder.build((String)"primaryGroupDN", (Object[])new Object[]{pgDN});
            } else if (oclass.is(ObjectClass.GROUP_NAME) && String.format("%s;range=%d-%d", ((ADConfiguration)((Object)ADConfiguration.class.cast(this.connection.getConfiguration()))).getGroupMemberReferenceAttribute(), 0, 999).equalsIgnoreCase(attributeName)) {
                String membAttrPrefix = ((ADConfiguration)((Object)ADConfiguration.class.cast(this.connection.getConfiguration()))).getGroupMemberReferenceAttribute();
                String membAttrName = String.format("%s;range=0-*", membAttrPrefix);
                attribute = this.connection.getSchemaMapping().createAttribute(oclass, membAttrName, entry, true);
                ArrayList values = new ArrayList(attribute.getValue());
                if (values.isEmpty()) {
                    int start = 0;
                    int end = 999;
                    membAttrName = String.format("%s;range=%d-%d", membAttrPrefix, start, end);
                    attribute = this.connection.getSchemaMapping().createAttribute(oclass, membAttrName, entry, true);
                    values.addAll(attribute.getValue());
                    boolean theEnd = CollectionUtil.isEmpty((Collection)attribute.getValue());
                    while (!theEnd) {
                        membAttrName = String.format("%s;range=%d-%d", membAttrPrefix, start += 1000, end += 1000);
                        Attributes membAttrs = this.getAttributes(entry.getDN().toString(), membAttrName);
                        if (membAttrs == null || membAttrs.size() <= 0) {
                            theEnd = true;
                            continue;
                        }
                        Attribute membAttr = membAttrs.getAll().next();
                        theEnd = membAttr.getID().equalsIgnoreCase(String.format("%s;range=%d-*", membAttrPrefix, start));
                        NamingEnumeration<?> ne = membAttr.getAll();
                        while (ne.hasMore()) {
                            values.add(ne.next());
                        }
                    }
                }
                attribute = AttributeBuilder.build((String)membAttrPrefix, values);
            } else if (profile.get(attributeName) != null) {
                attribute = this.connection.getSchemaMapping().createAttribute(oclass, attributeName, entry, false);
            }
            if (attribute == null) continue;
            builder.addAttribute(new org.identityconnectors.framework.common.objects.Attribute[]{attribute});
        }
        return builder.build();
    }

    public final String getDN(ObjectClass oclass, Name nameAttr, org.identityconnectors.framework.common.objects.Attribute cnAttr) {
        String cn = cnAttr == null || cnAttr.getValue() == null || cnAttr.getValue().isEmpty() || cnAttr.getValue().get(0) == null || StringUtil.isBlank((String)cnAttr.getValue().get(0).toString()) ? nameAttr.getNameValue() : cnAttr.getValue().get(0).toString();
        return "cn=" + cn + "," + (oclass.is(ObjectClass.ACCOUNT_NAME) ? ((ADConfiguration)this.connection.getConfiguration()).getDefaultPeopleContainer() : ((ADConfiguration)this.connection.getConfiguration()).getDefaultGroupContainer());
    }

    public static boolean isDN(String dn) {
        try {
            return StringUtil.isNotBlank((String)dn) && new LdapName(dn) != null;
        }
        catch (InvalidNameException ex) {
            if (LOG.isOk()) {
                LOG.ok((Throwable)ex, "Invalid DN {0}", new Object[]{dn});
            }
            return false;
        }
    }

    public String getMembershipSearchFilter(ADConfiguration conf) {
        StringBuilder ufilter = new StringBuilder();
        String[] memberships = conf.getMemberships();
        if (memberships != null && memberships.length > 0) {
            ufilter.append(conf.isMembershipsInOr() ? "(|" : "(&");
            for (String group : memberships) {
                ufilter.append("(").append("memberOf").append("=").append(group).append(")");
            }
            ufilter.append(")");
        }
        return ufilter.toString();
    }

    public LdapEntry getEntryToBeUpdated(String entryDN) {
        LdapEntry obj = null;
        try {
            obj = LdapSearches.getEntry((LdapConnection)this.connection, (LdapName)new LdapName(entryDN), (String[])new String[]{"userAccountControl", "ntSecurityDescriptor", "objectSID", "primaryGroupID"});
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "Invalid entry DN", new Object[0]);
        }
        if (obj == null) {
            throw new ConnectorException("Entry not found");
        }
        return obj;
    }

    public ConnectorObject getEntryToBeUpdated(Uid uid, ObjectClass oclass) {
        String filter = this.connection.getSchemaMapping().getLdapUidAttribute(oclass) + "=" + uid.getUidValue();
        ConnectorObject obj = LdapSearches.findObject((LdapConnection)this.connection, (ObjectClass)oclass, (LdapFilter)LdapFilter.forNativeFilter((String)filter), (String[])new String[]{"userAccountControl", "ntSecurityDescriptor", "objectSID", "primaryGroupID"});
        if (obj == null) {
            throw new ConnectorException("Entry not found");
        }
        return obj;
    }

    public Attributes getAttributes(String entryDN, String ... attributes) {
        try {
            return this.connection.getInitialContext().getAttributes(entryDN, attributes);
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public Attribute userCannotChangePassword(String entryDN, Boolean cannot) {
        Attribute ntSecurityDescriptor = this.getAttributes(entryDN, "ntSecurityDescriptor").get("ntSecurityDescriptor");
        if (ntSecurityDescriptor == null) {
            return null;
        }
        try {
            return this.userCannotChangePassword((byte[])ntSecurityDescriptor.get(), cannot);
        }
        catch (NamingException ex) {
            LOG.error((Throwable)ex, "Error retrieving sddl", new Object[0]);
            return null;
        }
    }

    public Attribute userCannotChangePassword(ConnectorObject obj, Boolean cannot) {
        org.identityconnectors.framework.common.objects.Attribute ntSecurityDescriptor = obj.getAttributeByName("ntSecurityDescriptor");
        if (ntSecurityDescriptor == null || ntSecurityDescriptor.getValue() == null || ntSecurityDescriptor.getValue().isEmpty()) {
            return null;
        }
        return this.userCannotChangePassword((byte[])ntSecurityDescriptor.getValue().get(0), cannot);
    }

    public Attribute userCannotChangePassword(byte[] obj, Boolean cannot) {
        if (obj == null) {
            return null;
        }
        return new BasicAttribute("ntSecurityDescriptor", SDDLHelper.userCannotChangePassword((SDDL)new SDDL(obj), (Boolean)cannot).toByteArray());
    }

    public Set<SearchResult> basicLdapSearch(String filter, String ... baseContextDNs) {
        LdapContext ctx = this.connection.getInitialContext();
        SearchControls searchCtls = LdapInternalSearch.createDefaultSearchControls();
        searchCtls.setSearchScope(2);
        searchCtls.setReturningAttributes(new String[0]);
        HashSet<SearchResult> result = new HashSet<SearchResult>();
        for (String baseContextDn : baseContextDNs) {
            if (LOG.isOk()) {
                LOG.ok("Searching from " + baseContextDn, new Object[0]);
            }
            try {
                NamingEnumeration<SearchResult> answer = ctx.search(baseContextDn, filter, searchCtls);
                while (answer.hasMoreElements()) {
                    result.add((SearchResult)answer.nextElement());
                }
            }
            catch (NamingException e) {
                LOG.error((Throwable)e, "While searching base context {0} with filter {1} and search controls {2}", new Object[]{baseContextDn, filter, searchCtls});
            }
        }
        return result;
    }

    public Set<String> getGroups(String entryDN) {
        return this.getGroups(entryDN, ((ADConfiguration)this.connection.getConfiguration()).getGroupBaseContexts());
    }

    public Set<String> getGroups(String entryDN, String ... baseContexts) {
        String member = ((ADConfiguration)this.connection.getConfiguration()).getGroupMemberReferenceAttribute();
        TreeSet<String> ldapGroups = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (SearchResult res : this.basicLdapSearch(this.filterInOr(member, entryDN), baseContexts)) {
            ldapGroups.add(res.getNameInNamespace());
        }
        return ldapGroups;
    }

    private String filterInOr(String attr, String ... values) {
        boolean multi;
        StringBuilder builder = new StringBuilder();
        boolean bl = multi = values != null && values.length > 1;
        if (multi) {
            builder.append("(|");
        }
        for (String memberValue : values) {
            builder.append('(');
            builder.append(attr);
            builder.append('=');
            LdapUtil.escapeAttrValue((Object)memberValue, (StringBuilder)builder);
            builder.append(')');
        }
        if (multi) {
            builder.append(")");
        }
        return builder.toString();
    }
}

