/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.common.arquillian.objects;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.wasdev.wlp.common.arquillian.objects.LibertyProperty;

public class LibertyManagedObject {
    private static final String XML_START = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<arquillian xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txmlns=\"http://jboss.org/schema/arquillian\"\n\txsi:schemaLocation=\"http://jboss.org/schema/arquillian http://jboss.org/schema/arquillian/arquillian_1_0.xsd\">\n\t<container qualifier=\"liberty_managed\" default=\"true\">\n\t\t<configuration>\n";
    private static final String XML_END = "\t\t</configuration>\n\t</container>\n</arquillian>\n";
    private final String wlpHome;
    private final String serverName;
    private final int httpPort;
    private final Map<LibertyProperty.LibertyPropertyI, String> arquillianProperties;

    public LibertyManagedObject(String wlpHome, String serverName, int httpPort, Map<LibertyProperty.LibertyPropertyI, String> arquillianProperties) {
        this.wlpHome = wlpHome;
        this.serverName = serverName;
        this.httpPort = httpPort;
        this.arquillianProperties = arquillianProperties;
    }

    public String getWlpHome() {
        return this.wlpHome;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public Map<LibertyProperty.LibertyPropertyI, String> getArquillianProperties() {
        return this.arquillianProperties;
    }

    public void build(File arquillianXml) throws IOException {
        StringBuilder xml = new StringBuilder(XML_START);
        xml.append("\t\t\t<property name=\"wlpHome\">").append(this.getWlpHome()).append("</property>\n");
        xml.append("\t\t\t<property name=\"serverName\">").append(this.getServerName()).append("</property>\n");
        xml.append("\t\t\t<property name=\"httpPort\">").append(this.getHttpPort()).append("</property>\n");
        for (Map.Entry<LibertyProperty.LibertyPropertyI, String> e : this.arquillianProperties.entrySet()) {
            LibertyManagedProperty property = (LibertyManagedProperty)e.getKey();
            String key = property.name();
            xml.append("\t\t\t<property name=\"").append(key).append("\">").append(e.getValue()).append("</property>\n");
        }
        xml.append(XML_END);
        xml.append("<!-- This file was generated by the Liberty build plugin. -->");
        LibertyProperty.write(xml, arquillianXml);
    }

    public static enum LibertyManagedProperty implements LibertyProperty.LibertyPropertyI
    {
        serverStartTimeout,
        serverStopTimeout,
        appDeployTimeout,
        appUndeployTimeout,
        sharedLib,
        deployType,
        javaVmArguments,
        addLocalConnector,
        securityConfiguration,
        failSafeUndeployment,
        outputToConsole,
        allowConnectingToRunningServer,
        verifyApps,
        verifyAppDeployTimeout,
        fileDeleteRetries,
        standardFileDeleteRetryInterval;

    }
}

