/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.common.plugins.config;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import net.wasdev.wlp.common.plugins.config.XmlDocument;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class LooseConfigData
extends XmlDocument {
    public LooseConfigData() throws ParserConfigurationException {
        this.createDocument("archive");
    }

    public void addDir(File src, String target) throws DOMException, IOException {
        if (src != null && src.exists() && src.isDirectory()) {
            this.addDir(this.doc.getDocumentElement(), src, target);
        }
    }

    public void addDir(Element parent, File src, String target) throws DOMException, IOException {
        if (src != null && src.exists() && src.isDirectory()) {
            Element child = this.doc.createElement("dir");
            this.addElement(parent, child, src, target);
        }
    }

    public void addFile(File src, String target) throws DOMException, IOException {
        if (src != null && src.exists() && src.isFile()) {
            this.addFile(this.doc.getDocumentElement(), src, target);
        }
    }

    public void addFile(Element parent, File src, String target) throws DOMException, IOException {
        if (src != null && src.exists() && src.isFile()) {
            Element child = this.doc.createElement("file");
            this.addElement(parent, child, src, target);
        }
    }

    public Element addArchive(String target) {
        return this.addArchive(this.doc.getDocumentElement(), target);
    }

    public Element addArchive(Element parent, String target) {
        Element child = this.doc.createElement("archive");
        this.addElement(parent, child, target);
        return child;
    }

    public void addArchive(File src, String target) throws DOMException, IOException {
        Element child = this.addArchive(target);
        this.addElement(child, this.doc.createElement("dir"), src, "/");
    }

    public void toXmlFile(File xmlFile) throws Exception {
        this.writeXMLDocument(xmlFile);
    }

    public Element getDocumentRoot() {
        return this.doc.getDocumentElement();
    }

    private void addElement(Element parent, Element child, File src, String target) throws DOMException, IOException {
        child.setAttribute("sourceOnDisk", src.getCanonicalPath());
        this.addElement(parent, child, target);
    }

    private void addElement(Element parent, Element child, String target) {
        child.setAttribute("targetInArchive", target);
        parent.appendChild(child);
    }
}

