/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.html;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Pattern;
import nl.talsmasoftware.umldoclet.configuration.Configuration;
import nl.talsmasoftware.umldoclet.configuration.ImageConfig;
import nl.talsmasoftware.umldoclet.html.ClassDiagramInserter;
import nl.talsmasoftware.umldoclet.html.DiagramFile;
import nl.talsmasoftware.umldoclet.html.PackageDependenciesInserter;
import nl.talsmasoftware.umldoclet.html.PackageDiagramInserter;
import nl.talsmasoftware.umldoclet.util.FileUtils;

final class DiagramCollector
extends SimpleFileVisitor<Path> {
    private static final Pattern PACKAGE_DIAGRAM_PATTERN = Pattern.compile("package\\.[a-z]+$");
    private static final Pattern PACKAGE_DEPENDENCY_DIAGRAM_PATTERN = Pattern.compile("package-dependencies\\.[a-z]+$");
    private final File basedir;
    private final Optional<File> imagesDirectory;
    private final Optional<ImageConfig.Format> imageFormat;
    private final ThreadLocal<Collection<DiagramFile>> collected = ThreadLocal.withInitial(ArrayList::new);

    DiagramCollector(Configuration config) {
        this.basedir = new File(config.destinationDirectory());
        this.imageFormat = config.images().formats().stream().findFirst();
        this.imagesDirectory = config.images().directory().map(imagesDir -> new File(config.destinationDirectory(), (String)imagesDir));
    }

    Collection<DiagramFile> collectDiagrams() throws IOException {
        if (!this.imageFormat.isPresent()) {
            return Collections.emptySet();
        }
        try {
            Files.walkFileTree(this.imagesDirectory.orElse(this.basedir).toPath(), this);
            Collection<DiagramFile> collection = Collections.unmodifiableCollection(this.collected.get());
            return collection;
        }
        finally {
            this.collected.remove();
        }
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
        if (attrs.isRegularFile() && FileUtils.hasExtension(path, this.imageFormat.orElse((ImageConfig.Format)ImageConfig.Format.SVG).fileExtension)) {
            this.collected.get().add(this.createDiagramInstance(path));
        }
        return super.visitFile(path, attrs);
    }

    private boolean isPackageDiagram(File diagramFile) {
        return PACKAGE_DIAGRAM_PATTERN.matcher(diagramFile.getName()).find();
    }

    private boolean isPackageDependencyDiagram(File diagramFile) {
        return PACKAGE_DEPENDENCY_DIAGRAM_PATTERN.matcher(diagramFile.getName()).find();
    }

    private DiagramFile createDiagramInstance(Path diagramPath) {
        File diagramFile = diagramPath.normalize().toFile();
        ImageConfig.Format format = this.imageFormat.orElse(ImageConfig.Format.SVG);
        if (this.isPackageDiagram(diagramFile)) {
            return new PackageDiagramInserter(this.basedir, diagramFile, format, this.imagesDirectory.isPresent());
        }
        if (this.isPackageDependencyDiagram(diagramFile)) {
            return new PackageDependenciesInserter(this.basedir, diagramFile, format);
        }
        return new ClassDiagramInserter(this.basedir, diagramFile, format, this.imagesDirectory.isPresent());
    }
}

