/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.uml;

import java.io.File;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;
import nl.talsmasoftware.umldoclet.uml.Namespace;
import nl.talsmasoftware.umldoclet.uml.Type;
import nl.talsmasoftware.umldoclet.uml.UMLNode;
import nl.talsmasoftware.umldoclet.util.FileUtils;

public class Link
extends UMLNode {
    private static final ThreadLocal<String> LINK_FROM = new ThreadLocal();
    private final URI target;

    private Link(UMLNode parent, URI target) {
        super(parent);
        this.target = target;
    }

    public static Link forType(Type type) {
        String destinationDirectory = type.getConfiguration().destinationDirectory();
        String packageName = type.getPackagename();
        String nameInPackage = type.getName().qualified.startsWith(packageName + ".") ? type.getName().qualified.substring(packageName.length() + 1) : type.getName().simple;
        Optional<URI> target = Link.relativeHtmlFile(destinationDirectory, type.getModulename().orElse(null), packageName, nameInPackage).or(() -> type.getConfiguration().resolveExternalLinkToType(packageName, nameInPackage));
        return new Link(type, target.orElse(null));
    }

    public static Link forPackage(Namespace namespace) {
        String destinationDirectory = namespace.getConfiguration().destinationDirectory();
        String moduleName = namespace.getModuleName().orElse(null);
        String packageName = namespace.name;
        Optional<URI> target = Stream.of("package-summary", "module-summary").map(name -> Link.relativeHtmlFile(destinationDirectory, moduleName, packageName, name)).filter(Optional::isPresent).map(Optional::get).findFirst().or(() -> namespace.getConfiguration().resolveExternalLinkToType(packageName, "package-summary"));
        return new Link(namespace, target.orElse(null));
    }

    private static Optional<URI> relativeHtmlFile(String destinationDirectory, String moduleName, String packageName, String nameInPackage) {
        String packageAsPath = packageName.replace('.', '/');
        String htmlFileName = nameInPackage + ".html";
        File file = new File(destinationDirectory + "/" + packageAsPath, htmlFileName);
        if (file.isFile()) {
            return Optional.of(file.toURI());
        }
        if (moduleName != null && (file = new File(destinationDirectory + "/" + moduleName + "/" + packageAsPath, htmlFileName)).isFile()) {
            return Optional.of(file.toURI());
        }
        return Optional.empty();
    }

    public static boolean linkFrom(String basePath) {
        if (Objects.equals(basePath, LINK_FROM.get())) {
            return false;
        }
        if (basePath == null) {
            LINK_FROM.remove();
        } else {
            LINK_FROM.set(basePath);
        }
        return true;
    }

    private Optional<File> linkFromDir() {
        File fromDir;
        String dir = LINK_FROM.get();
        if (dir == null) {
            dir = this.getConfiguration().destinationDirectory();
        }
        return (fromDir = new File(dir)).isDirectory() ? Optional.of(fromDir) : Optional.empty();
    }

    private Optional<String> relativeTarget() {
        return Optional.ofNullable(this.target).filter(uri -> "file".equals(uri.getScheme())).map(File::new).flatMap(targetFile -> this.linkFromDir().map(dir -> FileUtils.relativePath(dir, targetFile)));
    }

    @Override
    public <IPW extends IndentingPrintWriter> IPW writeTo(IPW output) {
        if (this.target != null) {
            output.append("[[").append(this.relativeTarget().orElseGet(this.target::toASCIIString)).append("]]");
        }
        return output;
    }
}

