/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.uml;

import nl.talsmasoftware.umldoclet.configuration.MethodConfig;
import nl.talsmasoftware.umldoclet.configuration.TypeDisplay;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;
import nl.talsmasoftware.umldoclet.uml.TypeName;
import nl.talsmasoftware.umldoclet.uml.UMLNode;

public class Parameters
extends UMLNode {
    private boolean varargs = false;

    public Parameters(UMLNode parent) {
        super(parent);
    }

    @Override
    public void addChild(UMLNode child) {
        if (child instanceof Parameter) {
            super.addChild(child);
        }
    }

    public Parameters add(String name, TypeName type) {
        this.addChild(new Parameter(name, type));
        return this;
    }

    public Parameters varargs(boolean varargs) {
        this.varargs = varargs;
        return this;
    }

    @Override
    public <IPW extends IndentingPrintWriter> IPW writeTo(IPW output) {
        return this.writeChildrenTo(output);
    }

    @Override
    public <IPW extends IndentingPrintWriter> IPW writeChildrenTo(IPW output) {
        output.append('(');
        String sep = "";
        for (UMLNode param : this.getChildren()) {
            param.writeTo(output.append(sep));
            sep = ", ";
        }
        output.append(')');
        return output;
    }

    void replaceParameterizedType(TypeName from, TypeName to) {
        if (from != null) {
            this.getChildren().stream().filter(Parameter.class::isInstance).map(Parameter.class::cast).filter(p -> from.equals(((Parameter)p).type)).forEach(p -> ((Parameter)p).type = to);
        }
    }

    public class Parameter
    extends UMLNode {
        private final String name;
        private TypeName type;

        private Parameter(String name, TypeName type) {
            super(Parameters.this);
            this.name = name;
            this.type = type;
        }

        @Override
        public <IPW extends IndentingPrintWriter> IPW writeTo(IPW output) {
            String sep = "";
            MethodConfig methodConfig = this.getConfiguration().methods();
            if (this.name != null && MethodConfig.ParamNames.BEFORE_TYPE.equals((Object)methodConfig.paramNames())) {
                output.append(this.name);
                sep = ": ";
            }
            if (this.type != null && !TypeDisplay.NONE.equals((Object)methodConfig.paramTypes())) {
                Object typeUml = this.type.toUml(methodConfig.paramTypes(), null);
                if (Parameters.this.varargs && ((String)typeUml).endsWith("[]")) {
                    typeUml = ((String)typeUml).substring(0, ((String)typeUml).length() - 2) + "...";
                }
                output.append(sep).append((CharSequence)typeUml);
                sep = " ";
            }
            if (this.name != null && MethodConfig.ParamNames.AFTER_TYPE.equals((Object)methodConfig.paramNames())) {
                output.append(sep).append(this.name);
            }
            return output;
        }
    }
}

