/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.plugins.lockableresources.actions;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Api;
import hudson.model.Descriptor;
import hudson.model.RootAction;
import hudson.model.Run;
import hudson.security.AccessDeniedException3;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkins.plugins.lockableresources.LockableResource;
import org.jenkins.plugins.lockableresources.LockableResourcesManager;
import org.jenkins.plugins.lockableresources.Messages;
import org.jenkins.plugins.lockableresources.queue.LockableResourcesStruct;
import org.jenkins.plugins.lockableresources.queue.QueuedContextStruct;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@ExportedBean
public class LockableResourcesRootAction
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(LockableResourcesRootAction.class.getName());
    public static final PermissionGroup PERMISSIONS_GROUP = new PermissionGroup(LockableResourcesManager.class, Messages._LockableResourcesRootAction_PermissionGroup());
    public static final Permission UNLOCK = new Permission(PERMISSIONS_GROUP, "Unlock", Messages._LockableResourcesRootAction_UnlockPermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    public static final Permission RESERVE = new Permission(PERMISSIONS_GROUP, "Reserve", Messages._LockableResourcesRootAction_ReservePermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    public static final Permission STEAL = new Permission(PERMISSIONS_GROUP, "Steal", Messages._LockableResourcesRootAction_StealPermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    public static final Permission VIEW = new Permission(PERMISSIONS_GROUP, "View", Messages._LockableResourcesRootAction_ViewPermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    public static final Permission QUEUE = new Permission(PERMISSIONS_GROUP, "Queue", Messages._LockableResourcesRootAction_QueueChangeOrderPermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    public static final String ICON = "symbol-lock-closed";

    public String getIconFileName() {
        return Jenkins.get().hasPermission(VIEW) ? ICON : null;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    @CheckForNull
    public String getUserName() {
        return LockableResource.getUserName();
    }

    public String getDisplayName() {
        return Messages.LockableResourcesRootAction_PermissionGroup();
    }

    public String getUrlName() {
        return Jenkins.get().hasPermission(VIEW) ? "lockable-resources" : "";
    }

    @Exported
    @Restricted(value={NoExternalUse.class})
    public List<LockableResource> getResources() {
        return LockableResourcesManager.get().getReadOnlyResources();
    }

    @Restricted(value={NoExternalUse.class})
    public LinkedHashMap<String, LockableResourcesLabel> getLabelsList() {
        LinkedHashMap<String, LockableResourcesLabel> map = new LinkedHashMap<String, LockableResourcesLabel>();
        for (LockableResource r : LockableResourcesManager.get().getReadOnlyResources()) {
            List<String> assignedLabels;
            if (r == null || r.getName().isEmpty() || (assignedLabels = r.getLabelsAsList()).isEmpty()) continue;
            for (String labelString : assignedLabels) {
                if (labelString == null || labelString.isEmpty()) continue;
                LockableResourcesLabel label = map.get(labelString);
                if (label == null) {
                    label = new LockableResourcesLabel(labelString);
                }
                label.update(r);
                map.put(labelString, label);
            }
        }
        return map;
    }

    @Restricted(value={NoExternalUse.class})
    public LockableResource getResource(String resourceName) {
        return LockableResourcesManager.get().fromName(resourceName);
    }

    @Restricted(value={NoExternalUse.class})
    @Deprecated
    public int getFreeResourceAmount(String labelString) {
        this.informPerformanceIssue();
        LockableResourcesLabel label = this.getLabelsList().get(labelString);
        return label == null ? 0 : label.getFree();
    }

    @Restricted(value={NoExternalUse.class})
    @Deprecated
    public int getFreeResourcePercentage(String labelString) {
        this.informPerformanceIssue();
        LockableResourcesLabel label = this.getLabelsList().get(labelString);
        return label == null ? 0 : label.getPercentage();
    }

    @Restricted(value={NoExternalUse.class})
    @Deprecated
    public Set<String> getAllLabels() {
        this.informPerformanceIssue();
        return LockableResourcesManager.get().getAllLabels();
    }

    @Restricted(value={NoExternalUse.class})
    @Deprecated
    public int getNumberOfAllLabels() {
        this.informPerformanceIssue();
        return this.getLabelsList().size();
    }

    @Restricted(value={NoExternalUse.class})
    @Deprecated
    public int getAssignedResourceAmount(String labelString) {
        this.informPerformanceIssue();
        return LockableResourcesManager.get().getResourcesWithLabel(labelString).size();
    }

    private void informPerformanceIssue() {
        String method = Thread.currentThread().getStackTrace()[2].getMethodName();
        StringBuilder buf = new StringBuilder();
        for (StackTraceElement st : Thread.currentThread().getStackTrace()) {
            buf.append("\n").append(st);
        }
        LOGGER.warning("lockable-resources-plugin: The method " + method + " has been deprecated due performance issues. When you see this message, please inform plugin developers:" + String.valueOf(buf));
    }

    @Restricted(value={NoExternalUse.class})
    public Queue getQueue() throws Descriptor.FormException {
        List<QueuedContextStruct> currentQueueContext = List.copyOf(LockableResourcesManager.get().getCurrentQueuedContext());
        Queue queue = new Queue();
        for (QueuedContextStruct context : currentQueueContext) {
            for (LockableResourcesStruct resourceStruct : context.getResources()) {
                queue.add(resourceStruct, context);
            }
        }
        return queue;
    }

    @Restricted(value={NoExternalUse.class})
    @Deprecated
    public List<QueuedContextStruct> getCurrentQueuedContext() {
        return LockableResourcesManager.get().getCurrentQueuedContext();
    }

    @Restricted(value={NoExternalUse.class})
    @Deprecated
    @CheckForNull
    public LockableResourcesStruct getOldestQueue() {
        LockableResourcesStruct oldest = null;
        for (QueuedContextStruct context : this.getCurrentQueuedContext()) {
            for (LockableResourcesStruct resourceStruct : context.getResources()) {
                if (resourceStruct.queuedAt == 0L || oldest != null && oldest.queuedAt <= resourceStruct.queuedAt) continue;
                oldest = resourceStruct;
            }
        }
        return oldest;
    }

    @RequirePOST
    public void doUnlock(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(UNLOCK);
        List<LockableResource> resources = this.getResourcesFromRequest(req, rsp);
        if (resources == null) {
            return;
        }
        LockableResourcesManager.get().unlockResources(resources);
        rsp.forwardToPreviousPage(req);
    }

    @RequirePOST
    public void doReserve(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(RESERVE);
        List<LockableResource> resources = this.getResourcesFromRequest(req, rsp);
        if (resources == null) {
            return;
        }
        String userName = this.getUserName();
        if (userName != null && !LockableResourcesManager.get().reserve(resources, userName)) {
            rsp.sendError(423, Messages.error_resourceAlreadyLocked(LockableResourcesManager.getResourcesNames(resources)));
            return;
        }
        rsp.forwardToPreviousPage(req);
    }

    @RequirePOST
    public void doSteal(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(STEAL);
        List<LockableResource> resources = this.getResourcesFromRequest(req, rsp);
        if (resources == null) {
            return;
        }
        String userName = this.getUserName();
        if (userName != null) {
            LockableResourcesManager.get().steal(resources, userName);
        }
        rsp.forwardToPreviousPage(req);
    }

    @RequirePOST
    public void doReassign(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(STEAL);
        String userName = this.getUserName();
        if (userName == null) {
            throw new AccessDeniedException3(Jenkins.getAuthentication2(), STEAL);
        }
        List<LockableResource> resources = this.getResourcesFromRequest(req, rsp);
        if (resources == null) {
            return;
        }
        for (LockableResource resource : resources) {
            if (!userName.equals(resource.getReservedBy())) continue;
            return;
        }
        LockableResourcesManager.get().reassign(resources, userName);
        rsp.forwardToPreviousPage(req);
    }

    @RequirePOST
    public void doUnreserve(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(RESERVE);
        List<LockableResource> resources = this.getResourcesFromRequest(req, rsp);
        if (resources == null) {
            return;
        }
        String userName = this.getUserName();
        for (LockableResource resource : resources) {
            if (userName != null && userName.equals(resource.getReservedBy()) || Jenkins.get().hasPermission(Jenkins.ADMINISTER)) continue;
            throw new AccessDeniedException3(Jenkins.getAuthentication2(), RESERVE);
        }
        LockableResourcesManager.get().unreserve(resources);
        rsp.forwardToPreviousPage(req);
    }

    @RequirePOST
    public void doReset(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(UNLOCK);
        List<LockableResource> resources = this.getResourcesFromRequest(req, rsp);
        if (resources == null) {
            return;
        }
        LockableResourcesManager.get().reset(resources);
        rsp.forwardToPreviousPage(req);
    }

    @RequirePOST
    public void doSaveNote(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        LockableResource resource;
        Jenkins.get().checkPermission(RESERVE);
        String resourceName = req.getParameter("resource");
        if (resourceName == null) {
            resourceName = req.getParameter("resourceName");
        }
        if ((resource = this.getResource(resourceName)) == null) {
            rsp.sendError(404, Messages.error_resourceDoesNotExist(resourceName));
        } else {
            String resourceNote = req.getParameter("note");
            if (resourceNote == null) {
                resourceNote = req.getParameter("resourceNote");
            }
            resource.setNote(resourceNote);
            LockableResourcesManager.get().save();
            rsp.forwardToPreviousPage(req);
        }
    }

    @Restricted(value={NoExternalUse.class})
    @RequirePOST
    public void doChangeQueueOrder(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        int newIndex;
        Jenkins.get().checkPermission(QUEUE);
        String queueId = req.getParameter("id");
        String newIndexStr = req.getParameter("index");
        LOGGER.fine("doChangeQueueOrder, id: " + queueId + " newIndexStr: " + newIndexStr);
        try {
            newIndex = Integer.parseInt(newIndexStr);
        }
        catch (NumberFormatException e) {
            rsp.sendError(423, Messages.error_isNotANumber(newIndexStr));
            return;
        }
        try {
            LockableResourcesManager.get().changeQueueOrder(queueId, newIndex - 1);
        }
        catch (IOException e) {
            rsp.sendError(423, e.toString().replace("java.io.IOException: ", ""));
            return;
        }
        rsp.forwardToPreviousPage(req);
    }

    private List<LockableResource> getResourcesFromRequest(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        String name = req.getParameter("resource");
        LockableResource r = LockableResourcesManager.get().fromName(name);
        if (r == null) {
            rsp.sendError(404, Messages.error_resourceDoesNotExist(name));
            return null;
        }
        ArrayList<LockableResource> resources = new ArrayList<LockableResource>();
        resources.add(r);
        return resources;
    }

    public static class LockableResourcesLabel {
        String name;
        int free;
        int assigned;

        public LockableResourcesLabel(String _name) {
            this.name = _name;
            this.free = 0;
            this.assigned = 0;
        }

        public void update(LockableResource resource) {
            ++this.assigned;
            if (resource.isFree()) {
                ++this.free;
            }
        }

        public String getName() {
            return this.name;
        }

        public int getFree() {
            return this.free;
        }

        public int getAssigned() {
            return this.assigned;
        }

        public int getPercentage() {
            if (this.assigned == 0) {
                return this.assigned;
            }
            return (int)((double)this.free / (double)this.assigned * 100.0);
        }
    }

    public static class Queue {
        List<QueueStruct> queue = new ArrayList<QueueStruct>();
        QueueStruct oldest;

        @Restricted(value={NoExternalUse.class})
        public Queue() {
        }

        @Restricted(value={NoExternalUse.class})
        public void add(LockableResourcesStruct resourceStruct, QueuedContextStruct context) throws Descriptor.FormException {
            QueueStruct queueStruct = new QueueStruct(resourceStruct, context);
            this.queue.add(queueStruct);
            if (resourceStruct.queuedAt == 0L) {
                return;
            }
            if (this.oldest == null || this.oldest.getQueuedAt() > queueStruct.getQueuedAt()) {
                this.oldest = queueStruct;
            }
        }

        @Restricted(value={NoExternalUse.class})
        public List<QueueStruct> getAll() {
            return Collections.unmodifiableList(this.queue);
        }

        @Restricted(value={NoExternalUse.class})
        public QueueStruct getOldest() {
            return this.oldest;
        }

        @Restricted(value={NoExternalUse.class})
        public static class QueueStruct {
            List<LockableResource> requiredResources;
            String requiredLabel;
            String groovyScript;
            String requiredNumber;
            long queuedAt = 0L;
            int priority = 0;
            String id = null;
            Run<?, ?> build;

            public QueueStruct(LockableResourcesStruct resourceStruct, QueuedContextStruct context) throws Descriptor.FormException {
                this.requiredResources = resourceStruct.required;
                this.requiredLabel = resourceStruct.label;
                this.requiredNumber = resourceStruct.requiredNumber;
                this.queuedAt = resourceStruct.queuedAt;
                this.build = context.getBuild();
                this.priority = context.getPriority();
                this.id = context.getId();
                SecureGroovyScript systemGroovyScript = resourceStruct.getResourceMatchScript();
                if (systemGroovyScript != null) {
                    this.groovyScript = systemGroovyScript.getScript();
                }
            }

            @Restricted(value={NoExternalUse.class})
            public List<LockableResource> getRequiredResources() {
                return this.requiredResources;
            }

            @Restricted(value={NoExternalUse.class})
            @NonNull
            public String getRequiredLabel() {
                return this.requiredLabel == null ? "N/A" : this.requiredLabel;
            }

            @Restricted(value={NoExternalUse.class})
            @NonNull
            public String getRequiredNumber() {
                return this.requiredNumber == null ? "0" : this.requiredNumber;
            }

            @Restricted(value={NoExternalUse.class})
            @NonNull
            public String getGroovyScript() {
                return this.groovyScript == null ? "N/A" : this.groovyScript;
            }

            @Restricted(value={NoExternalUse.class})
            public Run<?, ?> getBuild() {
                return this.build;
            }

            @Restricted(value={NoExternalUse.class})
            public long getQueuedAt() {
                return this.queuedAt;
            }

            @Restricted(value={NoExternalUse.class})
            public boolean takeTooLong() {
                return new Date().getTime() - this.queuedAt > 3600000L;
            }

            @Restricted(value={NoExternalUse.class})
            public Date getQueuedTimestamp() {
                return new Date(this.queuedAt);
            }

            @Restricted(value={NoExternalUse.class})
            public int getPriority() {
                if (this.id == null) {
                    return 0;
                }
                return this.priority;
            }

            @Restricted(value={NoExternalUse.class})
            public String getId() {
                if (this.id == null) {
                    return "NN";
                }
                return this.id;
            }

            @Restricted(value={NoExternalUse.class})
            public boolean resourcesMatch() {
                return this.requiredResources != null && this.requiredResources.size() > 0;
            }

            @Restricted(value={NoExternalUse.class})
            public boolean labelsMatch() {
                return this.requiredLabel != null;
            }

            @Restricted(value={NoExternalUse.class})
            public boolean scriptMatch() {
                return this.groovyScript != null && !this.groovyScript.isEmpty();
            }
        }
    }
}

