/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.logs;

import java.util.Arrays;
import org.apache.activemq.artemis.logs.ActiveMQUtilLogger;
import org.slf4j.Logger;

public class ActiveMQUtilLogger_impl
implements ActiveMQUtilLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQUtilLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void startingService(String component) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ201000: Network is healthy, starting service {}", (Object)component);
        }
    }

    @Override
    public void stoppingService(String component) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ201001: Network is unhealthy, stopping service {}", (Object)component);
        }
    }

    @Override
    public void addressloopback(String address) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ202001: {} is a loopback address and will be discarded.", (Object)address);
        }
    }

    @Override
    public void addressWasntReacheable(String address) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ202002: Ping Address {} wasn't reacheable.", (Object)address);
        }
    }

    @Override
    public void urlWasntReacheable(String url) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ202003: Ping Url {} wasn't reacheable.", (Object)url);
        }
    }

    @Override
    public void errorStartingComponent(String component, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ202004: Error starting component {} ", (Object)component, (Object)e);
        }
    }

    @Override
    public void errorStoppingComponent(String component, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ202005: Error stopping component {} ", (Object)component, (Object)e);
        }
    }

    @Override
    public void failedToCheckURL(String url, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ202006: Failed to check Url {}.", (Object)url, (Object)e);
        }
    }

    @Override
    public void failedToCheckAddress(String address, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ202007: Failed to check Address {}.", (Object)address, (Object)e);
        }
    }

    @Override
    public void failedToParseAddressList(String addressList, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ202008: Failed to check Address list {}.", (Object)addressList, (Object)e);
        }
    }

    @Override
    public void failedToParseUrlList(String urlList, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ202009: Failed to check Url list {}.", (Object)urlList, (Object)e);
        }
    }

    @Override
    public void failedToSetNIC(String nic, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ202010: Failed to set NIC {}.", (Object)nic, (Object)e);
        }
    }

    @Override
    public void failedToReadFromStream(String stream) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ202011: Failed to read from stream {}.", (Object)stream);
        }
    }

    @Override
    public void failedToSerializeObject(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ202012: Object cannot be serialized.", e);
        }
    }

    @Override
    public void failedToCleanupFile(String file) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ202015: Failed to clean up file {}", (Object)file);
        }
    }

    @Override
    public void failedListFilesToCleanup(String path) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ202016: Could not list files to clean up in {}", (Object)path);
        }
    }

    @Override
    public void deprecatedDefaultCodecTwoWayAlgorithm() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ202017: Algorithm two-way is deprecated and will be removed from the default codec in a future version. Use a custom codec instead. Consult the manual for details.");
        }
    }
}

