/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.BaseMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Bits;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArray;

public class LongMessage
extends BaseMessage {
    protected long value;

    public LongMessage() {
    }

    public LongMessage(Address dest, long v) {
        super(dest);
        this.value = v;
    }

    public long getValue() {
        return this.value;
    }

    public LongMessage setValue(long v) {
        this.value = v;
        return this;
    }

    @Override
    public short getType() {
        return 4;
    }

    @Override
    public boolean hasPayload() {
        return true;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLength() {
        return Bits.size(this.value);
    }

    @Override
    public LongMessage setArray(byte[] b, int o, int l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LongMessage setArray(ByteArray b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject() {
        return (T)Long.valueOf(this.value);
    }

    @Override
    public LongMessage setObject(Object obj) {
        Number v = (Number)obj;
        this.value = v.longValue();
        return this;
    }

    @Override
    public Supplier<? extends Message> create() {
        return LongMessage::new;
    }

    @Override
    protected Message copyPayload(Message copy) {
        ((LongMessage)copy).setValue(this.value);
        return copy;
    }

    @Override
    public void writePayload(DataOutput out) throws IOException {
        Bits.writeLongCompressed(this.value, out);
    }

    @Override
    public void readPayload(DataInput in) throws IOException, ClassNotFoundException {
        this.value = Bits.readLongCompressed(in);
    }

    @Override
    public int size() {
        return super.size() + Bits.size(this.value);
    }

    @Override
    public String toString() {
        return super.toString() + " value=" + this.value;
    }
}

