/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue;

import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.queue.QueueServiceClient;
import java.time.Duration;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.azure.storage.queue.QueueComponent;
import org.apache.camel.component.azure.storage.queue.QueueConfiguration;
import org.apache.camel.component.azure.storage.queue.QueueOperationDefinition;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class QueueComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private QueueConfiguration getOrCreateConfiguration(QueueComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new QueueConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        QueueComponent target = (QueueComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)QueueComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)QueueComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)QueueComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((QueueConfiguration)QueueComponentConfigurer.property((CamelContext)camelContext, QueueConfiguration.class, (Object)value));
                return true;
            }
            case "credentials": {
                this.getOrCreateConfiguration(target).setCredentials((StorageSharedKeyCredential)QueueComponentConfigurer.property((CamelContext)camelContext, StorageSharedKeyCredential.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)QueueComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxmessages": 
            case "maxMessages": {
                this.getOrCreateConfiguration(target).setMaxMessages((Integer)QueueComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((QueueOperationDefinition)((Object)QueueComponentConfigurer.property((CamelContext)camelContext, QueueOperationDefinition.class, (Object)value)));
                return true;
            }
            case "serviceclient": 
            case "serviceClient": {
                this.getOrCreateConfiguration(target).setServiceClient((QueueServiceClient)QueueComponentConfigurer.property((CamelContext)camelContext, QueueServiceClient.class, (Object)value));
                return true;
            }
            case "timetolive": 
            case "timeToLive": {
                this.getOrCreateConfiguration(target).setTimeToLive((Duration)QueueComponentConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value));
                return true;
            }
            case "timeout": {
                this.getOrCreateConfiguration(target).setTimeout((Duration)QueueComponentConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value));
                return true;
            }
            case "visibilitytimeout": 
            case "visibilityTimeout": {
                this.getOrCreateConfiguration(target).setVisibilityTimeout((Duration)QueueComponentConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessKey", String.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("bridgeErrorHandler", Boolean.TYPE);
        answer.put("configuration", QueueConfiguration.class);
        answer.put("credentials", StorageSharedKeyCredential.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("maxMessages", Integer.class);
        answer.put("operation", QueueOperationDefinition.class);
        answer.put("serviceClient", QueueServiceClient.class);
        answer.put("timeToLive", Duration.class);
        answer.put("timeout", Duration.class);
        answer.put("visibilityTimeout", Duration.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        QueueComponent target = (QueueComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "credentials": {
                return this.getOrCreateConfiguration(target).getCredentials();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxmessages": 
            case "maxMessages": {
                return this.getOrCreateConfiguration(target).getMaxMessages();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "serviceclient": 
            case "serviceClient": {
                return this.getOrCreateConfiguration(target).getServiceClient();
            }
            case "timetolive": 
            case "timeToLive": {
                return this.getOrCreateConfiguration(target).getTimeToLive();
            }
            case "timeout": {
                return this.getOrCreateConfiguration(target).getTimeout();
            }
            case "visibilitytimeout": 
            case "visibilityTimeout": {
                return this.getOrCreateConfiguration(target).getVisibilityTimeout();
            }
        }
        return null;
    }
}

