/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue.operations;

import com.azure.core.http.rest.Response;
import com.azure.storage.queue.models.SendMessageResult;
import com.azure.storage.queue.models.UpdateMessageResult;
import java.time.Duration;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.queue.QueueConfiguration;
import org.apache.camel.component.azure.storage.queue.QueueExchangeHeaders;
import org.apache.camel.component.azure.storage.queue.client.QueueClientWrapper;
import org.apache.camel.component.azure.storage.queue.operations.QueueOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class QueueOperations {
    private final QueueConfiguration configuration;
    private final QueueClientWrapper client;

    public QueueOperations(QueueConfiguration configuration, QueueClientWrapper client) {
        ObjectHelper.notNull((Object)client, (String)"client can not be null.");
        this.configuration = configuration;
        this.client = client;
    }

    public QueueOperationResponse createQueue(Exchange exchange) {
        if (exchange == null) {
            return this.buildResponseWithEmptyBody(this.client.create(null, this.configuration.getTimeout()));
        }
        Map<String, String> metadata = QueueExchangeHeaders.getMetadataFromHeaders(exchange);
        Duration timeout = this.getTimeout(exchange);
        return this.buildResponseWithEmptyBody(this.client.create(metadata, timeout));
    }

    public QueueOperationResponse clearQueue(Exchange exchange) {
        if (exchange == null) {
            return this.buildResponseWithEmptyBody(this.client.clearMessages(this.configuration.getTimeout()));
        }
        Duration timeout = this.getTimeout(exchange);
        return this.buildResponseWithEmptyBody(this.client.clearMessages(timeout));
    }

    public QueueOperationResponse deleteQueue(Exchange exchange) {
        if (exchange == null) {
            return this.buildResponseWithEmptyBody(this.client.delete(this.configuration.getTimeout()));
        }
        Duration timeout = this.getTimeout(exchange);
        return this.buildResponseWithEmptyBody(this.client.delete(timeout));
    }

    public QueueOperationResponse sendMessage(Exchange exchange) {
        ObjectHelper.notNull((Object)exchange, (String)"exchange cannot be null");
        boolean queueCreated = QueueExchangeHeaders.getQueueCreatedFlagFromHeaders(exchange);
        if (!queueCreated) {
            this.createQueue(exchange);
        }
        String text = QueueExchangeHeaders.getMessageTextFromHeaders(exchange);
        Duration visibilityTimeout = this.getVisibilityTimeout(exchange);
        Duration timeToLive = this.getTimeToLive(exchange);
        Duration timeout = this.getTimeout(exchange);
        return this.buildResponseWithEmptyBody(this.client.sendMessage(text, visibilityTimeout, timeToLive, timeout));
    }

    public QueueOperationResponse deleteMessage(Exchange exchange) {
        ObjectHelper.notNull((Object)exchange, (String)"exchange cannot be null");
        String messageId = QueueExchangeHeaders.getMessageIdFromHeaders(exchange);
        String popReceipt = QueueExchangeHeaders.getPopReceiptFromHeaders(exchange);
        Duration timeout = this.getTimeout(exchange);
        if (ObjectHelper.isEmpty((Object)messageId)) {
            throw new IllegalArgumentException(String.format("Message ID must be specified in camel headers '%s' for deleteMessage operation.", "CamelAzureStorageQueueMessageId"));
        }
        if (ObjectHelper.isEmpty((Object)popReceipt)) {
            throw new IllegalArgumentException(String.format("Message Pop Receipt must be specified in camel headers '%s' for deleteMessage operation.", "CamelAzureStorageQueuePopReceipt"));
        }
        return this.buildResponseWithEmptyBody(this.client.deleteMessage(messageId, popReceipt, timeout));
    }

    public QueueOperationResponse receiveMessages(Exchange exchange) {
        if (exchange == null) {
            return new QueueOperationResponse(this.client.receiveMessages(this.configuration.getMaxMessages(), this.configuration.getVisibilityTimeout(), this.configuration.getTimeout()));
        }
        Integer maxMessages = this.getMaxMessages(exchange);
        Duration visibilityTimeout = this.getVisibilityTimeout(exchange);
        Duration timeout = this.getTimeout(exchange);
        return new QueueOperationResponse(this.client.receiveMessages(maxMessages, visibilityTimeout, timeout));
    }

    public QueueOperationResponse peekMessages(Exchange exchange) {
        if (exchange == null) {
            return new QueueOperationResponse(this.client.peekMessages(this.configuration.getMaxMessages(), this.configuration.getTimeout()));
        }
        Integer maxMessages = this.getMaxMessages(exchange);
        Duration timeout = this.getTimeout(exchange);
        return new QueueOperationResponse(this.client.peekMessages(maxMessages, timeout));
    }

    public QueueOperationResponse updateMessage(Exchange exchange) {
        ObjectHelper.notNull((Object)exchange, (String)"exchange cannot be null");
        String updatedText = QueueExchangeHeaders.getMessageTextFromHeaders(exchange);
        String messageId = QueueExchangeHeaders.getMessageIdFromHeaders(exchange);
        String popReceipt = QueueExchangeHeaders.getPopReceiptFromHeaders(exchange);
        Duration visibilityTimeout = this.getVisibilityTimeout(exchange);
        Duration timeout = this.getTimeout(exchange);
        if (ObjectHelper.isEmpty((Object)messageId)) {
            throw new IllegalArgumentException(String.format("Message ID must be specified in camel headers '%s' for updateMessage operation.", "CamelAzureStorageQueueMessageId"));
        }
        if (ObjectHelper.isEmpty((Object)popReceipt)) {
            throw new IllegalArgumentException(String.format("Message Pop Receipt must be specified in camel headers '%s' for updateMessage operation.", "CamelAzureStorageQueuePopReceipt"));
        }
        if (ObjectHelper.isEmpty((Object)visibilityTimeout)) {
            throw new IllegalArgumentException(String.format("Visibility Timeout must be specified in camel headers '%s' for updateMessage operation.", "CamelAzureStorageQueueVisibilityTimeout"));
        }
        Response<UpdateMessageResult> response = this.client.updateMessage(messageId, popReceipt, updatedText, visibilityTimeout, timeout);
        QueueExchangeHeaders headers = new QueueExchangeHeaders().timeNextVisible(((UpdateMessageResult)response.getValue()).getTimeNextVisible()).popReceipt(((UpdateMessageResult)response.getValue()).getPopReceipt()).httpHeaders(response.getHeaders());
        return new QueueOperationResponse(true, headers.toMap());
    }

    private QueueOperationResponse buildResponseWithEmptyBody(Response response) {
        return this.buildResponse(response, true);
    }

    private QueueOperationResponse buildResponse(Response response, boolean emptyBody) {
        Object body = emptyBody ? Boolean.valueOf(true) : response.getValue();
        QueueExchangeHeaders exchangeHeaders = response.getValue() instanceof SendMessageResult ? QueueExchangeHeaders.createQueueExchangeHeadersFromSendMessageResult((SendMessageResult)response.getValue()) : new QueueExchangeHeaders();
        exchangeHeaders.httpHeaders(response.getHeaders());
        return new QueueOperationResponse(body, exchangeHeaders.toMap());
    }

    private Duration getVisibilityTimeout(Exchange exchange) {
        return ObjectHelper.isEmpty((Object)QueueExchangeHeaders.getVisibilityTimeout(exchange)) ? this.configuration.getVisibilityTimeout() : QueueExchangeHeaders.getVisibilityTimeout(exchange);
    }

    private Duration getTimeToLive(Exchange exchange) {
        return ObjectHelper.isEmpty((Object)QueueExchangeHeaders.getTimeToLiveFromHeaders(exchange)) ? this.configuration.getTimeToLive() : QueueExchangeHeaders.getTimeToLiveFromHeaders(exchange);
    }

    private Duration getTimeout(Exchange exchange) {
        return ObjectHelper.isEmpty((Object)QueueExchangeHeaders.getTimeoutFromHeaders(exchange)) ? this.configuration.getTimeout() : QueueExchangeHeaders.getTimeoutFromHeaders(exchange);
    }

    private Integer getMaxMessages(Exchange exchange) {
        return ObjectHelper.isEmpty((Object)QueueExchangeHeaders.getMaxMessagesFromHeaders(exchange)) ? this.configuration.getMaxMessages() : QueueExchangeHeaders.getMaxMessagesFromHeaders(exchange);
    }
}

