/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.directvm.DirectVmEndpoint;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;

public final class DirectVmProcessor
extends DelegateAsyncProcessor {
    private final DirectVmEndpoint endpoint;

    public DirectVmProcessor(Processor processor, DirectVmEndpoint endpoint) {
        super(processor);
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        final Exchange copy = this.prepareExchange(exchange);
        final ClassLoader current = Thread.currentThread().getContextClassLoader();
        boolean changed = false;
        try {
            ClassLoader appClassLoader = this.endpoint.getCamelContext().getApplicationContextClassLoader();
            if (appClassLoader != null) {
                this.log.trace("Setting Thread ContextClassLoader to {}", (Object)appClassLoader);
                Thread.currentThread().setContextClassLoader(appClassLoader);
                changed = true;
            }
            final boolean chgd = changed;
            boolean bl = this.processor.process(copy, new AsyncCallback(){

                public void done(boolean done) {
                    try {
                        if (chgd) {
                            DirectVmProcessor.this.log.trace("Restoring Thread ContextClassLoader to {}", (Object)current);
                            Thread.currentThread().setContextClassLoader(current);
                        }
                        ExchangeHelper.copyResults((Exchange)exchange, (Exchange)copy);
                    }
                    finally {
                        callback.done(done);
                    }
                }
            });
            return bl;
        }
        finally {
            if (changed) {
                this.log.trace("Restoring Thread ContextClassLoader to {}", (Object)current);
                Thread.currentThread().setContextClassLoader(current);
            }
        }
    }

    protected Exchange prepareExchange(Exchange exchange) {
        Exchange newExchange = ExchangeHelper.copyExchangeAndSetCamelContext((Exchange)exchange, (CamelContext)this.endpoint.getCamelContext(), (boolean)false);
        newExchange.setFromEndpoint((Endpoint)this.endpoint);
        if (newExchange.getProperty("CamelStreamCacheUnitOfWork") == null) {
            newExchange.setProperty("CamelStreamCacheUnitOfWork", (Object)exchange.getUnitOfWork());
        }
        return newExchange;
    }

    public String toString() {
        return "DirectVm[" + this.processor + "]";
    }
}

