/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.ehcache.EhcacheConfiguration;
import org.apache.camel.component.ehcache.EhcacheEndpoint;
import org.apache.camel.component.ehcache.EhcacheManager;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheComponent
extends DefaultComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheComponent.class);
    private final ConcurrentMap<Object, EhcacheManager> managers = new ConcurrentHashMap<Object, EhcacheManager>();
    @Metadata(label="advanced")
    private EhcacheConfiguration configuration = new EhcacheConfiguration();

    public EhcacheComponent() {
    }

    public EhcacheComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        EhcacheConfiguration configuration = this.configuration.copy();
        this.setProperties(configuration, parameters);
        return new EhcacheEndpoint(uri, this, remaining, this.createCacheManager(configuration), configuration);
    }

    private EhcacheManager createCacheManager(EhcacheConfiguration configuration) throws IOException {
        ObjectHelper.notNull((Object)configuration, (String)"Camel Ehcache configuration");
        if (configuration.hasCacheManager()) {
            LOGGER.info("EhcacheManager configured with supplied CacheManager");
            return this.managers.computeIfAbsent(configuration.getCacheManager(), m -> new EhcacheManager((CacheManager)CacheManager.class.cast(m), false, configuration));
        }
        if (configuration.hasCacheManagerConfiguration()) {
            LOGGER.info("EhcacheManager configured with supplied CacheManagerConfiguration");
            return this.managers.computeIfAbsent(configuration.getCacheManagerConfiguration(), c -> new EhcacheManager(CacheManagerBuilder.newCacheManager((Configuration)((Configuration)Configuration.class.cast(c))), true, configuration));
        }
        if (configuration.hasConfigurationUri()) {
            String configurationUri = configuration.getConfigurationUri();
            ClassResolver classResolver = this.getCamelContext().getClassResolver();
            URL url = ResourceHelper.resolveMandatoryResourceAsUrl((ClassResolver)classResolver, (String)configurationUri);
            LOGGER.info("EhcacheManager configured with supplied URI {}", (Object)url);
            return this.managers.computeIfAbsent(url, u -> new EhcacheManager(CacheManagerBuilder.newCacheManager((Configuration)new XmlConfiguration((URL)URL.class.cast(u))), true, configuration));
        }
        LOGGER.info("EhcacheManager configured with default builder");
        return new EhcacheManager(CacheManagerBuilder.newCacheManagerBuilder().build(), true, configuration);
    }

    public EhcacheConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EhcacheConfiguration configuration) {
        ObjectHelper.notNull((Object)configuration, (String)"EhcacheConfiguration");
        this.configuration = configuration;
    }

    public CacheManager getCacheManager() {
        return this.configuration.getCacheManager();
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.configuration.setCacheManager(cacheManager);
    }

    public Configuration getCacheManagerConfiguration() {
        return this.configuration.getCacheManagerConfiguration();
    }

    public void setCacheManagerConfiguration(Configuration cacheManagerConfiguration) {
        this.configuration.setCacheManagerConfiguration(cacheManagerConfiguration);
    }

    public void setCacheConfiguration(CacheConfiguration<?, ?> cacheConfiguration) {
        this.configuration.setConfiguration(cacheConfiguration);
    }

    public CacheConfiguration<?, ?> getCacheConfiguration() {
        return this.configuration.getConfiguration();
    }

    public Map<String, CacheConfiguration<?, ?>> getCachesConfigurations() {
        return this.configuration.getConfigurations();
    }

    public void setCachesConfigurations(Map<String, CacheConfiguration<?, ?>> configurations) {
        this.configuration.setConfigurations(configurations);
    }

    public void addCachesConfigurations(Map<String, CacheConfiguration<?, ?>> configurations) {
        this.configuration.addConfigurations(configurations);
    }

    public String getCacheConfigurationUri() {
        return this.configuration.getConfigurationUri();
    }

    public void setCacheConfigurationUri(String configurationUri) {
        this.configuration.setConfigurationUri(configurationUri);
    }
}

