/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class EhcacheEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":cacheName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "ehcache".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "cacheName", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(19);
        props.add("eventOrdering");
        props.add("configuration");
        props.add("configurations");
        props.add("synchronous");
        props.add("exchangePattern");
        props.add("cacheManagerConfiguration");
        props.add("eventTypes");
        props.add("cacheManager");
        props.add("configurationUri");
        props.add("lazyStartProducer");
        props.add("cacheName");
        props.add("bridgeErrorHandler");
        props.add("eventFiring");
        props.add("valueType");
        props.add("createCacheIfNotExist");
        props.add("action");
        props.add("keyType");
        props.add("exceptionHandler");
        props.add("key");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

