/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.jsonpath.JsonPathExpression;
import org.apache.camel.jsonpath.easypredicate.EasyPredicateParser;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.SingleInputTypedLanguageSupport;
import org.apache.camel.support.component.PropertyConfigurerSupport;

@Language(value="jsonpath")
public class JsonPathLanguage
extends SingleInputTypedLanguageSupport
implements PropertyConfigurer {
    private boolean suppressExceptions;
    private boolean allowSimple = true;
    private boolean allowEasyPredicate = true;
    private boolean writeAsString;
    private boolean unpackArray;
    private Option[] options;

    public boolean isSuppressExceptions() {
        return this.suppressExceptions;
    }

    public void setSuppressExceptions(boolean suppressExceptions) {
        this.suppressExceptions = suppressExceptions;
    }

    public boolean isAllowSimple() {
        return this.allowSimple;
    }

    public void setAllowSimple(boolean allowSimple) {
        this.allowSimple = allowSimple;
    }

    public boolean isAllowEasyPredicate() {
        return this.allowEasyPredicate;
    }

    public void setAllowEasyPredicate(boolean allowEasyPredicate) {
        this.allowEasyPredicate = allowEasyPredicate;
    }

    public boolean isWriteAsString() {
        return this.writeAsString;
    }

    public void setWriteAsString(boolean writeAsString) {
        this.writeAsString = writeAsString;
    }

    public boolean isUnpackArray() {
        return this.unpackArray;
    }

    public void setUnpackArray(boolean unpackArray) {
        this.unpackArray = unpackArray;
    }

    public Option[] getOptions() {
        return this.options;
    }

    public void setOptions(Option ... options) {
        this.options = options;
    }

    public Predicate createPredicate(Expression source, String expression, Object[] properties) {
        return this.doCreateJsonPathExpression(source, expression, properties, true);
    }

    public Expression createExpression(Expression source, String expression, Object[] properties) {
        return this.doCreateJsonPathExpression(source, expression, properties, false);
    }

    protected ExpressionAdapter doCreateJsonPathExpression(Expression source, String expression, Object[] properties, boolean predicate) {
        JsonPathExpression answer = new JsonPathExpression(expression);
        answer.setSource(source);
        answer.setPredicate(predicate);
        answer.setResultType((Class)this.property(Class.class, properties, 0, null));
        answer.setSuppressExceptions((Boolean)this.property(Boolean.TYPE, properties, 2, this.isSuppressExceptions()));
        answer.setAllowSimple((Boolean)this.property(Boolean.TYPE, properties, 3, this.isAllowSimple()));
        answer.setAllowEasyPredicate((Boolean)this.property(Boolean.TYPE, properties, 4, this.isAllowEasyPredicate()));
        answer.setWriteAsString((Boolean)this.property(Boolean.TYPE, properties, 5, this.isWriteAsString()));
        answer.setUnpackArray((Boolean)this.property(Boolean.TYPE, properties, 6, this.isUnpackArray()));
        Object option = this.property(Object.class, properties, 7, null);
        if (option != null) {
            ArrayList<Option> list = new ArrayList<Option>();
            if (option instanceof String) {
                String str = (String)option;
                for (String s : str.split(",")) {
                    list.add((Option)this.getCamelContext().getTypeConverter().convertTo(Option.class, (Object)s));
                }
            } else if (option instanceof Option) {
                Option opt = (Option)option;
                list.add(opt);
            }
            answer.setOptions(list.toArray(new Option[0]));
        } else if (this.options != null) {
            answer.setOptions(this.options);
        }
        if (this.getCamelContext() != null) {
            answer.init(this.getCamelContext());
        }
        return answer;
    }

    public boolean validateExpression(String expression) {
        JsonPath.compile((String)expression, (com.jayway.jsonpath.Predicate[])new com.jayway.jsonpath.Predicate[0]);
        return true;
    }

    public boolean validatePredicate(String expression) {
        EasyPredicateParser parser = new EasyPredicateParser();
        String exp = parser.parse(expression);
        JsonPath.compile((String)exp, (com.jayway.jsonpath.Predicate[])new com.jayway.jsonpath.Predicate[0]);
        return true;
    }

    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        if (target != this) {
            throw new IllegalStateException("Can only configure our own instance !");
        }
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "suppressexceptions": 
            case "suppressExceptions": {
                this.setSuppressExceptions((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "allowsimple": 
            case "allowSimple": {
                this.setAllowSimple((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "alloweasypredicate": 
            case "allowEasyPredicate": {
                this.setAllowEasyPredicate((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "writeasstring": 
            case "writeAsString": {
                this.setWriteAsString((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "unpackarray": 
            case "unpackArray": {
                this.setUnpackArray((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "options": {
                this.setOptions((Option[])PropertyConfigurerSupport.property((CamelContext)camelContext, Option[].class, (Object)value));
                return true;
            }
        }
        return false;
    }
}

