/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedCamelHealthMBean;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.spi.ManagementStrategy;

public class ManagedCamelHealth
implements ManagedCamelHealthMBean {
    private final CamelContext context;
    private final HealthCheckRegistry healthCheckRegistry;

    public ManagedCamelHealth(CamelContext context, HealthCheckRegistry healthCheckRegistry) {
        this.context = context;
        this.healthCheckRegistry = healthCheckRegistry;
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.context;
    }

    public boolean isEnabled() {
        return this.healthCheckRegistry.isEnabled();
    }

    public boolean isHealthy() {
        for (HealthCheck.Result result : HealthCheckHelper.invoke((CamelContext)this.context)) {
            if (result.getState() != HealthCheck.State.DOWN) continue;
            return false;
        }
        return true;
    }

    public boolean isHealthyReadiness() {
        for (HealthCheck.Result result : HealthCheckHelper.invokeReadiness((CamelContext)this.context)) {
            if (result.getState() != HealthCheck.State.DOWN) continue;
            return false;
        }
        return true;
    }

    public boolean isHealthyLiveness() {
        for (HealthCheck.Result result : HealthCheckHelper.invokeLiveness((CamelContext)this.context)) {
            if (result.getState() != HealthCheck.State.DOWN) continue;
            return false;
        }
        return true;
    }

    public Collection<String> getHealthChecksIDs() {
        return this.healthCheckRegistry.getCheckIDs();
    }

    public TabularData details() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.camelHealthDetailsTabularType());
            CompositeType type = CamelOpenMBeanTypes.camelHealthDetailsCompositeType();
            for (HealthCheck.Result result : HealthCheckHelper.invoke((CamelContext)this.context)) {
                String failureUri = result.getDetails().getOrDefault("endpoint.uri", "");
                Integer failureCount = result.getDetails().getOrDefault("failure.count", 0);
                String stacktrace = "";
                if (result.getError().isPresent()) {
                    try (StringWriter stackTraceWriter2 = new StringWriter();
                         PrintWriter pw = new PrintWriter((Writer)stackTraceWriter2, true);){
                        ((Throwable)result.getError().get()).printStackTrace(pw);
                        stacktrace = stackTraceWriter2.getBuffer().toString();
                    }
                    catch (IOException stackTraceWriter2) {
                        // empty catch block
                    }
                }
                CompositeDataSupport data = new CompositeDataSupport(type, new String[]{"id", "group", "state", "enabled", "message", "failureUri", "failureCount", "failureStackTrace", "readiness", "liveness", "interval", "successThreshold", "failureThreshold"}, new Object[]{result.getCheck().getId(), result.getCheck().getGroup(), result.getState().name(), result.getCheck().getConfiguration().isEnabled(), result.getMessage().orElse(""), failureUri, failureCount, stacktrace, result.getCheck().isReadiness(), result.getCheck().isLiveness(), result.getCheck().getConfiguration().getInterval(), result.getCheck().getConfiguration().getSuccessThreshold(), result.getCheck().getConfiguration().getFailureThreshold()});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public String invoke(String id) {
        Optional result = HealthCheckHelper.invoke((CamelContext)this.context, (String)id, Collections.emptyMap());
        return result.map(r -> r.getState().name()).orElse(HealthCheck.State.UNKNOWN.name());
    }

    public void enableById(String id) {
        Optional hc = this.healthCheckRegistry.getCheck(id);
        if (hc.isPresent()) {
            ((HealthCheck)hc.get()).getConfiguration().setEnabled(true);
        } else {
            Optional hcr = this.healthCheckRegistry.getRepository(id);
            hcr.ifPresent(repository -> repository.setEnabled(true));
        }
    }

    public void disableById(String id) {
        Optional hc = this.healthCheckRegistry.getCheck(id);
        if (hc.isPresent()) {
            ((HealthCheck)hc.get()).getConfiguration().setEnabled(false);
        } else {
            Optional hcr = this.healthCheckRegistry.getRepository(id);
            hcr.ifPresent(repository -> repository.setEnabled(false));
        }
    }
}

