/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.support.builder.ExpressionBuilder;

public class MockExpressionClauseSupport<T> {
    private T result;
    private Expression expressionValue;
    private ExpressionFactory expressionType;

    public MockExpressionClauseSupport(T result) {
        this.result = result;
    }

    public T expression(Expression expression) {
        this.setExpressionValue(expression);
        if (expression instanceof ExpressionFactory) {
            this.setExpressionType((ExpressionFactory)expression);
        }
        return this.result;
    }

    public T language(ExpressionFactory expression) {
        this.setExpressionType(expression);
        return this.result;
    }

    public T constant(Object value) {
        return this.expression(ExpressionBuilder.constantExpression((Object)value));
    }

    public T exchange() {
        return this.expression(ExpressionBuilder.exchangeExpression());
    }

    public T inMessage() {
        return this.expression(ExpressionBuilder.inMessageExpression());
    }

    public T body() {
        return this.expression(ExpressionBuilder.bodyExpression());
    }

    public T body(Class<?> expectedType) {
        return this.expression(ExpressionBuilder.bodyExpression(expectedType));
    }

    public T header(String name) {
        return this.expression(ExpressionBuilder.headerExpression((String)name));
    }

    public T headers() {
        return this.expression(ExpressionBuilder.headersExpression());
    }

    public T exchangePattern() {
        return this.expression(ExpressionBuilder.exchangePatternExpression());
    }

    public T exchangeProperty(String name) {
        return this.expression(ExpressionBuilder.exchangePropertyExpression((String)name));
    }

    public T exchangeProperties() {
        return this.expression(ExpressionBuilder.exchangePropertiesExpression());
    }

    public T method(String bean) {
        return this.expression(ExpressionBuilder.beanExpression((String)bean));
    }

    public T method(String bean, String method) {
        if (method != null) {
            return this.expression(ExpressionBuilder.languageExpression((String)"bean", (String)(bean + "?method=" + method)));
        }
        return this.method(bean);
    }

    public T groovy(String text) {
        return this.expression(ExpressionBuilder.languageExpression((String)"groovy", (String)text));
    }

    public T jsonpath(String text) {
        return this.expression(ExpressionBuilder.languageExpression((String)"jsonpath", (String)text));
    }

    public T ognl(String text) {
        return this.expression(ExpressionBuilder.languageExpression((String)"ognl", (String)text));
    }

    public T mvel(String text) {
        return this.expression(ExpressionBuilder.languageExpression((String)"mvel", (String)text));
    }

    public T ref(String ref) {
        return this.expression(ExpressionBuilder.languageExpression((String)"ref", (String)ref));
    }

    public T spel(String text) {
        return this.expression(ExpressionBuilder.languageExpression((String)"spel", (String)text));
    }

    public T simple(String text) {
        return this.expression(ExpressionBuilder.languageExpression((String)"simple", (String)text));
    }

    public T hl7terser(String text) {
        return this.expression(ExpressionBuilder.languageExpression((String)"hl7terser", (String)text));
    }

    public T xpath(String text) {
        return this.expression(ExpressionBuilder.languageExpression((String)"xpath", (String)text));
    }

    public T xquery(String text) {
        return this.expression(ExpressionBuilder.languageExpression((String)"xquery", (String)text));
    }

    public T language(String language, String expression) {
        return this.expression(ExpressionBuilder.languageExpression((String)language, (String)expression));
    }

    public Expression getExpressionValue() {
        return this.expressionValue;
    }

    public void setExpressionValue(Expression expressionValue) {
        this.expressionValue = expressionValue;
    }

    public ExpressionFactory getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(ExpressionFactory expressionType) {
        this.expressionType = expressionType;
    }

    protected Expression createExpression(CamelContext camelContext) {
        if (this.getExpressionValue() == null) {
            if (this.getExpressionType() != null) {
                this.setExpressionValue(this.getExpressionType().createExpression(camelContext));
            } else {
                throw new IllegalStateException("No expression value configured");
            }
        }
        return this.getExpressionValue();
    }

    protected void configureExpression(CamelContext camelContext, Expression expression) {
    }
}

