/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringJoiner;
import org.apache.camel.CamelContext;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.support.ResourceHelper;

public final class SqlHelper {
    private SqlHelper() {
    }

    public static String resolveQuery(CamelContext camelContext, String query, String placeholder) throws NoTypeConversionAvailableException, IOException {
        String answer = query;
        if (ResourceHelper.hasScheme((String)query)) {
            String[] lines;
            try (InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)query);){
                answer = (String)camelContext.getTypeConverter().mandatoryConvertTo(String.class, (Object)is);
            }
            if (placeholder != null) {
                answer = answer.replaceAll(placeholder, "?");
            }
            StringJoiner sj = new StringJoiner("\n");
            for (String line : lines = answer.split("\n")) {
                String trim = line.trim();
                if (trim.isEmpty() || trim.startsWith("--")) continue;
                sj.add(line);
            }
            answer = sj.toString();
        }
        return answer;
    }
}

