/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceHelper.class);

    private ResourceHelper() {
    }

    public static boolean hasScheme(String uri) {
        if (uri == null) {
            return false;
        }
        return uri.startsWith("file:") || uri.startsWith("classpath:") || uri.startsWith("http:") || uri.startsWith("https:");
    }

    public static String getScheme(String uri) {
        if (ResourceHelper.hasScheme(uri)) {
            return uri.substring(0, uri.indexOf(58) + 1);
        }
        return null;
    }

    public static InputStream resolveMandatoryResourceAsInputStream(CamelContext camelContext, String uri) throws IOException {
        InputStream is = ResourceHelper.resolveResourceAsInputStream(camelContext, uri);
        if (is == null) {
            String resolvedName = ResourceHelper.resolveUriPath(uri);
            throw new FileNotFoundException("Cannot find resource: " + resolvedName + " for URI: " + uri);
        }
        return is;
    }

    public static InputStream resolveResourceAsInputStream(CamelContext camelContext, String uri) throws IOException {
        ExtendedCamelContext ecc = (ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class);
        ResourceLoader loader = ecc.getResourceLoader();
        Resource resource = loader.resolveResource(uri);
        return resource.getInputStream();
    }

    public static URL resolveMandatoryResourceAsUrl(CamelContext camelContext, String uri) throws FileNotFoundException, MalformedURLException {
        URL url = ResourceHelper.resolveResourceAsUrl(camelContext, uri);
        if (url == null) {
            String resolvedName = ResourceHelper.resolveUriPath(uri);
            throw new FileNotFoundException("Cannot find resource: " + resolvedName + " in classpath for URI: " + uri);
        }
        return url;
    }

    public static URL resolveResourceAsUrl(CamelContext camelContext, String uri) throws MalformedURLException {
        ExtendedCamelContext ecc = (ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class);
        ResourceLoader loader = ecc.getResourceLoader();
        Resource resource = loader.resolveResource(uri);
        return resource.getURL();
    }

    public static boolean isClasspathUri(String uri) {
        if (ObjectHelper.isEmpty((Object)uri)) {
            return false;
        }
        return uri.startsWith("classpath:") || uri.indexOf(58) == -1;
    }

    public static boolean isHttpUri(String uri) {
        if (ObjectHelper.isEmpty((Object)uri)) {
            return false;
        }
        return uri.startsWith("http:") || uri.startsWith("https:");
    }

    public static String appendParameters(String uri, Map<String, Object> parameters) throws URISyntaxException {
        if (!parameters.isEmpty()) {
            String query = URISupport.createQueryString(parameters);
            URI u = new URI(uri);
            u = URISupport.createURIWithQuery((URI)u, (String)query);
            parameters.clear();
            return u.toString();
        }
        return uri;
    }

    private static String resolveUriPath(String name) {
        return FileUtil.compactPath((String)name, (char)'/');
    }

    public static Set<Path> findInFileSystem(Path root, String pattern) throws Exception {
        try (Stream<Path> path = Files.walk(root, new FileVisitOption[0]);){
            Set set = path.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(entry -> {
                Path relative = root.relativize((Path)entry);
                String str = relative.toString().replaceAll(Pattern.quote(File.separator), "/");
                boolean match = AntPathMatcher.INSTANCE.match(pattern, str);
                LOG.debug("Found resource: {} matching pattern: {} -> {}", new Object[]{entry, pattern, match});
                return match;
            }).collect(Collectors.toCollection(LinkedHashSet::new));
            return set;
        }
    }

    public static Resource fromBytes(final String location, final byte[] content) {
        return new Resource(){

            public String getLocation() {
                return location;
            }

            public boolean exists() {
                return true;
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(content);
            }
        };
    }

    public static Resource fromString(String location, String content) {
        return ResourceHelper.fromBytes(location, content.getBytes(StandardCharsets.UTF_8));
    }
}

