/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor.idempotent;

import java.util.Map;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.service.ServiceSupport;

@ManagedResource(description="Memory based idempotent repository")
public class MemoryIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    private Map<String, Object> cache;
    private int cacheSize;

    public MemoryIdempotentRepository() {
        this.cache = LRUCacheFactory.newLRUCache(1000);
    }

    public MemoryIdempotentRepository(Map<String, Object> set) {
        this.cache = set;
    }

    public static IdempotentRepository memoryIdempotentRepository() {
        return new MemoryIdempotentRepository();
    }

    public static IdempotentRepository memoryIdempotentRepository(int cacheSize) {
        return MemoryIdempotentRepository.memoryIdempotentRepository(LRUCacheFactory.newLRUCache(cacheSize));
    }

    public static IdempotentRepository memoryIdempotentRepository(Map<String, Object> cache) {
        return new MemoryIdempotentRepository(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String key) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            if (this.cache.containsKey(key)) {
                return false;
            }
            this.cache.put(key, key);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            return this.cache.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            return this.cache.remove(key) != null;
        }
    }

    public boolean confirm(String key) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Clear the store")
    public void clear() {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    public Map<String, Object> getCache() {
        return this.cache;
    }

    @ManagedAttribute(description="The current cache size")
    public int getCacheSize() {
        return this.cache.size();
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    protected void doStart() throws Exception {
        if (this.cacheSize > 0) {
            this.cache = LRUCacheFactory.newLRUCache(this.cacheSize);
        }
    }

    protected void doStop() throws Exception {
        this.cache.clear();
    }
}

