/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.Scanner;

public final class GroupTokenIterator
implements Iterator<Object>,
Closeable {
    private final CamelContext camelContext;
    private final Exchange exchange;
    private final Iterator<?> it;
    private final String token;
    private final int group;
    private final boolean skipFirst;
    private final AtomicBoolean hasSkipFirst;
    private boolean closed;
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream();

    public GroupTokenIterator(Exchange exchange, Iterator<?> it, String token, int group, boolean skipFirst) {
        this.exchange = exchange;
        this.camelContext = exchange.getContext();
        this.it = it;
        this.token = LanguageSupport.hasSimpleFunction(token) && it instanceof Scanner ? ((Scanner)it).getDelim() : token;
        this.group = group;
        if (group <= 0) {
            throw new IllegalArgumentException("Group must be a positive number, was: " + group);
        }
        this.skipFirst = skipFirst;
        this.hasSkipFirst = skipFirst ? new AtomicBoolean() : null;
    }

    @Override
    public void close() throws IOException {
        try {
            IOHelper.closeIterator(this.it);
        }
        finally {
            this.bos.close();
            this.closed = true;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        boolean answer = this.it.hasNext();
        if (!answer) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return answer;
    }

    @Override
    public Object next() {
        try {
            return this.doNext();
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    private Object doNext() throws IOException, NoTypeConversionAvailableException {
        for (int count = 0; count < this.group && this.it.hasNext(); ++count) {
            InputStream is;
            Object data = this.it.next();
            if (this.skipFirst && this.hasSkipFirst.compareAndSet(false, true)) {
                data = this.it.hasNext() ? this.it.next() : "";
            }
            if (data != null && count > 0 && this.token != null) {
                this.bos.write(this.token.getBytes());
            }
            if (data instanceof InputStream) {
                is = (InputStream)data;
                IOHelper.copy((InputStream)is, (OutputStream)this.bos);
                continue;
            }
            if (data instanceof byte[]) {
                byte[] bytes = (byte[])data;
                this.bos.write(bytes);
                continue;
            }
            if (data == null) continue;
            is = (InputStream)this.camelContext.getTypeConverter().mandatoryConvertTo(InputStream.class, this.exchange, data);
            IOHelper.copy((InputStream)is, (OutputStream)this.bos);
        }
        String answer = this.bos.toString(ExchangeHelper.getCharset(this.exchange));
        this.bos.reset();
        return answer;
    }

    @Override
    public void remove() {
        this.it.remove();
    }
}

