/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.converter.jaxp.StaxConverter;
import org.apache.camel.converter.jaxp.XMLReaderPool;
import org.apache.camel.converter.jaxp.XmlErrorListener;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.builder.xml.StAX2SAXSource;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.xml.BytesSource;
import org.apache.camel.util.xml.StringSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

@Converter(generateBulkLoader=true)
public class XmlConverter {
    public static final String OUTPUT_PROPERTIES_PREFIX = "org.apache.camel.xmlconverter.output.";
    public static final String DOCUMENT_BUILDER_FACTORY_FEATURE = "org.apache.camel.xmlconverter.documentBuilderFactory.feature";
    public static String defaultCharset = ObjectHelper.getSystemProperty((String)"org.apache.camel.default.charset", (String)"UTF-8");
    private static final String JDK_FALLBACK_TRANSFORMER_FACTORY = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
    private static final String XALAN_TRANSFORMER_FACTORY = "org.apache.xalan.processor.TransformerFactoryImpl";
    private static final Logger LOG = LoggerFactory.getLogger(XmlConverter.class);
    private static final ErrorHandler DOCUMENT_BUILDER_LOGGING_ERROR_HANDLER = new DocumentBuilderLoggingErrorHandler();
    private volatile DocumentBuilderFactory documentBuilderFactory;
    private volatile TransformerFactory transformerFactory;
    private volatile XMLReaderPool xmlReaderPool;

    public XmlConverter() {
    }

    public XmlConverter(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public Properties defaultOutputProperties() {
        Properties properties = new Properties();
        properties.put("encoding", defaultCharset);
        properties.put("omit-xml-declaration", "yes");
        return properties;
    }

    public void toResult(Source source, Result result) throws TransformerException {
        this.toResult(source, result, this.defaultOutputProperties());
    }

    public void toResult(Source source, Result result, Properties outputProperties) throws TransformerException {
        if (source == null) {
            return;
        }
        Transformer transformer = this.createTransformer();
        if (transformer == null) {
            throw new TransformerException("Could not create a transformer - JAXP is misconfigured!");
        }
        transformer.setOutputProperties(outputProperties);
        if (this.transformerFactory.getClass().getName().equals(XALAN_TRANSFORMER_FACTORY) && source instanceof StAXSource) {
            source = new StAX2SAXSource(((StAXSource)source).getXMLStreamReader());
        }
        transformer.transform(source, result);
    }

    @Converter(order=1)
    public QName toQName(String str) {
        return QName.valueOf(str);
    }

    @Converter(order=2)
    public Boolean toBoolean(NodeList list) {
        return list.getLength() > 0;
    }

    @Converter(order=3)
    public BytesSource toBytesSource(byte[] data) {
        return new BytesSource(data);
    }

    @Converter(order=4)
    public StringSource toStringSource(String data) {
        return new StringSource(data);
    }

    @Converter(order=5)
    public DOMSource toDOMSource(Document document) {
        return new DOMSource(document);
    }

    @Converter(order=6)
    public DOMSource toDOMSource(Node node) throws ParserConfigurationException, TransformerException {
        Document document = this.toDOMDocument(node);
        return new DOMSource(document);
    }

    @Converter(order=7)
    public Source toSource(String data) {
        return new StringSource(data);
    }

    @Converter(order=8)
    public Source toSource(byte[] in) {
        return new BytesSource(in);
    }

    @Converter(order=9)
    public Source toSource(Document document) {
        return new DOMSource(document);
    }

    @Converter(order=10)
    public String toString(Source source, Exchange exchange) throws TransformerException {
        Properties properties;
        if (source == null) {
            return null;
        }
        if (source instanceof StringSource) {
            return ((StringSource)source).getText();
        }
        if (source instanceof BytesSource) {
            return new String(((BytesSource)source).getData());
        }
        StringWriter buffer = new StringWriter();
        if (exchange != null && (properties = CamelContextHelper.getCamelPropertiesWithPrefix((String)OUTPUT_PROPERTIES_PREFIX, (CamelContext)exchange.getContext())).size() > 0) {
            this.toResult(source, new StreamResult(buffer), properties);
            return buffer.toString();
        }
        this.toResult(source, new StreamResult(buffer));
        return buffer.toString();
    }

    @Converter(order=11)
    public byte[] toByteArray(Source source, Exchange exchange) throws TransformerException {
        Properties properties;
        if (source instanceof BytesSource) {
            return ((BytesSource)source).getData();
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        if (exchange != null && (properties = CamelContextHelper.getCamelPropertiesWithPrefix((String)OUTPUT_PROPERTIES_PREFIX, (CamelContext)exchange.getContext())).size() > 0) {
            this.toResult(source, new StreamResult(buffer), properties);
            return buffer.toByteArray();
        }
        this.toResult(source, new StreamResult(buffer));
        return buffer.toByteArray();
    }

    @Converter(order=12)
    public DOMSource toDOMSource(String text) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        Source source = this.toSource(text);
        return this.toDOMSourceFromStream((StreamSource)source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter(order=13)
    public DOMSource toDOMSource(byte[] bytes) throws IOException, SAXException, ParserConfigurationException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            DOMSource dOMSource = this.toDOMSource(is, null);
            return dOMSource;
        }
        finally {
            IOHelper.close((Closeable)is);
        }
    }

    @Converter(order=14)
    public SAXSource toSAXSource(String source, Exchange exchange) throws IOException, SAXException, TransformerException {
        return this.toSAXSource(this.toSource(source), exchange);
    }

    @Converter(order=15)
    public StAXSource toStAXSource(String source, Exchange exchange) throws XMLStreamException {
        XMLStreamReader r = new StaxConverter().createXMLStreamReader(new StringReader(source));
        return new StAXSource(r);
    }

    @Converter(order=16)
    public StAXSource toStAXSource(byte[] in, Exchange exchange) throws XMLStreamException {
        XMLStreamReader r = new StaxConverter().createXMLStreamReader(new ByteArrayInputStream(in), exchange);
        return new StAXSource(r);
    }

    @Converter(order=17)
    public SAXSource toSAXSource(InputStream source, Exchange exchange) throws IOException, SAXException, TransformerException {
        return this.toSAXSource(this.toStreamSource(source), exchange);
    }

    @Converter(order=18)
    public SAXSource toSAXSource(byte[] in, Exchange exchange) throws IOException, SAXException, TransformerException {
        return this.toSAXSource(this.toStreamSource(in, exchange), exchange);
    }

    @Converter(order=19)
    public StAXSource toStAXSource(InputStream source, Exchange exchange) throws XMLStreamException {
        XMLStreamReader r = new StaxConverter().createXMLStreamReader(source, exchange);
        return new StAXSource(r);
    }

    @Converter(order=20)
    public SAXSource toSAXSource(File file, Exchange exchange) throws IOException, SAXException, TransformerException {
        BufferedInputStream is = IOHelper.buffered((InputStream)new FileInputStream(file));
        return this.toSAXSource(is, exchange);
    }

    @Converter(order=21)
    public StAXSource toStAXSource(File file, Exchange exchange) throws FileNotFoundException, XMLStreamException {
        BufferedInputStream is = IOHelper.buffered((InputStream)new FileInputStream(file));
        XMLStreamReader r = new StaxConverter().createXMLStreamReader(is, exchange);
        return new StAXSource(r);
    }

    @Converter(order=22)
    public StreamSource toStreamSource(String in) {
        return new StreamSource(new ByteArrayInputStream(in.getBytes()));
    }

    @Converter(order=23)
    public StreamSource toStreamSource(InputStream in) {
        return new StreamSource(in);
    }

    @Converter(order=24)
    public StreamSource toStreamSource(Reader in) {
        return new StreamSource(in);
    }

    @Converter(order=25)
    public StreamSource toStreamSource(File in) {
        return new StreamSource(in);
    }

    @Converter(order=26)
    public StreamSource toStreamSource(byte[] in, Exchange exchange) throws TransformerException {
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, exchange, (Object)in);
        return new StreamSource(is);
    }

    @Converter(order=27)
    public StreamSource toStreamSource(ByteBuffer in, Exchange exchange) throws TransformerException {
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, exchange, (Object)in);
        return new StreamSource(is);
    }

    @Converter(order=28)
    public StreamSource toStreamSourceFromSAX(SAXSource source, Exchange exchange) throws TransformerException {
        InputSource inputSource = source.getInputSource();
        if (inputSource != null) {
            if (inputSource.getCharacterStream() != null) {
                return new StreamSource(inputSource.getCharacterStream());
            }
            if (inputSource.getByteStream() != null) {
                return new StreamSource(inputSource.getByteStream());
            }
        }
        String result = this.toString(source, exchange);
        return new StringSource(result);
    }

    @Converter(order=29)
    public StreamSource toStreamSourceFromDOM(DOMSource source, Exchange exchange) throws TransformerException {
        String result = this.toString(source, exchange);
        return new StringSource(result);
    }

    @Converter(order=30)
    public StreamSource toStreamSourceFromStAX(StAXSource source, Exchange exchange) throws TransformerException {
        String result = this.toString(source, exchange);
        return new StringSource(result);
    }

    @Converter(order=31)
    public SAXSource toSAXSourceFromStream(StreamSource source, Exchange exchange) throws SAXException {
        InputSource inputSource = source.getReader() != null ? new InputSource(source.getReader()) : new InputSource(source.getInputStream());
        inputSource.setSystemId(source.getSystemId());
        inputSource.setPublicId(source.getPublicId());
        XMLReader xmlReader = null;
        try {
            SAXParserFactory sfactory;
            if (exchange != null && (sfactory = (SAXParserFactory)exchange.getProperty("CamelSAXParserFactory", SAXParserFactory.class)) != null) {
                if (!sfactory.isNamespaceAware()) {
                    sfactory.setNamespaceAware(true);
                }
                xmlReader = sfactory.newSAXParser().getXMLReader();
            }
            if (xmlReader == null) {
                if (this.xmlReaderPool == null) {
                    this.xmlReaderPool = new XMLReaderPool(this.createSAXParserFactory());
                }
                xmlReader = this.xmlReaderPool.createXMLReader();
            }
        }
        catch (Exception ex) {
            LOG.warn("Cannot create the SAXParser XMLReader, due to {}", (Object)ex.getMessage(), (Object)ex);
        }
        return new SAXSource(xmlReader, inputSource);
    }

    @Converter(order=32)
    public Reader toReader(StreamSource source) {
        Reader r = source.getReader();
        if (r == null) {
            r = new InputStreamReader(source.getInputStream());
        }
        return r;
    }

    @Converter(order=33)
    public Reader toReaderFromSource(Source src, Exchange exchange) throws TransformerException {
        StreamSource stSrc = this.toStreamSource(src, exchange);
        Reader r = stSrc.getReader();
        if (r == null) {
            r = new InputStreamReader(stSrc.getInputStream());
        }
        return r;
    }

    @Converter(order=34)
    public DOMSource toDOMSource(InputStream is, Exchange exchange) throws ParserConfigurationException, IOException, SAXException {
        InputSource source = new InputSource(is);
        String systemId = source.getSystemId();
        DocumentBuilder builder = this.createDocumentBuilder(this.getDocumentBuilderFactory(exchange));
        Document document = builder.parse(source);
        return new DOMSource(document, systemId);
    }

    @Converter(order=35)
    public DOMSource toDOMSource(File file, Exchange exchange) throws ParserConfigurationException, IOException, SAXException {
        BufferedInputStream is = IOHelper.buffered((InputStream)new FileInputStream(file));
        return this.toDOMSource(is, exchange);
    }

    @Converter(order=36)
    public DOMSource toDOMSourceFromStream(StreamSource source, Exchange exchange) throws ParserConfigurationException, IOException, SAXException {
        Document document;
        String systemId = source.getSystemId();
        DocumentBuilder builder = this.createDocumentBuilder(this.getDocumentBuilderFactory(exchange));
        Reader reader = source.getReader();
        if (reader != null) {
            document = builder.parse(new InputSource(reader));
        } else {
            InputStream inputStream = source.getInputStream();
            if (inputStream != null) {
                InputSource inputsource = new InputSource(inputStream);
                inputsource.setSystemId(systemId);
                document = builder.parse(inputsource);
            } else {
                throw new IOException("No input stream or reader available on StreamSource: " + source);
            }
        }
        return new DOMSource(document, systemId);
    }

    @Converter(order=37)
    public SAXSource toSAXSourceFromDOM(DOMSource source, Exchange exchange) throws TransformerException {
        String str = this.toString(source, exchange);
        StringReader reader = new StringReader(str);
        return new SAXSource(new InputSource(reader));
    }

    @Converter(order=38)
    public SAXSource toSAXSourceFromStAX(StAXSource source, Exchange exchange) throws TransformerException {
        String str = this.toString(source, exchange);
        StringReader reader = new StringReader(str);
        return new SAXSource(new InputSource(reader));
    }

    @Converter(order=39)
    public DOMSource toDOMSourceFromSAX(SAXSource source) throws TransformerException {
        return new DOMSource(this.toDOMNodeFromSAX(source));
    }

    @Converter(order=40)
    public DOMSource toDOMSourceFromStAX(StAXSource source) throws TransformerException {
        return new DOMSource(this.toDOMNodeFromStAX(source));
    }

    @Converter(order=41)
    public Node toDOMNodeFromSAX(SAXSource source) throws TransformerException {
        DOMResult result = new DOMResult();
        this.toResult(source, result);
        return result.getNode();
    }

    @Converter(order=42)
    public Node toDOMNodeFromStAX(StAXSource source) throws TransformerException {
        DOMResult result = new DOMResult();
        this.toResult(source, result);
        return result.getNode();
    }

    @Converter(order=43, allowNull=true)
    public Node toDOMNodeFromSingleNodeList(NodeList nl) {
        return nl.getLength() == 1 ? nl.item(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter(order=44)
    public Document toDOMDocument(Node node) throws ParserConfigurationException, TransformerException {
        ObjectHelper.notNull((Object)node, (String)"node");
        if (node instanceof Document) {
            return (Document)node;
        }
        if (node instanceof Element) {
            Element elem = (Element)node;
            if (elem.getOwnerDocument().getDocumentElement() == elem) {
                return elem.getOwnerDocument();
            }
            Document doc = this.createDocument();
            Document document = node.getOwnerDocument();
            synchronized (document) {
                doc.appendChild(doc.importNode(node, true));
            }
            return doc;
        }
        throw new TransformerException("Unable to convert DOM node to a Document: " + node);
    }

    @Converter(order=45, allowNull=true)
    public Node toDOMNode(Source source) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        DOMSource domSrc = this.toDOMSource(source, null);
        return domSrc != null ? domSrc.getNode() : null;
    }

    @Converter(order=46)
    public Element toDOMElement(Source source) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        Node node = this.toDOMNode(source);
        return this.toDOMElement(node);
    }

    @Converter(order=47)
    public Element toDOMElement(Node node) throws TransformerException {
        if (node instanceof Document) {
            return ((Document)node).getDocumentElement();
        }
        if (node instanceof Element) {
            return (Element)node;
        }
        throw new TransformerException("Unable to convert DOM node to an Element");
    }

    @Converter(order=48)
    public Document toDOMDocument(byte[] data, Exchange exchange) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.createDocumentBuilder(this.getDocumentBuilderFactory(exchange));
        return documentBuilder.parse(new ByteArrayInputStream(data));
    }

    @Converter(order=49)
    public Document toDOMDocument(InputStream in, Exchange exchange) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.createDocumentBuilder(this.getDocumentBuilderFactory(exchange));
        if (in instanceof IOHelper.EncodingInputStream) {
            IOHelper.EncodingInputStream encIn = (IOHelper.EncodingInputStream)in;
            return documentBuilder.parse(encIn.toOriginalInputStream());
        }
        return documentBuilder.parse(in);
    }

    @Converter(order=50)
    public Document toDOMDocument(Reader in, Exchange exchange) throws IOException, SAXException, ParserConfigurationException {
        return this.toDOMDocument(new InputSource(in), exchange);
    }

    @Converter(order=51)
    public Document toDOMDocument(InputSource in, Exchange exchange) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.createDocumentBuilder(this.getDocumentBuilderFactory(exchange));
        return documentBuilder.parse(in);
    }

    @Converter(order=52)
    public Document toDOMDocument(String text, Exchange exchange) throws IOException, SAXException, ParserConfigurationException {
        return this.toDOMDocument(new StringReader(text), exchange);
    }

    @Converter(order=53)
    public Document toDOMDocument(File file, Exchange exchange) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.createDocumentBuilder(this.getDocumentBuilderFactory(exchange));
        return documentBuilder.parse(file);
    }

    @Converter(order=54)
    public Document toDOMDocument(Source source) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        Node node = this.toDOMNode(source);
        if (node != null) {
            return this.toDOMDocument(node);
        }
        return null;
    }

    @Converter(order=55, allowNull=true)
    public Document toDOMDocumentFromSingleNodeList(NodeList nl) throws ParserConfigurationException, TransformerException {
        if (nl.getLength() == 1) {
            return this.toDOMDocument(nl.item(0));
        }
        if (nl instanceof Node) {
            return this.toDOMDocument((Node)((Object)nl));
        }
        return null;
    }

    @Converter(order=56)
    public InputStream toInputStream(DOMSource source, Exchange exchange) throws TransformerException {
        return new ByteArrayInputStream(this.toByteArray(source, exchange));
    }

    @Converter(order=57)
    public InputStream toInputStream(Document dom, Exchange exchange) throws TransformerException {
        return this.toInputStream(new DOMSource(dom), exchange);
    }

    @Converter(order=58)
    public InputSource toInputSource(InputStream is, Exchange exchange) {
        return new InputSource(is);
    }

    @Converter(order=59)
    public InputSource toInputSource(File file, Exchange exchange) throws FileNotFoundException {
        BufferedInputStream is = IOHelper.buffered((InputStream)new FileInputStream(file));
        return new InputSource(is);
    }

    @Converter(order=60)
    public DOMSource toDOMSource(Source source, Exchange exchange) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        if (source instanceof DOMSource) {
            return (DOMSource)source;
        }
        if (source instanceof SAXSource) {
            return this.toDOMSourceFromSAX((SAXSource)source);
        }
        if (source instanceof StreamSource) {
            return this.toDOMSourceFromStream((StreamSource)source, exchange);
        }
        if (source instanceof StAXSource) {
            return this.toDOMSourceFromStAX((StAXSource)source);
        }
        return null;
    }

    @Converter(order=61)
    public SAXSource toSAXSource(Source source, Exchange exchange) throws IOException, SAXException, TransformerException {
        if (source instanceof SAXSource) {
            return (SAXSource)source;
        }
        if (source instanceof DOMSource) {
            return this.toSAXSourceFromDOM((DOMSource)source, exchange);
        }
        if (source instanceof StreamSource) {
            return this.toSAXSourceFromStream((StreamSource)source, exchange);
        }
        if (source instanceof StAXSource) {
            return this.toSAXSourceFromStAX((StAXSource)source, exchange);
        }
        return null;
    }

    @Converter(order=62)
    public StreamSource toStreamSource(Source source, Exchange exchange) throws TransformerException {
        if (source instanceof StreamSource) {
            return (StreamSource)source;
        }
        if (source instanceof DOMSource) {
            return this.toStreamSourceFromDOM((DOMSource)source, exchange);
        }
        if (source instanceof SAXSource) {
            return this.toStreamSourceFromSAX((SAXSource)source, exchange);
        }
        if (source instanceof StAXSource) {
            return this.toStreamSourceFromStAX((StAXSource)source, exchange);
        }
        return null;
    }

    @Converter(order=63)
    public InputStream toInputStream(StreamSource source) throws IOException {
        InputStream is = source.getInputStream();
        if (is == null) {
            Reader r = source.getReader();
            String s = IOHelper.toString((Reader)r);
            is = new ByteArrayInputStream(s.getBytes());
        }
        return is;
    }

    public String toStringFromDocument(Document document, Properties outputOptions) throws TransformerException {
        if (document == null) {
            return null;
        }
        DOMSource source = new DOMSource(document);
        StringWriter buffer = new StringWriter();
        this.toResult(source, new StreamResult(buffer), outputOptions);
        return buffer.toString();
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.documentBuilderFactory == null) {
            this.documentBuilderFactory = this.createDocumentBuilderFactory();
        }
        return this.documentBuilderFactory;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = this.createTransformerFactory();
        }
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        if (transformerFactory != null) {
            this.configureSaxonTransformerFactory(transformerFactory);
        }
        this.transformerFactory = transformerFactory;
    }

    protected void setupFeatures(DocumentBuilderFactory factory) {
        Properties properties = System.getProperties();
        ArrayList<String> features = new ArrayList<String>();
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            String key = (String)prop.getKey();
            if (!key.startsWith(DOCUMENT_BUILDER_FACTORY_FEATURE)) continue;
            String uri = StringHelper.after((String)key, (String)":");
            Boolean value = Boolean.valueOf((String)prop.getValue());
            try {
                factory.setFeature(uri, value);
                features.add("feature " + uri + " value " + value);
            }
            catch (ParserConfigurationException e) {
                LOG.warn("DocumentBuilderFactory doesn't support the feature {} with value {}, due to {}.", new Object[]{uri, value, e.getMessage(), e});
            }
        }
        if (!features.isEmpty()) {
            StringBuilder featureString = new StringBuilder();
            for (String feature : features) {
                if (featureString.length() != 0) {
                    featureString.append(", ");
                }
                featureString.append(feature);
            }
            LOG.info("DocumentBuilderFactory has been set with features {{}}.", (Object)featureString);
        }
    }

    public DocumentBuilderFactory getDocumentBuilderFactory(Exchange exchange) {
        DocumentBuilderFactory factory;
        DocumentBuilderFactory answer = this.getDocumentBuilderFactory();
        if (exchange != null && (factory = (DocumentBuilderFactory)exchange.getProperty("CamelDocumentBuilderFactory", DocumentBuilderFactory.class)) != null) {
            answer = factory;
        }
        return answer;
    }

    public DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (ParserConfigurationException e) {
            LOG.warn("DocumentBuilderFactory doesn't support the feature {} with value {}, due to {}.", new Object[]{"http://javax.xml.XMLConstants/feature/secure-processing", true, e.getMessage(), e});
        }
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException e) {
            LOG.warn("DocumentBuilderFactory doesn't support the feature {} with value {}, due to {}.", new Object[]{"http://xml.org/sax/features/external-general-entities", false, e.getMessage(), e});
        }
        try {
            Class smClass = ObjectHelper.loadClass((String)"org.apache.xerces.util.SecurityManager");
            if (smClass != null) {
                Object sm = smClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                factory.setAttribute("http://apache.org/xml/properties/security-manager", sm);
            }
        }
        catch (Exception e) {
            LOG.warn("DocumentBuilderFactory doesn't support the attribute {}, due to {}.", new Object[]{"http://apache.org/xml/properties/security-manager", e.getMessage(), e});
        }
        this.setupFeatures(factory);
        return factory;
    }

    public DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        return this.createDocumentBuilder(this.getDocumentBuilderFactory());
    }

    public DocumentBuilder createDocumentBuilder(DocumentBuilderFactory factory) throws ParserConfigurationException {
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(DOCUMENT_BUILDER_LOGGING_ERROR_HANDLER);
        return builder;
    }

    public Document createDocument() throws ParserConfigurationException {
        DocumentBuilder builder = this.createDocumentBuilder();
        return builder.newDocument();
    }

    public Transformer createTransformer() throws TransformerConfigurationException {
        TransformerFactory factory = this.getTransformerFactory();
        return factory.newTransformer();
    }

    public TransformerFactory createTransformerFactory() {
        TransformerFactory factory;
        try {
            factory = TransformerFactory.newInstance();
        }
        catch (TransformerFactoryConfigurationError e) {
            TransformerFactoryConfigurationError cause = e;
            try {
                LOG.debug("Cannot create/load TransformerFactory due: {}. Will attempt to use JDK fallback TransformerFactory: {}", (Object)e.getMessage(), (Object)JDK_FALLBACK_TRANSFORMER_FACTORY);
                factory = TransformerFactory.newInstance(JDK_FALLBACK_TRANSFORMER_FACTORY, null);
            }
            catch (Exception t) {
                throw cause;
            }
        }
        LOG.debug("Created TransformerFactory: {}", (Object)factory);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            LOG.warn("TransformerFactory doesn't support the feature {} with value {}, due to {}.", new Object[]{"http://javax.xml.XMLConstants/feature/secure-processing", "true", e.getMessage()});
        }
        factory.setErrorListener(new XmlErrorListener());
        this.configureSaxonTransformerFactory(factory);
        return factory;
    }

    public void configureSaxonTransformerFactory(TransformerFactory factory) {
        Class<?> factoryClass = factory.getClass();
        if (factoryClass.getName().startsWith("net.sf.saxon") || factoryClass.getName().startsWith("com.saxonica")) {
            ClassLoader loader = factoryClass.getClassLoader();
            Class<?> messageWarner = null;
            try {
                messageWarner = loader.loadClass("net.sf.saxon.serialize.MessageWarner");
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    messageWarner = loader.loadClass("net.sf.saxon.event.MessageWarner");
                }
                catch (ClassNotFoundException cnfe2) {
                    LOG.warn("Error loading Saxon's net.sf.saxon.serialize.MessageWarner class from the classpath! <xsl:message> output will not be redirected to the ErrorListener!");
                }
            }
            if (messageWarner != null) {
                factory.setAttribute("http://saxon.sf.net/feature/messageEmitterClass", messageWarner.getName());
            }
        }
    }

    public SAXParserFactory createSAXParserFactory() {
        SAXParserFactory sfactory = SAXParserFactory.newInstance();
        try {
            sfactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception e) {
            LOG.warn("SAXParser doesn't support the feature {} with value {}, due to {}.", new Object[]{"http://javax.xml.XMLConstants/feature/secure-processing", "true", e.getMessage()});
        }
        try {
            sfactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (Exception e) {
            LOG.warn("SAXParser doesn't support the feature {} with value {}, due to {}.", new Object[]{"http://xml.org/sax/features/external-general-entities", false, e.getMessage()});
        }
        sfactory.setNamespaceAware(true);
        return sfactory;
    }

    private static class DocumentBuilderLoggingErrorHandler
    implements ErrorHandler {
        private DocumentBuilderLoggingErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            LOG.warn(exception.getMessage(), (Throwable)exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            LOG.error(exception.getMessage(), (Throwable)exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            LOG.error(exception.getMessage(), (Throwable)exception);
        }
    }
}

