/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.sync.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.OrderedProperties;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="sync-properties", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class SyncPropertiesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}/../../../parent/pom.xml")
    protected File sourcePom;
    @Parameter(defaultValue="${basedir}/../../../camel-dependencies/pom.xml")
    protected File targetPom;
    @Parameter(defaultValue="${basedir}/../../etc/apache-header.xml")
    protected File licenceHeader;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Properties parentProp;
            Model model;
            MavenXpp3Reader mavenReader;
            try (FileReader reader = new FileReader(this.sourcePom);){
                mavenReader = new MavenXpp3Reader();
                model = mavenReader.read((Reader)reader);
                MavenProject project = new MavenProject(model);
                parentProp = project.getProperties();
            }
            reader = new FileReader(this.targetPom);
            var3_2 = null;
            try {
                mavenReader = new MavenXpp3Reader();
                model = mavenReader.read((Reader)reader);
                OrderedProperties op = new OrderedProperties();
                op.putAll(new TreeMap<Object, Object>(parentProp));
                MavenProject project = new MavenProject(model);
                project.getModel().setProperties((Properties)op);
                MavenXpp3Writer mavenWriter = new MavenXpp3Writer();
                mavenWriter.write((Writer)new FileWriter(this.targetPom), model);
            }
            catch (Throwable mavenReader2) {
                var3_2 = mavenReader2;
                throw mavenReader2;
            }
            finally {
                if (reader != null) {
                    if (var3_2 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable mavenReader2) {
                            var3_2.addSuppressed(mavenReader2);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            String text = IOHelper.loadText((InputStream)new FileInputStream(this.targetPom));
            String text2 = IOHelper.loadText((InputStream)new FileInputStream(this.licenceHeader));
            StringBuffer sb = new StringBuffer(text);
            int pos = sb.indexOf("<project");
            sb.insert(pos, text2);
            String out = sb.toString();
            out = out.replace("https://maven.apache.org/xsd/maven-4.0.0.xsd", "http://maven.apache.org/xsd/maven-4.0.0.xsd");
            FileOutputStream outputStream = new FileOutputStream(this.targetPom);
            byte[] strToBytes = out.getBytes();
            outputStream.write(strToBytes);
            outputStream.close();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Cannot copy the properties between POMs", ex);
        }
    }
}

