/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.upgrade.camel40.yaml;

import java.util.ArrayList;
import lombok.Generated;
import org.apache.camel.upgrade.AbstractCamelYamlVisitor;
import org.apache.camel.upgrade.RecipesUtil;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.format.IndentsVisitor;
import org.openrewrite.yaml.style.IndentsStyle;
import org.openrewrite.yaml.tree.Yaml;

public final class CamelYamlStepsInFromRecipe
extends Recipe {
    private static final String[] PATHS_TO_PRE_CHECK = new String[]{"route.from"};
    private static final JsonPathMatcher MATCHER_WITHOUT_ROUTE = new JsonPathMatcher("$.steps");
    private static final JsonPathMatcher MATCHER_WITH_ROUTE = new JsonPathMatcher("$.route.steps");

    public String getDisplayName() {
        return "Camel Yaml steps not allowed as route child";
    }

    public String getDescription() {
        return "The YAML DSL backwards compatible mode in Camel 3.14 or older, which allowed 'steps' to be defined as a child of 'route' has been removed.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AbstractCamelYamlVisitor(){
            Yaml.Mapping from = null;
            Yaml.Mapping.Entry steps = null;

            @Override
            protected void clearLocalCache() {
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable Yaml.Mapping.Entry doVisitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml.Mapping.Entry e = super.doVisitMappingEntry(entry, ctx);
                if (this.steps == null && (MATCHER_WITH_ROUTE.matches(this.getCursor()) || MATCHER_WITHOUT_ROUTE.matches(this.getCursor()))) {
                    this.steps = e;
                    if (this.from != null) {
                        this.moveSteps();
                    }
                    return null;
                }
                return e;
            }

            @Override
            public Yaml.Mapping doVisitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                Yaml.Mapping m = super.doVisitMapping(mapping, ctx);
                String prop = RecipesUtil.getProperty(this.getCursor());
                if (("route.from".equals(prop) || "from".equals(prop)) && this.from == null) {
                    this.from = m;
                    if (this.steps != null) {
                        this.moveSteps();
                    }
                }
                return m;
            }

            private void moveSteps() {
                this.doAfterVisit((TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

                    public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                        Yaml.Mapping m = super.visitMapping(mapping, (Object)ctx);
                        if (m == from) {
                            ArrayList<Yaml.Mapping.Entry> entries = new ArrayList<Yaml.Mapping.Entry>(m.getEntries());
                            entries.add(steps.copyPaste().withPrefix("\n"));
                            m = m.withEntries(entries);
                        }
                        return m;
                    }
                });
                this.doAfterVisit((TreeVisitor)new IndentsVisitor(new IndentsStyle(2), null));
            }
        };
    }

    @Generated
    public CamelYamlStepsInFromRecipe() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "CamelYamlStepsInFromRecipe()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CamelYamlStepsInFromRecipe)) {
            return false;
        }
        CamelYamlStepsInFromRecipe other = (CamelYamlStepsInFromRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof CamelYamlStepsInFromRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

