/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.upgrade.customRecipes;

import java.util.ArrayList;
import java.util.Optional;
import lombok.Generated;
import org.apache.camel.upgrade.AbstractCamelXmlVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class ReplacePropertyInDataFormatXml
extends Recipe {
    @Option(example="TODO Provide a usage example for the docs", displayName="Component", description="Component name.")
    String component;
    @Option(example="TODO Provide a usage example for the docs", displayName="Old property key", description="The property key to rename.")
    String oldPropertyKey;
    @Option(example="TODO Provide a usage example for the docs", displayName="New prefix before any group", description="The prefix to be replaced with.")
    String newPropertyKey;

    public String getDisplayName() {
        return "Camel XMl DSL changes";
    }

    public String getDescription() {
        return "Apache Camel XML DSL migration from version 4.9 o 4.10.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AbstractCamelXmlVisitor(){

            @Override
            public Xml.Tag doVisitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.doVisitTag(tag, ctx);
                if (new XPathMatcher("//marshal/" + ReplacePropertyInDataFormatXml.this.component).matches(this.getCursor())) {
                    return ReplacePropertyInDataFormatXml.this.replacePropertyIfPossible(t);
                }
                return t;
            }
        };
    }

    private Xml.Tag replacePropertyIfPossible(Xml.Tag tag) {
        ArrayList<Xml.Attribute> attributes = new ArrayList<Xml.Attribute>(tag.getAttributes());
        Optional<Xml.Attribute> property = attributes.stream().filter(a -> this.oldPropertyKey.equals(a.getKey().getName())).findAny();
        if (property.isPresent()) {
            attributes.remove(property.get());
            attributes.add(property.get().withKey(property.get().getKey().withName(this.newPropertyKey)));
            return tag.withAttributes(attributes);
        }
        return tag;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplacePropertyInDataFormatXml)) {
            return false;
        }
        ReplacePropertyInDataFormatXml other = (ReplacePropertyInDataFormatXml)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$component = this.component;
        String other$component = other.component;
        if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
            return false;
        }
        String this$oldPropertyKey = this.oldPropertyKey;
        String other$oldPropertyKey = other.oldPropertyKey;
        if (this$oldPropertyKey == null ? other$oldPropertyKey != null : !this$oldPropertyKey.equals(other$oldPropertyKey)) {
            return false;
        }
        String this$newPropertyKey = this.newPropertyKey;
        String other$newPropertyKey = other.newPropertyKey;
        return !(this$newPropertyKey == null ? other$newPropertyKey != null : !this$newPropertyKey.equals(other$newPropertyKey));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReplacePropertyInDataFormatXml;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $component = this.component;
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        String $oldPropertyKey = this.oldPropertyKey;
        result = result * 59 + ($oldPropertyKey == null ? 43 : $oldPropertyKey.hashCode());
        String $newPropertyKey = this.newPropertyKey;
        result = result * 59 + ($newPropertyKey == null ? 43 : $newPropertyKey.hashCode());
        return result;
    }

    @Generated
    public ReplacePropertyInDataFormatXml() {
    }

    @Generated
    public ReplacePropertyInDataFormatXml(String component, String oldPropertyKey, String newPropertyKey) {
        this.component = component;
        this.oldPropertyKey = oldPropertyKey;
        this.newPropertyKey = newPropertyKey;
    }

    @Generated
    public void setComponent(String component) {
        this.component = component;
    }

    @Generated
    public void setOldPropertyKey(String oldPropertyKey) {
        this.oldPropertyKey = oldPropertyKey;
    }

    @Generated
    public void setNewPropertyKey(String newPropertyKey) {
        this.newPropertyKey = newPropertyKey;
    }
}

