/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.collections;

import java.util.Arrays;
import java.util.Iterator;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.springframework.lang.Nullable;

public final class _PrimitiveCollections {
    private _PrimitiveCollections() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class IntList
    implements Iterable<Integer> {
        private static final int DEFAULT_INITIAL_CAPACITY = 8;
        private int[] buf;
        private int size = 0;

        public IntList(int initialCapacity) {
            if (initialCapacity < 0) {
                throw new IndexOutOfBoundsException(initialCapacity);
            }
            this.buf = initialCapacity == 0 ? null : new int[initialCapacity];
        }

        public IntList(@Nullable int[] array) {
            this.size = _NullSafe.size(array);
            if (this.size == 0) {
                return;
            }
            this.buf = new int[this.size];
            System.arraycopy(array, 0, this.buf, 0, this.size);
        }

        public int size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public boolean isNotEmpty() {
            return this.size != 0;
        }

        public IntList add(int v) {
            if (this.buf == null) {
                this.buf = new int[8];
            } else if (this.size == this.buf.length) {
                int[] old = this.buf;
                this.buf = new int[this.buf.length * 2];
                System.arraycopy(old, 0, this.buf, 0, this.size);
            }
            this.buf[this.size++] = v;
            return this;
        }

        public IntList addUnique(int v) {
            if (!this.contains(v)) {
                return this.add(v);
            }
            return this;
        }

        public IntList addAll(@Nullable int[] array) {
            int n = _NullSafe.size(array);
            if (n != 0) {
                int[] old = this.buf;
                this.buf = new int[this.size + n];
                System.arraycopy(old, 0, this.buf, 0, this.size);
                System.arraycopy(array, 0, this.buf, this.size, n);
                this.size += n;
            }
            return this;
        }

        public IntList addAllUnique(@Nullable int[] array) {
            int n = _NullSafe.size(array);
            if (n != 0) {
                for (int v : array) {
                    this.addUnique(v);
                }
            }
            return this;
        }

        public int get(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException(index);
            }
            return this.buf[index];
        }

        public OptionalInt indexOf(int v) {
            if (this.isEmpty()) {
                return OptionalInt.empty();
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.buf[i] != v) continue;
                return OptionalInt.of(i);
            }
            return OptionalInt.empty();
        }

        public boolean contains(int v) {
            if (this.isEmpty()) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.buf[i] != v) continue;
                return true;
            }
            return false;
        }

        public int[] toArrayPickByIndex(int ... indexes) {
            int n = _NullSafe.size(indexes);
            if (n == 0) {
                return new int[0];
            }
            int[] newElements = new int[n];
            int maxIndex = this.size() - 1;
            int elementCount = 0;
            for (int index : indexes) {
                if (index < 0 || index > maxIndex) continue;
                newElements[elementCount++] = this.buf[index];
            }
            return elementCount == n ? newElements : Arrays.copyOf(newElements, elementCount);
        }

        public int[] toArray() {
            int[] result = new int[this.size];
            if (!this.isEmpty()) {
                System.arraycopy(this.buf, 0, result, 0, this.size);
            }
            return result;
        }

        public IntStream stream() {
            return IntStream.of(this.toArray());
        }

        @Override
        public Iterator<Integer> iterator() {
            final int[] defensiveCopy = this.toArray();
            return new PrimitiveIterator.OfInt(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < defensiveCopy.length;
                }

                @Override
                public int nextInt() {
                    return defensiveCopy[this.index++];
                }
            };
        }

        public IntList() {
        }
    }
}

