/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Optional;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.internal.reflection._Annotations;
import org.apache.causeway.commons.internal.reflection._GenericResolver;
import org.apache.causeway.commons.internal.reflection._Reflect;

public final class _MethodFacades {
    public static MethodFacade paramsAsTuple(@NonNull _GenericResolver.ResolvedMethod method, @NonNull _GenericResolver.ResolvedConstructor patConstructor) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (patConstructor == null) {
            throw new NullPointerException("patConstructor is marked non-null but is null");
        }
        _Reflect.guardAgainstSynthetic(method.method());
        return new ParamsAsTupleMethod(patConstructor, method);
    }

    public static MethodFacade regular(@NonNull _GenericResolver.ResolvedMethod method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        _Reflect.guardAgainstSynthetic(method.method());
        return new RegularMethod(method);
    }

    private _MethodFacades() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class ParamsAsTupleMethod
    implements MethodFacade {
        private final _GenericResolver.ResolvedConstructor patConstructor;
        private final _GenericResolver.ResolvedMethod method;

        @Override
        public Class<?>[] getParameterTypes() {
            return this.patConstructor.paramTypes();
        }

        @Override
        public Class<?> getParameterType(int paramNum) {
            return this.patConstructor.paramType(paramNum);
        }

        @Override
        public int getParameterCount() {
            return this.patConstructor.paramCount();
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.returnType();
        }

        @Override
        public String getName() {
            return this.method.name();
        }

        @Override
        public String getParameterName(int paramNum) {
            return this.patConstructor.constructor().getParameters()[paramNum].getName();
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.method.method().getDeclaringClass();
        }

        @Override
        public Optional<_GenericResolver.ResolvedMethod> asMethod() {
            return Optional.empty();
        }

        @Override
        public Optional<_GenericResolver.ResolvedConstructor> asConstructor() {
            return Optional.of(this.patConstructor);
        }

        @Override
        public _GenericResolver.ResolvedMethod asMethodForIntrospection() {
            return this.method;
        }

        @Override
        public Executable asExecutable() {
            return this.patConstructor.constructor();
        }

        @Override
        public Object[] getArguments(Object[] executionParameters) {
            return new Object[]{this.patConstructor.constructor().newInstance(executionParameters)};
        }

        @Override
        public <A extends Annotation> Optional<A> synthesize(Class<A> annotationType) {
            return _Annotations.synthesize(this.method.method(), annotationType);
        }

        @Override
        public <A extends Annotation> Optional<A> synthesizeOnParameter(Class<A> annotationType, int paramNum) {
            return _Annotations.synthesize(this.patConstructor.constructor().getParameters()[paramNum], annotationType);
        }

        @Override
        public boolean isAnnotatedAsNullable() {
            return _NullSafe.stream(this.method.method().getAnnotations()).map(annot -> annot.annotationType().getSimpleName()).anyMatch(name -> name.equals("Nullable"));
        }

        public String toString() {
            return this.method.method().toString();
        }

        public ParamsAsTupleMethod(_GenericResolver.ResolvedConstructor patConstructor, _GenericResolver.ResolvedMethod method) {
            this.patConstructor = patConstructor;
            this.method = method;
        }

        public _GenericResolver.ResolvedConstructor getPatConstructor() {
            return this.patConstructor;
        }

        public _GenericResolver.ResolvedMethod getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsAsTupleMethod)) {
                return false;
            }
            ParamsAsTupleMethod other = (ParamsAsTupleMethod)o;
            _GenericResolver.ResolvedConstructor this$patConstructor = this.getPatConstructor();
            _GenericResolver.ResolvedConstructor other$patConstructor = other.getPatConstructor();
            if (this$patConstructor == null ? other$patConstructor != null : !this$patConstructor.equals(other$patConstructor)) {
                return false;
            }
            _GenericResolver.ResolvedMethod this$method = this.getMethod();
            _GenericResolver.ResolvedMethod other$method = other.getMethod();
            return !(this$method == null ? other$method != null : !this$method.equals(other$method));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            _GenericResolver.ResolvedConstructor $patConstructor = this.getPatConstructor();
            result = result * 59 + ($patConstructor == null ? 43 : $patConstructor.hashCode());
            _GenericResolver.ResolvedMethod $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            return result;
        }
    }

    private static final class RegularMethod
    implements MethodFacade {
        private final _GenericResolver.ResolvedMethod method;

        @Override
        public Class<?> getDeclaringClass() {
            return this.method.method().getDeclaringClass();
        }

        @Override
        public int getParameterCount() {
            return this.method.paramCount();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.method.paramTypes();
        }

        @Override
        public Class<?> getParameterType(int paramNum) {
            return this.method.paramType(paramNum);
        }

        @Override
        public String getName() {
            return this.method.name();
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.returnType();
        }

        @Override
        public Optional<_GenericResolver.ResolvedMethod> asMethod() {
            return Optional.of(this.method);
        }

        @Override
        public Optional<_GenericResolver.ResolvedConstructor> asConstructor() {
            return Optional.empty();
        }

        @Override
        public Executable asExecutable() {
            return this.method.method();
        }

        @Override
        public <A extends Annotation> Optional<A> synthesize(Class<A> annotationType) {
            return _Annotations.synthesize(this.method.method(), annotationType);
        }

        @Override
        public _GenericResolver.ResolvedMethod asMethodForIntrospection() {
            return this.method;
        }

        @Override
        public String getParameterName(int paramNum) {
            return this.method.method().getParameters()[paramNum].getName();
        }

        @Override
        public <A extends Annotation> Optional<A> synthesizeOnParameter(Class<A> annotationType, int paramNum) {
            return _Annotations.synthesize(this.method.method().getParameters()[paramNum], annotationType);
        }

        @Override
        public Object[] getArguments(Object[] executionParameters) {
            return executionParameters;
        }

        @Override
        public boolean isAnnotatedAsNullable() {
            return _NullSafe.stream(this.method.method().getAnnotations()).map(annot -> annot.annotationType().getSimpleName()).anyMatch(name -> name.equals("Nullable"));
        }

        public String toString() {
            return this.method.method().toString();
        }

        public RegularMethod(_GenericResolver.ResolvedMethod method) {
            this.method = method;
        }

        public _GenericResolver.ResolvedMethod getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegularMethod)) {
                return false;
            }
            RegularMethod other = (RegularMethod)o;
            _GenericResolver.ResolvedMethod this$method = this.getMethod();
            _GenericResolver.ResolvedMethod other$method = other.getMethod();
            return !(this$method == null ? other$method != null : !this$method.equals(other$method));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            _GenericResolver.ResolvedMethod $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            return result;
        }
    }

    public static interface MethodFacade {
        public Class<?>[] getParameterTypes();

        public Class<?> getParameterType(int var1);

        public int getParameterCount();

        public Class<?> getReturnType();

        public String getName();

        public String getParameterName(int var1);

        public Class<?> getDeclaringClass();

        public Optional<_GenericResolver.ResolvedMethod> asMethod();

        public Optional<_GenericResolver.ResolvedConstructor> asConstructor();

        public _GenericResolver.ResolvedMethod asMethodForIntrospection();

        public Executable asExecutable();

        public Object[] getArguments(Object[] var1);

        public <A extends Annotation> Optional<A> synthesize(Class<A> var1);

        public <A extends Annotation> Optional<A> synthesizeOnParameter(Class<A> var1, int var2);

        default public _GenericResolver.ResolvedMethod asMethodElseFail() {
            return this.asMethod().orElseThrow(() -> _Exceptions.unrecoverable("Framework Bug: unexpeced method-facade, regular variant expected: %s", this.asMethodForIntrospection()));
        }

        default public _GenericResolver.ResolvedConstructor asConstructorElseFail() {
            return this.asConstructor().orElseThrow(() -> _Exceptions.unrecoverable("Framework Bug: unexpeced method-facade, wrapper of constructor expected: %s", this.asMethodForIntrospection()));
        }

        public boolean isAnnotatedAsNullable();

        default public _GenericResolver.ResolvedType resolveMethodReturn() {
            return _GenericResolver.forMethodReturn(this.asMethodForIntrospection());
        }

        default public _GenericResolver.ResolvedType resolveParameter(int paramIndex) {
            Executable executable = this.asExecutable();
            if (executable instanceof Method) {
                return _GenericResolver.forMethodParameter(this.asMethodForIntrospection(), paramIndex);
            }
            if (executable instanceof Constructor) {
                return _GenericResolver.forConstructorParameter(this.asConstructorElseFail(), paramIndex);
            }
            throw _Exceptions.unexpectedCodeReach();
        }
    }

    public static final class testing {
        public static MethodFacade regular(@NonNull Method method) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            return _MethodFacades.regular(_GenericResolver.resolveMethod(method, method.getDeclaringClass()).orElseThrow());
        }

        private testing() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

