/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.base;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.springframework.lang.Nullable;

public final class _StringInterpolation {
    final Map<String, String> variables;

    public _StringInterpolation(_Strings.KeyValuePair ... kvPairs) {
        if (kvPairs == null) {
            throw new NullPointerException("kvPairs is marked non-null but is null");
        }
        this.variables = new HashMap<String, String>();
        _NullSafe.stream(kvPairs).forEach(kvPair -> this.variables.put((String)kvPair.getKey(), (String)kvPair.getValue()));
    }

    public _StringInterpolation(@NonNull Map<String, String> variables) {
        if (variables == null) {
            throw new NullPointerException("variables is marked non-null but is null");
        }
        this.variables = variables;
    }

    public String applyTo(@Nullable String template) {
        if (template == null) {
            return null;
        }
        String acc = template;
        for (Map.Entry<String, String> entry : this.variables.entrySet()) {
            String placeholderLiteral = "${" + entry.getKey() + "}";
            String placeholderValue = entry.getValue();
            acc = acc.replace(placeholderLiteral, placeholderValue);
        }
        return acc;
    }

    public Can<String> applyTo(@Nullable Can<String> lines) {
        if (lines == null) {
            return Can.empty();
        }
        return lines.map(this::applyTo);
    }
}

