/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Collections;
import org.springframework.lang.Nullable;

public final class _Lists {
    public static <T> T firstElementIfAny(@Nullable List<T> list) {
        if (_NullSafe.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public static <T> Optional<T> firstElement(@Nullable List<T> list) {
        if (_NullSafe.isEmpty(list)) {
            return Optional.empty();
        }
        return Optional.ofNullable(list.get(0));
    }

    public static <T> T lastElementIfAny(@Nullable List<T> list) {
        if (_NullSafe.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <T> Optional<T> lastElement(@Nullable List<T> list) {
        if (_NullSafe.isEmpty(list)) {
            return Optional.empty();
        }
        return Optional.ofNullable(list.get(list.size() - 1));
    }

    public static <T> List<T> append(@Nullable List<T> list, @Nullable T element) {
        if (_NullSafe.isEmpty(list)) {
            return Collections.singletonList(element);
        }
        ArrayList<T> resultList = new ArrayList<T>(list.size() + 1);
        resultList.addAll(list);
        resultList.add(element);
        return Collections.unmodifiableList(resultList);
    }

    public static <T> List<T> concat(@Nullable List<T> list1, @Nullable List<T> list2) {
        boolean isEmpty1 = _NullSafe.isEmpty(list1);
        boolean isEmpty2 = _NullSafe.isEmpty(list2);
        if (isEmpty1) {
            return isEmpty2 ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<T>(list2));
        }
        if (isEmpty2) {
            return Collections.unmodifiableList(new ArrayList<T>(list1));
        }
        ArrayList<T> resultList = new ArrayList<T>(list1.size() + list2.size());
        resultList.addAll(list1);
        resultList.addAll(list2);
        return Collections.unmodifiableList(resultList);
    }

    public static <T> List<T> singleton(@NonNull T element) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return Collections.singletonList(element);
    }

    public static <T> List<T> singletonOrElseEmpty(@Nullable T element) {
        return element != null ? Collections.singletonList(element) : Collections.emptyList();
    }

    public static <T> List<T> ofNullable(@Nullable T e0) {
        return Collections.singletonList(e0);
    }

    public static <T> List<T> ofNullable(@Nullable T e0, @Nullable T e1) {
        ArrayList<T> list = new ArrayList<T>(2);
        list.add(e0);
        list.add(e1);
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> ofNullable(@Nullable T e0, @Nullable T e1, @Nullable T e2) {
        ArrayList<T> list = new ArrayList<T>(3);
        list.add(e0);
        list.add(e1);
        list.add(e2);
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> ofNullable(@Nullable T e0, @Nullable T e1, @Nullable T e2, @Nullable T e3) {
        ArrayList<T> list = new ArrayList<T>(4);
        list.add(e0);
        list.add(e1);
        list.add(e2);
        list.add(e3);
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> ofNullable(@Nullable T e0, @Nullable T e1, @Nullable T e2, @Nullable T e3, @Nullable T e4) {
        ArrayList<T> list = new ArrayList<T>(5);
        list.add(e0);
        list.add(e1);
        list.add(e2);
        list.add(e3);
        list.add(e4);
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> ofNullable(@Nullable T e0, @Nullable T e1, @Nullable T e2, @Nullable T e3, @Nullable T e4, @Nullable T e5) {
        ArrayList<T> list = new ArrayList<T>(6);
        list.add(e0);
        list.add(e1);
        list.add(e2);
        list.add(e3);
        list.add(e4);
        list.add(e5);
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> ofNullable(@Nullable T e0, @Nullable T e1, @Nullable T e2, @Nullable T e3, @Nullable T e4, @Nullable T e5, @Nullable T e6) {
        ArrayList<T> list = new ArrayList<T>(7);
        list.add(e0);
        list.add(e1);
        list.add(e2);
        list.add(e3);
        list.add(e4);
        list.add(e5);
        list.add(e6);
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> ofNullable(@Nullable T e0, @Nullable T e1, @Nullable T e2, @Nullable T e3, @Nullable T e4, @Nullable T e5, @Nullable T e6, @Nullable T e7) {
        ArrayList<T> list = new ArrayList<T>(8);
        list.add(e0);
        list.add(e1);
        list.add(e2);
        list.add(e3);
        list.add(e4);
        list.add(e5);
        list.add(e6);
        list.add(e7);
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> ofArray(@Nullable T[] elements) {
        if (elements == null || elements.length == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(_NullSafe.stream(elements).collect(Collectors.toList()));
    }

    public static <T> List<T> unmodifiable(@Nullable Iterable<T> iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(_NullSafe.stream(iterable).collect(Collectors.toList()));
    }

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> newArrayList(int initialSize) {
        return new ArrayList(initialSize);
    }

    public static <T> ArrayList<T> newArrayList(@Nullable Collection<T> collection) {
        if (collection == null) {
            return _Lists.newArrayList();
        }
        return new ArrayList<T>(collection);
    }

    public static <T> ArrayList<T> newArrayList(@Nullable Iterable<T> iterable) {
        return _Collections.collectFromIterable(iterable, _Lists::newArrayList, () -> Collectors.toCollection(ArrayList::new));
    }

    public static <T> LinkedList<T> newLinkedList() {
        return new LinkedList();
    }

    public static <T> LinkedList<T> newLinkedList(@Nullable Collection<T> collection) {
        if (collection == null) {
            return _Lists.newLinkedList();
        }
        return new LinkedList<T>(collection);
    }

    public static <T> LinkedList<T> newLinkedList(@Nullable Iterable<T> iterable) {
        return _Collections.collectFromIterable(iterable, _Lists::newLinkedList, () -> Collectors.toCollection(LinkedList::new));
    }

    public static <T> CopyOnWriteArrayList<T> newConcurrentList() {
        return new CopyOnWriteArrayList();
    }

    public static <T> CopyOnWriteArrayList<T> newConcurrentList(@Nullable Collection<T> collection) {
        if (collection == null) {
            return _Lists.newConcurrentList();
        }
        return new CopyOnWriteArrayList<T>(collection);
    }

    public static <T> CopyOnWriteArrayList<T> newConcurrentList(@Nullable Iterable<T> iterable) {
        return _Collections.collectFromIterable(iterable, _Lists::newConcurrentList, () -> Collectors.toCollection(CopyOnWriteArrayList::new));
    }

    public static <T, R> List<R> map(@Nullable Collection<T> input, Function<T, R> mapper) {
        return _NullSafe.stream(input).map(mapper).collect(Collectors.toList());
    }

    public static <T> List<T> filter(@Nullable Collection<T> input, Predicate<? super T> filter) {
        return _NullSafe.stream(input).filter(filter).collect(Collectors.toList());
    }

    public static <T> Collector<T, ?, List<T>> toUnmodifiable(Supplier<List<T>> collectionFactory) {
        return Collectors.collectingAndThen(Collectors.toCollection(collectionFactory), Collections::unmodifiableList);
    }

    public static <T> Collector<T, ?, List<T>> toUnmodifiable() {
        return _Lists.toUnmodifiable(ArrayList::new);
    }

    @Generated
    private _Lists() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

