/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.os;

import java.io.File;
import java.io.FileWriter;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.OptionalLong;
import lombok.Generated;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.io.TextUtils;
import org.springframework.lang.Nullable;

public final class _OsUtil {
    public static void thereCanBeOnlyOne(File pidFile) {
        if (pidFile.exists()) {
            TextUtils.readLinesFromFile(pidFile, StandardCharsets.UTF_8).filter(_Strings::isNotEmpty).getFirst().ifPresent(pid -> _OsUtil.terminateProcessByPid(pid));
        }
        long newPid = ProcessHandle.current().pid();
        try (FileWriter fw = new FileWriter(pidFile, StandardCharsets.UTF_8);){
            fw.write("" + newPid);
        }
    }

    public static void thereCanBeOnlyOne() {
        if ("true".equalsIgnoreCase(System.getenv("THERE_CAN_BE_ONLY_ONE"))) {
            _OsUtil.thereCanBeOnlyOne(new File("pid.log"));
        }
    }

    public static void terminateProcessByPid(@Nullable String pid) {
        String[] cmd;
        String pidTrimmed = _Strings.blankToNullOrTrim(pid);
        if (pidTrimmed == null) {
            return;
        }
        Runtime rt = Runtime.getRuntime();
        OS os = OS.current();
        switch (os) {
            case WINDOWS: {
                cmd = new String[]{"taskkill.exe", "/F", "/PID", pidTrimmed, "/T"};
                break;
            }
            default: {
                throw _Exceptions.unsupportedOperation("OS " + os + " not (yet) supported");
            }
        }
        rt.exec(cmd);
    }

    public static OptionalLong machineId() {
        try {
            long hash = 5381L;
            boolean valid = false;
            for (NetworkInterface netint : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                byte[] hwAddr = netint.getHardwareAddress();
                if (_NullSafe.size(hwAddr) < 6) continue;
                for (byte b : hwAddr) {
                    hash = hash * 33L + (long)b;
                }
                valid = true;
            }
            if (valid) {
                return OptionalLong.of(hash);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return OptionalLong.empty();
    }

    @Generated
    private _OsUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum OS {
        WINDOWS,
        LINUX,
        MAC_OS,
        OTHER;


        public boolean isWindows() {
            return this == WINDOWS;
        }

        public boolean isLinux() {
            return this == LINUX;
        }

        public boolean isMacOs() {
            return this == MAC_OS;
        }

        public static OS current() {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.startsWith("windows")) {
                return WINDOWS;
            }
            if (osName.contains("linux")) {
                return LINUX;
            }
            if (osName.contains("mac")) {
                return MAC_OS;
            }
            return OTHER;
        }
    }
}

