/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.causeway.commons.functional.ThrowingConsumer;
import org.apache.causeway.commons.functional.ThrowingSupplier;
import org.apache.causeway.commons.functional.Try;

@FunctionalInterface
public interface DataSink {
    public void writeAll(@NonNull ThrowingConsumer<OutputStream> var1);

    public static DataSink none() {
        return consumingMapper -> {};
    }

    public static DataSink ofOutputStreamSupplier(final @NonNull ThrowingSupplier<OutputStream> outputStreamSupplier) {
        if (outputStreamSupplier == null) {
            throw new NullPointerException("outputStreamSupplier is marked non-null but is null");
        }
        return new DataSink(){

            @Override
            public void writeAll(@NonNull ThrowingConsumer<OutputStream> outputStreamConsumer) {
                if (outputStreamConsumer == null) {
                    throw new NullPointerException("outputStreamConsumer is marked non-null but is null");
                }
                try (OutputStream os = (OutputStream)outputStreamSupplier.get();){
                    outputStreamConsumer.accept(os);
                }
            }
        };
    }

    public static DataSink ofByteArrayConsumer(final @NonNull ThrowingConsumer<byte[]> byteArrayConsumer, final int initalBufferSize) {
        if (byteArrayConsumer == null) {
            throw new NullPointerException("byteArrayConsumer is marked non-null but is null");
        }
        return new DataSink(){

            @Override
            public void writeAll(@NonNull ThrowingConsumer<OutputStream> outputStreamConsumer) {
                if (outputStreamConsumer == null) {
                    throw new NullPointerException("outputStreamConsumer is marked non-null but is null");
                }
                try (ByteArrayOutputStream bos = new ByteArrayOutputStream(initalBufferSize);){
                    outputStreamConsumer.accept(bos);
                    byteArrayConsumer.accept(bos.toByteArray());
                }
            }
        };
    }

    public static DataSink ofByteArrayConsumer(@NonNull ThrowingConsumer<byte[]> byteArrayConsumer) {
        if (byteArrayConsumer == null) {
            throw new NullPointerException("byteArrayConsumer is marked non-null but is null");
        }
        return DataSink.ofByteArrayConsumer(byteArrayConsumer, 32);
    }

    public static DataSink ofFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return DataSink.ofOutputStreamSupplier(() -> Try.call(() -> new FileOutputStream(file)).valueAsNonNullElseFail());
    }

    public static DataSink ofStringConsumer(@NonNull Consumer<String> stringConsumer, @NonNull Charset charset) {
        if (stringConsumer == null) {
            throw new NullPointerException("stringConsumer is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return DataSink.ofByteArrayConsumer(bytes -> stringConsumer.accept(new String((byte[])bytes, charset)));
    }

    public static DataSink ofStringUtf8Consumer(@NonNull Consumer<String> stringUtf8Consumer) {
        if (stringUtf8Consumer == null) {
            throw new NullPointerException("stringUtf8Consumer is marked non-null but is null");
        }
        return DataSink.ofStringConsumer(stringUtf8Consumer, StandardCharsets.UTF_8);
    }

    public static DataSink ofStringConsumer(@NonNull StringBuilder stringConsumer, @NonNull Charset charset) {
        if (stringConsumer == null) {
            throw new NullPointerException("stringConsumer is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return DataSink.ofByteArrayConsumer(bytes -> stringConsumer.append(new String((byte[])bytes, charset)));
    }

    public static DataSink ofStringUtf8Consumer(@NonNull StringBuilder stringUtf8Consumer) {
        if (stringUtf8Consumer == null) {
            throw new NullPointerException("stringUtf8Consumer is marked non-null but is null");
        }
        return DataSink.ofStringConsumer(stringUtf8Consumer, StandardCharsets.UTF_8);
    }
}

